#ifndef _FWDPARSE_H
#define _FWDPARSE_H

struct altlist	{
	char 		*name;			/* name of alternate BBS */
	long 		minutes;		/* time (in minutes) before ALT assigned msg */
	struct altlist	*next;			/* next in linked list */
};

#define NULLALTLIST	((struct altlist *)0)

struct arealist	{
	char		*name;			/* name of area */
	char		*forceaddr;		/* forced rewrite address */
	short		isALT;			/* if set, we are an ALT BBS for this area */
	struct altlist	*alternates;		/* list of out ALTs for this area */
	struct arealist	*next;			/* next in linked list */
};

#define NULLAREALIST	((struct arealist *)0)

struct fscript	{
	short		linetype;		/* type of command - SCRIPT_xxx */
	char		*string;		/* parameter string */
	short		timeout;		/* timeout (for wait command) */
	struct fscript	*next;			/* next in linked list */
};

#define NULLFSCRIPT	((struct fscript *)0)

#define SCRIPT_SEND 	0
#define SCRIPT_WAIT	1
#define SCRIPT_SID	2

#define FWDTYPE_MBLRLI	0
#define FWDTYPE_XFWD	1
#define FWDTYPE_FBBNON	2
#define FWDTYPE_FBB	3

struct fwdbbs	{
	char 		*name;			/* name of BBS */
	char 		*conn;			/* connect string (if null, can't do it now) */
	long		ALTtime;		/* default ALT BBS time */
	long		maxsize;		/* maximum size of message to send */
	long		fbbsize;		/* maximum FBB negotiation size */
	short		maxtries;		/* maximum number of 'TRY' conditionals */
	int		minidle;		/* minimum idle time between connects */
	char		poll;			/* is set, we poll even if no outgoing */
	char		subchannel;		/* subchannel number (or NOSUBCHANNEL) */
	char		noreverseincoming;	/* if set, no reverse requested (non FBB) */
	char		noclockset;		/* if set, no clock set to this PMS */
	char		clockoffset;		/* clock set offset (in hours) */
	char		personals;		/* forwarding personal areas permitted */
	char		bulletins;		/* forwarding public areas permitted */
	char		limittype;		/* limit forwarding protocol type */
	char		alwaysupdate;		/* whether to always update laston - for dumb TNCs */
	char		eatenanyprompts;	/* this is to allow eating at most one stray prompt from remote */
	char		dumbpms;		/* this is to work-around TNC PMSs that send no SID */
	time_t		starttime;		/* time this forward session started */
	time_t		limittime;		/* limit time this forward session can process */
	struct fscript	*script;		/* connection script data */
	struct arealist	*areas;			/* information on the areas */
};

#define NULLFWDBBS	((struct fwdbbs *)0)

#define NOSUBCHANNEL	(NUMMBX + 10)
#define IFLEVELS	20

void fwdfree (struct fwdbbs **f);
struct fwdbbs *fwdread (char *name, int try);

#endif /* _FWDPARSE_H */
