/*
 * twcw:  A gui application that sends Morse Code 
 * Copyright (C) 1997 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 1.4 JAN 2008
 */

/*
 * Dialogs for twcw
 */
#include "common.h"
#include "twcw.h"

/*
 * Prompt dialog - used to enter text at an '*' when sending a file
 */
void inputDiag (char *word)
{
   static Widget promptDiag;
   Widget textWid;
   XmString msg_xs;
   XmString textField;

   if (promptDiag == NULL)
   {
      promptDiag = XmCreatePromptDialog (shell, "promptDiag", (ArgList) NULL, 0);
      XtUnmanageChild (XmSelectionBoxGetChild (promptDiag, XmDIALOG_HELP_BUTTON));
      textWid = XtNameToWidget (promptDiag, "Text");
      if (textWid == NULL)
         printf ("NOT FOUND\n");

      XtAddCallback (promptDiag, XmNokCallback, OkCB, (XtPointer) NULL);
      XtAddCallback (promptDiag, XmNcancelCallback, cancelCB, (XtPointer) NULL);
      XtAddCallback (textWid, XmNmodifyVerifyCallback, modTextCB, (XtPointer) NULL);
   }
   XtVaSetValues (XtParent (promptDiag),
      XmNtitle, "TWCW Prompt Dialog",
      NULL);

   msg_xs = XmStringCreateLocalized (word);
   textField = XmStringCreateLocalized ("");
   XtVaSetValues (promptDiag,
      XmNtextString, textField,
      XmNselectionLabelString, msg_xs,
      NULL); 
   XmStringFree (msg_xs);
   XmStringFree (textField);
   XtManageChild (promptDiag);
}


/*
 * value changed CB for promptDiag's textField
 */
void modTextCB (Widget w, XtPointer cldata, XtPointer cbdata)
{
   int i;
   XmTextVerifyCallbackStruct *cbs = (XmTextVerifyCallbackStruct *)cbdata;

   for (i = 0; i < cbs->text->length; i++)
   {
      cbs->text->ptr[i] = toupper (cbs->text->ptr[i]); 
   }
}


/*
 * OK Callback for promptDiag
 */
void OkCB (Widget w, XtPointer cldata, XtPointer cbdata)
{
   char *words, *sendwords;
   XmTextPosition cur_pos;
   int len;
   XmSelectionBoxCallbackStruct *cbs = (XmSelectionBoxCallbackStruct *) cbdata;

   XmStringGetLtoR (cbs->value, XmFONTLIST_DEFAULT_TAG, &words);

   len = strlen (words);

   sendwords = XtMalloc (strlen (words) + 2);
   strcpy (sendwords, words);
   sendwords[len] = ' ';               /* Replace the space that was deleated */
   sendwords[len+1] = '\0';

   cur_pos = XmTextGetLastPosition (txText);
   XmTextSetInsertionPosition (txText, cur_pos);
   XmTextInsert (txText, cur_pos, sendwords);
   XtFree (sendwords);
                                       /* Now reschedule the work proc */
   XtAppAddWorkProc (ac, procData, (XtPointer) NULL);
}


/*
 * Cancel Callback for promptDiag
 */
void cancelCB (Widget w, XtPointer cldata, XtPointer cbdata)
{
   XtAppAddWorkProc (ac, procData, (XtPointer) NULL);
}


/*
 * aboutDiag Function
 * Just an info dialog
 */
void aboutCB (Widget w, XtPointer cldata, XtPointer cbdata)
{
   static Widget diag = NULL;
   XmString  msg_xs;
   char msg_str[] = PACKAGE_STRING
              " \251 1998-2008\nwas written by Ted Williams - WA\330EIR\n\n"
              "Please send bug reports to\n" PACKAGE_BUGREPORT;

   msg_xs = XmStringCreateLtoR (msg_str, XmFONTLIST_DEFAULT_TAG);
   if (diag == NULL)
      {
      diag = XmCreateInformationDialog (shell, "aboutDiag",  (ArgList) NULL, 0);
      XtVaSetValues (XtParent(diag),
         XmNtitle, "ABOUT TWCW",
         NULL);

      XtVaSetValues (diag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, msg_xs,
         NULL);
      XmStringFree(msg_xs);

      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_HELP_BUTTON));
      }
   XtManageChild (diag);
}


/*
 * Error Dialog - called from many places and passed the parent widget,
 * the error message to display and a flag that indicates the Cancel
 * button is not wanted.  Only the File Exist diag gets a Cancel btn.
 */
void errorDiag (Widget w, char *emess, int flag)
{
   Widget errDiag;
   XmString xs;

   errDiag = XmCreateErrorDialog (w, "errDiag", NULL, 0);
   xs = XmStringCreateLocalized(emess);

   XtVaSetValues (XtParent(errDiag),
      XmNtitle, "TWLOG ERROR",
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      NULL);

   XtVaSetValues (errDiag,
      XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
      XmNmessageString, xs,
      NULL);
   XmStringFree (xs);

   if (flag == NO_CANCEL)
   {
      XtUnmanageChild (XmMessageBoxGetChild(errDiag, XmDIALOG_CANCEL_BUTTON));
   }
   XtUnmanageChild (XmMessageBoxGetChild(errDiag, XmDIALOG_HELP_BUTTON));

   /* add callback and pop it up */
   XtAddCallback (errDiag, XmNokCallback, errOkCB, (XtPointer) -1);
   XtManageChild (errDiag);
}


/*
 * errOkCB - does cleanup and exits
 */
void errOkCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   /* do the right thing */
   cleanup();
   XtUnmanageChild (cdata);
   exit (-1);
} 


