/*
 * twcw:  A gui application that sends Morse Code 
 * Copyright (C) 1997 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 1.4  JAN 2008
 */

/*
 * main Function
 *  Usage:  twcw ([--cwirc] [serDevice])
 *  called without arguments for standalone use.
 *  called by cwirc with the --cwirc argument.
 *
 *  main calls the following functions:
 *   1) build_widgets() to create the interface.
 *   2) setup() to initialize a message queue and signal traping.
 *   3) fork_sendCW() to create the child process.
 *  main then adds a work proceedure (do_work) and enters the event loop.
 */
#include "common.h"
#include "twcw.h"

#ifdef MAKE_ICON
#include "icons/twcw.xpm"
#endif

AppRes app_res;

int  main (int argc, char *argv[])
{
   int i, pos, rtn;
   struct stat buf;
   Dimension width, height;
   struct tag1 dummy;
   char mess[200] = "\0";   /* long enuf? shud be */

#ifdef MAKE_ICON
   Pixmap pixmap, mask;
   XpmAttributes pix_attributes;
   XpmColorSymbol transparentColor[1] = {{NULL, "none", 0}};
#endif

/*
 * Describe the application defined resources. This struct is
 * for the app resources which are read from the resource
 * file.  See the resource file (Twcw) for more info.
 */
   XtResource app_res_desc[] =
   {
      {
      XmNcall,                             /* Name */
      XmCCall,                             /* Class */
      XmRString,                           /* Target data type */
      sizeof (char *),                     /* size of target type */
      XtOffsetOf (AppRes, call),           /* Offset into LogRes */ 
      XtRImmediate, "N0CALL"               /* Default data type */
      },
 
      {
      XmNbuttonNames,                      /* Name */
      XmCButtonNames,                      /* Class */
      XmRStringTable,                      /* Target data type */
      sizeof (char **),                    /* size of target type */
      XtOffsetOf (AppRes, buttonNames),    /* Offset into LogRes */ 
      XtRImmediate, "Bogus Names"          /* Default value */
      }, 

      {
      XmNserialDevice,                     /* Name */
      XmCSerialDevice,                     /* Class */
      XmRString,                           /* Target data type */
      sizeof (char *),                     /* size of target type */
      XtOffsetOf (AppRes, serialDevice),   /* Offset into LogRes */ 
      XtRImmediate, "/dev/ttyS0"           /* Default value */
      },

      {
      XmNdspDevice,                        /* Same as above */
      XmCDspDevice,
      XtRString,
      sizeof (String),
      XtOffsetOf (AppRes, dspDevice),
      XtRImmediate,
      (XtPointer) "/dev/dsp"
      },

      {
      XmNmixerDevice,                  /* Same as above */
      XmCMixerDevice,
      XtRString,
      sizeof (String),
      XtOffsetOf (AppRes, mixerDevice),
      XtRImmediate,
      (XtPointer) "/dev/mixer"
      }
   };

#ifdef XmVERSION_STRING
   extern const char _XmVersionString[];
   fprintf (stderr, "Compiled with %s\n", XmVERSION_STRING + 4);
   fprintf (stderr, "Running with %s\n", _XmVersionString + 4);
#endif

   /* seed the random number generator for practice mode */
   srand (time(NULL));

   /*
    * Initialize the tool kit, create the application and icon shells,
    * get the app defined resources and check that dirPath and 
    * buttonNames are defined.  This does not check for valid
    * pathnames.  They can be NULL - just gota have twcw.dirPath
    * and twcw.buttonNames in Twcw.
    */   
   shell = XtVaAppInitialize (&ac, "Twcw", NULL, 0, &argc, argv, NULL,
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      XmNtitle, "TWCW",
      NULL);

   /*
    * Get resources and check to see if buttonNames was set
    */
   XtGetApplicationResources (shell, &app_res, app_res_desc,
      XtNumber (app_res_desc), NULL, 0);

   /*
    * Check command line args and set CWIRC or TWCW mode.
    * Look for the "--cwirc" switch so we know what args we have.
    * if argv[1] == --cwirc, 
         serdev == argv[2] == shm_id for CWIRC mode
    * else
    *    serdev == app_res.serialDevice for TWCW mode.
    */ 
   if ((argc == 3) && (!strcmp (argv[1], "--cwirc")))   /* for CWIRC mode */
   {
      cwArgs.mode = CWIRC;
      strcpy (cwArgs.shm_id, argv[2]);
   }
   else                                                 /* for TWCW mode */
   {
      cwArgs.mode = TWCW;
      strcpy (cwArgs.dspdev, app_res.dspDevice);
      strcpy (cwArgs.mixerdev, app_res.mixerDevice);
      strcpy (cwArgs.serdev, app_res.serialDevice);
   }
   /*
    * If MAKE_ICON is defined, create its pixmap
    */
#ifdef MAKE_ICON
   pix_attributes.closeness = 40000;
   pix_attributes.valuemask = XpmColorSymbols | XpmCloseness;
   pix_attributes.colorsymbols = transparentColor;
   pix_attributes.numsymbols = 1;

   XpmCreatePixmapFromData (XtDisplay(shell),
      DefaultRootWindow (XtDisplay (shell)),
      twcw_xpm, &pixmap, &mask, &pix_attributes);
#endif

   /*
    * build and realize the widgets
    */
   build_widgets (shell, &app_res, cwArgs.mode);

   /*
    * tx Text widget doesn't exist in CWIRC mode so,
    * if mode == TWCW, print out the application resources
    * to the tx Text widget. First call and file names
    */ 
   if (cwArgs.mode == TWCW)
   {
      strcpy (mess, "TWCW Application Resources\n  Call: ");
      strcat (mess, app_res.call);
      strcat (mess, "\n  File Names:\n");
      XmTextInsert (rxText, 0, mess);
      i = 0;
      while (app_res.buttonNames[i] != NULL)
      {
         sprintf (mess, "    %s%s\n", app_res.buttonNames[i],
                  app_res.buttonNames[i+1] == NULL ? " " : ",");
         pos = XmTextGetLastPosition (rxText);
         XmTextInsert (rxText, pos, mess);
         i++;
      }
      /* And now print the devices being used */
      strcpy (mess, "  DSP device:  ");
      strcat (mess, app_res.dspDevice);
      strcat (mess, "\n  Mixer device:  ");
      strcat (mess, app_res.mixerDevice);
      strcat (mess, "\n  Serial Device:  ");
      strcat (mess, app_res.serialDevice);
      strcat (mess, "\n");
      pos = XmTextGetLastPosition (rxText);
      XmTextInsert (rxText, pos, mess);
   }
   
   XtRealizeWidget (shell);

#ifdef MAKE_ICON
   XtVaSetValues (shell,
      XmNiconPixmap, pixmap,
      NULL);
#endif

   /* find the helpfile */
   strcpy (helppath, PKG_DATA_DIR);  /* helpfile is here */
   strcat (helppath, HELPFILE);

   if (stat (helppath, &buf) < 0)
   {
      errorDiag (shell, "Instalation Problem\n"
                        "Can't find the help file\n"
                        "twcw must exit", NO_CANCEL);
   }

   /*
    * Setup the message queue. Also sets up signal traps 
    */
   if (setup() == False)
   {
      errorDiag (shell, "Open message queue failed.\n"
                        "twcw must exit", NO_CANCEL);
   }

   if ((pid = fork_sendCW (&cwArgs)) == False)
   {
      errorDiag (shell, "Fork failed\n"
                        "twcw must exit", NO_CANCEL);
   }

   /*
    *  Set min width of the shell
    */
   XtVaGetValues (shell,
      XmNwidth, &width,
      XmNheight, &height,
      NULL);

   XtVaSetValues (shell,
      XmNminWidth, width,
      XmNminHeight, height,
      NULL);


   /* force focus to txText */
   XmProcessTraversal (txText, XmTRAVERSE_CURRENT);

#if 0   /* 2.0 stuff */
   /*
    * Initialize fftw and the soundcard
    */
    init_plan  ();   /* should go hr but in audio - it leaks badly! */
    init_table ();
    init_audio ();
    init_mixer ();
#endif

   /* wait for speed set message */
   while (True)
   {
      if (msgrcv (qid, (struct tag1 *) &dummy,
         MAX_WORD_LENGTH, WPM_DONE, IPC_NOWAIT) != 1)
      {
         XUndefineCursor (XtDisplay (shell), XtWindow (shell));
         break;
      }
   }

   /*
    * add the work proc and enter the main loop
    */
   XtAppAddWorkProc (ac, do_work, (XtPointer) NULL);

   XtVaSetValues (farnsScale,
      XmNshowValue, False,
      NULL);

   XtAppMainLoop (ac);
   exit (0);
}


/*
 * fork_sendCW Function
 * Forks the send_CW child process and returns it's pid
 */
int  fork_sendCW ( struct tag2 *cwArgs)
{
   int  pid;
   char mode_str[4];

   switch (pid = fork ())
      {
      case -1:                          /* Can't fork a child */
         errorDiag (shell,
                    "Fork failed!\n"
                    "twcw must exit", NO_CANCEL);
         break;

      case 0:                           /* Child comes here */
         sprintf (mode_str, "%d", cwArgs->mode);
         execlp ("sendCW", "sendCW", 
                            mode_str,
                            cwArgs->dspdev,
                            cwArgs->mixerdev,
                            cwArgs->serdev,
                            cwArgs->shm_id,
                            NULL);
         perror ("execlp");             /* never here */
         break;

      default:                          /* Parent comes here */
         break;
      }
   return (pid);
}


/*
 * do_work Function
 * Work Proceedure to get messages from the sendCW process
 */
Boolean do_work (XtPointer cdata)
{
   int  rtn;
   char group[8];
   struct tag1 indata;

#if 0 /* TJW more 2.0 stuff */
   Boolean txFlag = XmToggleButtonGetState (tb1);

   /*
    * Here we first check for messages, then on Xmit button state
    * Then can get rid of wait loop nr setup - above... 
    * First do receive, then look for a messages.
    */

   if (txFlag == False)
   {
      select_loop ();  //2.0 select loop
      return False;
   }
#endif

   /*
    * First, check for a WPM_DONE message and restore the cursor
    */
   rtn = msgrcv (qid, (struct msgbuf *) &indata,
                 MAX_WORD_LENGTH, WPM_DONE, IPC_NOWAIT);
   if (rtn != -1)    /* restore the cursor if we got a WPM_DONE */
   {
      XUndefineCursor (XtDisplay (shell), XtWindow (shell));
      //return FALSE;
   }

   /*
    * Now look for a SENT_MSG
    */
   rtn = msgrcv (qid,(struct msgbuf *) &indata,
                 MAX_WORD_LENGTH, SENT_MSG, IPC_NOWAIT);

   if (rtn == -1 && errno != ENOMSG)   /* There was an error, ENOMSG is OK  */
   {
      errorDiag (shell, 
                 "msgrcv error\n"
                 "twcw must exit", NO_CANCEL);
      return (True);                   /* return True to stop work proc */
   }

   if (rtn > 0)     /* there was a SENT_MSG */
   {
      /* TJW  - add highlight for xmit text hr? */
      /* Add sent text to rxText if TWCW mode */
      if (cwArgs.mode == TWCW)
      {
         XmTextInsert (rxText, XmTextGetLastPosition (rxText),
            indata.data.word);
      }
//old loc   }

      /* Now, see if we are in practice mode */
      /* and should we send another word */
      if (XmToggleButtonGetState(practiceTB) == True)
      {
         pcnt++;
         if (pcnt >= 5)
         {
            send_msg (WORD_MSG, getFive(group));  /* Send a word to the queue */
            pcnt = 0;
         }
      }
   }
   usleep (100);
   return False;                      /* Always register again */      
}  


/*
 * getFive - generate 5 random letters
 */
#define PRACTICE_CHARS_CNT 26
//#define PRACTICE_CHARS_CNT 40

char *getFive (char grp[])
{
   int k, i;
   char p_letters[PRACTICE_CHARS_CNT] ="ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                                       //".,/?";
                                       //"1234567890";

   for (k=0; k<5; k++)
   {
      i = rand() % (PRACTICE_CHARS_CNT - 1);
      grp[k] = p_letters[i];
   }
   grp[5] = ' ';
   grp[6] = '\0';
   return (grp);
}
