/*
 * Common header file for twcw.c and sendCW.c
 */
#ifndef INCLUDED_COMMON_H
#define INCLUDED_COMMON_H
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <sys/msg.h>
#include <pthread.h>
#include "../config.h"
/*
 * Common Defines
 */
/* The two message types below are only read by twcw */
#define WPM_DONE         8L      /* Done setting new WPM */
#define SENT_MSG         7L      /* Send text to be displayed by the GUI */

/* The message types below are only read by sendCW */
/* and are processed in 1 -> 5 order */
#define WORD_MSG         6L      /* Read text to send */
#define STOP_MSG         5L      /* Stop sending */
#define FREQ_MSG         4L      /* Set sidetone frequency */
#define KEY_DEVICES_MSG  3L      /* Turn sidetone on of off */
#define FARNS_MSG        2L      /* Farnsworth value */
#define WPM_MSG          1L      /* Set new WPM */

#define TWCW_KEY         73      /* Message Queue Key */
#define MAX_WORD_LENGTH  100L    /* Maximum length of a word */

#define TWCW 0
#define CWIRC 1

/*
 * Message Queue Structure
 */
struct tag1
{
   long type;
   union
      {
          char word[MAX_WORD_LENGTH];
          int  val;
      } data;
};
#endif
