/*
 * hamlog_util.h - Funcoes uteis para o programa HamLog
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 	CT1FOX
 */

#ifndef HAMLOG_UTIL_INCLUDE
#define HAMLOG_UTIL_INCLUDE

#include "includes.h"
#include "hamlog_file.h"

typedef struct informacao
{
   GList *lista_cidades, *lista_paises, *lista_bandas, *lista_indicativos,
   *lista_modulacoes , *lista_antenas;
} INFORMACAO;

typedef struct escolha
{
   gint campo;
   gchar *conteudo;
} ESCOLHA;

extern void limpa_poe_dados_na_arvore ( GtkWidget *arvore , GList *lista_dados );
extern void acrescenta_dado_arvore ( GtkWidget *arvore , BASES_DADOS *dados );
extern void limpa_poe_indicativos_na_arvore ( GtkWidget *arvore , GList *lista_indicativos );
extern void acrescenta_indicativo_arvore ( GtkWidget *arvore , CONTACTO *dados );
extern GList *procura_indicativo_na_lista ( GList *lista_indicativos , gchar *indicativo );
extern GList *procura_nome_na_lista ( GList *lista_dados , gchar *nome );
extern void poe_valores_lista_colunas ( INFORMACAO *info , GtkWidget *lista_colunas , ESCOLHA escolha );
extern void converte_contacto_linha_texto ( INFORMACAO *info, CONTACTO *contacto , gchar *texto[] , gboolean sai );
extern gchar *converte_numero_em_dado ( GList *lista_dados , gint numero );
extern gchar *converte_numero_campo_em_dado ( INFORMACAO *info , CONTACTO *contacto,  gint numero_campo );
extern GList *converte_numero_campo_info_em_lista ( INFORMACAO *info , gint numero_campo );
extern CONTACTO *cria_estrutura_contacto (void);
extern void liberta_estrutura_contacto( GList *lista_indicativos , CONTACTO **contacto );
extern char *nomes_botoes ( gint numero_campo );
extern gpointer *ponteiro_do_campo_de_contacto ( CONTACTO *contacto, gint numero_campo );
extern gint comprimento_maximo_dados ( gint numero_campo );
extern gchar *numero_inteiro_para_letras ( gint numero );
extern gchar *numero_real_para_letras ( gfloat numero );
extern gchar *numero_timet_para_letras ( time_t tempo );
extern gint acrescenta_dado_lista ( GList *lista_dados , gchar *texto_de_entrada );
#endif
