/*
 * hamlog_ecran.c - Funcoes que tratam do aspecto grafico do HamLog
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 	CT1FOX
 */


#include "includes.h"
#include "hamlog.h"
#include "hamlog_callback.h"
#include "hamlog_file.h"
#include "hamlog_util.h"
#include "hamlog_ecran.h"

char *titulos_colunas[]={ NOME_CONTACTO_INDICATIVO ,
   			  NOME_CONTACTO_NOME,
   			  NOME_CONTACTO_BANDA,
   			  NOME_CONTACTO_PAIS,
   			  NOME_CONTACTO_MODULACAO,
                          NOME_CONTACTO_DATA,
   			  NOME_CONTACTO_CIDADE,
   			  NOME_CONTACTO_REMOTO "\n" NOME_CONTACTO_SINAL,
   		          NOME_CONTACTO_REMOTO "\n" NOME_CONTACTO_AUDIO,
   		          NOME_CONTACTO_LOCAL "\n" NOME_CONTACTO_AUDIO,
   		          NOME_CONTACTO_LOCAL "\n" NOME_CONTACTO_SINAL,
   			  NOME_CONTACTO_OBSERVACOES
};

void cria_ecran_principal ( GtkWidget **janela_principal )
{
   *janela_principal = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_name ( *janela_principal, GTKRC_NOME_JANELA);
   gtk_window_set_title (GTK_WINDOW (*janela_principal), TITULO_JANELA_PRINCIPAL );
   gtk_container_border_width (GTK_CONTAINER (*janela_principal), JANELA_BORDO);
   gtk_widget_set_usize (*janela_principal, JANELA_TAMANHO_X, JANELA_TAMANHO_Y);
   gtk_signal_connect (GTK_OBJECT (*janela_principal), "delete_event",
                       GTK_SIGNAL_FUNC (sai_janela_principal), NULL);
   gtk_signal_connect (GTK_OBJECT (*janela_principal), "destroy",
                            GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
}

void cria_ecran_tabelas ( GtkWidget *janela_principal , GtkWidget **tabela )
{
   *tabela = gtk_table_new( 10, 10 , TRUE );
   gtk_widget_set_name ( *tabela, GTKRC_NOME_TABELA);
   gtk_container_add (GTK_CONTAINER ( janela_principal ), *tabela);
   gtk_widget_show ( *tabela );
}


void cria_menus ( GtkWidget *tabela , GtkWidget **barra_menu )
{
   GtkWidget *sub_menu , *menu , *item;
   
   /* cria a barra de menu */
   *barra_menu = gtk_menu_bar_new();
   gtk_widget_set_name ( *barra_menu, GTKRC_NOME_BARRA_MENU );
   
   /* menu Ficheiro */
   sub_menu = gtk_menu_new ();
   gtk_widget_set_name ( sub_menu, GTKRC_MENU_FICHEIRO_NOME);
   	/* Novo Contacto */
   	item = gtk_menu_item_new_with_label ( MENU_FICHEIRO_CONTACTO_NOME );
   	gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(funcao_menu_ficheiro),
                                   (gpointer) MENU_FICHEIRO_CONTACTO_NOME );
   	gtk_menu_append( GTK_MENU(sub_menu), item);
   	gtk_widget_show(item);
   	
   	/* Grava */
   	item = gtk_menu_item_new_with_label ( MENU_FICHEIRO_GRAVA_NOME );
	gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(funcao_menu_ficheiro),
                                   (gpointer) MENU_FICHEIRO_GRAVA_NOME );   
   	gtk_menu_append( GTK_MENU(sub_menu), item);
      	gtk_widget_show(item);
   	/* Imprime 
   	item = gtk_menu_item_new_with_label ( MENU_FICHEIRO_IMPRIME_NOME );
   	gtk_menu_append( GTK_MENU(sub_menu), item);
      	gtk_widget_show(item);*/
   	/* Imprime QSL
   	item = gtk_menu_item_new_with_label ( MENU_FICHEIRO_IMPRIME_QSL_NOME );
   	gtk_menu_append( GTK_MENU(sub_menu), item);
      	gtk_widget_show(item);*/
   	/* Sair */
   	item = gtk_menu_item_new_with_label ( MENU_FICHEIRO_SAI_NOME );
	gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(funcao_menu_ficheiro),
                                   (gpointer) MENU_FICHEIRO_GRAVA_NOME );   
	gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(gtk_main_quit),
                                    NULL);   
   	gtk_menu_append( GTK_MENU(sub_menu), item);
      	gtk_widget_show(item);
   	/* Acrescenta o menu Ficheiro a' barra */
   	menu = gtk_menu_item_new_with_label ( MENU_FICHEIRO_NOME );
   	gtk_widget_show (menu);
   	gtk_menu_item_set_submenu( GTK_MENU_ITEM(menu), sub_menu );
   	gtk_menu_bar_append( GTK_MENU_BAR (*barra_menu), menu );

   
   /* Menu Ajuda */
   sub_menu = gtk_menu_new ();
   gtk_widget_set_name ( sub_menu, GTKRC_MENU_AJUDA_NOME);
   	/* Ajuda
   	item = gtk_menu_item_new_with_label ( MENU_AJUDA_AJUDA_NOME );
   	gtk_menu_append( GTK_MENU(sub_menu), item);
   	gtk_widget_show(item);
        gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(funcao_menu_ajuda),
                                   (gpointer) MENU_AJUDA_NOME );*/
   	/* Creditos
   	item = gtk_menu_item_new_with_label ( MENU_AJUDA_CREDITOS_NOME );
   	gtk_menu_append( GTK_MENU(sub_menu), item);
      	gtk_widget_show(item);
        gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(funcao_menu_ajuda),
                                   (gpointer) MENU_AJUDA_CREDITOS_NOME );*/
   	/* Sobre */
   	item = gtk_menu_item_new_with_label ( MENU_AJUDA_SOBRE_NOME );
   	gtk_menu_append( GTK_MENU(sub_menu), item);
      	gtk_widget_show(item);
        gtk_signal_connect_object( GTK_OBJECT(item), "activate",
                                   GTK_SIGNAL_FUNC(funcao_menu_ajuda),
                                   (gpointer) MENU_AJUDA_SOBRE_NOME );   
   	/* Acrescenta o menu Ajuda a' barra */
   	menu = gtk_menu_item_new_with_label ( MENU_AJUDA_NOME );
   	gtk_widget_show (menu);
   	gtk_menu_item_set_submenu( GTK_MENU_ITEM(menu), sub_menu );
    	/* Poe do lado direito */
    	gtk_menu_item_right_justify( GTK_MENU_ITEM(menu));
   	gtk_menu_bar_append( GTK_MENU_BAR (*barra_menu), menu );
   
   
   /* Acrescenta o menu a' tabela */
   gtk_table_attach_defaults( GTK_TABLE(tabela) , *barra_menu , 0 , 10 , 0 , 1 );
   gtk_widget_show ( *barra_menu );
}


void cria_janela_separada ( GtkWidget *tabela , GtkWidget **janela_separada )
{
   *janela_separada = gtk_hpaned_new ();
   gtk_widget_show ( *janela_separada );
   gtk_paned_set_gutter_size (GTK_PANED(*janela_separada), 15 );

/*   gtk_paned_set_position ( GTK_PANED(*janela_separada), 1 ); */
   gtk_table_attach_defaults( GTK_TABLE(tabela) , *janela_separada , 0 , 10 , 1 , 9 );
}


void cria_arvore ( GtkWidget *janela_separada , GtkWidget **arborizacao , GList *lista_arvore )
{
   GtkWidget *janela , *item ;
   GList *corrente;
   ARVORE *dados_arvore;
   
   /* cria janela que vai conter a arvore e acrecenta-a a' tabela */
   janela = gtk_scrolled_window_new( NULL , NULL );
   gtk_widget_show ( janela );
   gtk_widget_set_name ( janela, GTKRC_NOME_JANELA_ARVORE);
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW(janela) , GTK_POLICY_AUTOMATIC ,
				  GTK_POLICY_AUTOMATIC );
   /* gtk_widget_set_usize (janela, 150, 200); */
   gtk_paned_add1 (GTK_PANED(janela_separada), janela);

   /* cria arvore: */
   *arborizacao = gtk_tree_new();
   gtk_tree_set_selection_mode( GTK_TREE(*arborizacao) , GTK_SELECTION_SINGLE );
   gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(janela), *arborizacao);
   gtk_widget_show (*arborizacao);
   
   if ( lista_arvore == NULL ) return;
   corrente = lista_arvore->next;
   while ( corrente != NULL )
     {
	if ( (dados_arvore = corrente->data) == NULL ) break;
	/* acrecenta item a' lista principal */
	item = gtk_tree_item_new_with_label( dados_arvore->nome );
  	gtk_tree_append( GTK_TREE(*arborizacao) , item );
   	gtk_widget_show (item);
	/* Cria sub-arvore */
   	dados_arvore->arvore = gtk_tree_new();
   	gtk_tree_item_set_subtree( GTK_TREE_ITEM(item) , dados_arvore->arvore );
        gtk_signal_connect (GTK_OBJECT(dados_arvore->arvore), "select_child",
		      GTK_SIGNAL_FUNC(dados_arvore->funcao), dados_arvore->arvore );
	corrente = corrente->next;
     }
}

void cria_lista_colunas ( GtkWidget *janela_separada , GtkWidget **lista_colunas )
{
   GtkWidget *janela;
   gint n;
   janela = gtk_scrolled_window_new( NULL , NULL );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW(janela) , GTK_POLICY_AUTOMATIC ,
				  GTK_POLICY_AUTOMATIC );
   gtk_widget_show ( janela );
   gtk_paned_add2 (GTK_PANED(janela_separada), janela);

   *lista_colunas = gtk_clist_new_with_titles( MOSTRA_NUMERO_COLUNAS, titulos_colunas );
   gtk_clist_set_selection_mode( GTK_CLIST(*lista_colunas),
				GTK_SELECTION_BROWSE );
   gtk_clist_set_shadow_type (GTK_CLIST(*lista_colunas), GTK_SHADOW_OUT );
   gtk_clist_column_titles_passive( GTK_CLIST(*lista_colunas) );
   for (n=0;n<MOSTRA_NUMERO_COLUNAS;n++)
     {
     	gtk_clist_set_column_auto_resize (GTK_CLIST(*lista_colunas), n, TRUE );
	gtk_clist_set_column_justification(GTK_CLIST(*lista_colunas),n,GTK_JUSTIFY_CENTER);
     }
   gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(janela), *lista_colunas);
   gtk_signal_connect( GTK_OBJECT(*lista_colunas), "select_row" ,
		      GTK_SIGNAL_FUNC(funcao_linha_seleccionada), NULL );
   gtk_widget_show ( *lista_colunas );
}

GtkWidget *cria_botao_opcao_contacto ( GtkWidget *janela, GtkWidget *tabela ,
				gint x , gint y , gint comprimento ,
				gint numero_campo ,
				CONTACTO *contacto , INFORMACAO *info ,
				gint tipo )
{
   BOTAO_OPCAO *botao;
   gchar *conteudo;
   botao = g_malloc0 (sizeof(BOTAO_OPCAO));
   
   botao->nome = nomes_botoes (numero_campo);
   botao->numero_campo = numero_campo;
   botao->janela_pai = janela;
   botao->campo_contacto = ponteiro_do_campo_de_contacto ( contacto, numero_campo );
   switch(tipo)
     {
      case ENTRADA_LETRAS:
	botao->lista_dados = converte_numero_campo_info_em_lista ( info , numero_campo );
	conteudo = converte_numero_campo_em_dado ( info , contacto, numero_campo );
	break;
      case ENTRADA_DATAS:
	botao->lista_dados = NULL;
	conteudo = numero_timet_para_letras( *((time_t *)botao->campo_contacto));
	break;
     }
#ifdef HAMLOG_DEBUG
   printf ("lista:%p\tcampo:%p\tinfo:%p\tn campo:%d\n",
	   botao->lista_dados , botao->campo_contacto, info , botao->numero_campo );
#endif
   botao->botao = gtk_button_new ();
   gtk_widget_show (botao->botao);
   botao->label = gtk_label_new("");
   gtk_widget_show (botao->label);
   gtk_label_set_justify(GTK_LABEL(botao->label), GTK_JUSTIFY_LEFT );
   gtk_container_add (GTK_CONTAINER (botao->botao), botao->label );
   poe_nome_no_botao ( botao , conteudo );
   switch (tipo)
     {
      case ENTRADA_LETRAS:
	gtk_signal_connect_object (GTK_OBJECT(botao->botao), "clicked",
				   GTK_SIGNAL_FUNC(funcao_botao_altera_campo_lista),
				   (gpointer)botao );
	break;
      case ENTRADA_DATAS:
	gtk_signal_connect_object(GTK_OBJECT(botao->botao), "clicked",
			   GTK_SIGNAL_FUNC(funcao_botao_altera_campo_data),
			   (gpointer)botao );
	break;
     }
   gtk_signal_connect_object (GTK_OBJECT(botao->botao), "destroy",
			      GTK_SIGNAL_FUNC(g_free),
			      (gpointer) botao);
   gtk_table_attach_defaults( GTK_TABLE(tabela) , botao->botao , 
			     x , x+comprimento , y , y+1 );
   return (botao->botao);
}
				

GtkWidget *cria_entrada_contacto ( GtkWidget *tabela , 
				     gint x , gint y , 
				     gint comprimento_nome ,
				     gint comprimento_entrada,
				     gint numero_campo , 
				     CONTACTO *contacto , gint tipo )
{
   GtkWidget *nome , *entrada;
   gpointer campo;
   gint comprimento_dados;
   gchar *conteudo, *nome_botao;
   if ( contacto == NULL ) return(NULL);

   campo = ponteiro_do_campo_de_contacto ( contacto, numero_campo );
   comprimento_dados = comprimento_maximo_dados ( numero_campo );
   
   /* cria ponteiro de caracteres com o nome da entrada */
   nome_botao = nomes_botoes (numero_campo);
   conteudo = g_malloc0 ( strlen (nome_botao) + 3 );
   strcpy ( conteudo , nome_botao ); strcat ( conteudo , ": ");
   
   nome = gtk_label_new(conteudo);
   gtk_widget_show (nome);
   entrada = gtk_entry_new_with_max_length (comprimento_dados);
   gtk_widget_show (entrada);
   gtk_table_attach_defaults( GTK_TABLE(tabela) , nome , x ,
			     x + comprimento_nome , y , y + 1 );
   gtk_table_attach_defaults( GTK_TABLE(tabela) , entrada , 
			     x + comprimento_nome  , 
			     x + comprimento_nome + comprimento_entrada ,
			     y , y + 1 );
   switch (tipo)
     {
      case ENTRADA_NUMEROS_REAIS:
	gtk_entry_set_text(GTK_ENTRY(entrada),
			   numero_real_para_letras( *((gfloat*)campo) ) );
	gtk_signal_connect(GTK_OBJECT(entrada), "changed",
			   GTK_SIGNAL_FUNC(funcao_altera_campo_numeros_reais),
			   (gpointer)campo );
	break;
      case ENTRADA_NUMEROS_INTEIROS:
	gtk_entry_set_text(GTK_ENTRY(entrada), 
			   numero_inteiro_para_letras( *((gint*)campo) ));
   	gtk_signal_connect(GTK_OBJECT(entrada), "changed",
			   GTK_SIGNAL_FUNC(funcao_altera_campo_numeros_inteiros),
			   (gpointer)campo );
	break;
      case ENTRADA_LETRAS:
	gtk_entry_set_text( GTK_ENTRY(entrada), (gchar*)campo );
	gtk_signal_connect(GTK_OBJECT(entrada), "changed",
			   GTK_SIGNAL_FUNC(funcao_altera_campo_letras),
			   (gpointer)campo );
	break;
     }
   g_free ( conteudo );
   return(entrada);
}




void cria_janela_contacto ( GtkWidget **janela_contacto , INFORMACAO *info, CONTACTO *contacto , gboolean novo )
{
   GtkWidget *tabela , *texto, *botao;
   gchar titulo_janela[strlen(TITULO_JANELA_CONTACTO)+COMPRIMENTO_INDICATIVO+4];
   if (( info == NULL ) || ( contacto == NULL )) return;
   /* Cria Janela de Contacto */
   *janela_contacto = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_position(GTK_WINDOW(*janela_contacto), GTK_WIN_POS_MOUSE );
   gtk_widget_set_name ( *janela_contacto, GTKRC_NOME_JANELA_CONTACTO);
   strcpy (titulo_janela , TITULO_JANELA_CONTACTO);
   strcat (titulo_janela , ": ");
   if ( g_strcasecmp (contacto->indicativo, "" ) != 0 )
   	strcat (titulo_janela , contacto->indicativo );
   else
        strcat (titulo_janela, NOME_NOVO_CONTACTO);
   gtk_window_set_title (GTK_WINDOW (*janela_contacto), titulo_janela );
   gtk_container_border_width (GTK_CONTAINER (*janela_contacto), JANELA_BORDO);
   gtk_widget_set_usize (*janela_contacto,
			 JANELA_CONTACTO_TAMANHO_X, JANELA_CONTACTO_TAMANHO_Y);
   gtk_signal_connect_object (GTK_OBJECT (*janela_contacto), "delete_event",
                       GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		       GTK_OBJECT(*janela_contacto));
   /* Cria tabela para formatacao */
   tabela = gtk_table_new( 14, 14 , TRUE );
   gtk_container_add (GTK_CONTAINER (*janela_contacto), tabela);
   gtk_widget_show ( tabela );

   /* botao OK */
   botao = gtk_button_new_with_label(NOME_BOTAO_OK);
   gtk_widget_show (botao);
   gtk_table_attach_defaults( GTK_TABLE(tabela) , botao , 0 , 2 , 13 , 14 );
   if ( novo == TRUE )
     {
     gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (funcao_contacto_acrescenta),
                                   (gpointer)contacto);
     }
     gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (*janela_contacto));   
   /* botao Sair */
   botao = gtk_button_new_with_label(NOME_BOTAO_SAI);
   gtk_widget_show (botao);
   gtk_table_attach_defaults( GTK_TABLE(tabela) , botao , 4 , 6 , 13 , 14 );
   if ( novo == TRUE )
     {
     gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (funcao_contacto_retira),
                                   (gpointer)contacto);
     }
     gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (*janela_contacto));
   /* Botao apaga contacto */
/*   botao = gtk_button_new_with_label(NOME_BOTAO_APAGA);
*   gtk_widget_show (botao);
*   gtk_table_attach_defaults( GTK_TABLE(tabela) , botao , 12 , 14 , 13 , 14 );
*   gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
*                                   GTK_SIGNAL_FUNC (funcao_contacto_retira),
*                                   (gpointer)contacto);
*   gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
*                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (*janela_contacto));*/

   
   
   /* Indicativo */
   cria_entrada_contacto ( tabela , 0 , 0 , 2 , 4 , 
			  NUMERO_CAMPO_INDICATIVO , contacto , ENTRADA_LETRAS );
   /* nome */
   cria_entrada_contacto ( tabela , 8 , 0 , 2 , 4 , 
			  NUMERO_CAMPO_NOME , contacto , ENTRADA_LETRAS );
   /* Cidade */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 0 , 2 , 6 , 
			      NUMERO_CAMPO_CIDADE , contacto, info , ENTRADA_LETRAS );
   /* Pais */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 8 , 2 , 6 , 
			      NUMERO_CAMPO_PAIS , contacto , info , ENTRADA_LETRAS);
   /* Banda */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 0 , 3 , 6 , 
			      NUMERO_CAMPO_BANDA , contacto , info , ENTRADA_LETRAS );
   /* Tipo de Modulacao */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 8 , 3 , 6 , 
			      NUMERO_CAMPO_MODULACAO , contacto , info , ENTRADA_LETRAS );
   /* Data Inicio */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 0 , 1 , 6 , 
			      NUMERO_CAMPO_DATA_INICIO , contacto , info, ENTRADA_DATAS );
   /* Data Fim */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 8 , 1 , 6 , 
			      NUMERO_CAMPO_DATA_FIM , contacto , info, ENTRADA_DATAS );
   /* Remoto:Sinal */
   cria_entrada_contacto ( tabela , 0 , 5 , 2 , 1 , NUMERO_CAMPO_SINAL_REMOTO ,
			  		contacto , ENTRADA_NUMEROS_INTEIROS );
   /* Remoto:Audio */
   cria_entrada_contacto ( tabela , 0 , 6 , 2 , 1 , NUMERO_CAMPO_AUDIO_REMOTO ,
			  		contacto , ENTRADA_NUMEROS_INTEIROS );
   /* Remoto:Potencia */
   cria_entrada_contacto ( tabela , 3 , 5 , 2 , 2 , NUMERO_CAMPO_POTENCIA_REMOTA ,
			  		contacto , ENTRADA_NUMEROS_REAIS );
   /* Remoto:Frequencia */
   cria_entrada_contacto ( tabela , 3 , 6 , 2 , 2 , NUMERO_CAMPO_FREQUENCIA_RX ,
			  		contacto , ENTRADA_NUMEROS_REAIS );
   /* Remoto:Antena RX */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 0 , 8 , 7 , 
			      NUMERO_CAMPO_ANT_RX_REMOTA , contacto , info , ENTRADA_LETRAS );
   /* Remoto:Antena TX */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 0 , 9 , 7 , 
			      NUMERO_CAMPO_ANT_TX_REMOTA , contacto , info , ENTRADA_LETRAS );
   /* Local:Sinal */
   cria_entrada_contacto ( tabela , 7 , 5 , 2 , 1 , NUMERO_CAMPO_SINAL_LOCAL ,
			  			contacto , ENTRADA_NUMEROS_INTEIROS );
   /* Local:Audio */
   cria_entrada_contacto ( tabela , 7 , 6 , 2 , 1 , NUMERO_CAMPO_AUDIO_LOCAL ,
			  			contacto , ENTRADA_NUMEROS_INTEIROS );
   /* Local:Potencia */
   cria_entrada_contacto ( tabela , 10 , 5 , 2 , 2 , NUMERO_CAMPO_POTENCIA_LOCAL ,
			  			contacto , ENTRADA_NUMEROS_REAIS );
   /* Local:Frequencia */
   cria_entrada_contacto ( tabela , 10 , 6 , 2 , 2 , NUMERO_CAMPO_FREQUENCIA_TX ,
			  			contacto , ENTRADA_NUMEROS_REAIS );
   /* Local:Antena RX */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 7 , 8 , 7 , 
			      NUMERO_CAMPO_ANT_RX_LOCAL , contacto , info , ENTRADA_LETRAS );
   /* Local:Antena TX */
   cria_botao_opcao_contacto ( *janela_contacto, tabela , 7 , 9 , 7 , 
			      NUMERO_CAMPO_ANT_TX_LOCAL , contacto , info , ENTRADA_LETRAS );
   /* observacoes */
   cria_entrada_contacto ( tabela , 0 , 11 , 1 , 12 , NUMERO_CAMPO_OBSERVACOES ,
			  			contacto , ENTRADA_LETRAS );
   /* Remoto */
   texto = gtk_label_new(NOME_CONTACTO_REMOTO);
   gtk_widget_show (texto);
   gtk_table_attach_defaults( GTK_TABLE(tabela) , texto , 0 , 7 ,4 , 5 );
   /* Local */
   texto = gtk_label_new(NOME_CONTACTO_LOCAL);
   gtk_widget_show (texto);
   gtk_table_attach_defaults( GTK_TABLE(tabela) , texto , 7 , 14 ,4 , 5 );
   
   gtk_widget_show ( *janela_contacto );
}



void mostra_lista_opcoes ( BOTAO_OPCAO *botao_opcao )
{
   GtkWidget *dialogo, *botao, *entrada;
   GtkWidget *janela_coluna, *lista_coluna;
   GList *corrente, *lista_dados;
   BASES_DADOS *dados;
   gint numero_linha, numero_campo, comprimento_dados;
   gchar *titulo_janela;
   
   if ( botao_opcao == NULL ) return;
   numero_campo = botao_opcao->numero_campo;
   titulo_janela = botao_opcao->nome;
   lista_dados = botao_opcao->lista_dados;
   comprimento_dados = comprimento_maximo_dados ( numero_campo );
   if ( lista_dados == NULL ) return;
   gtk_widget_set_sensitive(botao_opcao->janela_pai, FALSE );

   /* cria janela de "dialogo" */
   dialogo = gtk_dialog_new();
   gtk_window_set_position(GTK_WINDOW(dialogo), GTK_WIN_POS_MOUSE );
   gtk_window_set_title (GTK_WINDOW (dialogo), titulo_janela );
   gtk_widget_set_usize (dialogo,JANELA_LISTA_TAMANHO_X,
			 JANELA_LISTA_TAMANHO_Y);
   gtk_signal_connect (GTK_OBJECT (dialogo), "destroy",
                                   GTK_SIGNAL_FUNC (liberta_janela),
                                   (gpointer) botao_opcao->janela_pai );
   gtk_widget_set_sensitive(botao_opcao->janela_pai, FALSE );
   /* Botao Cancelar */
   botao = gtk_button_new_with_label(NOME_BOTAO_SAI);
   gtk_widget_show (botao);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->action_area),
                            botao, TRUE, TRUE, 0);
   gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (dialogo));
   /* Janela que vai conter a lista */
   janela_coluna = gtk_scrolled_window_new( NULL , NULL );
   gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW(janela_coluna) , GTK_POLICY_AUTOMATIC ,
				  GTK_POLICY_AUTOMATIC );
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->vbox),
                            janela_coluna, TRUE, TRUE, 0);
   /* entrada de novos valores */
   entrada = gtk_entry_new_with_max_length (comprimento_dados);
   gtk_widget_show (entrada);
   gtk_tooltips_set_tip( ajudinha , entrada , AJUDA_NOVA_ENTRADA , NULL );
   gtk_signal_connect (GTK_OBJECT(entrada), "activate",
			   GTK_SIGNAL_FUNC(funcao_acrecenta_dado_lista),
			   (gpointer)botao_opcao );
   gtk_signal_connect_object( GTK_OBJECT(entrada), "activate" ,
		      	   GTK_SIGNAL_FUNC(gtk_widget_destroy),
		      	   GTK_OBJECT (dialogo) );
   
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->vbox),
                            entrada, TRUE, TRUE, 0);
   /* Cria lista de dados */
   lista_coluna = gtk_clist_new ( 1 );
   gtk_clist_set_selection_mode( GTK_CLIST(lista_coluna),GTK_SELECTION_BROWSE );
   gtk_clist_set_shadow_type (GTK_CLIST(lista_coluna), GTK_SHADOW_OUT );
   gtk_clist_set_column_auto_resize (GTK_CLIST(lista_coluna), 0, TRUE );
   gtk_clist_set_column_justification(GTK_CLIST(lista_coluna),0,GTK_JUSTIFY_CENTER);
   gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(janela_coluna),
					  lista_coluna);
   gtk_signal_connect( GTK_OBJECT(lista_coluna), "select_row" ,
		      GTK_SIGNAL_FUNC(funcao_muda_campo_contacto),
		      (gpointer) botao_opcao );
   gtk_widget_show ( lista_coluna );
   gtk_widget_show ( janela_coluna );

   /* Poe os dados na lista */
   corrente = lista_dados->next;
   numero_linha=0;
   while ( corrente != NULL )
     {
	if ( (dados = corrente->data) == NULL )break;
	/* acrescenta a' lista */
	gtk_clist_append( GTK_CLIST(lista_coluna) , &(dados->nome) );
	/* associa a cada linha o ponteiro que usamos para metar os dados */
	gtk_clist_set_row_data (GTK_CLIST(lista_coluna),
				     numero_linha , dados );
	numero_linha++;
	corrente = corrente->next;
     }
   /* tenho que por isto DEPOIS da actualizacao das listas pois
    * o sinal "select_row" e' chamado no inicio...talvez um BUG da GTK?
    */
   gtk_signal_connect_object( GTK_OBJECT(lista_coluna), "select_row" ,
		      GTK_SIGNAL_FUNC(gtk_widget_destroy),
		      GTK_OBJECT (dialogo) );
   gtk_widget_show ( dialogo );
}


void poe_nome_no_botao ( BOTAO_OPCAO *botao , gchar *dado )
{
   gchar conteudo[MAXIMO_COMPRIMENTO_CONTEUDO];
   if ( botao == NULL ) return;
   if ( botao->label == NULL ) return;
   memset ( conteudo , 0 , MAXIMO_COMPRIMENTO_CONTEUDO );
   if ( botao->nome != NULL ) strcpy ( conteudo , botao->nome);
   strcat ( conteudo , ": ");
   if ( dado != NULL ) strcat ( conteudo , dado );
   gtk_label_set_text( GTK_LABEL(botao->label), conteudo );
}



void mostra_calendario ( BOTAO_OPCAO *botao_opcao )
{
   GtkWidget *dialogo, *botao, *calendario, *escala;
   GtkAdjustment *ajuste;
   struct tm *data;
   gint dia, mes , ano, hora, minuto;
   
   if ( botao_opcao == NULL ) return;
   gtk_widget_set_sensitive(botao_opcao->janela_pai, FALSE );
   
   data = localtime ((time_t *)botao_opcao->campo_contacto);
   dia = data->tm_mday;
   mes = data->tm_mon;
   ano = data->tm_year + 1900;
   hora = data->tm_hour;
   minuto = data->tm_min;

#ifdef HAMLOG_DEBUG
   printf ("dia: %d\tmes: %d\tano: %d\n", dia, mes , ano );
#endif
   
   /* cria dialogo */
   dialogo = gtk_dialog_new();
   gtk_window_set_position(GTK_WINDOW(dialogo), GTK_WIN_POS_MOUSE );
   gtk_window_set_title (GTK_WINDOW (dialogo), TITULO_JANELA_CALENDARIO );
   gtk_widget_set_usize (dialogo,JANELA_CALENDARIO_TAMANHO_X,
			 JANELA_CALENDARIO_TAMANHO_Y);
   gtk_signal_connect (GTK_OBJECT (dialogo), "destroy",
                                   GTK_SIGNAL_FUNC (liberta_janela),
                                   (gpointer) botao_opcao->janela_pai );
   /* Botao de Cancelar */
   botao = gtk_button_new_with_label(NOME_BOTAO_SAI);
   gtk_widget_show (botao);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->action_area),
                            botao, TRUE, TRUE, 0);
   gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (dialogo));  
   /* Mostra data */
   calendario = gtk_calendar_new ();
   gtk_widget_show(calendario);
   gtk_calendar_display_options (GTK_CALENDAR(calendario), 
				 GTK_CALENDAR_SHOW_DAY_NAMES | 
				 GTK_CALENDAR_SHOW_WEEK_NUMBERS | 
				 GTK_CALENDAR_WEEK_START_MONDAY |
				 GTK_CALENDAR_SHOW_HEADING );
   gtk_calendar_select_month    (GTK_CALENDAR(calendario), mes , ano );
   gtk_calendar_select_day      (GTK_CALENDAR(calendario), dia );
   gtk_signal_connect (GTK_OBJECT (calendario), "day_selected",
                                   GTK_SIGNAL_FUNC (funcao_muda_campo_data),
                                   (gpointer) botao_opcao );
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->vbox),
                            calendario, TRUE, TRUE, 0);
   /* Cria ajustes para hora e data */
   /* hora */
   ajuste = GTK_ADJUSTMENT(gtk_adjustment_new( hora , 0.0 , 23.0 , 1.0 , 12.0 , 0.0 ));
   ajuste->value = hora;
   gtk_signal_connect (GTK_OBJECT (ajuste), "value_changed",
                                   GTK_SIGNAL_FUNC (funcao_muda_campo_hora),
                                   (gpointer) botao_opcao );
   escala = gtk_hscale_new(GTK_ADJUSTMENT(ajuste));
   gtk_scale_set_digits( GTK_SCALE(escala), 0);
   gtk_range_set_update_policy( GTK_RANGE(escala),GTK_UPDATE_DELAYED);
   gtk_widget_show (escala);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->vbox),
                            escala, TRUE, TRUE, 0);
   /* minuto */
   ajuste = GTK_ADJUSTMENT(gtk_adjustment_new( hora , 0.0 , 59.0 , 1.0 , 5.0 , 0.0 ));
   ajuste->value = minuto;   
   gtk_signal_connect (GTK_OBJECT (ajuste), "value_changed",
                                   GTK_SIGNAL_FUNC (funcao_muda_campo_minuto),
                                   (gpointer) botao_opcao );
   escala = gtk_hscale_new(GTK_ADJUSTMENT(ajuste));
   gtk_scale_set_digits( GTK_SCALE(escala), 0);
   gtk_range_set_update_policy( GTK_RANGE(escala),GTK_UPDATE_DELAYED);
   gtk_widget_show (escala);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialogo)->vbox),
                            escala, TRUE, TRUE, 0);
   gtk_widget_show ( dialogo );
}
