/*
 * hamlog_callback.h - Funcoes de chamada para o programa HamLog
 * 
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * CT1FOX
 * 
 */

#include "includes.h"
#include "hamlog.h"
#include "hamlog_callback.h"
#include "hamlog_file.h"
#include "hamlog_util.h"
#include "hamlog_ecran.h"

gint posicao_item_seleccionado ( GtkWidget *arvore )
{
   GList *seleccao;
   GtkWidget *item;
   seleccao = GTK_TREE_SELECTION(arvore);
   if ( seleccao == NULL ) return(-1);
   item = GTK_WIDGET (seleccao->data);
   return (gtk_tree_child_position( GTK_TREE(arvore), item));
}

gchar *conteudo_item_seleccionado( GtkWidget *arvore )
{
   GList *seleccao;
   gchar *nome;
   GtkLabel *label;
   GtkWidget *item;
   seleccao = GTK_TREE_SELECTION(arvore);
   if ( seleccao == NULL ) return(NULL);
   item = GTK_WIDGET (seleccao->data);
   label = GTK_LABEL (GTK_BIN (item)->child);
   gtk_label_get (label, &nome);
   return(nome);
}

gint sai_janela_principal(GtkWidget *widget, GdkEvent *event, gpointer data)
{
   /* Grava antes de sair */
   funcao_menu_ficheiro ( MENU_FICHEIRO_GRAVA_NOME );
   return(FALSE);
}

void funcao_indicativo_seleccionado (GtkWidget *root_tree, GtkWidget *child, GtkWidget *subtree)
{
   ESCOLHA escolha;
   escolha.campo = NUMERO_CAMPO_INDICATIVO;
   escolha.conteudo = conteudo_item_seleccionado(root_tree);
   poe_valores_lista_colunas ( &info , lista_colunas , escolha );
}

void funcao_bandas_seleccionado (GtkWidget *root_tree, GtkWidget *child, GtkWidget *subtree)
{
   ESCOLHA escolha;
   escolha.campo = NUMERO_CAMPO_BANDA;
   escolha.conteudo = conteudo_item_seleccionado(root_tree);
   poe_valores_lista_colunas ( &info , lista_colunas , escolha );
}

void funcao_cidades_seleccionado (GtkWidget *root_tree, GtkWidget *child, GtkWidget *subtree)
{
   ESCOLHA escolha;
   escolha.campo = NUMERO_CAMPO_CIDADE;
   escolha.conteudo = conteudo_item_seleccionado(root_tree);
   poe_valores_lista_colunas ( &info , lista_colunas , escolha );
}

void funcao_paises_seleccionado (GtkWidget *root_tree, GtkWidget *child, GtkWidget *subtree)
{
   ESCOLHA escolha;
   escolha.campo = NUMERO_CAMPO_PAIS;
   escolha.conteudo = conteudo_item_seleccionado(root_tree);
   poe_valores_lista_colunas ( &info , lista_colunas , escolha );
}


void funcao_linha_seleccionada ( GtkWidget *lista_colunas, gint linha, 
		          gint coluna, GdkEventButton *event, gpointer data)
/*
 * esta funcao e' chamada quando o utilizador escolhe uma linha (contacto)
 * na janela principal
 */
{
   CONTACTO *contacto;
   GtkWidget *janela_contacto;
   contacto = gtk_clist_get_row_data( GTK_CLIST (lista_colunas), linha );
   cria_janela_contacto ( &janela_contacto , &info , contacto , FALSE );
}


void funcao_menu_ficheiro ( gchar *seleccao )
{
   /* novo contacto */
   if ( g_strcasecmp ( seleccao , MENU_FICHEIRO_CONTACTO_NOME ) == 0 )
     {
	GtkWidget *janela_contacto;
	CONTACTO *contacto;
	contacto = cria_estrutura_contacto();
	cria_janela_contacto ( &janela_contacto , &info , contacto , TRUE );
	return;
     }
   /* grava tudo */
   if ( g_strcasecmp ( seleccao , MENU_FICHEIRO_GRAVA_NOME ) == 0 )
     {
	grava_indicativos ( NOME_FICHEIRO_CONTACTOS , info.lista_indicativos );
	grava_dados ( NOME_FICHEIRO_CIDADES , info.lista_cidades );
	grava_dados ( NOME_FICHEIRO_PAISES , info.lista_paises );
	grava_dados ( NOME_FICHEIRO_BANDAS , info.lista_bandas );
	grava_dados ( NOME_FICHEIRO_MODULACOES , info.lista_modulacoes );
	grava_dados ( NOME_FICHEIRO_ANTENAS , info.lista_antenas );
	return;
     }
   printf ("oops\n");
}

void funcao_menu_ajuda ( gchar *seleccao )
{
   GtkWidget *janela, *botao, *texto;
   /* Sobre o programa */
   if ( g_strcasecmp ( seleccao , MENU_AJUDA_SOBRE_NOME ) == 0 )
     {
	janela = gtk_dialog_new();
	gtk_window_set_position(GTK_WINDOW(janela), GTK_WIN_POS_MOUSE );
	gtk_widget_set_usize (janela,JANELA_SOBRE_TAMANHO_X, JANELA_SOBRE_TAMANHO_Y);
	botao = gtk_button_new_with_label(NOME_BOTAO_OK);
   	gtk_widget_show (botao);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (janela)->action_area),
                            botao, TRUE, TRUE, 0);
	gtk_signal_connect_object (GTK_OBJECT (botao), "clicked",
                                   GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                   GTK_OBJECT (janela));
	texto = gtk_label_new (NOME_PROGRAMA "\n" VERSAO_PROGRAMA "\n" AUTOR_PROGRAMA1 "\n" );
        gtk_box_pack_start (GTK_BOX (GTK_DIALOG (janela)->vbox),
                            texto, TRUE, TRUE, 0);
        gtk_widget_show (texto);
	gtk_widget_show (janela);
	return;
     }
   printf ("oops\n");
}


void funcao_contacto_acrescenta ( CONTACTO *contacto )
{
/*   g_print ("Novo Contacto\n");*/
   g_list_append ( info.lista_indicativos , contacto );
}

void funcao_contacto_retira ( CONTACTO *contacto )
{
/*   g_print ("Novo Contacto retirado\n");*/
   liberta_estrutura_contacto(info.lista_indicativos, &contacto);
}

void funcao_altera_campo_letras ( GtkWidget *entrada , gchar *campo )
/*
 * estao funcao e' chamada quando o utilizador introduz um novo valor
 * num campo de entrada de letras (nome, indicativo, observacoes,etc)
 */

{
   gchar *texto_de_entrada;
   texto_de_entrada = gtk_entry_get_text(GTK_ENTRY(entrada));
   strcpy ( campo , texto_de_entrada );
}

void funcao_altera_campo_numeros_inteiros ( GtkWidget *entrada , gint *campo )
/*
 * estao funcao e' chamada quando o utilizador introduz um novo valor
 * num campo de entrada de valores inteiros
 */

{
   gchar *texto_de_entrada, *endptr;
   texto_de_entrada = gtk_entry_get_text(GTK_ENTRY(entrada));
   *campo = strtol ( texto_de_entrada, &endptr , 10 );
   if ( *endptr != '\0' )
     {
	gtk_entry_set_text( GTK_ENTRY(entrada), "0" );
	*campo = 0;
     }
}

void funcao_altera_campo_numeros_reais ( GtkWidget *entrada , gfloat *campo )
/*
 * estao funcao e' chamada quando o utilizador introduz um novo valor
 * num campo de entrada de valores reais
 */
{
   gchar *texto_de_entrada, *endptr;
   texto_de_entrada = gtk_entry_get_text(GTK_ENTRY(entrada));
   *campo = strtod ( texto_de_entrada, &endptr );
   if ( *endptr != '\0' )
     {
	gtk_entry_set_text( GTK_ENTRY(entrada), "0.0" );
	*campo = 0.0;
     }
}

void funcao_altera_observacoes ( GtkWidget *entrada , gchar *campo )
/*
 * ja' nao uso esta funcao...
 */
{
   guint comprimento;
   gchar *texto;
   comprimento = gtk_text_get_length( GTK_TEXT (entrada) );
   texto = gtk_editable_get_chars( GTK_EDITABLE(entrada), 0 , -1 );
   if ( comprimento < (COMPRIMENTO_OBSERVACOES) )
     {
	strcpy ( campo , texto );
     }
   else
     gtk_text_backward_delete( GTK_TEXT(entrada), 
			      comprimento - COMPRIMENTO_OBSERVACOES );
   g_free ( texto );
}

void funcao_botao_altera_campo_lista ( BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando se carrega num botao para seleccionar
 * um novo valor, seja tipo de antena , modulacao , etc */
{
   if ( botao_opcao == NULL ) return;
   mostra_lista_opcoes ( botao_opcao );
}


void funcao_botao_altera_campo_data ( BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando se carrega no botao de mudanca de data
 * na janela de contacto
 */
{
   if ( botao_opcao == NULL ) return;
   mostra_calendario ( botao_opcao );
}

void funcao_muda_campo_data ( GtkWidget *calendario , BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando a data e' alterada na janela de calendario
 */
{
   struct tm data;
   struct tm *data_temp;
   gint dia, mes, ano;
   gchar *conteudo;
   data_temp = localtime ((time_t *)botao_opcao->campo_contacto);
   data.tm_hour = data_temp->tm_hour;
   data.tm_min = data_temp->tm_min;
   data.tm_sec = data_temp->tm_sec;
   gtk_calendar_get_date (GTK_CALENDAR (calendario), &ano , &mes, &dia);
   data.tm_year = ano - 1900;
   data.tm_mday = dia;
   data.tm_mon = mes;
#ifdef HAMLOG_DEBUG
   printf ("dia: %d\tmes: %d\tano: %d\n" ,
	   data.tm_mday , data.tm_mon, data.tm_year );
#endif
   *((time_t *)botao_opcao->campo_contacto) = mktime(&data);
   conteudo = numero_timet_para_letras(*((time_t*)botao_opcao->campo_contacto));
   poe_nome_no_botao ( botao_opcao , conteudo );
}


void funcao_muda_campo_hora ( GtkAdjustment *ajuste , BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando a hora e' alterada na janela de calendario
 */
{
   struct tm data;
   struct tm *data_temp;
   gchar *conteudo;
   data_temp = localtime ((time_t *)botao_opcao->campo_contacto);
   data.tm_min = data_temp->tm_min;
   data.tm_sec = data_temp->tm_sec;
   data.tm_year = data_temp->tm_year;
   data.tm_mday = data_temp->tm_mday;
   data.tm_mon = data_temp->tm_mon;
   
   data.tm_hour = (int)ajuste->value;

   *((time_t *)botao_opcao->campo_contacto) = mktime(&data);
   conteudo = numero_timet_para_letras(*((time_t*)botao_opcao->campo_contacto));
   poe_nome_no_botao ( botao_opcao , conteudo );
}

void funcao_muda_campo_minuto ( GtkAdjustment *ajuste , BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando os minutos sao alterados na janela de 
 * calendario
 */
{
   struct tm data;
   struct tm *data_temp;
   gchar *conteudo;
   data_temp = localtime ((time_t *)botao_opcao->campo_contacto);
   data.tm_hour = data_temp->tm_hour;
   data.tm_sec = data_temp->tm_sec;
   data.tm_year = data_temp->tm_year;
   data.tm_mday = data_temp->tm_mday;
   data.tm_mon = data_temp->tm_mon;
   
   data.tm_min = (int)ajuste->value;

   *((time_t *)botao_opcao->campo_contacto) = mktime(&data);
   conteudo = numero_timet_para_letras(*((time_t*)botao_opcao->campo_contacto));
   poe_nome_no_botao ( botao_opcao , conteudo );  
}


void funcao_muda_campo_contacto ( GtkWidget *lista_coluna, gint linha,
		          gint coluna, GdkEventButton *event, BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando e' seleccionada uma linha na janela
 * de seleccao de valor para um determinado campo das bases de dados
 */
{
   BASES_DADOS *escolha;
   GList *lista_dados;
   GtkWidget *label;
   gchar *conteudo;
   escolha = gtk_clist_get_row_data( GTK_CLIST (lista_coluna), linha );
   if ( escolha == NULL ) return;

   *(gint*)(botao_opcao->campo_contacto) = escolha->numero;
   label = botao_opcao->label;
   lista_dados = botao_opcao->lista_dados;
   conteudo = converte_numero_em_dado ( lista_dados , escolha->numero );
   poe_nome_no_botao ( botao_opcao , conteudo );
}


void funcao_acrecenta_dado_lista ( GtkWidget *entrada , BOTAO_OPCAO *botao_opcao )
/*
 * esta funcao e' chamada quando o utilizador acrescenta um novo dado a uma
 * base de dados
 */
{
   GList *lista_dados;
   gint numero_dado;
   gchar *texto_de_entrada, *conteudo;
   GtkWidget *label;
   
   texto_de_entrada = gtk_entry_get_text(GTK_ENTRY(entrada));
   if ( g_strcasecmp ( texto_de_entrada, "" ) == 0 )
     return;
   lista_dados = botao_opcao->lista_dados;
   numero_dado = acrescenta_dado_lista ( lista_dados , texto_de_entrada );
   
   /* actualiza ecran de novo/alteracao de contacto */
   *((gint*)botao_opcao->campo_contacto) = numero_dado;   
   label = botao_opcao->label;
   conteudo = converte_numero_em_dado ( lista_dados , numero_dado );
   poe_nome_no_botao ( botao_opcao , conteudo );
}


gint liberta_janela(GtkWidget *widget, GtkWidget *janela )
/*
 * esta funcao e' chamada quando e' emitido o sinal "destroy" para
 * a janela de calendario e para a janela com lista de bases de dados
 * e vai por a janela "sensivel"
 */
{
   gtk_widget_set_sensitive(janela, TRUE );
   return(FALSE);
}
