/*
 * hamlog.c - Programa HamLog
 * 
 * 	Programa de base de dados de contactos nas bandas de Amador
 * 
 * 1999 Nuno Sucena Almeida <slug@student.dee.uc.pt
 * 	CT1FOX
 */

#include "includes.h"
#include "hamlog.h"
#include "hamlog_callback.h"
#include "hamlog_file.h"
#include "hamlog_util.h"
#include "hamlog_ecran.h"


INFORMACAO info;
GtkWidget *lista_colunas;
GtkTooltips *ajudinha;

int main ( int argc , char *argv[] )
{
   GtkWidget *janela_principal , *tabela , *barra_menu , *arvore;
   GtkWidget *janela_separada/*, *janela_contacto*/;
   GList *lista_arvore;
   ARVORE *indicativos, *paises , *cidades , *bandas;
/*   CONTACTO *contacto;*/

   printf ( "%s %s, gcc %s\n%s\n\n" , 
	   NOME_PROGRAMA , VERSAO_PROGRAMA , __VERSION__ , AUTOR_PROGRAMA );
   
   /* inicializacao do ambiente GTK */
   gtk_init (&argc, &argv);
   
   /* Le parametros do ficheiro de configuracao de GTK */
   gtk_rc_parse( NOME_FICHEIRO_RC_GTK );
   
   /* le as varias bases de dados */
   if ( le_bases_dados ( NOME_FICHEIRO_CIDADES , &(info.lista_cidades) ) == EXIT_FAILURE ) 
     return(EXIT_FAILURE);
   if ( le_bases_dados ( NOME_FICHEIRO_PAISES , &(info.lista_paises) ) == EXIT_FAILURE )
     return(EXIT_FAILURE);
   if ( le_bases_dados ( NOME_FICHEIRO_BANDAS , &(info.lista_bandas) ) == EXIT_FAILURE )
     return(EXIT_FAILURE);
   if ( le_bases_dados ( NOME_FICHEIRO_ANTENAS , &(info.lista_antenas) ) == EXIT_FAILURE )
     return(EXIT_FAILURE);
   if ( le_bases_dados ( NOME_FICHEIRO_MODULACOES , &(info.lista_modulacoes) ) == EXIT_FAILURE )
     return(EXIT_FAILURE);
   if ( le_indicativos ( NOME_FICHEIRO_CONTACTOS , &(info.lista_indicativos) ) == EXIT_FAILURE )
     return(EXIT_FAILURE);
/*   mostra_dados_indicativo ( info.lista_indicativos ); */
   
   ajudinha = gtk_tooltips_new ();

   cria_ecran_principal ( &janela_principal );
   cria_ecran_tabelas ( janela_principal , &tabela );
   cria_menus ( tabela , &barra_menu );
   cria_janela_separada ( tabela , &janela_separada );
   cria_lista_colunas ( janela_separada , &lista_colunas );
/*   contacto = (CONTACTO*)(info.lista_indicativos->next->data);
   cria_janela_contacto ( &janela_contacto , &info , contacto );*/
   
   /* Cria conteudo da arvore */
   lista_arvore = g_list_alloc ();
   indicativos = g_malloc (sizeof(ARVORE));
   bandas = g_malloc (sizeof(ARVORE));
   cidades = g_malloc (sizeof(ARVORE));
   paises = g_malloc (sizeof(ARVORE));
   
   indicativos->nome = g_strdup (NOME_ITEM_ARVORE_INDICATIVOS );
   bandas->nome = g_strdup (NOME_ITEM_ARVORE_BANDAS );
   cidades->nome = g_strdup ( NOME_ITEM_ARVORE_CIDADES );
   paises->nome = g_strdup ( NOME_ITEM_ARVORE_PAISES );

   indicativos->funcao = GTK_SIGNAL_FUNC(funcao_indicativo_seleccionado);
   bandas->funcao = GTK_SIGNAL_FUNC(funcao_bandas_seleccionado);
   cidades->funcao = GTK_SIGNAL_FUNC(funcao_cidades_seleccionado);
   paises->funcao = GTK_SIGNAL_FUNC(funcao_paises_seleccionado);
   
   g_list_append ( lista_arvore , indicativos );
   g_list_append ( lista_arvore , bandas );
   g_list_append ( lista_arvore , cidades );
   g_list_append ( lista_arvore , paises );
   
   cria_arvore ( janela_separada , &arvore , lista_arvore );
   limpa_poe_indicativos_na_arvore ( indicativos->arvore , info.lista_indicativos );
   limpa_poe_dados_na_arvore ( bandas->arvore , info.lista_bandas );
   limpa_poe_dados_na_arvore ( cidades->arvore , info.lista_cidades );
   limpa_poe_dados_na_arvore ( paises->arvore , info.lista_paises );
   gtk_widget_show ( janela_principal );
   
   
/*   mostra_calendario ( NULL ); */
   gtk_main ();
   
   /* Programa terminou */
   return (EXIT_SUCCESS);
}
