/* Copyright (C) 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <iostream>
#include <cstdlib>
#include "readcluster.h"

const int MAX_LIST_SIZE = 30;  // this constant determines the number of spots cached
                               // to stop duplicate spots being displayed

Dx_spot_node::Dx_spot_node(const char* text): key(0) {
    const char* temp_p;
    int count;
    for (count = 0, temp_p = text; *temp_p; temp_p++) {
        if (count >= 3) {
	    count = 0;
	    key += *temp_p;
	}
    }
    spot_text = new char[strlen(text) + 1];
    if (!temp_p) {
        cerr << "Memory allocation error in Dx_spot_node::Dx_spot_node()" << endl;
	exit(MEM_ERROR);
    }
    strcpy(spot_text, text);
}

int Dx_spot_list::add(const char* dx_spot_p) {
    int return_val = 0;
    Dx_spot_node* spot_node_p = new Dx_spot_node(dx_spot_p);

    // check to see if the dx spot line is unique
    const Dx_spot_node* result1;
    bool result2 = false;
    dx_node_list.reset(DList_enum::top_end); // start at the most recent dx spot
    do {
        result1 = dx_node_list.inspect(DList_enum::down);
	if (result1) result2 = (*result1 == *spot_node_p);
    } while (result1 && !result2);

    if (result1 && result2) {    // we have got a match - it is not unique
        delete spot_node_p;
        return_val = -1;
    }
    else {                                   // it's a new dx spot
        if (count >= MAX_LIST_SIZE) { // list is full - extract oldest
	    dx_node_list.reset(DList_enum::bottom_end);
	    dx_node_list.inspect(DList_enum::up);
	    delete dx_node_list.extract();
	}
	else count++;
	dx_node_list.add(spot_node_p);
    }
    return return_val;
}

void Dx_spot_list::clear_list(void) {
    dx_node_list.reset(DList_enum::top_end);
    while(dx_node_list.inspect(DList_enum::down)) delete dx_node_list.extract();
    count = 0;
}
