/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <cstring>
#include <unistd.h>
#include <cstdlib>
#include <iostream>
#include <cstdio>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "download.h"
#include "dlist.cpp" // contains template definitions

extern Prog_func prog_func;

bool DownloadFile::open_file(const char* filename) {
    fileout.clear();

    int write_fd = open(filename, O_WRONLY | O_CREAT | O_TRUNC,
			S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
    if (write_fd != -1) fileout.attach(write_fd);
    else fileout.setstate(ios::failbit);

    if (!fileout) return false;
    return true;
}

DownloadList::DownloadList(void) {
    int port;
    int stream;
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    download_status[stream][port] = DownloadList::off;
	}
    }
}

bool PrintFile::start_store(void) {
    bool return_val = false;

    fileout.clear();
    char temp_p[] = "/tmp/kamprint.XXXXXX";
    int fd = mkstemp(temp_p);
    if (fd != -1) fileout.attach(fd);
    else fileout.setstate(ios::failbit);

    if (fileout)  {
        filename = new char[strlen(temp_p) + 1];
	if (!filename) {
	    cerr << "Memory allocation error in PrintFile::PrintFile()" << endl;
	    exit(MEM_ERROR);
	}
	strcpy(filename, temp_p);
	return_val = true;
    }
    return return_val;
}

void PrintFile::print(void) {
    if (filename) {
        fileout.clear();
        fileout.close();

	int rd_fd = open(filename, O_RDONLY);
	if (rd_fd < 0) {
	    cerr << "File open error in PrintFile::~PrintFile()" << endl;
	    exit(FILEOPEN_ERROR);
	}
	char buffer[BUFSIZ];
	ssize_t read_bytes = read(rd_fd, buffer, BUFSIZ);
	if (read_bytes > 0) { // we don't want to use popen if there is nothing to read
	                      // or lpr will complain of an empty pipe
	    FILE* pipe_fp = popen(prog_func.print_cmd.c_str(), "w");
	    do {
	        fwrite(buffer, sizeof(char), read_bytes, pipe_fp);
	    } while ((read_bytes = read(rd_fd, buffer, BUFSIZ)) > 0);
	    fclose(pipe_fp);
	}

	close(rd_fd);
	unlink(filename);
	delete[] filename;
	filename = 0;
    }
}

void PrintFile::cancel(void) {
    if (filename) {
        fileout.clear();
        fileout.close();
	unlink(filename);
	delete[] filename;
	filename = 0;
    }
}

PrintList::PrintList(void) {
    int port;
    int stream;
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    print_status[stream][port] = PrintList::off;
	}
    }
}

