// dlist.cpp

#ifndef DLIST_CPP
#define DLIST_CPP

#include <iostream>
#include <cstdlib>
#include "dlist.h"

#ifndef MEM_ERROR
#define MEM_ERROR 10
#endif

template <class Type>
void DList<Type>::add(Type* item_p) {
    DListNode<Type>* node = new DListNode<Type>(item_p, top);
    if (!node) {
        cerr << "Memory allocation error in DList<Type>::add()" << endl;
	exit(MEM_ERROR);
    }
    if (!bottom) bottom = node; // if this is the first entry, attach it to bottom
    if (top) top->next = node; // set DListNode<Type>::next in previous entry to new entry
    top = node; // now update top
}

template <class Type>
const Type* DList<Type>::inspect(DList_enum::Direction dir) {
    Type* temp;
    if (inspect_pos) { // not at end of inspection
        extract_pos = inspect_pos;
        temp = inspect_pos->item_p; // this is the return value
	if (dir == DList_enum::down) inspect_pos = inspect_pos->prev; // set inspect_pos to previous node in the list if going down the list
	else inspect_pos = inspect_pos->next; // else we are going up the list
    }
    else temp = 0;
    return temp;
}

template <class Type>
const Type*  DList<Type>::extract(void) {
    if (top == 0 || extract_pos == 0) return 0;

    Type* temp = extract_pos->item_p; // this is the return value
    if (top == bottom) top = bottom = 0; // only one entry in DList object
    else {
    // if there is a higher item, then reset the link
        if (extract_pos->next) extract_pos->next->prev = extract_pos->prev;
    // if not, the item to be extracted must be at the top, so reset top
	else top = extract_pos->prev; // the extracted item is at the top, so reset top
    // if there is a lower item, then reset the link
	if (extract_pos->prev) extract_pos->prev->next = extract_pos->next;
    // if not, the item to be extracted must be at the bottom, so reset bottom
	else bottom = extract_pos->next;
    }
    delete extract_pos;
    extract_pos = 0;
    return temp;
}

template <class Type>
const Type*  DList<Type>::extract(const Type* item_p) {
    const Type* temp = 0;
    reset(DList_enum::top_end);
    if (top) { // not empty
	while ((temp = inspect(DList_enum::down)) != 0 && temp != item_p);
	if (temp) extract();
    }        
    return temp;
}

template <class Type>
void DList<Type>::clear_list(void) {
    DListNode<Type>* temp;
    reset(DList_enum::top_end);
    while(inspect_pos) {
        temp = inspect_pos;
	inspect(DList_enum::down);
        delete temp;
    }
    top = bottom = 0;
}

#endif
