dnl aclocal.m4 -- various bits of this have been borrowed from the m4
dnl configuration files for KDE

AC_DEFUN(AC_FIND_FILE,
[
$3=NO
for i in $2;
do
  for j in $1;
  do
    if test -r "$i/$j"; then
      $3=$i
      break 2
    fi
  done
done
])

AC_DEFUN(AC_INSTALL_DIRS,
[
AC_MSG_CHECKING(which are the install directories)
BINDIR="$1"
INSTALLDIR="$1"
AC_PREFIX_DEFAULT([$1])
if test -n "$prefix" && test "$prefix" != "NONE"; then
  INSTALLDIR="$prefix"
fi
if test -n "$exec_prefix" && test "$exec_prefix" != "NONE"; then
  BINDIR="$exec_prefix"
fi
AC_MSG_RESULT([ BINDIR is $BINDIR INSTALLDIR is $INSTALLDIR ])
AC_SUBST(BINDIR)
AC_SUBST(INSTALLDIR)
])

AC_DEFUN(AC_PATH_QT_DIRECT,
[if test "$ac_qt_includes" = NO; then
AC_TRY_CPP([#include <qtstream.h>],
[
ac_qt_includes=
],[
])
fi
])

AC_DEFUN(AC_KAM_PATH_X,
[
AC_CACHE_VAL(ac_cv_have_x,
[# One or both of the vars are not set, and there is no cached value.
ac_x_includes=NO ac_x_libraries=NO
AC_PATH_X
if test "$ac_x_includes" = NO || test "$ac_x_libraries" = NO; then
  AC_MSG_ERROR([Can't find X includes. Please check your installation and add the correct paths!])
else
  # Record where we found X for the cache.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$ac_x_includes ac_x_libraries=$ac_x_libraries"
fi])dnl
eval "$ac_cv_have_x"
 
if test "$have_x" != yes; then
  AC_MSG_RESULT($have_x)
  no_x=yes
else
  # If each of the values was on the command line, it overrides each guess.
  test "x$x_includes" = xNONE && x_includes=$ac_x_includes
  test "x$x_libraries" = xNONE && x_libraries=$ac_x_libraries
  # Update the cache value to reflect the command line values.
  ac_cv_have_x="have_x=yes \
                ac_x_includes=$x_includes ac_x_libraries=$x_libraries"
fi

if test -z "$x_includes" || test "x$x_includes" = xNONE; then
  X_INCLUDES=""
  x_includes="."; dnl better than nothing :-
 else
  X_INCLUDES="-I$x_includes"
fi

if test -z "$x_libraries" || test "$x_libraries" = xNONE; then
  X_LDFLAGS=""
  x_libraries="/usr/lib"; dnl better than nothing :-
  all_libraries=""
 else
  X_LDFLAGS="-L$x_libraries"
  all_libraries=$X_LDFLAGS
fi

AC_SUBST(X_INCLUDES)
AC_SUBST(X_LDFLAGS)
all_includes=$X_INCLUDES
])

AC_DEFUN(AC_PATH_QT,
[
AC_REQUIRE([AC_KAM_PATH_X])

AC_MSG_CHECKING([for QT])
ac_qt_includes=NO ac_qt_libraries=NO
qt_libraries=""
qt_includes=""
ac_qt_root=""
AC_ARG_WITH(qt-dir,
    [  --with-qt-dir           where the root of qt is installed ],
    [  ac_qt_includes="$withval"/include
       ac_qt_libraries="$withval"/lib
       ac_qt_root="$withval"
    ])

AC_ARG_WITH(qt-includes,
    [  --with-qt-includes      where the qt includes are. ],
    [  
       ac_qt_includes="$withval"
    ])
    
AC_ARG_WITH(qt-libraries,
    [  --with-qt-libraries     where the qt library is installed.],
    [  ac_qt_libraries="$withval"
    ])

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then

AC_CACHE_VAL(ac_cv_have_qt,
AC_PATH_QT_DIRECT
[#try to guess qt locations

qt_incdirs="/usr/lib/qt/include /usr/local/qt/include /usr/include/qt /usr/include /usr/X11R6/include/X11/qt $x_includes $QTINC"
test -n "$QTDIR" && qt_incdirs="$QTDIR/include $QTDIR $qt_incdirs"
dnl QHBox first appeared in Qt-2.*
AC_FIND_FILE(qhbox.h, $qt_incdirs, qt_incdir)
ac_qt_includes=$qt_incdir

ac_libs_safe=$LIBS
LIBS="-lqt -lXext -lX11"
qt_in_qtdir="no"

if test -n "$QTDIR"; then
  AC_FIND_FILE(libqt.so.2 libqt.so.2.2 libqt.so.2.3 libqt.so libqt.a libqt.sl libqt.so.3, $QTDIR/lib $QTDIR, qt_libdir)
  if test "$qt_libdir" != NO; then
    qt_in_qtdir="yes"
  else
    AC_FIND_FILE(libqt-mt.so.3 libqt-mt.so libqt-mt.a libqt-mt.sl, $QTDIR/lib $QTDIR, qt_libdir)
    if test "$qt_libdir" != NO; then
      LIBS="-lqt-mt -lXext -lX11"
      qt_in_qtdir="yes"
    fi
  fi
fi

if test "$qt_in_qtdir" = "no"; then
  qt_libdirs="/usr/lib/qt/lib /usr/local/qt/lib /usr/lib/qt /usr/lib $x_libraries $QTLIB"
  AC_FIND_FILE(libqt.so.2 libqt.so.2.2 libqt.so.2.3 libqt.so libqt.a libqt.sl libqt.so.3, $qt_libdirs, qt_libdir)
  if test "$qt_libdir" = NO; then
    AC_FIND_FILE(libqt-mt.so.3 libqt-mt.so libqt-mt.a libqt-mt.sl, $qt_libdirs, qt_libdir)
    LIBS="-lqt-mt -lXext -lX11"
  fi
fi

ac_qt_libraries=$qt_libdir

ac_cxxflags_safe=$CXXFLAGS
ac_ldflags_safe=$LDFLAGS
CXXFLAGS="$CXXFLAGS -I$qt_incdir"
LDFLAGS="-L$qt_libdir $X_LDFLAGS"

AC_LANG_CPLUSPLUS
cat > conftest.$ac_ext <<EOF
#include "confdefs.h"
#include <qmovie.h>
int main() {
  QMovie m;
  m.setSpeed(20);
  return 0;
};
EOF

if AC_TRY_EVAL(ac_link) && test -s conftest; then
  rm -f conftest*
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat conftest.$ac_ext >&AC_FD_CC
  ac_qt_libraries="NO"
fi
rm -f conftest*
CXXFLAGS=$ac_cxxflags_safe
LDFLAGS=$ac_ldflags_safe
LIBS=$ac_libs_safe

if test "$ac_qt_includes" = NO || test "$ac_qt_libraries" = NO; then
  ac_cv_have_qt="have_qt=no"
  ac_qt_notfound=""
  if test "$ac_qt_includes" = NO; then
    if test "$ac_qt_libraries" = NO; then
      ac_qt_notfound="(headers and libraries)";
    else
      ac_qt_notfound="(headers)";
    fi
  else
    ac_qt_notfound="(libraries)";
  fi

  AC_MSG_ERROR([QT-2.*/QT-3.* $ac_qt_notfound not found. Please check your installation! ]);
else
  have_qt="yes"
fi
])
else
  have_qt="yes"
fi

eval "$ac_cv_have_qt"

if test "$have_qt" != yes; then
  AC_MSG_RESULT([$have_qt]);
else
  ac_cv_have_qt="have_qt=yes \
    ac_qt_includes=$ac_qt_includes ac_qt_libraries=$ac_qt_libraries"
  AC_MSG_RESULT([libraries $ac_qt_libraries, headers $ac_qt_includes])
  
  qt_libraries=$ac_qt_libraries
  qt_includes=$ac_qt_includes
fi
AC_SUBST(qt_libraries)
AC_SUBST(qt_includes)

if test "$qt_includes" = "$x_includes"; then
 QT_INCLUDES="";
else
 QT_INCLUDES="-I$qt_includes"
 all_includes="$QT_INCLUDES $all_includes"
fi

if test "$qt_libraries" = "$x_libraries"; then
 QT_LDFLAGS=""
else
 QT_LDFLAGS="-L$qt_libraries"
 all_libraries="$QT_LDFLAGS $all_libraries"
fi

AC_SUBST(QT_INCLUDES)
AC_SUBST(QT_LDFLAGS)

ac_have_qt_mt="no"
AC_FIND_FILE(libqt.so.2 libqt.so.2.2 libqt.so.2.3 libqt.so libqt.a libqt.sl libqt.so.3, $ac_qt_libraries, test_val)
if test "$test_val" = NO; then
  AC_FIND_FILE(libqt-mt.so.3 libqt-mt.so libqt-mt.a libqt-mt.sl, $ac_qt_libraries, test_val)
  if test "$test_val" != NO; then
    ac_have_qt_mt="yes"
  fi
fi

if test "$ac_have_qt_mt" = "yes"; then
  LIBS="$LIBS -lqt-mt"
else
  LIBS="$LIBS -lqt"
fi

qt_moc_dirs="$PATH:/usr/bin:/usr/X11R6/bin:/usr/lib/qt/bin:/usr/local/qt/bin"
if test -n "$ac_qt_root"; then
  qt_moc_dirs="$ac_qt_root/bin:$qt_moc_dirs"
else
  qt_moc_dirs="$QTDIR/bin:$qt_moc_dirs"
fi
AC_PATH_PROG(MOC, moc, /usr/bin/moc,
  [$qt_moc_dirs])


AC_MSG_CHECKING(for QTextEdit class)
ac_test_result=NO
dnl QTextEdit first appeared in Qt-3.0
AC_FIND_FILE(qtextedit.h, $qt_includes, ac_test_result)

TEXT_EDIT=""
if test "$ac_test_result" = NO; then
  AC_MSG_RESULT([no - will use the QMultiLineEdit class])
else
  TEXT_EDIT="-qt3"
  AC_MSG_RESULT([yes])
fi
AC_SUBST(TEXT_EDIT)
])

AC_DEFUN(AC_CHECK_USLEEP,
[
  AC_LANG_C
  ac_cflags_safe=$CFLAGS
  ac_ldflags_safe=$LDFLAGS
  ac_libs_safe=$LIBS
  CFLAGS=""
  LDFLAGS=""
  LIBS=""

  AC_MSG_CHECKING(for usleep)
  AC_CACHE_VAL(ac_cv_have_usleep,
  [
    LIBS="$LIBS $LIBUSLEEP"
    AC_TRY_LINK([
#include <stdlib.h>
#include <unistd.h>
],
[
usleep(200);
],
    [ac_cv_have_usleep="yes"],
    [ac_cv_have_usleep="no"])
  ]) dnl end AC_CHECK_VAL
  AC_MSG_RESULT($ac_cv_have_usleep)
  CFLAGS=$ac_cflags_safe
  LDFLAGS=$ac_ldflags_safe
  LIBS=$ac_libs_safe
  if test "$ac_cv_have_usleep" = "yes"; then
    AC_DEFINE(HAVE_USLEEP, 1, [
#include<sys/time.h>
#include<sys/types.h>
inline void usleep(unsigned int usecs) {
    timeval timeout;
    fd_set fds;
    FD_ZERO(&fds);
    FD_SET(FD_SETSIZE - 1, &fds);
    timeout.tv_sec = 0;
    timeout.tv_usec = usecs;
    select(1, &fds, 0, 0, &timeout);
}
  ])
  fi
])

AC_DEFUN(AC_CHECK_BOOL,
[
  AC_MSG_CHECKING(for bool)
  AC_CACHE_VAL(ac_cv_have_bool,
  [
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE([],
      [bool aBool = true;],
      [ac_cv_have_bool="yes"],
      [ac_cv_have_bool="no"])
  ]) dnl end AC_CHECK_VAL
    AC_MSG_RESULT($ac_cv_have_bool)
    if test "$ac_cv_have_bool" = "yes"; then
      AC_DEFINE(HAVE_BOOL, 1, [
typedef int bool;
const bool false = 0;
const bool true = 1;
    ]) 
    fi 
])

AC_DEFUN(AC_CHECK_COMPILERS,
[
  AC_ARG_ENABLE(debug,[  --enable-debug 	  creates debugging code [default=no]],
  [ 
   if test $enableval = "no"; dnl 
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

  dnl Just for configure --help

  dnl this prevents stupid AC_PROG_CXX from adding "-g" to the default CXXFLAGS
  cxx_flags_in=$CXXFLAGS
  AC_PROG_CXX
  CXXFLAGS=$cxx_flags_in

  AC_PROG_CXXCPP

  if test -z "$CXXFLAGS"; then 
    if test "$GXX" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CXXFLAGS="-g $CXXFLAGS"
      else
        CXXFLAGS="-O2 $CXXFLAGS"
        if test -z "$LDLFLAGS"; then 
          LDFLAGS="-s"
        fi
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_COMPILER_FLAG(g,
          [
            CXXFLAGS="-g $CXXFLAGS"
        ])
      else 
        AC_CHECK_COMPILER_FLAG(O2,
          [
            CXXFLAGS="-O2 $CXXFLAGS"
        ])
      fi
    fi
    AC_CHECK_COMPILER_FLAG(fno-exceptions,
      [
        CXXFLAGS="$CXXFLAGS -fno-exceptions"
    ])

    AC_CHECK_COMPILER_FLAG(frtti,
      [
        CXXFLAGS="$CXXFLAGS -frtti"
    ])

    AC_CHECK_COMPILER_FLAG(fsigned-char,
      [
        CXXFLAGS="$CXXFLAGS -fsigned-char"
    ])

    AC_CHECK_COMPILER_FLAG(fno-check-new,
      [
        CXXFLAGS="$CXXFLAGS -fno-check-new"
    ])

    if test "$GXX" = "yes"; then
       CXXFLAGS="$CXXFLAGS -Wall"
    fi

    AC_CHECK_COMPILER_FLAG(Wno-deprecated,
      [
        CXXFLAGS="$CXXFLAGS -Wno-deprecated"
    ])
  fi  
])

AC_DEFUN(AC_CHECK_COMPILER_FLAG,
[
AC_MSG_CHECKING(whether $CXX supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_cxx_$flag_cache,
[
echo 'int main() { return 0; }' >conftest.cc
eval "ac_cv_prog_cxx_$flag_cache=no"
if test -z "`$CXX -$1 -c conftest.cc 2>&1`"; then
  if test -z "`$CXX -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_cxx_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_cxx_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN(AC_CHECK_SELECT,
[
  AC_LANG_C
  ac_cflags_safe=$CFLAGS
  ac_ldflags_safe=$LDFLAGS
  ac_libs_safe=$LIBS
  CFLAGS=""
  LDFLAGS=""
  LIBS=""
  AC_CHECK_FUNCS(select,,
    AC_MSG_ERROR([Library function select is required and cannot be found]))
  CFLAGS=$ac_cflags_safe
  LDFLAGS=$ac_ldflags_safe
  LIBS=$ac_libs_safe
])

AC_DEFUN(AC_CHECK_MKSTEMP,
[
  AC_LANG_C
  ac_cflags_safe=$CFLAGS
  ac_ldflags_safe=$LDFLAGS
  ac_libs_safe=$LIBS
  CFLAGS=""
  LDFLAGS=""
  LIBS=""
  AC_CHECK_FUNCS(mkstemp,,
    AC_MSG_ERROR([Library function mkstemp is required and cannot be found]))
  CFLAGS=$ac_cflags_safe
  LDFLAGS=$ac_ldflags_safe
  LIBS=$ac_libs_safe
])

AC_DEFUN(AC_CHECK_HAVE_IOS_NOCREATE,
[
  AC_MSG_CHECKING(for fstream ios::nocreate flag)
  AC_CACHE_VAL(ac_cv_have_ios_nocreate,
  [
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE([
#include <fstream>
    ],
    [
      std::fstream strm("dummy.txt", std::ios::in | std::ios::nocreate);
      strm << 'a';
    ],
    [ac_cv_have_ios_nocreate="yes"],
    [ac_cv_have_ios_nocreate="no"
    ]) dnl end AC_TRY_COMPILE
  ])
  AC_MSG_RESULT([$ac_cv_have_ios_nocreate])
  if test "$ac_cv_have_ios_nocreate" = "yes" ; then
     AC_DEFINE(HAVE_IOS_NOCREATE, 1, [ Define if the C++ fstream object has ios::nocreate ])
  fi 
])

AC_DEFUN(AC_CHECK_HAVE_ATTACH,
[
  AC_MSG_CHECKING(for fstream attach)
  AC_CACHE_VAL(ac_cv_have_attach,
  [
    AC_LANG_CPLUSPLUS
    AC_TRY_COMPILE([
#include <fstream>
    ],
    [
      std::fstream strm;
      strm.attach(1);
    ],
    [ac_cv_have_attach="yes"],
    [ac_cv_have_attach="no"
    ]) dnl end AC_TRY_COMPILE
  ])
  AC_MSG_RESULT([$ac_cv_have_attach])
  if test "$ac_cv_have_attach" = "yes" ; then
     AC_DEFINE(HAVE_ATTACH, 1, [ Define if the C++ fstream object has fstream::attach(int fd) funtion ])
  fi 
])

AC_DEFUN(AC_COMPILE_OPTIONS,
[
  AC_CHECKING(compile time options)

  PRIVILEGES="-DRELEASE_PRIVILEGES"
  AC_ARG_ENABLE(keep-privileges,[  --enable-keep-privileges
                          the compiled program will not release suid root privileges [default=no]],
  [ 
   if test "$enableval" != "no"; dnl 
     then PRIVILEGES=""
   fi
  ])
  AC_SUBST(PRIVILEGES)
  if test -n "$PRIVILEGES"; then
    AC_MSG_RESULT([    Program will release suid/sgid root privileges on main process])
  fi

  LOCKDIR="/var/lock"
  AC_ARG_WITH(lockdir,
    [  --with-lockdir=DIR      where lock files are installed [default is /var/lock]],
  [
   if test "$withval" != "no"; dnl 
     then LOCKDIR="$withval"
   fi
  ])
  AC_SUBST(LOCKDIR)
  AC_MSG_RESULT([    LOCKDIR is $LOCKDIR])

  CHARSET="LATIN_1"
  AC_ARG_WITH(charset, [  --with-charset={latin-1, cp437, ascii}
                          the character set of the display [default is latin-1]],
  [
   if test "$withval" = "cp437"; dnl 
     then CHARSET="CP437"
   elif test "$withval" = "ascii"; dnl 
     then CHARSET="ASCII"
   fi
  ])
  AC_SUBST(CHARSET)
  AC_MSG_RESULT([    CHARSET is $CHARSET])

  EXCLUDE_MODE=""
  AC_ARG_ENABLE(gtor,
    [  --enable-gtor           the compiled program will support gtor [default=yes]],
  [ 
   if test "$enableval" = "no"; then
     EXCLUDE_MODE="-DNO_GTOR"
     AC_MSG_RESULT([    Program will not support gtor])
   fi
  ])
  AC_ARG_ENABLE(pactor,
    [  --enable-pactor         the compiled program will support pactor [default=yes]],
  [ 
   if test "$enableval" = "no"; then
     EXCLUDE_MODE="-DNO_PACTOR"
     AC_MSG_RESULT([    Program will not support pactor or gtor])
   fi
  ])
  AC_SUBST(EXCLUDE_MODE)

  CHANGEOVER="-DBUFFERED_CO"
  AC_ARG_ENABLE(buffered-changeover,[  --enable-buffered-changeover
                          changeover in Tor mode will occur when the text entered so far has been sent [default=yes]],
  [ 
   if test "$enableval" = "no"; dnl 
     then CHANGEOVER=""
   fi
  ])
  AC_SUBST(CHANGEOVER)
  if test -z "$CHANGEOVER"; then
    AC_MSG_RESULT([    Program will not have a buffered changeover])
  fi

  KDE2_WARNING="-DKDE2_WARNING"
  AC_ARG_ENABLE(kde2-warning,
    [  --enable-kde2-warning   on start-up, the program will give a warning about KDE-2 and the F12 key [default=yes]],
  [ 
   if test "$enableval" = "no"; dnl 
     then KDE2_WARNING=""
   fi
  ])
  AC_SUBST(KDE2_WARNING)
  if test -z "$KDE2_WARNING"; then
    AC_MSG_RESULT([    Program will not give a warning about KDE-2 and the F12 key])
  fi
])

AC_DEFUN(AC_CLOSING_MESSAGE,
[
echo
echo "    Configuration complete."
echo
echo "    To compile, enter \`make', and then enter \`make install'"
echo "      -- \`make install' must be run as root."
echo
echo "    To reconfigure, enter \`make clean' and then run \`./configure' again."
echo
])

