/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

/*

The classes in this file provide most of the main event slots for the
program.  The EventSlots class object is just a convenient container
for them, which (because it contains slots) must be derived from
QObject.  The EventSlots class object has no other wider
functionality.

Except where slots are local (for example, they relate to the printing
out or saving of selected text in the receive window class found in
widgets.h/widgets.cpp), most of the slot methods used by this program
are found in this file.

*/

#ifndef EVENT_SLOTS_H
#define EVENT_SLOTS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <qobject.h>
#include <iostream>
#include <fstream>
#include <ctime>
#include "buffers.h"
#include "tnc.h"
#include "filesend.h"
#include "prog_defs.h"

#include <qglobal.h>
#if QT_VERSION >= 300
#include "dialogs-qt3.h"
#include "widgets-qt3.h"
#else
#include "dialogs.h"
#include "widgets.h"
#endif

class EventSlots: public QObject {

    Q_OBJECT
signals:
    void sig_show_qso_count(int);
public:
    enum Running_flag{not_running, running};
    enum Autocq_mode {choose, amtor, pactor};
    enum Changeover_mode{rx, tx};
private:
    MainScreen* mainscreen_p;
    ReceiveWin* receivewin_p;
    SendWin* sendwin_p;
    Tnc* tnc_p;
    Transmit_buffer& tr_buffer;
    BufferList& buffer_list;
    int standard_size;
    Running_flag connect_script_flag;
    Running_flag send_parms_flag;
    ifstream script_file;
    ifstream parm_file;
    ifstream message_file;
    char wordwrap_buffer[WORDWRAP + 2];
    int wordwrap_buffer_count;
    int line_lettercount;
    bool space_flag;
    int cw_speed_val;
    RttySpeedDialog::Rtty_speed rtty_speed;
    AsciiSpeedDialog::Ascii_speed ascii_speed;
    time_t connect_script_timeout_base;
    void make_connection(QString&);
    void send_parms(const char*);
    void disconnect(void);
    void abort(void);
    void enter_call(QString&);
    void send_command(QString&);
    void rst(QString&);
    void upload(QString&, streampos, int);
    void download(QString&, int);
    void start_auto_cq(void);
    void end_auto_cq(void);
    void set_cw_speed_prompt(void);
    void set_rtty_speed_prompt(void);
    void set_ascii_speed_prompt(void);
    void set_cw_speed(int);
    void set_rtty_speed(RttySpeedDialog::Rtty_speed);
    void set_ascii_speed(AsciiSpeedDialog::Ascii_speed);
    void read_settings(void);
    bool get_prog_parm(const char*, std::string&, std::string&);
    void set_print_mark(void);
    void print_from_mark(int);
    void reset_speeds(void) {cw_speed_val = 20; rtty_speed = RttySpeedDialog::b45;
                             ascii_speed = AsciiSpeedDialog::b110;}
public slots:
    void vhf_menu(int);
    void hf_menu(int);
    inline void change_port(void);
    inline void stream_up(void);
    inline void stream_down(void);
    void change_hfmode(int mode, int prompt_flag);            // slot methods cannot
    void change_hfmode(int mode) {change_hfmode(mode, false);} // take default values
    void make_connection_prompt(void);
    void send_message_preprocess(int message_number, int prompt_flag); // slot methods cannot
    void send_message_preprocess(int message_number)                    // take default values
                           {send_message_preprocess(message_number, false);}
    void send_parms_prompt(const char*);
    void send_tnc_config(void) {send_parms_prompt("tnc.parms");}
    void upload_prompt(int);   // the int parameter indicates the type of
                               // FileSendBuffer object (text, binary, s_plus) to be created
    void download_prompt(int); // the int parameter will indicate the type of
                               // DownloadFile object (binary, s_plus) to be created
    void disconnect_prompt(void);
    void enter_call_prompt(void);
    void lock_call(void);
    void auto_cq_preprocess(int, int);            // slot methods cannot
    void auto_cq_preprocess(void)                  // take default values
              {auto_cq_preprocess(EventSlots::choose, false);}
    void lock_speed(void);
    void ident(void);
    void rst_prompt(void);
    void sync(void);
    void command_prompt(void);
    void command_script_prompt(void);
    void abort_prompt(void);
    void hfsend_mode(int mode) {prog_func.send_mode = (Prog_func::smode)mode;
                                mainscreen_p->display_send_mode_status();}
    void helpfile(void);
    void capture(void);
    void changeover_rx(void);
    void changeover_tx(void);
    void send_letter(uchar);
    void change_speed(void); // changes baud rate in RTTY/ASCII or speed in CW
    void ctrl_a(void);
    void ctrl_t(void);
    void ctrl_z(void);
    void font_change(int size) {sendwin_p->font_change(size); receivewin_p->font_change(size);}
    void settings_prompt(void);
    void set_print_mark_prompt(void);
    void print_from_mark_prompt(void);
    void context_print_mark(void);
    void increment_qso_count(void);
    void decrement_qso_count(void);
    void reset_qso_count(void);
    void read_cluster(void);
public:
    int wordwrap_buffer_add(uchar); // returns letter added, or -1 if tr_buffer full (or we are
                                    // at beginning of a line after a backspace entered)
    void flush_wordwrap_buffer(void);
    void send_parms(void) {send_parms(0);}
    void run_connect_script(const char* = 0);
    void send_message(int message_number);
    Running_flag get_connect_script_flag(void) const {return connect_script_flag;}
    Running_flag get_send_parms_flag(void) const {return send_parms_flag;}
    EventSlots(MainScreen* a, ReceiveWin* b, SendWin* c, Tnc* d, Transmit_buffer& e, BufferList& f, int g):
                    mainscreen_p(a), receivewin_p(b), sendwin_p(c),
                    tnc_p(d), tr_buffer(e), buffer_list(f), standard_size(g),
                    connect_script_flag(not_running), send_parms_flag(not_running),
                    wordwrap_buffer_count(0), line_lettercount(0), space_flag(false),
                    cw_speed_val(20), rtty_speed(RttySpeedDialog::b45),
                    ascii_speed(AsciiSpeedDialog::b110) {}
};


inline void EventSlots::change_port(void) {
    if (!tnc_p->tnc_func.active_port) hf_menu(tnc_p->tnc_func.active_hf_stream);
    else vhf_menu(tnc_p->tnc_func.active_vhf_stream);
}

inline void EventSlots::stream_up(void) {
    if (!tnc_p->tnc_func.active_port) {
        if (tnc_p->tnc_func.active_vhf_stream == MAXUSERS - 1) vhf_menu(0);
	else vhf_menu(tnc_p->tnc_func.active_vhf_stream + 1);
    }
    else if (tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        if (tnc_p->tnc_func.active_hf_stream == MAXUSERS - 1) hf_menu(0);
	else hf_menu(tnc_p->tnc_func.active_hf_stream + 1);
    }
}

inline void EventSlots::stream_down(void) {
    if (!tnc_p->tnc_func.active_port) {
        if (!tnc_p->tnc_func.active_vhf_stream) vhf_menu(MAXUSERS - 1);
	else vhf_menu(tnc_p->tnc_func.active_vhf_stream - 1);
    }
    else if (tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        if (!tnc_p->tnc_func.active_hf_stream) hf_menu(MAXUSERS - 1);
        else hf_menu(tnc_p->tnc_func.active_hf_stream - 1);
    }
}

#endif
