/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef IQUEUE_CPP
#define IQUEUE_CPP

#include <iostream.h>
#include <stdlib.h>
#include "iqueue.h"

template <class Type>
Iqueue<Type>::Iqueue(int a, int b):
    itembuffer_length(a), discard_flag(b), itemcount(0) {
    itembuffer = new Type[itembuffer_length];
    if (!itembuffer) {
        cerr << "Memory allocation error in configure_program(int&, int&)" << endl;
	exit(MEM_ERROR);
    }
    itembuffer_baseptr = itembuffer_backptr = itembuffer;
			          // initialise the pointers to the front of
				  // the buffer and the back of it
    max_itemptr = itembuffer + itembuffer_length - 1;
                              // max_itemptr points to highest address
	           	      // element of the circular part of the buffer,
}

template <class Type>
void Iqueue<Type>::reset(void) {
    itembuffer_baseptr = itembuffer_backptr = itembuffer;
    itemcount = 0;
}

template <class Type>
int Iqueue<Type>::add_item(const Type& item) {
    if (itemcount == itembuffer_length) {  // if buffer full
        if (!discard_flag) return -1;
        else {                     // discard item at front of buffer
	    itemcount--;
            if (itembuffer_baseptr < max_itemptr) itembuffer_baseptr++;
            else itembuffer_baseptr = itembuffer; // scroll itembuffer_baseptr
        }
    }
    // enter item in buffer
    *itembuffer_backptr = item;
    // now increment itembuffer_backptr
    if (itembuffer_backptr < max_itemptr) itembuffer_backptr++;
    else itembuffer_backptr = itembuffer;            // scroll itembuffer_backptr
    itemcount++;
    return 0;
}

template <class Type>
Type Iqueue<Type>::front(Extract_mode mode) {
    Type temp = 0;
    if (itemcount) {
        temp = *itembuffer_baseptr;
	if (mode == remove) {
	    itemcount--;
	    if (itembuffer_baseptr < max_itemptr) itembuffer_baseptr++;
	    else itembuffer_baseptr = itembuffer; // scroll itembuffer_baseptr
	}
    }
    return temp;
}

template <class Type>
Type Iqueue<Type>::back(Extract_mode mode) {
    Type* temp = itembuffer_backptr;
    Type return_value = 0;
    if (itemcount) {  // something to extract
    	if (temp > itembuffer) temp--;
	else temp = max_itemptr;          // scroll temp
	return_value = *temp;
	
	if(mode == remove) {
	    itembuffer_backptr = temp;
	    itemcount--;
	}
    }
    return return_value;
}

#endif
