/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <qmessagebox.h>
#include <qapplication.h>
#include "filesend.h"
#include "dlist.cpp"   // contains template definitions

static volatile bool cq_alarm_flag = false;

bool FilesendBuffer::open_file(const char* filename, bool convert_codes) {
  // Thefilename supplied will be opened, and convert_codes may be set to true.
  // If if is set true, then $a will be translated to your call, and $b will be 
  // translated to your selcall, and $c will be translated to the call in the callsign
  // store buffer for the currently active screen

  // we only send a file in packet mode when connected
    if ((!get_port() || tnc_ptr->tnc_func.hfmode == Tnc_func::packet)
	&& tnc_ptr->tnc_func.stream_status[get_stream()][get_port()] == Tnc_func::disconnected) {

        QMessageBox::warning(sendwin_ptr, "Filesend",
				 "Cannot send a file in packet mode unless connected",
				 QMessageBox::Ok | QMessageBox::Default, 0);
        return false;
    }

    bool return_val = false;
    if (file_flag == not_sending) {
#ifdef HAVE_IOS_NOCREATE
	filein.open(filename, ios::in | ios::nocreate);
#else
	// we must have Std C++ so we probably don't need a ios::nocreate
	// flag on a read open to ensure uniqueness
	filein.open(filename, ios::in);
#endif
	if (!filein) {
	    ostrstream strm;
	    strm << filename << " cannot be found/opened" << ends;
	    char* message = strm.str();
	    QMessageBox::warning(sendwin_ptr, "Filesend", message,
				 QMessageBox::Ok | QMessageBox::Default, 0);
	    delete[] message;
	}
	else {
	    file_flag = loading_buffer;
	    return_val = true;
	    if (get_buffer_mode() == FileBuffer::text) convert_codes_flag = convert_codes;
	    else {
	        convert_codes_flag = false;
		receivewin_ptr->write("\nSending file ...\n", get_stream(), get_port());
	    }
	}
    }
    return return_val;
}

bool FilesendBuffer::load_buffer(void) {

  // if we were sending a file and now it has all gone to the Kam, signal this
  // (when this method has finished loading the file into tr_buffer, we set
  // FilesendBuffer::file_flag to FilesendBuffer::loading_complete, not
  // FilesendBuffer::not_sending, so that the program will know that there is material
  // in tr_buffer which should be flushed even if the return key, etc., has not been pressed)

  // this method should accordingly be called by the program timer event handler whenever
  // FilesendBuffer::file_flag != FilesendBuffer::not_sending

  // the program returns false when FilesendBuffer::file_flag == FilesendBuffer::not_sending,
  // or if FilesendBuffer::file_flag == FilesendBuffer::loading_complete and the buffer is empty,
  // otherwise it returns true

  // the method FilesendBuffer::end_loading() is available to put the FilesendBuffer object
  // into a state which will itself and will ensure that FilesendBuffer::load_buffer()
  // will return false so that it may be safely deleted by the function/method which
  // calls FilesendBuffer::end_loading

    if (file_flag == not_sending) return false;
    if (file_flag == loading_complete) {
        if (Iqueue<char>::is_empty()) {
	    if (get_buffer_mode() == FileBuffer::binary || get_buffer_mode() == FileBuffer::s_plus) {
		receivewin_ptr->write("\nSending completed.\n", get_stream(), get_port());
	    }
	    file_flag = not_sending;
	    filein.close();
	    return false;
	}
    }

    char letter;
    int result = 0;
    int count;
    bool write_to_sendwin_flag = false;
    int sendwin_count = 0;

    if (get_stream() == tnc_ptr->tnc_func.active_stream()
	&& get_port() == tnc_ptr->tnc_func.active_port
	&& get_buffer_mode() == FileBuffer::text) {
        write_to_sendwin_flag = true;
    }

    for (count = 0; result != -1 && count < TR_BUFFER_SIZE/2 && filein.get(letter); count++) {
        if (get_buffer_mode() == FileBuffer::text
	    && tnc_ptr->tnc_func.active_port
	    && (uchar)letter > 31) {
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::rtty
		|| tnc_ptr->tnc_func.hfmode == Tnc_func::fec
		|| tnc_ptr->tnc_func.hfmode == Tnc_func::amtor
		|| (tnc_ptr->tnc_func.hfmode == Tnc_func::gtor
		    && tnc_ptr->tnc_func.stream_status[0][1] == Tnc_func::disconnected)
		|| (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		    && (tnc_ptr->tnc_func.stream_status[0][1] == Tnc_func::disconnected
			|| tnc_ptr->tnc_func.tor_connected_mode == Tnc_func::not_pactor_gtor))) {
	        if (!is_baudot(letter)) letter = 0;
		else if (tnc_ptr->tnc_func.hfmode == Tnc_func::rtty) letter = toupper(static_cast<unsigned char> (letter));
	    }
	    else if (tnc_ptr->tnc_func.hfmode == Tnc_func::cw) {
	        if (!is_morse(letter) 
		     && !(letter == '$' && convert_codes_flag)) letter = 0; // allow the $ token through
		else letter = toupper(static_cast<unsigned char> (letter));
	    }
	}

#if CHAR_SET==LATIN_1
        if (get_buffer_mode() == FileBuffer::binary  || get_buffer_mode() == FileBuffer::s_plus
	      || (uchar)letter > 31 || letter == '\n') {
#elif CHAR_SET==CP437
        if (get_buffer_mode() == FileBuffer::binary || get_buffer_mode() == FileBuffer::s_plus
	      || ((uchar) letter < 256 && (uchar)letter > 31) || letter == '\n') {
#else
	if (get_buffer_mode() == FileBuffer::binary || get_buffer_mode() == FileBuffer::s_plus
	      || (letter < 127 && letter > 31) || letter == '\n') {
#endif
	    if (letter == '$' && convert_codes_flag) {
	        int second_letter = filein.peek();
		if (second_letter == 'a') {
		    if ((string::size_type)is_free() >= prog_func.myCall.size()) {
		        for (const char* letter_ptr = prog_func.myCall.c_str(); *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(prog_func.myCall.c_str());
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'a' code
		    }
		    else {           // not sufficient room in buffer for selcall
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'b') {
		    if ((string::size_type)is_free() >= prog_func.mySelCall.size()) {
		        for (const char* letter_ptr = prog_func.mySelCall.c_str(); *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(prog_func.mySelCall.c_str());
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'b' code
		    }
		    else {           // not sufficient room in buffer for selcall
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'c') {
		    if ((string::size_type)is_free() >= 
			   tnc_ptr->tnc_func.hisCall[tnc_ptr->tnc_func.active_stream()][tnc_ptr->tnc_func.active_port].size()) {
		        for (const char* letter_ptr = tnc_ptr->tnc_func.hisCall[tnc_ptr->tnc_func.active_stream()][tnc_ptr->tnc_func.active_port].c_str(); *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(tnc_ptr->tnc_func.hisCall[tnc_ptr->tnc_func.active_stream()][tnc_ptr->tnc_func.active_port].c_str());
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'c' code
		    }
		    else {           // not sufficient room in buffer for selcall
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'd') {
		    if ((unsigned int)is_free() >= 5) {
		        time_t time_val;
			time(&time_val);
			tm* time_ptr = gmtime(&time_val);
			ostrstream s1;
			s1 << setfill('0') << setw(2) << time_ptr->tm_hour
			   << ":" << setw(2) << time_ptr->tm_min << ends;
			char* time_string = s1.str();
			for (char* letter_ptr = time_string; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(time_string);
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'd' code
			delete[] time_string;
		    }
		    else {           // not sufficient room in buffer for time
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'e') {
		    if ((unsigned int)is_free() >= 9) {
		        time_t time_val;
			time(&time_val);
			tm* time_ptr = gmtime(&time_val);
			ostrstream s1;
			char month[4];
			get_month(month, time_ptr->tm_mon);
			s1 << time_ptr->tm_mday << "-" << month << "-"
			   << setfill('0') << setw(2) << (time_ptr->tm_year)%100 << ends;
			char* date_string = s1.str();
			for (char* letter_ptr = date_string; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(date_string);
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'e' code
			delete[] date_string;
		    }
		    else {           // not sufficient room in buffer for date
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'f') {
		    if ((unsigned int)is_free() >=  3) {
		        for (char* letter_ptr = prog_func.rst; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(prog_func.rst);
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'f' code
		    }
		    else {           // not sufficient room in buffer for rst report
		        filein.putback('$');
			result = -1;
		    }
		}
		else if (second_letter == 'g') {
		    ostrstream s1;
		    s1 << setfill('0') << setw(3) << prog_func.qso_count << ends;
		    char* qso_count_string = s1.str();
		    
		    if ((unsigned int)is_free() >= strlen(qso_count_string)) {
			for (char* letter_ptr = qso_count_string; *letter_ptr; letter_ptr++) {
			    add_item(*letter_ptr);
			}
			if (write_to_sendwin_flag) {
			    sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_ptr->write(qso_count_string);
			    sendwin_count = 0;
			}
			second_letter = filein.get(); // get rid of the 'g' code
		    }
		    else {           // not sufficient room in buffer for qso count
		        filein.putback('$');
			result = -1;
		    }
		    delete[] qso_count_string;
		}
		else if (second_letter == EOF) {  // last letter of file is a '$'
		    result = add_item('$');
		    if (result == -1) filein.putback('$');
		    else if (write_to_sendwin_flag) {
		        sendwin_buffer[sendwin_count] = 0; // null terminate string
			sendwin_ptr->write(sendwin_buffer);
			sendwin_count = 0;
		        sendwin_ptr->write("$");
		    }
		}
	    }
	    else {
	        result = add_item(letter);
		if (result == -1) filein.putback(letter);
		else if (write_to_sendwin_flag) {
		    sendwin_buffer[sendwin_count++] = letter;
		    if (sendwin_count >= SENDFILE_CHUNK || letter == '\n') {
		        sendwin_buffer[sendwin_count] = 0; // null terminate string
			sendwin_ptr->write(sendwin_buffer);
			sendwin_count = 0;
		    }
		}
	    }
	}
    }

	
    if (sendwin_count) {
        sendwin_buffer[sendwin_count] = 0; // null terminate string
	sendwin_ptr->write(sendwin_buffer);
	sendwin_count = 0;
    }


    // if we are in packet mode and are now disconnected, stop sending file
    if ((!get_port() || tnc_ptr->tnc_func.hfmode == Tnc_func::packet)
	&& tnc_ptr->tnc_func.stream_status[get_stream()][get_port()] == Tnc_func::disconnected) {
        end_loading();
    }

    else if (file_flag == loading_buffer && !filein) {
        file_flag = loading_complete;
    }
    return true;
}

char FilesendBuffer::front(Extract_mode mode) {
    char return_val = Iqueue<char>::front(mode);
    if (mode == remove) bytes_sent++;
    return return_val;
}

bool CqsendBuffer::load_buffer(void) {
  // this method should be called by the program timer event handler whenever
  // an object of this class is in existence
  // so that the buffer is properly flushed and the cq alarm is properly set

  // the program returns false when this is the last call the CqsendBuffer::load_buffer(void),
  // or if the cq file cannot be opened
  // otherwise it returns true

  // the method CqsendBuffer::end_loading() is available to put the CqsendBuffer object
  // into a state which will itself and will ensure that CqsendBuffer::load_buffer()
  // will return false so that it may be safely deleted by the function/method which
  // calls CqsendBuffer::end_loading

  // only this method is intended to write to prog_func.sending_autocq, although
  // prog_func.sending_autocq is intended to be generally readable by other
  // functions and classes used in this program


    if (autocq_flag == off) {
        string filename(prog_func.filedir);
	filename += "/cq";
    
#ifdef HAVE_IOS_NOCREATE
	filein.open(filename.c_str(), ios::in | ios::nocreate);
#else
	// we must have Std C++ so we probably don't need a ios::nocreate
	// flag on a read open to ensure uniqueness
	filein.open(filename.c_str(), ios::in);
#endif
	if (!filein) {
	    ostrstream strm;
	    strm << filename << " cannot be found/opened" << ends;
	    char* message = strm.str();
	    QMessageBox::warning(sendwin_ptr, "Auto-CQ", message,
				 QMessageBox::Ok | QMessageBox::Default, 0);
	    delete[] message;
	    prog_func.sending_autocq = false;
	    return false;
	}
	else {
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		  && prog_func.tor_autocq_mode == Prog_func::pactor) {
	        tnc_ptr->send_specialcommand(packetCMD);
		usleep(200000);
		tnc_ptr->send_kamcommand(pactorCMD, '2', '0');
		usleep(200000);
	    }
	    autocq_flag = loading_cq_buffer;
	    prog_func.sending_autocq = true;
	    mainscreen_ptr->display_connected_status();
	    mainscreen_ptr->set_auto_cq_button();
	    tnc_ptr->send_specialcommand(txCMD);
	}
    }

    bool return_val = true;
    char letter;
    int result = 0;
    int count;
    bool write_to_sendwin_flag = false;
    int sendwin_count = 0;

    if (tnc_ptr->tnc_func.active_port) write_to_sendwin_flag = true;

    if (autocq_flag == loading_cq_buffer && tnc_ptr->tnc_func.tx_status == Tnc_func::tx) {
        for (count = 0; result != -1 && count < CQ_BUFFER_SIZE/2 && filein.get(letter); count++) {
	    if ((uchar)letter > 31
		&& tnc_ptr->tnc_func.hfmode != Tnc_func::pactor
		&& !is_baudot(letter)) {
	        letter = 0;
	    }

#if CHAR_SET==LATIN_1
	    if ((uchar)letter > 31 || letter == '\n') {
#elif CHAR_SET==CP437
	    if (((uchar) letter < 256 && (uchar)letter > 31) || letter == '\n') {
#else
	    if ((letter < 127 && letter > 31) || letter == '\n') {
#endif
	        if (letter == '$') {
		    int second_letter = filein.peek();
		    if (second_letter == 'a') {
		        if ((string::size_type)is_free() >= prog_func.myCall.size()) {
			    for (const char* letter_ptr = prog_func.myCall.c_str(); *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(prog_func.myCall.c_str());
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'a' code
			}
			else {           // not sufficient room in buffer for selcall
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'b') {
		        if ((string::size_type)is_free() >= prog_func.mySelCall.size()) {
			    for (const char* letter_ptr = prog_func.mySelCall.c_str(); *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(prog_func.mySelCall.c_str());
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'b' code
			}
			else {           // not sufficient room in buffer for selcall
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'c') {
		        if ((string::size_type)is_free() >= 
			    tnc_ptr->tnc_func.hisCall[0][1].size()) {
			    for (const char* letter_ptr = tnc_ptr->tnc_func.hisCall[0][1].c_str(); *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(tnc_ptr->tnc_func.hisCall[0][1].c_str());
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'c' code
			}
			else {           // not sufficient room in buffer for selcall
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'd') {
		        if ((unsigned int)is_free() >= 5) {
			    time_t time_val;
			    time(&time_val);
			    tm* time_ptr = gmtime(&time_val);
			    ostrstream s1;
			    s1 << setfill('0') << setw(2) << time_ptr->tm_hour
			       << ":" << setw(2) << time_ptr->tm_min << ends;
			    char* time_string = s1.str();
			    for (char* letter_ptr = time_string; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(time_string);
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'd' code
			    delete[] time_string;
			}
			else {           // not sufficient room in buffer for time
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'e') {
		        if ((unsigned int)is_free() >= 9) {
			    time_t time_val;
			    time(&time_val);
			    tm* time_ptr = gmtime(&time_val);
			    ostrstream s1;
			    char month[4];
			    get_month(month, time_ptr->tm_mon);
			    s1 << time_ptr->tm_mday << "-" << month << "-"
			       << setfill('0') << setw(2) << (time_ptr->tm_year)%100 << ends;
			    char* date_string = s1.str();
			    for (char* letter_ptr = date_string; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(date_string);
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'd' code
			    delete[] date_string;
			}
			else {           // not sufficient room in buffer for time
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'f') {
		        if ((unsigned int)is_free() >= 3) {
			    for (char* letter_ptr = prog_func.rst; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(prog_func.rst);
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'f' code
			}
			else {           // not sufficient room in buffer for rst report
			    filein.putback('$');
			    result = -1;
			}
		    }
		    else if (second_letter == 'g') {
		        ostrstream s1;
			s1 << setfill('0') << setw(3) << prog_func.qso_count << ends;
			char* qso_count_string = s1.str();
		    
			if ((unsigned int)is_free() >= strlen(qso_count_string)) {
			    for (char* letter_ptr = qso_count_string; *letter_ptr; letter_ptr++) {
			        add_item(*letter_ptr);
			    }
			    if (write_to_sendwin_flag) {
			        sendwin_buffer[sendwin_count] = 0; // null terminate string
				sendwin_ptr->write(sendwin_buffer);
				sendwin_ptr->write(qso_count_string);
				sendwin_count = 0;
			    }
			    second_letter = filein.get(); // get rid of the 'g' code
			}
			else {           // not sufficient room in buffer for qso count
			    filein.putback('$');
			    result = -1;
			}
			delete[] qso_count_string;
		    }
		    else if (second_letter == EOF) {  // last letter of file is a '$'
		        result = add_item('$');
			if (result == -1) filein.putback('$');
			else if (write_to_sendwin_flag) {
		            sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_count = 0;
			    sendwin_ptr->write("$");
			}
		    }
		}
		else {
		    result = add_item(letter);
		    if (result == -1) filein.putback(letter);
		    else if (write_to_sendwin_flag) {
		        sendwin_buffer[sendwin_count++] = letter;
			if (sendwin_count >= SENDFILE_CHUNK || letter == '\n') {
		            sendwin_buffer[sendwin_count] = 0; // null terminate string
			    sendwin_ptr->write(sendwin_buffer);
			    sendwin_count = 0;
			}
		    }
		}
	    }
	}

	if (sendwin_count) {
            sendwin_buffer[sendwin_count] = 0; // null terminate string
	    sendwin_ptr->write(sendwin_buffer);
	    sendwin_count = 0;
	}

	if (!filein) {
	    autocq_flag = loading_cq_buffer_complete;
	    add_item('\n');
	    add_item(CMDinbuffer);
	    add_item('E');
	    add_item(CMDinbuffer);
	    if (write_to_sendwin_flag) sendwin_ptr->new_line();
	}
    }   
    else if (autocq_flag == loading_cq_buffer_complete) {
        if (tnc_ptr->tnc_func.tx_status == Tnc_func::rx) rx_count++;// stop one stray rx status info
                                                                    // triggering a premature send
	if (rx_count > 2) {
	    filein.clear();               // go back to begining of file ready for next pass through
	    filein.seekg(0, ios::beg);    // after the timer alarm goes off
	    autocq_flag = waiting;
	    cq_alarm_flag = false;
	    signal(SIGALRM, cq_alarm_handler);
	    int alarm_val = prog_func.autocq_delay;
	    if (!alarm_val) alarm_val = 90;
	    alarm(alarm_val);
	    rx_count = 0;
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		  && prog_func.tor_autocq_mode == Prog_func::pactor) {
// we need to go back to Tor Standby mode if we have been sending FEC
// in Pactor.  Note: if we cancel a cq message half way through by means
// of EventSlots::auto_cq(), EventSlots::auto_cq() will (by calling
// CqsendBuffer::end_loading()) set autocq_flag to
// CqsendBuffer::close_down which will in turn cause this method to
// set prog_func.sending_autocq to false, with the result that
// Tnc::read_state_message() will automatically change the TNC back to Tor
// Standby mode, so there is no need to cater here for a change of mode
// in those circumstances
	        tnc_ptr->send_specialcommand(packetCMD);
		usleep(300000);
		tnc_ptr->send_kamcommand(torCMD, '2', '0');
		usleep(100000);
	    }
	}
    }
    else if (autocq_flag == waiting) {
        // if we have made a connection or we have had a slip-up in changing from
        // Pactor mode to Tor mode when sending a Tor mode autocq using Pactor FEC
        // then we need to end the autocq
        if (tnc_ptr->tnc_func.stream_status[0][1] ==  Tnc_func::connected
	    || tnc_ptr->tnc_func.hfmode == Tnc_func::packet) {
	    filein.close();
	    prog_func.sending_autocq = false;
	    mainscreen_ptr->display_connected_status();
	    // set_auto_cq_button() will be called in MainScreenFuncs::timerEvent()
	    // once the buffer is extracted - calling it now will give a false display
	    return_val = false;
	}
	else if (cq_alarm_flag) {
	    QApplication::beep();
	    autocq_flag = loading_cq_buffer;
	    if (tnc_ptr->tnc_func.hfmode == Tnc_func::tor
		  && prog_func.tor_autocq_mode == Prog_func::pactor) {
	        tnc_ptr->send_specialcommand(packetCMD);
		usleep(200000);
		tnc_ptr->send_kamcommand(pactorCMD, '2', '0');
		usleep(100000);
	    }
	    tnc_ptr->send_specialcommand(txCMD);  // go back to transmit
	    cq_alarm_flag = false;
	}
    }
    else if (autocq_flag == close_down) {
        filein.close();
	prog_func.sending_autocq = false;
	mainscreen_ptr->display_connected_status();
	// set_auto_cq_button() will be called in MainScreenFuncs::timerEvent()
	// once the buffer is extracted - calling it now will give a false display
	return_val = false;
    }
    return return_val;
}


void cq_alarm_handler(int) {
    cq_alarm_flag = true;
}

BufferList::BufferList(void) {
    int port;
    int stream;
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    upload_status[stream][port] = BufferList::keyboard;
	}
    }
}
