/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <qtoolbar.h>
#include <qsplitter.h>
#include <qmenubar.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qsocketnotifier.h>
#include <qpalette.h>
#include <qkeycode.h>
#include <qcolor.h>
#include <qstring.h>
#include <qfiledialog.h>
#include <qvbox.h>
#include <qvaluelist.h>
#include <iostream>
#include <fstream>
#include <strstream>
#include <string>
#include <unistd.h>
#include <cstdio>
#include <cstdlib>
#include <cstring>

#if QT_VERSION >= 300
#include <qdockwindow.h>
#include "widgets-qt3.h"
#else
#include "widgets.h"
#endif

#include "buffers.h"
#include "event_slots.h"
#include "pipes.h"
#include "icons.h"
#include "download.h"

#define TIMER_INTERVAL 100      // number of milliseconds between timer events
#define INTERVAL_COUNT 200/TIMER_INTERVAL // beeps need to fire every 200 milliseconds
#define MAXLINES  300
#define DELETE_BLOCK 0


void MainScreen::about_kamplus(void) {
    QMessageBox::information(this, "About kamplus-qt",
			     "kamplus-qt-1.1.1c\n"
			     "Copyright (C) 1999 - 2002 Chris Vine, G3XXF\n"
			     "chris@cvine.freeserve.co.uk\n"
			     "G3XXF@GB7MSW.#33.GBR.EU\n\n"
			     "This program is released under the\n"
			     "GNU General Public License, version 2\n");
}

MainScreen::MainScreen(Tnc* a, Tnc_base* b, Pipe_fifo& c, Transmit_buffer& d,
		       BufferList& e, int win_fontsize):
                         letters_to_send_flag(false), flush_chars(false),
                         count(20), standard_size(30), buffer_count(0), beep_count(0),
                         interval_count(0), tnc_p(a), tnc_base_p(b), receive_pipe(c),
			 tr_buffer(d), buffer_list(e) {

    QVBox* vbox_p = new QVBox(this);

    display_line_p = new DisplayLine(vbox_p, standard_size);
    if (!display_line_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }
    display_line_p->setFixedHeight(standard_size);

    QSplitter* splitter_p = new QSplitter(QSplitter::Vertical, vbox_p);
    if (!splitter_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }
    vbox_p->setStretchFactor(display_line_p, 0);
    vbox_p->setStretchFactor(splitter_p, 1);

    setCentralWidget(vbox_p);

    QMenuBar* menubar_p = new QMenuBar(this);
    if (!menubar_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }

    sendwin_p = new SendWin(splitter_p, win_fontsize);
    if (!sendwin_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }

    receivewin_p = new ReceiveWin(splitter_p, tnc_p, standard_size, win_fontsize);
    if (!receivewin_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }

    event_slots_p = new EventSlots(this, receivewin_p, sendwin_p, tnc_p, tr_buffer, buffer_list, standard_size);
    if (!event_slots_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }

    upload_p = new QPopupMenu;
    if (!upload_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }
    upload_p->insertItem("&Text(CR->LF and CP437 conversion)", FilesendBuffer::text);
    upload_7plus_item = upload_p->insertItem("&7-plus(CR->LF conversion)", FilesendBuffer::s_plus);
    upload_binary_item = upload_p->insertItem("&Binary", FilesendBuffer::binary);
    QObject::connect(upload_p, SIGNAL(activated(int)), event_slots_p, SLOT(upload_prompt(int)));

    QPopupMenu* download_p = new QPopupMenu;
    if (!download_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }
    download_p->insertItem("&7-plus(CR->LF conversion)", DownloadFile::s_plus);
    download_p->insertItem("&Binary", DownloadFile::binary);
    QObject::connect(download_p, SIGNAL(activated(int)), event_slots_p, SLOT(download_prompt(int)));

    filemenu_p = new QPopupMenu;
    if (!filemenu_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }

    if (tnc_p) {
        upload_item = filemenu_p->insertItem("&Upload", upload_p);
	download_item = filemenu_p->insertItem("&Download", download_p);
	filemenu_p->insertSeparator();
	menu_copy_item = filemenu_p->insertItem("&Copy selected text", receivewin_p, SLOT(copy()));
	filemenu_p->insertSeparator();
	menu_print_selection_item = filemenu_p->insertItem("&Print selected text",
						  receivewin_p, SLOT(print_selection()));
	filemenu_p->insertItem("Print scroll &buffer", receivewin_p, SLOT(print_scroll_buffer()));
	menu_set_print_mark_item = filemenu_p->insertItem("Set print &mark",
							  event_slots_p, SLOT(set_print_mark_prompt()));
	menu_print_from_mark_item = filemenu_p->insertItem("Print &from mark",
							   event_slots_p, SLOT(print_from_mark_prompt()));
	filemenu_p->insertSeparator();
	menu_save_selection_item = filemenu_p->insertItem("S&ave selected text", receivewin_p, SLOT(save()));
	filemenu_p->insertSeparator();
	menu_qso_count_item = filemenu_p->insertItem("Qs&o counter", 
						     event_slots_p, SLOT(increment_qso_count()));
	filemenu_p->insertSeparator();
	filemenu_p->insertItem("Set up &Kam", event_slots_p, SLOT(send_tnc_config()));
	filemenu_p->insertSeparator();
	filemenu_p->insertItem("&Settings", event_slots_p, SLOT(settings_prompt()));
	filemenu_p->insertSeparator();
	filemenu_p->setItemEnabled(menu_copy_item, false);
	filemenu_p->setItemEnabled(menu_print_selection_item, false);
	filemenu_p->setItemEnabled(menu_print_from_mark_item, false);
	filemenu_p->setItemEnabled(menu_save_selection_item, false);
    }
    filemenu_p->insertItem("&Quit", qApp, SLOT(quit()));
    menubar_p->insertItem("&File", filemenu_p);

    filemenu_p->setItemEnabled(download_item, false);
    upload_p->setItemEnabled(upload_7plus_item, false);
    upload_p->setItemEnabled(upload_binary_item, false);
    filemenu_p->setItemEnabled(upload_item, false);

    if (tnc_p) {
        QPopupMenu* vhf_p = new QPopupMenu;
	if (!vhf_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	int stream;
	char vhfstreamlabel[] = "Vhf-&A";
	char* char_p = vhfstreamlabel + 5;
	for (stream = 0; stream < MAXUSERS; stream++, (*char_p)++) {
	    vhf_p->insertItem(vhfstreamlabel, stream);
	}
	QObject::connect(vhf_p, SIGNAL(activated(int)), event_slots_p, SLOT(vhf_menu(int)));

        QPopupMenu* mouse_vhf_p = new QPopupMenu;
	if (!mouse_vhf_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}

	*char_p = 0;
	char_p--;
	*char_p = 'A';
	for (stream = 0; stream < MAXUSERS; stream++, (*char_p)++) {
	    mouse_vhf_p->insertItem(vhfstreamlabel, stream);
	}
	QObject::connect(mouse_vhf_p, SIGNAL(activated(int)), event_slots_p, SLOT(vhf_menu(int)));

	hfpacket_p = new QPopupMenu;
	if (!hfpacket_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	char hfstreamlabel[] = "Hf-&A";
	char_p = hfstreamlabel + 4;
	for (stream = 0; stream < MAXUSERS; stream++, (*char_p)++) {
	    hfpacket_p->insertItem(hfstreamlabel, stream);
	}
	QObject::connect(hfpacket_p, SIGNAL(activated(int)), event_slots_p, SLOT(hf_menu(int)));
	hftor_p = new QPopupMenu;
	if (!hftor_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	hftor_p->insertItem("Hf-Tor", 0);
	QObject::connect(hftor_p, SIGNAL(activated(int)), event_slots_p, SLOT(hf_menu(int)));

	mouse_hfpacket_p = new QPopupMenu;
	if (!mouse_hfpacket_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	*char_p = 0;
	char_p--;
	*char_p = 'A';
	for (stream = 0; stream < MAXUSERS; stream++, (*char_p)++) {
	    mouse_hfpacket_p->insertItem(hfstreamlabel, stream);
	}
	QObject::connect(mouse_hfpacket_p, SIGNAL(activated(int)), event_slots_p, SLOT(hf_menu(int)));
	mouse_hftor_p = new QPopupMenu;
	if (!mouse_hftor_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	mouse_hftor_p->insertItem("Hf-Tor", 0);
	QObject::connect(mouse_hftor_p, SIGNAL(activated(int)), event_slots_p, SLOT(hf_menu(int)));

	streammenu_p = new QPopupMenu;
	if (!streammenu_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	streammenu_p->insertItem("&Vhf", vhf_p, 0);
	streammenu_p->insertItem("&Hf", hfpacket_p, 1);

	mouse_streammenu_p = new QPopupMenu;
	if (!mouse_streammenu_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	mouse_streammenu_p->insertItem("Vhf", mouse_vhf_p, 0);
	mouse_streammenu_p->insertItem("Hf", mouse_hfpacket_p, 1);

	QPopupMenu* modemenu_p = new QPopupMenu;
	if (!modemenu_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	modemenu_p->insertItem("Packet(&X)", Tnc_func::packet);
#ifndef NO_PACTOR
	modemenu_p->insertItem("&Pactor", Tnc_func::pactor);
#endif
	modemenu_p->insertItem("&Amtor", Tnc_func::amtor);
	modemenu_p->insertItem("&Lamtor", Tnc_func::lamtor);
	modemenu_p->insertItem("&Fec", Tnc_func::fec);
	modemenu_p->insertItem("&Rtty", Tnc_func::rtty);
	modemenu_p->insertItem("A&scii", Tnc_func::ascii);
#ifndef NO_PACTOR
  #ifndef NO_GTOR
	modemenu_p->insertItem("&Gtor", Tnc_func::gtor);
	modemenu_p->insertItem("G&mon", Tnc_func::gmon);
  #endif
	modemenu_p->insertItem("&Tor", Tnc_func::tor);
#endif
	modemenu_p->insertItem("&Cw", Tnc_func::cw);
	QObject::connect(modemenu_p, SIGNAL(activated(int)), event_slots_p, SLOT(change_hfmode(int)));

	QPopupMenu* mouse_modemenu_p = new QPopupMenu;
	if (!mouse_modemenu_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	mouse_modemenu_p->insertItem("Packet", Tnc_func::packet);
#ifndef NO_PACTOR
	mouse_modemenu_p->insertItem("Pactor", Tnc_func::pactor);
#endif
	mouse_modemenu_p->insertItem("Amtor", Tnc_func::amtor);
	mouse_modemenu_p->insertItem("Lamtor", Tnc_func::lamtor);
	mouse_modemenu_p->insertItem("Fec", Tnc_func::fec);
	mouse_modemenu_p->insertItem("Rtty", Tnc_func::rtty);
	mouse_modemenu_p->insertItem("Ascii", Tnc_func::ascii);
#ifndef NO_PACTOR
  #ifndef NO_GTOR
	mouse_modemenu_p->insertItem("Gtor", Tnc_func::gtor);
	mouse_modemenu_p->insertItem("Gmon", Tnc_func::gmon);
  #endif
	mouse_modemenu_p->insertItem("Tor", Tnc_func::tor);
#endif
	mouse_modemenu_p->insertItem("Cw", Tnc_func::cw);
	QObject::connect(mouse_modemenu_p, SIGNAL(activated(int)), event_slots_p, SLOT(change_hfmode(int)));

	QPopupMenu* sendmenu_p = new QPopupMenu;
	if (!sendmenu_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	sendmenu_p->insertItem("&Word", Prog_func::word);
	sendmenu_p->insertItem("&Guard", Prog_func::guard);
	sendmenu_p->insertItem("&Line", Prog_func::line);
	QObject::connect(sendmenu_p, SIGNAL(activated(int)), event_slots_p, SLOT(hfsend_mode(int)));

	QPopupMenu* messagemenu_p = new QPopupMenu;
	if (!messagemenu_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	messagemenu_p->insertItem("Message 1", '1');
	messagemenu_p->insertItem("Message 2", '2');
	messagemenu_p->insertItem("Message 3", '3');
	messagemenu_p->insertItem("Message 4", '4');
	messagemenu_p->insertItem("Message 5", '5');
	messagemenu_p->insertItem("File Msg 6", '6');
	messagemenu_p->insertItem("File Msg 7", '7');
	messagemenu_p->insertItem("File Msg 8", '8');
	messagemenu_p->insertItem("File Msg 9", '9');
	messagemenu_p->insertItem("File Msg 0", '0');
	QObject::connect(messagemenu_p, SIGNAL(activated(int)), event_slots_p, SLOT(send_message_preprocess(int)));

	menubar_p->insertItem("Stre&am", streammenu_p);
	menubar_p->insertItem("Hf &Mode", modemenu_p);
	menubar_p->insertItem("Hf S&end", sendmenu_p);
	menubar_p->insertItem("Messa&ge", messagemenu_p);

        mouse_popup_p = new QPopupMenu;
	if (!mouse_popup_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	mouse_popup_p->insertItem("Stream", mouse_streammenu_p);
	mouse_popup_p->insertItem("Hf Mode", mouse_modemenu_p);
	mouse_popup_p->insertSeparator();
	mouse_popup_p->insertItem("Settings", event_slots_p, SLOT(settings_prompt()));
	mouse_popup_p->insertSeparator();
	mouse_copy_item = mouse_popup_p->insertItem("Copy selected text", receivewin_p, SLOT(copy()));
	mouse_popup_p->insertSeparator();
	mouse_print_selection_item = mouse_popup_p->insertItem("Print selected text",
						      receivewin_p, SLOT(print_selection()));
	mouse_popup_p->insertItem("Print scroll buffer", receivewin_p, SLOT(print_scroll_buffer()));
	mouse_set_print_mark_item = mouse_popup_p->insertItem("Set print mark",
							       event_slots_p, SLOT(set_print_mark_prompt()));
	mouse_print_from_mark_item = mouse_popup_p->insertItem("Print from mark",
							        event_slots_p, SLOT(print_from_mark_prompt()));
	mouse_popup_p->setItemEnabled(mouse_copy_item, false);
	mouse_popup_p->setItemEnabled(mouse_print_selection_item, false);
	mouse_popup_p->setItemEnabled(mouse_print_from_mark_item, false);
	mouse_popup_p->insertSeparator();
	mouse_save_selection_item = mouse_popup_p->insertItem("S&ave selected text", receivewin_p, SLOT(save()));
	mouse_popup_p->setItemEnabled(mouse_save_selection_item, false);
	mouse_popup_p->insertSeparator();
	mouse_qso_count_item = mouse_popup_p->insertItem("Qso counter", 
							 event_slots_p, SLOT(increment_qso_count()));

	QPixmap abortIcon(abort_xpm);
	QPixmap autocqIcon(auto_cq_xpm);
	QPixmap callLockIcon(call_lock_xpm);
	QPixmap captureIcon(capture_xpm);
	QPixmap commandIcon(command_xpm);
	QPixmap connectIcon(connect_xpm);
	QPixmap changeSpeedIcon(change_speed_xpm);
	QPixmap disconnectIcon(disconnect_xpm);
	QPixmap dxclusterIcon(dx_cluster_xpm);
	QPixmap enterCallIcon(enter_call_xpm);
	QPixmap identIcon(ident_xpm);
	QPixmap lockSpeedIcon(lock_speed_xpm);
	QPixmap rstIcon(rst_xpm);
	QPixmap rxIcon(rx_xpm);
	QPixmap syncIcon(sync_xpm);
	QPixmap txIcon(tx_xpm);

	QToolBar* toolbar_p = new QToolBar("Kamplus toolbar", this);
	if (!toolbar_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}

	QToolButton* toolbutton_p;
	connect_button_p = new QToolButton(connectIcon, "Connect", 0, event_slots_p, SLOT(make_connection_prompt()), toolbar_p);
	if (!connect_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	disconnect_button_p = new QToolButton(disconnectIcon, "Disconnect", 0, event_slots_p, SLOT(disconnect_prompt()), toolbar_p);
	if (!disconnect_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) {
	    toolbar_p->addSeparator();
	    toolbar_p->addSeparator();
	    toolbar_p->addSeparator();
	    toolbar_p->addSeparator();
	}
#endif
	toolbar_p->addSeparator();
	toolbutton_p = new QToolButton(enterCallIcon, "Enter callsign", 0, event_slots_p, SLOT(enter_call_prompt()), toolbar_p);
	if (!toolbutton_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	call_lock_button_p = new QToolButton(callLockIcon, "Toggle callsign lock", 0, event_slots_p, SLOT(lock_call()), toolbar_p);
	if (!call_lock_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	call_lock_button_p->setToggleButton(true);
	call_lock_button_p->setOn(false);
#if QT_VERSION < 300
	if (style() == MotifStyle) {
	    toolbar_p->addSeparator();
	    toolbar_p->addSeparator();
	    toolbar_p->addSeparator();
	    toolbar_p->addSeparator();
	}
#endif
	toolbar_p->addSeparator();
	toolbutton_p = new QToolButton(commandIcon, "Command Kam", 0, event_slots_p, SLOT(command_prompt()), toolbar_p);
	if (!toolbutton_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	capture_button_p = new QToolButton(captureIcon, "Toggle capture stream on/off", 0,
				       event_slots_p, SLOT(capture()), toolbar_p);
	if (!capture_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	capture_button_p->setToggleButton(true);
	capture_button_p->setOn(false);
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	auto_cq_button_p = new QToolButton(autocqIcon, "Send Auto-CQ", 0, event_slots_p, SLOT(auto_cq_preprocess()), toolbar_p);
	if (!auto_cq_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	auto_cq_button_p->setToggleButton(true);
	auto_cq_button_p->setOn(false);
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	speed_lock_button_p = new QToolButton(lockSpeedIcon, "Lock Speed to 100 baud", 0, event_slots_p, SLOT(lock_speed()), toolbar_p);
	if (!speed_lock_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	speed_lock_button_p->setToggleButton(true);
	speed_lock_button_p->setOn(false);
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	ident_button_p = new QToolButton(identIcon, "Send Ident", 0, event_slots_p, SLOT(ident()), toolbar_p);
	if (!ident_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	toolbutton_p = new QToolButton(rstIcon, "Enter RST", 0, event_slots_p, SLOT(rst_prompt()), toolbar_p);
	if (!toolbutton_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	abort_button_p = new QToolButton(abortIcon, "Abort", 0, event_slots_p, SLOT(abort_prompt()), toolbar_p);
	if (!abort_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	sync_button_p = new QToolButton(syncIcon, "Sync Amtor/CW", 0, event_slots_p, SLOT(sync()), toolbar_p);
	if (!sync_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	change_speed_button_p = new QToolButton(changeSpeedIcon, "Set CW/RTTY/ASCII Speed", 0, event_slots_p, SLOT(change_speed()), toolbar_p);
	if (!change_speed_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
#if QT_VERSION < 300
	if (style() == MotifStyle) toolbar_p->addSeparator();
#endif
	dx_cluster_button_p = new QToolButton(dxclusterIcon, "Monitor DX Cluster", 0, event_slots_p, SLOT(read_cluster()), toolbar_p);
	if (!dx_cluster_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	dx_cluster_button_p->setToggleButton(true);
	dx_cluster_button_p->setOn(false);
	toolbar_p->addSeparator();

	QWidget* widget_p = new QToolButton(toolbar_p);
	if (!widget_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	widget_p->setEnabled(false);
#if QT_VERSION < 300
	toolbar_p->setHorizontalStretchable(true);
	toolbar_p->setVerticalStretchable(true);
#else
	toolbar_p->setHorizontallyStretchable(true);
	toolbar_p->setVerticallyStretchable(true);
#endif
	toolbar_p->setStretchableWidget(widget_p);

	rx_button_p = new QToolButton(rxIcon, "Receive", 0, event_slots_p, SLOT(changeover_rx()), toolbar_p);
	if (!rx_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}
	tx_button_p = new QToolButton(txIcon, "Transmit", 0, event_slots_p, SLOT(changeover_tx()), toolbar_p);
	if (!tx_button_p) {
	    cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	    exit(MEM_ERROR);
	}

	setDockEnabled(QMainWindow::Top, true);
	setDockEnabled(QMainWindow::Bottom, true);
	setDockEnabled(QMainWindow::Left, true);
	setDockEnabled(QMainWindow::Right, true);
	setDockEnabled(QMainWindow::TornOff, true);
	setDockEnabled(QMainWindow::Minimized, false);
	setToolBarsMovable(true);
	setOpaqueMoving(false);
#if QT_VERSION >= 300
	setDockMenuEnabled(false);
#endif
    }

    QPopupMenu* helpmenu_p = new QPopupMenu;
    if (!helpmenu_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }
    helpmenu_p->insertItem("&About kamplus-qt", this, SLOT(about_kamplus()));
    helpmenu_p->insertItem("About &Qt", this, SLOT(about_qt()));
    if (tnc_p) {
        helpmenu_p->insertSeparator();
        helpmenu_p->insertItem("&Helpfile", event_slots_p, SLOT(helpfile()));
    }
    menubar_p->insertSeparator();
    menubar_p->insertItem("&Help", helpmenu_p);

    status_line_p = new StatusLine(this, tnc_p, standard_size, display_line_p->get_minsize());
    if (!status_line_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }

    sendwin_p->setFocus();
    
    startTimer(TIMER_INTERVAL);

    QSocketNotifier* pipe_select_p = new QSocketNotifier(receive_pipe.get_read_fd(),
    					               QSocketNotifier::Read, this);
    if (!pipe_select_p) {
        cerr << "Memory allocation error in MainScreen::MainScreen()" << endl;
	exit(MEM_ERROR);
    }
    QObject::connect(pipe_select_p, SIGNAL(activated(int)), this, SLOT(process_receive_pipe(int)));
    QObject::connect(sendwin_p, SIGNAL(letter_to_send(uchar)), event_slots_p, SLOT(send_letter(uchar)));

    if (tnc_p) {
        QObject::connect(sendwin_p, SIGNAL(keyup()), receivewin_p, SLOT(scrollup()));
	QObject::connect(sendwin_p, SIGNAL(keydown()), receivewin_p, SLOT(scrolldown()));
	QObject::connect(sendwin_p, SIGNAL(keyright(int)), receivewin_p, SLOT(scrollout(int)));
        QObject::connect(sendwin_p, SIGNAL(CtrlA_pressed()), event_slots_p, SLOT(ctrl_a()));
        QObject::connect(sendwin_p, SIGNAL(CtrlD_pressed()), event_slots_p, SLOT(disconnect_prompt()));
        QObject::connect(sendwin_p, SIGNAL(CtrlT_pressed()), event_slots_p, SLOT(ctrl_t()));
        QObject::connect(sendwin_p, SIGNAL(CtrlZ_pressed()), event_slots_p, SLOT(ctrl_z()));
	QObject::connect(sendwin_p, SIGNAL(f1_pressed()), event_slots_p, SLOT(helpfile()));
	QObject::connect(sendwin_p, SIGNAL(f2_pressed()), event_slots_p, SLOT(capture()));
	QObject::connect(sendwin_p, SIGNAL(f3_pressed(int)), event_slots_p, SLOT(hfsend_mode(int)));
	QObject::connect(sendwin_p, SIGNAL(f4_pressed()), event_slots_p, SLOT(make_connection_prompt()));
	QObject::connect(sendwin_p, SIGNAL(f5_pressed()), event_slots_p, SLOT(command_prompt()));
	QObject::connect(sendwin_p, SIGNAL(f7_pressed()), event_slots_p, SLOT(enter_call_prompt()));
	QObject::connect(sendwin_p, SIGNAL(f8_pressed()), event_slots_p, SLOT(lock_call()));
	QObject::connect(sendwin_p, SIGNAL(f9_pressed()), event_slots_p, SLOT(send_tnc_config()));
        QObject::connect(sendwin_p, SIGNAL(f10_pressed()), event_slots_p, SLOT(change_port()));
	QObject::connect(sendwin_p, SIGNAL(f11_pressed()), event_slots_p, SLOT(stream_down()));
	QObject::connect(sendwin_p, SIGNAL(f12_pressed()), event_slots_p, SLOT(stream_up()));
	QObject::connect(sendwin_p, SIGNAL(altB_pressed()), receivewin_p, SLOT(print_scroll_buffer()));
	QObject::connect(sendwin_p, SIGNAL(altI_pressed()), event_slots_p, SLOT(ident()));
	QObject::connect(sendwin_p, SIGNAL(altL_pressed()), event_slots_p, SLOT(lock_speed()));
	QObject::connect(sendwin_p, SIGNAL(altN_pressed()), event_slots_p, SLOT(read_cluster()));
	QObject::connect(sendwin_p, SIGNAL(altP_pressed()), event_slots_p, SLOT(context_print_mark()));
	QObject::connect(sendwin_p, SIGNAL(altR_pressed()), event_slots_p, SLOT(rst_prompt()));
	QObject::connect(sendwin_p, SIGNAL(altS_pressed()), event_slots_p, SLOT(sync()));
	QObject::connect(sendwin_p, SIGNAL(altX_pressed()), event_slots_p, SLOT(abort_prompt()));
	QObject::connect(sendwin_p, SIGNAL(alt_plus_pressed()), event_slots_p, SLOT(increment_qso_count()));
	QObject::connect(sendwin_p, SIGNAL(alt_minus_pressed()), event_slots_p, SLOT(decrement_qso_count()));
	QObject::connect(sendwin_p, SIGNAL(pageup_pressed()), event_slots_p, SLOT(changeover_tx()));
	QObject::connect(sendwin_p, SIGNAL(pagedown_pressed()), event_slots_p, SLOT(changeover_rx()));
	QObject::connect(sendwin_p, SIGNAL(sig_auto_cq(int,int)), event_slots_p, SLOT(auto_cq_preprocess(int, int)));
	
	QObject::connect(sendwin_p, SIGNAL(sig_change_hfmode(int, int)), event_slots_p, SLOT(change_hfmode(int, int)));
	QObject::connect(sendwin_p, SIGNAL(sig_upload(int)), event_slots_p, SLOT(upload_prompt(int)));
	QObject::connect(sendwin_p, SIGNAL(sig_download(int)), event_slots_p, SLOT(download_prompt(int)));
	QObject::connect(sendwin_p, SIGNAL(sig_send_message(int, int)), event_slots_p, SLOT(send_message_preprocess(int, int)));
	QObject::connect(sendwin_p, SIGNAL(mouse_right_clicked()), this, SLOT(mouse_popup()));
	QObject::connect(receivewin_p, SIGNAL(mouse_right_clicked()), this, SLOT(mouse_popup()));
	QObject::connect(receivewin_p, SIGNAL(activate_textselected_items()), this, SLOT(activate_textselected_items()));
	QObject::connect(receivewin_p, SIGNAL(disactivate_textselected_items()), this, SLOT(disactivate_textselected_items()));
	QObject::connect(this, SIGNAL(toolBarPositionChanged(QToolBar*)), this, SLOT(toolbar_moved()));

        display_capture_status();
	display_send_mode_status();
	display_current_stream();
	display_connected_status();
	display_mode();
	set_call_lock_button();
	set_auto_cq_button();
	set_speed_lock_button();
	set_ident_button();
	set_sync_button();
	set_abort_button();
	set_rx_button();
	set_tx_button();
	set_change_speed_button();
	display_freebytes();
    }
    QValueList<int> splitter_size_list;
    splitter_size_list.append(standard_size * 3);
    splitter_size_list.append(standard_size * 6);
    splitter_p->setSizes(splitter_size_list);

    // the next line does not seem to work correctly - why not?
    topLevelWidget()->setMinimumSize(display_line_p->get_minsize(), standard_size * 11);
}

void MainScreen::toolbar_moved(void) {
    lineUpToolBars();
}

void MainScreen::process_receive_pipe(int fd) {
    if (fd == receive_pipe.get_read_fd()) {
        usleep(10000); // as the com port only runs at 9600 baud, we can let a few characters
	               // accumulate in receive_pipe and be even more kind to system resources
	tnc_base_p->process_received_bytes();
    }
}

void MainScreen::timerEvent(QTimerEvent*) {

// send any connect script being run, or any parameter file being sent

    if (event_slots_p->get_connect_script_flag() == EventSlots::running) event_slots_p->run_connect_script();
    if (event_slots_p->get_send_parms_flag() == EventSlots::running) event_slots_p->send_parms();


// check if anything needs to be sent out of tr_buffer to send_pipe
// (this includes a check whether there is a command in tr_buffer - the
// only command normally placed in the buffer is the receive command 'E':
// others are placed directly in send_pipe)

    int letter = tr_buffer.view_letter();
    if (letter == '\n' || letter == CMDinbuffer
	  || letter == 1 || letter == 8
	  || letter == 20 || letter == 26) {
        flush_chars = true;
    }

    if (tnc_p) {  // in normal mode
        if (flush_chars
	    || (tnc_p->tnc_func.active_port
		&& tnc_p->tnc_func.hfmode != Tnc_func::packet
		&& ((prog_func.send_mode == Prog_func::word
		     && tr_buffer.letters_used()) || 
		    (prog_func.send_mode == Prog_func::guard 
		     && tr_buffer.letters_used() > GUARD_QUEUE)))) {
        letters_to_send_flag = true;
	}
    }
    else if (letter != -1) letters_to_send_flag = true; // in set-up mode
    
// send anything to be sent

    if (letters_to_send_flag) {
        tnc_base_p->send_to_tnc(flush_chars);
	if (!tnc_p || !tnc_p->get_unsent_frame_flag()) {
	    letters_to_send_flag = false;
	    flush_chars = false;
	}
    }

// check if anything to be sent out of filesend buffers

    if(!buffer_list.is_empty()) {
        if (!buffer_count) buffer_count = 1;
	buffer_list.reset(DList_enum::bottom_end);
	FileBuffer* file_buffer_ptr;
	int loop_count;
	for (loop_count = 0;
	     (file_buffer_ptr = (FileBuffer*)buffer_list.inspect(DList_enum::up)) != 0;
	     loop_count++) {
	    if (!file_buffer_ptr->load_buffer()) {
	        // if FileBuffer::load_buffer() does not return TRUE
	        // then it indicates that the FileBuffer object is be extracted and deleted
	        buffer_list.extract();
		delete file_buffer_ptr; // this will also delete the UploadDialog object
		loop_count--;
		if (buffer_count) buffer_count--;
		set_auto_cq_button();  // in case it is a CqsendBuffer object which has been extracted
	    }
	    else tnc_p->send_file(file_buffer_ptr, buffer_count, loop_count);
	}
	buffer_count = loop_count;
    }
    else buffer_count = 0; 

// get Kam information, check free bytes in Kam buffer and check the keep alive status
    if (tnc_p) {
        tnc_p->get_info();
	if (count == 20) {
	    tnc_p->find_freebytes();
	    if (tnc_p->tnc_func.keep_alive.keep_alive_flag) tnc_p->check_keep_alive();
	    count = 0;
	}
	else count++;
    }

// check the scrolling condition
    receivewin_p->check_scroll_condition();

// check to see if we are beeping
    if (beep_count) {
        if (!interval_count) {
	    QApplication::beep();
	    beep_count--;
	    if (beep_count) interval_count = INTERVAL_COUNT - 1;
	}
	else interval_count--;
    }
    // check whether we have received SIGQUIT, SIGTERM SIGINT SIGHUP and SIGPIPE
    if (prog_func.exitflag) qApp->quit();
}

void MainScreen::activate_textselected_items(void) {
    filemenu_p->setItemEnabled(menu_copy_item, true);
    filemenu_p->setItemEnabled(menu_print_selection_item, true);
    filemenu_p->setItemEnabled(menu_save_selection_item, true);
    mouse_popup_p->setItemEnabled(mouse_copy_item, true);
    mouse_popup_p->setItemEnabled(mouse_print_selection_item, true);
    mouse_popup_p->setItemEnabled(mouse_save_selection_item, true);
}

void MainScreen::disactivate_textselected_items(void) {
    filemenu_p->setItemEnabled(menu_copy_item, false);
    filemenu_p->setItemEnabled(menu_print_selection_item, false);
    filemenu_p->setItemEnabled(menu_save_selection_item, false);
    mouse_popup_p->setItemEnabled(mouse_copy_item, false);
    mouse_popup_p->setItemEnabled(mouse_print_selection_item, false);
    mouse_popup_p->setItemEnabled(mouse_save_selection_item, false);
}

void MainScreen::update_file_load_items(void) {
    if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()]
                                 [tnc_p->tnc_func.active_port] != Tnc_func::connected
	|| (tnc_p->tnc_func.active_port
	    && (tnc_p->tnc_func.hfmode == Tnc_func::amtor
		|| (tnc_p->tnc_func.hfmode == Tnc_func::tor
		    && tnc_p->tnc_func.tor_connected_mode != Tnc_func::pactor_gtor)))) {
        filemenu_p->setItemEnabled(download_item, false);
	upload_p->setItemEnabled(upload_7plus_item, false);
	upload_p->setItemEnabled(upload_binary_item, false);
    }
    else {
        filemenu_p->setItemEnabled(download_item, true);
	upload_p->setItemEnabled(upload_7plus_item, true);
	upload_p->setItemEnabled(upload_binary_item, true);
    }
    if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()]
                                 [tnc_p->tnc_func.active_port] != Tnc_func::connected
	&& (!tnc_p->tnc_func.active_port
	    || tnc_p->tnc_func.hfmode == Tnc_func::packet)) {
        filemenu_p->setItemEnabled(upload_item, false);
    }
    else filemenu_p->setItemEnabled(upload_item, true);
}

void MainScreen::update_print_mark_items(void) {

    if (tnc_p->tnc_func.print_list_ptr->get_print_status(tnc_p->tnc_func.active_stream(),
	  tnc_p->tnc_func.active_port) ==  PrintList::off) {
        filemenu_p->setItemEnabled(menu_set_print_mark_item, true);
	mouse_popup_p->setItemEnabled(mouse_set_print_mark_item, true);
	filemenu_p->setItemEnabled(menu_print_from_mark_item, false);
	mouse_popup_p->setItemEnabled(mouse_print_from_mark_item, false);
    }
    else {
        filemenu_p->setItemEnabled(menu_set_print_mark_item, false);
	mouse_popup_p->setItemEnabled(mouse_set_print_mark_item, false);
	filemenu_p->setItemEnabled(menu_print_from_mark_item, true);
	mouse_popup_p->setItemEnabled(mouse_print_from_mark_item, true);
    }
}

void MainScreen::update_qso_counter_items(void) {
    if (prog_func.qso_count) {
        filemenu_p->setItemEnabled(menu_qso_count_item, false);
	mouse_popup_p->setItemEnabled(mouse_qso_count_item, false);
    }
    else {
        filemenu_p->setItemEnabled(menu_qso_count_item, true);
	mouse_popup_p->setItemEnabled(mouse_qso_count_item, true);
    }
}

void MainScreen::display_capture_status(void) {
    if (tnc_p->tnc_func.capturefile_flag == FALSE) display_line_p->write_capture("Off");
    else {
        char text[6] = {0};
        if (tnc_p->tnc_func.capture_stream.port) strcpy(text, "Hf-");
	else strcpy(text, "Vhf-");
	if (!tnc_p->tnc_func.capture_stream.port || tnc_p->tnc_func.hfmode == Tnc_func::packet)  {
	    char stream[2] = {0};
	    *stream = tnc_p->tnc_func.capture_stream.stream + 0x41;
	    strcat(text, stream);
	}
	else strcat(text, "Tor");
	display_line_p->write_capture(text);
    }
}

void MainScreen::display_current_stream(void) {
    char text[6] = {0};
    if (tnc_p->tnc_func.active_port) strcpy(text, "Hf-");
    else strcpy(text, "Vhf-");
    if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet)  {
        char stream[2] = {0};
	*stream = tnc_p->tnc_func.active_stream() + 0x41;
	strcat(text, stream);
    }
    else strcat(text, "Tor");
    display_line_p->write_stream(text);
}

void MainScreen::display_connected_status(void) {
     if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port]
	  ==  Tnc_func::disconnected) {
        if (tnc_p->tnc_func.active_port && prog_func.sending_autocq) {
	    if (prog_func.tor_autocq_mode == Prog_func::amtor) {
	        status_line_p->write_connected_status("Auto-CQ");
	    }
	    else status_line_p->write_connected_status("Auto-CQ (Pt)");
	}
	else if (tnc_p->tnc_func.read_cluster_flag
		 && !tnc_p->tnc_func.active_port
		 && tnc_p->tnc_func.active_vhf_stream == MAXUSERS - 1) {
	    status_line_p->write_connected_status("DX Cluster");
	}
        else status_line_p->write_connected_status("Disconnected");
    }
    else if (tnc_p->tnc_func.download_list_ptr->get_download_status(tnc_p->tnc_func.active_stream(),
                                     tnc_p->tnc_func.active_port) == DownloadList::on) {
        status_line_p->write_connected_status("Download");
    }
    else status_line_p->write_connected_status("Connected");
}

void MainScreen::display_mode(void) {
    switch(tnc_p->tnc_func.hfmode) {
    case Tnc_func::packet:
        display_line_p->write_hfmode("Packet");
	break;
    case Tnc_func::pactor:
        display_line_p->write_hfmode("Pactor");
	break;
    case Tnc_func::rtty:
        display_line_p->write_hfmode("RTTY");
	break;
    case Tnc_func::ascii:
        display_line_p->write_hfmode("ASCII");
	break;
    case Tnc_func::amtor:
        display_line_p->write_hfmode("Amtor");
	break;
    case Tnc_func::lamtor:
        display_line_p->write_hfmode("Lamtor");
	break;
    case Tnc_func::fec:
        display_line_p->write_hfmode("FEC");
	break;
    case Tnc_func::gtor:
        display_line_p->write_hfmode("Gtor");
	break;
    case Tnc_func::gmon:
        display_line_p->write_hfmode("Gmon");
	break;
    case Tnc_func::tor:
        display_line_p->write_hfmode("Tor");
	break;
    case Tnc_func::cw:
        display_line_p->write_hfmode("CW");
	break;
    }
}

void MainScreen::display_send_mode_status(void) {
    if (prog_func.send_mode == Prog_func::word) display_line_p->write_hfsend("Word ");
    else if (prog_func.send_mode == Prog_func::guard) display_line_p->write_hfsend("Guard");
    else display_line_p->write_hfsend("Line ");
}

void MainScreen::display_callsign(void) {
    string text;
    if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet 
	&& tnc_p->tnc_func.hisCall_lock == Tnc_func::on) text = '*';
    else text = ' ';
    text +=  tnc_p->tnc_func.hisCall[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    display_line_p->write_call(text.c_str());
}

void MainScreen::display_freebytes(void) {
    ostrstream strm;
    strm << tnc_p->get_active_freebytes() << ends;
    char* text = strm.str();
    status_line_p->write_freebytes(text);
    delete[] text;
}

void MainScreen::update_lockinfo(void) {
    if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
	if (tnc_p->tnc_func.speed_lock == Tnc_func::on) status_line_p->write_lock_status("LOCK");
	else status_line_p->write_lock_status("");
    }
}

void MainScreen::update_torinfo(unsigned char info) {
// info has a default value of 255
    if (info != 255) info_byte = info; // if info = 255 we just use the value stored in info_byte
    if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
        if (info_byte & 1) status_line_p->write_idle_status("IDLE");
	else status_line_p->write_idle_status("");
	if (info_byte & 2) status_line_p->write_err_status("ERR");
	else if (info_byte & 4) status_line_p->write_err_status("CMB");
	else if (info_byte & 8) status_line_p->write_err_status("RQ ");
	else status_line_p->write_err_status("");
	if (info_byte & 16) status_line_p->write_huff_status("HUFF");
	else status_line_p->write_huff_status("");
	if (info_byte & 32) status_line_p->write_irs_status("ISS");
	else if (tnc_p->tnc_func.stream_status[0][1] == Tnc_func::connected) {
	    status_line_p->write_irs_status("IRS");
	}
	else status_line_p->write_irs_status("");
	if (info_byte & 64) status_line_p->write_speed_status("200");
	else if (info_byte & 128) status_line_p->write_speed_status("300");
	else if (tnc_p->tnc_func.stream_status[0][1] == Tnc_func::connected) {
	    status_line_p->write_speed_status("100");
	}
	else status_line_p->write_speed_status("");
    }
}

void MainScreen::update_txinfo(unsigned char tx) {
// tx has a default value of 255
    if (tx != 255) tx_byte = tx; // if tx = 255 we just use the value stored in tx_byte
    if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
	if ((tx_byte & 2) || tnc_p->tnc_func.sending_cw_flag) {
	    status_line_p->write_tx_status("TX");
	    if (tx_status == MainScreen::rx) tx_status = MainScreen::tx;
	}
	else {
	    status_line_p->write_tx_status("RX");
	    if (tx_status == MainScreen::tx) tx_status = MainScreen::rx;
	}
    }
}

void MainScreen::set_connect_button(void) {
    if (tnc_p->tnc_func.stream_status[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port]
	    != Tnc_func::connected
	&& (!tnc_p->tnc_func.active_port ||
	    (tnc_p->tnc_func.hfmode != Tnc_func::rtty
	     && tnc_p->tnc_func.hfmode != Tnc_func::tor
	     && tnc_p->tnc_func.hfmode != Tnc_func::ascii
	     && tnc_p->tnc_func.hfmode != Tnc_func::cw))) {
        connect_button_p->setEnabled(true);
    }
    else connect_button_p->setEnabled(false);
}

void MainScreen::set_disconnect_button(void) {
    if (!tnc_p->tnc_func.active_port
	|| tnc_p->tnc_func.hfmode == Tnc_func::packet
	|| tnc_p->tnc_func.hfmode == Tnc_func::amtor
	|| tnc_p->tnc_func.hfmode == Tnc_func::gtor
	|| tnc_p->tnc_func.hfmode == Tnc_func::pactor
	|| tnc_p->tnc_func.hfmode == Tnc_func::tor) {
        disconnect_button_p->setEnabled(true);
    }
    else disconnect_button_p->setEnabled(false);
}

void MainScreen::set_call_lock_button(void) {
    if (!tnc_p->tnc_func.active_port || tnc_p->tnc_func.hfmode == Tnc_func::packet) {
        call_lock_button_p->setOn(false);
	call_lock_button_p->setEnabled(false);
    }
    else if (tnc_p->tnc_func.hisCall_lock == Tnc_func::on) {
        call_lock_button_p->setOn(true);
	call_lock_button_p->setEnabled(true);
    }
    else {
        call_lock_button_p->setOn(false);
	call_lock_button_p->setEnabled(true);
    }
}

void MainScreen::set_dx_cluster_button(void) {
    if (tnc_p->tnc_func.stream_status[0][MAXUSERS - 1] == Tnc_func::connected) {
        dx_cluster_button_p->setOn(false);
	dx_cluster_button_p->setEnabled(false);
    }
    else if (tnc_p->tnc_func.read_cluster_flag) {
        dx_cluster_button_p->setOn(true);
	dx_cluster_button_p->setEnabled(true);
    }
    else {
        dx_cluster_button_p->setOn(false);
	dx_cluster_button_p->setEnabled(true);
    }
}

void MainScreen::set_speed_lock_button(void) {
    if (!tnc_p->tnc_func.active_port
	|| !(tnc_p->tnc_func.hfmode == Tnc_func::pactor
	     || tnc_p->tnc_func.hfmode == Tnc_func::gtor
	     || tnc_p->tnc_func.hfmode == Tnc_func::tor)) {
        speed_lock_button_p->setOn(false);
	speed_lock_button_p->setEnabled(false);
    }
    else if (tnc_p->tnc_func.speed_lock == Tnc_func::on) {
        speed_lock_button_p->setOn(true);
	speed_lock_button_p->setEnabled(true);
    }
    else {
        speed_lock_button_p->setOn(false);
	speed_lock_button_p->setEnabled(true);
    }
}

void MainScreen::set_ident_button(void) {
    if (tnc_p->tnc_func.active_port
	&& tnc_p->tnc_func.hfmode != Tnc_func::packet) {
        ident_button_p->setEnabled(true);
    }
    else ident_button_p->setEnabled(false);
}

void MainScreen::set_sync_button(void) {
    if (tnc_p->tnc_func.active_port
	&& (tnc_p->tnc_func.hfmode == Tnc_func::cw
	    || tnc_p->tnc_func.hfmode == Tnc_func::lamtor
	    || tnc_p->tnc_func.hfmode == Tnc_func::fec
	    || (tnc_p->tnc_func.hfmode == Tnc_func::amtor
		 && tnc_p->tnc_func.stream_status[0][1] == Tnc_func::disconnected))) {
        sync_button_p->setEnabled(true);
    }
    else sync_button_p->setEnabled(false);
}
        
void MainScreen::set_abort_button(void) {
    if (tnc_p->tnc_func.active_port
	&& (tnc_p->tnc_func.hfmode == Tnc_func::amtor
	    || tnc_p->tnc_func.hfmode == Tnc_func::gtor
	    || tnc_p->tnc_func.hfmode == Tnc_func::pactor
	    || tnc_p->tnc_func.hfmode == Tnc_func::tor)) {
        abort_button_p->setEnabled(true);
    }
    else abort_button_p->setEnabled(false);
}

void MainScreen::set_auto_cq_button(void) {
    if (!tnc_p->tnc_func.active_port
	|| (tnc_p->tnc_func.hfmode != Tnc_func::pactor
	    && tnc_p->tnc_func.hfmode != Tnc_func::amtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::gtor
	    && tnc_p->tnc_func.hfmode != Tnc_func::tor)
	|| tnc_p->tnc_func.stream_status[0][1] == Tnc_func::connected
	|| (!prog_func.sending_autocq
	    && buffer_list.get_upload_status(0, 1) == BufferList::file)) {
        auto_cq_button_p->setOn(false);
	auto_cq_button_p->setEnabled(false);
    }
    else if (prog_func.sending_autocq) {
        auto_cq_button_p->setOn(true);
	auto_cq_button_p->setEnabled(true);
    }
    else {
        auto_cq_button_p->setOn(false);
        auto_cq_button_p->setEnabled(true);
    }
}

#if QT_VERSION >= 300
SendWin::SendWin(QWidget* widget, int fontsize): QTextEdit(widget) {
    setFont(QFont("Courier", fontsize, QFont::Normal));
    setTextFormat(PlainText);
}

#else
SendWin::SendWin(QWidget* widget, int fontsize): QMultiLineEdit(widget) {
    setFont(QFont("Courier", fontsize, QFont::Normal));
}
#endif

void SendWin::font_change(int size) {
    if (size == 10 || size == 12 || size == 14) {
        setFont(QFont("Courier", size, QFont::Normal));
    }
}

void SendWin::write(const char* text) {
#if QT_VERSION >= 300
    // moveCursor(QTextEdit::MoveEnd, false); // we shouldn't need to do this coz the cursor should always be at the end (and if it isn't, new_line() doesn't work).
    insert(text);
    if (paragraphs() >  MAXLINES + DELETE_BLOCK) {
	setUpdatesEnabled(false);
	int count = paragraphs() - MAXLINES;
	for (; count > 0; count--) removeParagraph(0);
	setUpdatesEnabled(true);
	repaint();
    }
#else
    insertAt(text, END_OF_WINDOW, END_OF_WINDOW);
    if (numLines() > MAXLINES + DELETE_BLOCK) {
        setAutoUpdate(false);
	int count = numLines() - MAXLINES;
	for (; count > 0; count--) removeLine(0);
	setAutoUpdate(true);
	repaint();
    }
#endif
}

void SendWin::keyPressEvent(QKeyEvent* event) {

    int keycode = event->key();
    int letter = event->ascii();
    int state = event->state();
    bool letter_flag = false;

    if (keycode ==  Key_Return) {
        letter = '\n';
	letter_flag = true;
    }
    else if (keycode == Key_Backspace) {
        letter = 8;
	letter_flag = true;
    }
    else if (keycode == Key_Delete); // ignore delete key

    else if (keycode == Key_F1) emit f1_pressed();
    else if (keycode == Key_F2) emit f2_pressed();
    else if (keycode == Key_F3) {
        int mode;
        if (prog_func.send_mode == Prog_func::line) mode = Prog_func::word;
	else if (prog_func.send_mode == Prog_func::word) mode = Prog_func::guard;
	else mode = Prog_func::line;
        emit f3_pressed(mode);
    }
    else if (keycode == Key_F4) emit f4_pressed();
    else if (keycode == Key_F5) emit f5_pressed();
    else if (keycode == Key_F6) emit sig_upload(FileBuffer::text);
    else if (keycode == Key_F7) emit f7_pressed();
    else if (keycode == Key_F8) emit f8_pressed();
    else if (keycode == Key_F9) emit f9_pressed();
    else if (keycode == Key_F10) emit f10_pressed();
    else if (keycode == Key_F11) emit f11_pressed();
    else if (keycode == Key_F12) emit f12_pressed();

    else if (!(state & AltButton) && (state & ControlButton)) {
        if (keycode == Key_A) emit CtrlA_pressed();
        else if (keycode == Key_C) emit sig_change_hfmode(Tnc_func::cw, true);
	else if (keycode == Key_D) emit CtrlD_pressed();
        else if (keycode == Key_F) emit sig_change_hfmode(Tnc_func::fec, true);
        else if (keycode == Key_L) emit sig_change_hfmode(Tnc_func::lamtor, true);
        else if (keycode == Key_R) emit sig_change_hfmode(Tnc_func::rtty, true);
        else if (keycode == Key_S) emit sig_change_hfmode(Tnc_func::ascii, true);
	else if (keycode == Key_T) emit CtrlT_pressed();
        else if (keycode == Key_X) emit sig_change_hfmode(Tnc_func::packet, true);
	else if (keycode == Key_Z) emit CtrlZ_pressed();
#ifndef NO_PACTOR
        else if (keycode == Key_P) emit sig_change_hfmode(Tnc_func::pactor, true);
  #ifndef NO_GTOR
        else if (keycode == Key_G) emit sig_change_hfmode(Tnc_func::gtor, true);
        else if (keycode == Key_O) emit sig_change_hfmode(Tnc_func::gmon, true);
  #endif
#endif
    }
    else if ((state & AltButton) && !(state & ControlButton)) {
        if (keycode == Key_B) emit altB_pressed();
        else if (keycode == Key_C) emit sig_auto_cq(EventSlots::amtor, true);
        else if (keycode == Key_D) emit sig_download(DownloadFile::s_plus);
        else if (keycode == Key_I) emit altI_pressed();
        else if (keycode == Key_L) emit altL_pressed();
        else if (keycode == Key_N) emit altN_pressed();
        else if (keycode == Key_P) emit altP_pressed();
        else if (keycode == Key_R) emit altR_pressed();
        else if (keycode == Key_S) emit altS_pressed();
        else if (keycode == Key_T) emit sig_auto_cq(EventSlots::pactor, true);
        else if (keycode == Key_U) emit sig_upload(FileBuffer::s_plus);
        else if (keycode == Key_X) emit altX_pressed();
        else if (keycode == Key_0) emit sig_send_message('0', true);
        else if (keycode == Key_1) emit sig_send_message('1', true);
        else if (keycode == Key_2) emit sig_send_message('2', true);
        else if (keycode == Key_3) emit sig_send_message('3', true);
        else if (keycode == Key_4) emit sig_send_message('4', true);
        else if (keycode == Key_5) emit sig_send_message('5', true);
        else if (keycode == Key_6) emit sig_send_message('6', true);
        else if (keycode == Key_7) emit sig_send_message('7', true);
        else if (keycode == Key_8) emit sig_send_message('8', true);
        else if (keycode == Key_9) emit sig_send_message('9', true);
	else if (keycode == Key_Plus || keycode == Key_Equal) emit alt_plus_pressed();
	else if (keycode == Key_Minus || keycode == Key_Underscore) emit alt_minus_pressed();
    }
    else if ((state & AltButton) && (state & ControlButton)) {
        if (keycode == Key_D) emit sig_download(DownloadFile::binary);
        else if (keycode == Key_U) emit sig_upload(FileBuffer::binary);
    }

    else if (keycode == Key_PageUp) emit pageup_pressed();
    else if (keycode == Key_PageDown) emit pagedown_pressed();

    else if (keycode == Key_Up) emit keyup();
    else if (keycode == Key_Down) emit keydown();
    else if (keycode == Key_Right) emit keyright(false);
    
    else letter_flag = true;
    if (letter_flag
	  && (letter == '\n' || letter == 8 || letter > 31)) {
        emit letter_to_send(letter);
    }
}

#if QT_VERSION >= 300
ReceiveWinNode::ReceiveWinNode(QWidget* widget, int fontsize): QTextEdit(widget) {
// we don't want to call setReadOnly(true) with a QTextEdit object or we won't be
// able to back-delete using the doKeyboardAction() method
  //setTextFormat(Qt::PlainText); // this stops colour in Qt-3.0.0!
    setFocusPolicy(QWidget::NoFocus);
    setFont(QFont("Courier", fontsize, QFont::Normal));
    setWordWrap(QTextEdit::WidgetWidth);
}

void ReceiveWinNode::contentsMousePressEvent(QMouseEvent* event) {
    if (event->button() == RightButton) emit mouse_right_clicked();
    else if (event->button() == LeftButton) {
        if (hasSelectedText()) selectAll(false);
        QTextEdit::contentsMousePressEvent(event);
    }
}

void ReceiveWinNode::contentsMouseReleaseEvent(QMouseEvent* event) {
    int button = event->button();
    if (button != MidButton) {
	QTextEdit::contentsMouseReleaseEvent(event);
	if (button == LeftButton) emit mouse_released();
    }
}

#else
ReceiveWinNode::ReceiveWinNode(QWidget* widget, int fontsize): QMultiLineEdit(widget) {
    setReadOnly(true);
    setFocusPolicy(QWidget::NoFocus);
    setFont(QFont("Courier", fontsize, QFont::Normal));
#if QT_VERSION >= 210
    setWordWrap(QMultiLineEdit::WidgetWidth);
#endif
    insertAt("\n\n", END_OF_WINDOW, END_OF_WINDOW);
}

void ReceiveWinNode::mousePressEvent(QMouseEvent* event) {
    if (event->button() == RightButton) emit mouse_right_clicked();
    else if (event->button() == LeftButton) QMultiLineEdit::mousePressEvent(event);
}

void ReceiveWinNode::mouseReleaseEvent(QMouseEvent* event) {
    int button = event->button();
    if (button != MidButton) {
        QMultiLineEdit::mouseReleaseEvent(event);
	if (button == LeftButton) emit mouse_released();
    }
}
#endif


ReceiveWin::ReceiveWin(QWidget* widget, Tnc* tnc_, int s_size, int fontsize): QWidgetStack(widget), tnc_p(tnc_),
					  standard_size(s_size), scroll_flag(false),
                                          black_colour(0, 0, 0), red_colour(204, 0, 0), blue_colour(0, 0, 204),
                                          green_colour(0, 153, 0), purple_colour(128, 0, 128) {
    int port;
    int stream;
    
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    if (!(node_ptr[stream][port] = new ReceiveWinNode(this, fontsize))) {
	        cerr << "Memory allocation error in ReceiveWin::ReceiveWin()" << endl;
		exit(MEM_ERROR);
	    }
	    addWidget(node_ptr[stream][port], (port * MAXUSERS) + stream);

	    // we now relay any mouse_right_clicked signals to slot mouse_popup() in class Mainscreen
	    QObject::connect(node_ptr[stream][port], SIGNAL(mouse_right_clicked()), this, SIGNAL(mouse_right_clicked()));
	    // and now cause any mouse release event to set the text selected items in menus
	    QObject::connect(node_ptr[stream][port], SIGNAL(mouse_released()), this, SLOT(set_textselected_items()));
	}
    }
    raiseWidget(0);

#ifdef KDE2_WARNING 
    char kde2_warning[] =
        "Note: KDE-2.0 has anti-social default key bindings.  By default it grabs\n"
        "the F12 key and uses it to place the keyboard in \"mouse\" mode (in mouse\n"
        "mode the screen cursor can be controlled by using the keyboard cursor keys).\n"
        "To release this mode, which blocks all other keyboard input, you must press\n"
        "F12 again.\n\n"

        "The result is that the F12 key cannot be used as intended by this program if\n"
        "you use KDE2 in its default set-up.  There are two solutions:\n\n"

        "  - use Shift-F12 to go up a stream on the current port, instead of F12, or\n"
        "  - change the KDE key binding for mouse mode.\n\n"

        "The README file explains how to change the KDE key bindings.\n\n";
  #if QT_VERSION >= 300
      node_ptr[0][0]->insert(kde2_warning);
  #else
      node_ptr[0][0]->insertAt(kde2_warning, END_OF_WINDOW, END_OF_WINDOW);
  #endif
#endif

    QApplication::clipboard();
}

ReceiveWin::~ReceiveWin(void) {
    int port;
    int stream;
  
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) delete node_ptr[stream][port];
    }
}

void ReceiveWin::write_store(void) {
    char buffer[SCROLL_STORE_SIZE + 1];
    const ScrollStoreNode* store_node_p = scroll_store.extract_store();

    while (store_node_p->colour != ScrollStoreNode::end_marker) {
        int current_colour;
	int buffer_index;

	for (buffer_index = 0, current_colour = store_node_p->colour;
	        store_node_p->colour == current_colour; store_node_p++) {
	    buffer[buffer_index++] = store_node_p->letter;
	}

	buffer[buffer_index] = 0; // null terminate C style string
        QColor* colour_p;
	switch(current_colour) {
	case ScrollStoreNode::red:
	    colour_p = &red_colour;
	    break;
	case ScrollStoreNode::blue:
	    colour_p = &blue_colour;
	    break;
	case ScrollStoreNode::green:
	    colour_p = &green_colour;
	    break;
	case ScrollStoreNode::purple:
	    colour_p = &purple_colour;
	    break;
	default:
	    colour_p = &black_colour;
	}
	ReceiveWinNode* node_p;
	if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
	else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
	node_p->setColor(*colour_p);
	node_p->selectAll(false);
	node_p->insert(buffer);
#else
	node_p->insertAt(buffer, END_OF_WINDOW, END_OF_WINDOW);
#endif
    }
}

void ReceiveWin::scrollup(void) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (node_p->contentsY() == 0) QApplication::beep();
    else node_p->setContentsPos(0, node_p->contentsY() - node_p->visibleHeight()/2);
#else
    if (node_p->rowIsVisible(0)) QApplication::beep();
    else node_p->setOffset(0, node_p->yOffset() - node_p->height()/2);
#endif
    scroll_flag = true;
    usleep(100000);
}

void ReceiveWin::scrolldown(void) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (node_p->contentsY() + node_p->visibleHeight() >= node_p->contentsHeight()) QApplication::beep();
    else node_p->setContentsPos(0, node_p->contentsY() + node_p->visibleHeight()/2);

    if (node_p->contentsY() + node_p->visibleHeight() >= node_p->contentsHeight()) {
        node_p->moveCursor(QTextEdit::MoveEnd, false);
	if (scroll_flag) {
	    int y_pos = node_p->contentsY();
	    node_p->setUpdatesEnabled(false);
	    write_store();
	    scroll_store.clear_store();
	    //node_p->setContentsPos(0, y_pos + node_p->visibleHeight()/2);
	    node_p->setUpdatesEnabled(true);
	    node_p->setContentsPos(0, y_pos + node_p->visibleHeight()/2);
	    node_p->repaint();
	    if (node_p->contentsY() + node_p->visibleHeight() >= node_p->contentsHeight()) {
	        scroll_flag = false;
		if (node_p->paragraphs() >  MAXLINES + DELETE_BLOCK) {
		    node_p->setUpdatesEnabled(false);
		    int count = node_p->paragraphs() - MAXLINES;
		    for (; count > 0; count--) node_p->removeParagraph(0);
		    node_p->setUpdatesEnabled(true);
		    node_p->repaint();
		}
	    }
	    usleep(100000);
	}
    }

#else
    if (node_p->rowIsVisible(node_p->numRows() - 1)) QApplication::beep();
    else node_p->setOffset(0, node_p->yOffset() + node_p->height()/2);

    if (node_p->rowIsVisible(node_p->numRows() - 1)) {
        node_p->setCursorPosition(END_OF_WINDOW, END_OF_WINDOW);
	if (scroll_flag) {
	    int y_pos = node_p->yOffset();
	    node_p->setAutoUpdate(false);
	    write_store();
	    scroll_store.clear_store();
	    node_p->setOffset(0, y_pos + node_p->height()/2);
	    node_p->setAutoUpdate(true);
	    node_p->repaint();
	    if (node_p->rowIsVisible(node_p->numRows() - 1)) {
	        scroll_flag = false;
		node_p->setOffset(0, node_p->totalHeight()); // the scrolldown sometimes leaves a small "gap" - remove it
		if (node_p->numLines() > MAXLINES + DELETE_BLOCK) {
		    node_p->setAutoUpdate(false);
		    int count = node_p->numLines() - MAXLINES;
		    for (; count > 0; count--) node_p->removeLine(0);
		    node_p->setAutoUpdate(true);
		    node_p->repaint();
		}
	    }
	    usleep(100000);
	}
    }
#endif
}

void ReceiveWin::scrollout(int silent) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (node_p->contentsY() + node_p->visibleHeight() >= node_p->contentsHeight()) {
        if (!silent) QApplication::beep();
    }
    else {
        node_p->moveCursor(QTextEdit::MoveEnd, false);
        node_p->setContentsPos(0, node_p->contentsHeight() - node_p->visibleHeight());
	scroll_flag = false;
	node_p->setUpdatesEnabled(false);
	write_store();
	scroll_store.clear_store();
	if (node_p->paragraphs() >  MAXLINES + DELETE_BLOCK) {
	  int count = node_p->paragraphs() - MAXLINES;
	  for (; count > 0; count--) node_p->removeParagraph(0);
	}
	node_p->setUpdatesEnabled(true);
	node_p->repaint();
        node_p->setContentsPos(0, node_p->contentsHeight() - node_p->visibleHeight());
	usleep(100000);
    }
#else
    if (node_p->rowIsVisible(node_p->numRows() - 1)) {
        if (!silent) QApplication::beep();
    }
    else {
        node_p->setCursorPosition(END_OF_WINDOW, END_OF_WINDOW);
	node_p->setOffset(0, node_p->totalHeight());
	scroll_flag = false;
	node_p->setAutoUpdate(false);
	write_store();
	scroll_store.clear_store();
	if (node_p->numLines() > MAXLINES + DELETE_BLOCK) {
	    int count = node_p->numLines() - MAXLINES;
	    for (; count > 0; count--) node_p->removeLine(0);
	}
	node_p->setAutoUpdate(true);
	node_p->repaint();
	node_p->setOffset(0, node_p->totalHeight());
	usleep(100000);
    }
#endif
}

void ReceiveWin::check_scroll_condition(void) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (scroll_flag && node_p->contentsY() + node_p->visibleHeight() >= node_p->contentsHeight()) {
        node_p->moveCursor(QTextEdit::MoveEnd, false);
	int y_pos = node_p->contentsY();
	node_p->setUpdatesEnabled(false);
	write_store();
	scroll_store.clear_store();
	node_p->setContentsPos(0, y_pos);
	node_p->setUpdatesEnabled(true);
	node_p->repaint();
	if (node_p->contentsY() + node_p->visibleHeight() >= node_p->contentsHeight()) {
	    scroll_flag = false;
	    if (node_p->paragraphs() >  MAXLINES + DELETE_BLOCK) {
		node_p->setUpdatesEnabled(false);
		int count = node_p->paragraphs() - MAXLINES;
		for (; count > 0; count--) node_p->removeParagraph(0);
		node_p->setUpdatesEnabled(true);
		node_p->repaint();
	    }
	}
	else usleep(100000); // leave a little time for the user to react to the new scrollbar position
    }
    else if (node_p->contentsY() + node_p->visibleHeight() < node_p->contentsHeight()) scroll_flag = true;
#else
    if (scroll_flag && node_p->rowIsVisible(node_p->numRows() - 1)) {
        node_p->setCursorPosition(END_OF_WINDOW, END_OF_WINDOW);
	int y_pos = node_p->yOffset();
	node_p->setAutoUpdate(false);
	write_store();
	scroll_store.clear_store();
	node_p->setOffset(0, y_pos);
	node_p->setAutoUpdate(true);
	node_p->repaint();
	if (node_p->rowIsVisible(node_p->numRows() - 1)) {
	    scroll_flag = false;
	    if (node_p->numLines() > MAXLINES + DELETE_BLOCK) {
	        node_p->setAutoUpdate(false);
		int count = node_p->numLines() - MAXLINES;
		for (; count > 0; count--) node_p->removeLine(0);
		node_p->setAutoUpdate(true);
		node_p->repaint();
	    }
	}
	else usleep(100000); // leave a little time for the user to react to the new scrollbar position
    }
    else if (!node_p->rowIsVisible(node_p->numRows() - 1)) scroll_flag = true;
#endif
}

void ReceiveWin::copy(void) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (node_p->hasSelectedText()) node_p->copy();
#else
    if (node_p->hasMarkedText()) node_p->copy();
#endif
}

void ReceiveWin::print_selection(void) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (node_p->hasSelectedText()) {
        QString text(node_p->selectedText().latin1()); // force a deep copy - gross but effective
#else
    if (node_p->hasMarkedText()) {
        QString text(node_p->markedText().latin1());   // force a deep copy - gross but effective
#endif
	PromptDialog* dialog_p = new PromptDialog("Print selected text?", "Print Text", standard_size, topLevelWidget());
	if (!dialog_p) {
	    cerr << "Memory allocation error in ReceiveWin::print_selection()" << endl;
	    exit(MEM_ERROR);
	}
	int result = dialog_p->exec();
	delete dialog_p;
	
	if (result == QDialog::Accepted) {
	    FILE* pipe_fp = popen(prog_func.print_cmd.c_str(), "w");
	    fwrite(text, sizeof(char), text.length(), pipe_fp);
	    fclose(pipe_fp);
	}
    }
}

void ReceiveWin::print_scroll_buffer(void) {
    QString text_string;
    if (tnc_p) text_string = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port]->text();
    else text_string = node_ptr[0][0]->text();
    if (!text_string.isEmpty()) {
        PromptDialog* dialog_p = new PromptDialog("Print the scroll buffer?", "Print Buffer", standard_size, topLevelWidget());
	if (!dialog_p) {
	    cerr << "Memory allocation error in ReceiveWin::print_scroll_buffer()" << endl;
	    exit(MEM_ERROR);
	}
	int result = dialog_p->exec();
	delete dialog_p;

	if (result == QDialog::Accepted) {
	    FILE* pipe_fp = popen(prog_func.print_cmd.c_str(), "w");
	    fwrite(text_string, sizeof(char), text_string.length(), pipe_fp);
	    fclose(pipe_fp);
	}
    }
}

void ReceiveWin::set_textselected_items(void) {
    if (tnc_p) {
#if QT_VERSION >= 300
        if (node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port]->hasSelectedText()) {
#else
        if (node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port]->hasMarkedText()) {
#endif
	    emit activate_textselected_items();
	}
	else emit disactivate_textselected_items();
    }
}

void ReceiveWin::save(void) {
    ReceiveWinNode* node_p;
    if (tnc_p) node_p = node_ptr[tnc_p->tnc_func.active_stream()][tnc_p->tnc_func.active_port];
    else node_p = node_ptr[0][0];
#if QT_VERSION >= 300
    if (node_p->hasSelectedText()) {
        QString text(node_p->selectedText().latin1()); // force a deep copy - gross but effective
#else
    if (node_p->hasMarkedText()) {
        QString text(node_p->markedText().latin1());   // force a deep copy - gross but effective
#endif

	bool file_flag = false;
	bool break_flag = false;
	QString filename;
	while (!break_flag) {
	    filename = QFileDialog::getSaveFileName(prog_func.filedir.c_str());
	    if (!filename.isNull()) {
	        if (!access(filename, F_OK)) { // file exists, check whether to overwrite
		    ostrstream strm;
		    strm << "File " << filename << " already exists\nOverwrite it?" << ends;
		    char* message = strm.str();
		    switch (QMessageBox::warning(this, "Save", message,
						 QMessageBox::Ok | QMessageBox::Default,
						 QMessageBox::Retry,
						 QMessageBox::Cancel | QMessageBox::Escape)) {
		    case QMessageBox::Ok: file_flag = break_flag = true; break;
		    case QMessageBox::Cancel: break_flag = true; break;
		    }
		    delete[] message;
		}
		else file_flag = break_flag = true;
	    }
	    else break_flag = true;
	}
	if (file_flag) {
	    ofstream file(filename, ios::out);
	    if (!file) {
	        ostrstream strm;
		strm << filename << " cannot be opened" << ends;
		char* message = strm.str();
		QMessageBox::warning(this, "Save", message,
				     QMessageBox::Ok | QMessageBox::Default, 0);
		delete[] message;
	    }
	    else {
	        file << static_cast<const char*>(text);
		file.close();
	    }
	}
    }
}

void ReceiveWin::write(const char* text, int stream, int port, const QColor* colour_p) {
    check_scroll_condition();

    ReceiveWinNode* node_p = node_ptr[stream][port];
    if (is_scrolling()
	&&  (!tnc_p
	     || (stream == tnc_p->tnc_func.active_stream()
		 && port == tnc_p->tnc_func.active_port))) {
        if ((size_t)scroll_store.is_free() >= strlen(text)) {
	    ScrollStoreNode letter_pair;
	    if (colour_p == &red_colour) letter_pair.colour = ScrollStoreNode::red;
	    else if (colour_p == &blue_colour) letter_pair.colour = ScrollStoreNode::blue;
	    else if (colour_p == &green_colour) letter_pair.colour = ScrollStoreNode::green;
	    else if (colour_p == &purple_colour) letter_pair.colour = ScrollStoreNode::purple;
	    else letter_pair.colour = ScrollStoreNode::black;
	    const char* char_p;
	    for (char_p = text; *char_p; char_p++) {
	      letter_pair.letter = *char_p;
	      scroll_store.add_letter(letter_pair);
	    }
	}
	else scrollout(false);
    }

    if (!is_scrolling()  // don't use 'else' here - we need to enter if scrollout() called above
	|| (tnc_p
	    && (stream != tnc_p->tnc_func.active_stream()
		|| port != tnc_p->tnc_func.active_port))) {
#if QT_VERSION >= 300
        node_p->selectAll(false);
	node_p->moveCursor(QTextEdit::MoveEnd, false);
	if (colour_p) node_p->setColor(*colour_p);
	else node_p->setColor(black_colour);
	node_p->insert(text);
	if (node_p->paragraphs() >  MAXLINES + DELETE_BLOCK) {
	    node_p->setUpdatesEnabled(false);
	    int count = node_p->paragraphs() - MAXLINES;
	    for (; count > 0; count--) node_p->removeParagraph(0);
	    node_p->setUpdatesEnabled(true);
	    node_p->repaint();
	}
#else
	colour_p = 0; // with Qt version 2.* we don't use colours
	node_p->insertAt(text, END_OF_WINDOW, END_OF_WINDOW);
	if (node_p->numLines() > MAXLINES + DELETE_BLOCK) {
	    node_p->setAutoUpdate(false);
	    int count = node_p->numLines() - MAXLINES;
	    for (; count > 0; count--) node_p->removeLine(0);
	    node_p->setAutoUpdate(true);
	    node_p->repaint();
	}
#endif
    }
}

void ReceiveWin::newline(int stream, int port) {

    check_scroll_condition();
    ReceiveWinNode* node_p = node_ptr[stream][port];
    if (is_scrolling()
	&&  (!tnc_p
	     || (stream == tnc_p->tnc_func.active_stream()
		 && port == tnc_p->tnc_func.active_port))) {
        if (scroll_store.is_free()) {
	    ScrollStoreNode letter_pair;
	    letter_pair.colour = scroll_store.last_colour();  // just take a guess at the colour - this is not important
	    letter_pair.letter = '\n';
	    scroll_store.add_letter(letter_pair);
	}
	else scrollout(false);
    }
    if (!is_scrolling()  // don't use 'else' here - we need to enter if scrollout() called above
	|| (tnc_p
	    && (stream != tnc_p->tnc_func.active_stream()
		|| port != tnc_p->tnc_func.active_port))) {
#if QT_VERSION >= 300
	node_p->moveCursor(QTextEdit::MoveEnd, false);
        if (node_p->paragraphs() >=  MAXLINES + DELETE_BLOCK) {
	    node_p->setUpdatesEnabled(false);
	    int count = node_p->paragraphs() - MAXLINES + 1;
	    for (; count > 0; count--) node_p->removeParagraph(0);
	    node_p->new_line();
	    node_p->setUpdatesEnabled(true);
	    node_p->repaint();
	}
        else node_p->new_line();
#else
	node_p->setCursorPosition(END_OF_WINDOW, END_OF_WINDOW);
	if (node_p->numLines() >= MAXLINES + DELETE_BLOCK) {
	    node_p->setAutoUpdate(false);
	    int count = node_p->numLines() - MAXLINES + 1;
	    for (; count > 0; count--) node_p->removeLine(0);
	    node_p->newLine();
	    node_p->setAutoUpdate(true);
	    node_p->repaint();
	}
	else node_p->newLine();
#endif
    }
}

void ReceiveWin::del_letter(int stream, int port) {
    ReceiveWinNode* node_p = node_ptr[stream][port];
    if (is_scrolling()
	&& !scroll_store.is_empty()
	&&  (!tnc_p
	     || (stream == tnc_p->tnc_func.active_stream()
		 && port == tnc_p->tnc_func.active_port))) {
        scroll_store.remove_letter();
    }
    else {
#if QT_VERSION >= 300
        if (node_p->hasSelectedText()) {
	    node_p->selectAll(false);
	    emit disactivate_textselected_items();
	}
	node_p->moveCursor(QTextEdit::MoveEnd, false);
#else
	if (node_p->hasMarkedText()) {
	    node_p->deselect();
	    emit disactivate_textselected_items();
	}
	node_p->setCursorPosition(END_OF_WINDOW, END_OF_WINDOW);
#endif
	node_p->backspace();
    }
}

void ReceiveWin::font_change(int size) {
    if (size == 10 || size == 12 || size == 14) {
	QFont font("Courier", size, QFont::Normal);
	int port;
	int stream;
	
	for (port = 0; port < 2; port++) {
	    for (stream = 0; stream < MAXUSERS; stream++) {
	        node_ptr[stream][port]->setFont(font);
	    }
	}
	if (tnc_p) scrollout(true);
    }
}

DisplayLine::DisplayLine(QWidget* a, int standard_size): QHBox(a) {
    
    QLabel* label_p;
    label_p = new QLabel(" Call: ", this);
    if (!label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    setStretchFactor(label_p, 0);
    hiscall_label_p = new QLabel(this);
    if (!hiscall_label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    hiscall_label_p->setMinimumSize((standard_size * 7)/2, standard_size);
    setStretchFactor(hiscall_label_p, 0);

    label_p = new QLabel("Hf Mode: ", this);
    if (!label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    setStretchFactor(label_p, 0);
    hfmode_label_p = new QLabel(this);
    if (!hfmode_label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    hfmode_label_p->setMinimumSize(standard_size * 2, standard_size);
    setStretchFactor(hfmode_label_p, 0);

    label_p = new QLabel("Capture: ", this);
    if (!label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    setStretchFactor(label_p, 0);
    capture_stream_label_p = new QLabel(this);
    if (!capture_stream_label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    capture_stream_label_p->setMinimumSize((standard_size * 3)/2, standard_size);
    setStretchFactor(capture_stream_label_p, 0);

    label_p = new QLabel("Hf Send: ", this);
    if (!label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    setStretchFactor(label_p, 0);
    hfsend_label_p = new QLabel(this);
    if (!hfsend_label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    hfsend_label_p->setMinimumSize(standard_size * 2, standard_size);
    setStretchFactor(hfsend_label_p, 0);

    QWidget* stretch_widget_p = new QWidget(this);
    if (!stretch_widget_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    setStretchFactor(stretch_widget_p, 1);

    label_p = new QLabel("Stream: ", this);
    if (!label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    setStretchFactor(label_p, 0);
    current_stream_label_p = new QLabel(this);
    if (!current_stream_label_p) {
        cerr << "Memory allocation error in DisplayLine::DisplayLine()" << endl;
	exit(MEM_ERROR);
    }
    current_stream_label_p->setMinimumSize((standard_size * 3)/2, standard_size);
    setStretchFactor(current_stream_label_p, 0);
    QPalette c_palette = current_stream_label_p->palette();
#if QT_VERSION >= 210
    QColorGroup c_group = c_palette.active();
    QColorGroup new_c_group(red, c_group.button(), c_group.light(), c_group.dark(),
			      c_group.mid(), red, red, c_group.base(), c_group.background());
    c_palette.setActive(new_c_group);
    c_palette.setInactive(new_c_group);
#else
    QColorGroup c_group = c_palette.normal();
    QColorGroup new_c_group(red, c_group.background(), c_group.light(), c_group.dark(),
			      c_group.mid(), red, c_group.base());
    c_palette.setNormal(new_c_group);
#endif
    current_stream_label_p->setPalette(c_palette);
}

void DisplayLine::write_call(const char* text) {
    QString temp(text);
    if (temp.length() > 13) {
        temp.truncate(12);
	temp += "..";
    }
    hiscall_label_p->setText(temp);
}

StatusLine::StatusLine(QWidget* widget_p, Tnc* tnc_p_, int standard_size, int min_size):
                         QStatusBar(widget_p), tnc_p(tnc_p_), torline_flag(false) {

    setFixedHeight(standard_size);
    int info_size;
    int tor_size;
    lock_label_p = new QLabel(this);
    if (!lock_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    lock_label_p->setFixedWidth((standard_size * 4)/3);
    lock_label_p->setAlignment(AlignCenter);
    tor_size = lock_label_p->width();

    tx_label_p = new QLabel(this);
    if (!tx_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    tx_label_p->setFixedWidth((standard_size * 4)/3);
    tx_label_p->setAlignment(AlignCenter);
    tor_size += tx_label_p->width();

    idle_label_p  = new QLabel(this);
    if (!idle_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    idle_label_p->setFixedWidth((standard_size * 4)/3);
    idle_label_p->setAlignment(AlignCenter);
    tor_size += idle_label_p->width();

    err_label_p = new QLabel(this);
    if (!err_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    err_label_p->setFixedWidth((standard_size * 4)/3);
    err_label_p->setAlignment(AlignCenter);
    tor_size += err_label_p->width();

    irs_label_p = new QLabel(this);
    if (!irs_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    irs_label_p->setFixedWidth((standard_size * 4)/3);
    irs_label_p->setAlignment(AlignCenter);
    tor_size += irs_label_p->width();

    speed_label_p = new QLabel(this);
    if (!speed_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    speed_label_p->setFixedWidth((standard_size * 4)/3);
    speed_label_p->setAlignment(AlignCenter);
    tor_size += speed_label_p->width();

    huff_label_p = new QLabel(this);
    if (!huff_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    huff_label_p->setFixedWidth((standard_size * 4)/3);
    huff_label_p->setAlignment(AlignCenter);
    tor_size += huff_label_p->width();

    connected_status_label_p = new QLabel(this);
    if (!connected_status_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    connected_status_label_p->setFixedWidth((standard_size * 7)/2);
    connected_status_label_p->setAlignment(AlignCenter);
    info_size = connected_status_label_p->width();

    freebytes_label_p = new QLabel(this);
    if (!freebytes_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    freebytes_label_p->setFixedWidth((standard_size * 4)/3);
    freebytes_label_p->setAlignment(AlignCenter);
    info_size += freebytes_label_p->width();

    with_tor_fleximinsize = min_size - (info_size + tor_size);
    if (with_tor_fleximinsize < 0) with_tor_fleximinsize = 0;
    no_tor_fleximinsize = min_size - info_size;
    if (no_tor_fleximinsize < 0) no_tor_fleximinsize = 0;

    flexi_label_p = new QLabel("F1 for help", this);
    if (!flexi_label_p) {
        cerr << "Memory allocation error in StatusLine::StatusLine()" << endl;
	exit(MEM_ERROR);
    }
    flexi_label_p->setAlignment(AlignCenter);

    addWidget(connected_status_label_p, 0);
    addWidget(freebytes_label_p, 0, true);
    addWidget(flexi_label_p, 10);

    lock_label_p->hide();
    tx_label_p->hide();
    idle_label_p->hide();
    err_label_p->hide();
    irs_label_p->hide();
    speed_label_p->hide();
    huff_label_p->hide();
    flexi_label_p->setMinimumWidth(no_tor_fleximinsize);
}

void StatusLine::make_torline(void) {
// check preconditions
    if (!tnc_p) return;

    if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
        if (!torline_flag) {
	    torline_flag = true;
	    flexi_label_p->setMinimumWidth(with_tor_fleximinsize);
	    removeWidget(flexi_label_p);
	    addWidget(lock_label_p, 0);
	    addWidget(tx_label_p, 0);
	    addWidget(idle_label_p, 0);
	    addWidget(err_label_p, 0);
	    addWidget(irs_label_p, 0);
	    addWidget(speed_label_p, 0);
	    addWidget(huff_label_p, 0);
	    addWidget(flexi_label_p, 10);
	    
	    lock_label_p->show();
	    tx_label_p->show();
	    idle_label_p->show();
	    err_label_p->show();
	    irs_label_p->show();
	    speed_label_p->show();
	    huff_label_p->show();
	}
	else {
	    write_lock_status("");
	    write_tx_status("");
	    write_idle_status("");
	    write_err_status("");
	    write_irs_status("");
	    write_speed_status("");
	    write_huff_status("");
	}
    }
    else if (torline_flag) {
        torline_flag = false;
        removeWidget(lock_label_p);
	removeWidget(tx_label_p);
	removeWidget(idle_label_p);
	removeWidget(err_label_p);
	removeWidget(irs_label_p);
	removeWidget(speed_label_p);
	removeWidget(huff_label_p);
	flexi_label_p->setMinimumWidth(no_tor_fleximinsize);
	
	lock_label_p->hide();
	tx_label_p->hide();
	idle_label_p->hide();
	err_label_p->hide();
	irs_label_p->hide();
	speed_label_p->hide();
	huff_label_p->hide();

	write_lock_status("");
	write_tx_status("");
	write_idle_status("");
	write_err_status("");
	write_irs_status("");
	write_speed_status("");
	write_huff_status("");
    }
}
