/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SETTINGS_HELP_H
#define SETTINGS_HELP_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>
#include <vector>

#include <qdialog.h>
#include <qwidget.h>

#include "prog_defs.h"

class SettingsMessagesBase {

protected:
  // so some people don't like protected data -- tough, this
  // is a convenient implementation
  std::vector<std::string> captions;
  std::vector<std::string> messages;
public:
  std::string get_caption(std::vector<std::string>::size_type);
  std::string get_message(std::vector<std::string>::size_type);
  SettingsMessagesBase(std::vector<std::string>::size_type size): captions(size), messages(size) {}
};

class IdentityMessages: public SettingsMessagesBase {
public:
  enum {mycall = 0, mypacketcall, myselcall};
  IdentityMessages(void);
};

class ComMessages: public SettingsMessagesBase {
public:
  enum {port = 0, speed};
  ComMessages(void);
};

class PacketMessages: public SettingsMessagesBase {
public:
  enum {vhf_packet_size = 0, hf_packet_size, keepalive_mins};
  PacketMessages(void);
};

class InterfaceMessages: public SettingsMessagesBase {
public:
  enum {receive_cw = 0, sound_bell, no_prompt};
  InterfaceMessages(void);
};

class CharsetMessages: public SettingsMessagesBase {
public:
  enum {message = 0};
  CharsetMessages(void);
};

class FontsizeMessages: public SettingsMessagesBase {
public:
  enum {message = 0};
  FontsizeMessages(void);
};

class MiscMessages: public SettingsMessagesBase {
public:
  enum {filedir = 0, print_cmd, autocq};
  MiscMessages(void);
};

class SettingsHelpDialog: public QDialog {

    Q_OBJECT

public:
  void run(void);
  SettingsHelpDialog(const int standard_size, const char* text, const char* caption, QWidget* qwidget_p = 0);
};

#endif



