/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <iostream>

#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>

#include "settings_help.h"

string SettingsMessagesBase::get_caption(std::vector<std::string>::size_type index) {
  if (index > captions.size()) {
    cerr << "Yikes, the message index is too large in SettingsMessagesBase::get_caption.\n"
            "Please report the bug to the author" << endl;
    return string(); // return empty string
  }
  else return captions[index];
}

string SettingsMessagesBase::get_message(std::vector<std::string>::size_type index) {
  if (index > messages.size()) {
    cerr << "Yikes, the message index is too large in SettingsMessagesBase::get_message.\n"
            "Please report the bug to the author" << endl;
    return string(); // return empty string
  }
  else return messages[index];
}

IdentityMessages::IdentityMessages(void): SettingsMessagesBase(myselcall + 1) {

  messages[mycall] = "Enter your callsign here";
  captions[mycall] = "kamplus help: Callsign";

  messages[mypacketcall] = "The packet callsign cannot contain any '/' characters.  If you have\n"
                           "a callsign for RTTY/CW/Amtor/Pactor/G-Tor which contains a '/'\n"
                           "character, and so must use a different Packet callsign, enter the\n"
                           "callsign to be used for packet here.  Otherwise leave it blank";
  captions[mypacketcall] = "kamplus help: Packet callsign";

  messages[myselcall] = "You don't normally need to specify your selcall, because the program\n"
                        "can work it out automatically, but if you want a non-standard one,\n"
                        "enter it here.  Otherwise leave it blank, and let the program sort it out";
  captions[myselcall] = "kamplus help: Selcall";
}

ComMessages::ComMessages(void): SettingsMessagesBase(speed + 1) {

  messages[port] = "This indicates the serial port device (eg. ttyS0) to which\n"
                   "the Kam is connected.  Do not include the `/dev/' part of\n"
                   "the device name -- ie state it as `ttyS1' or `cua2', etc.\n"
                   "With Linux, ttyS0 equates to COM 1, ttyS1 to COM 2, and so on";
  captions[port] = "kamplus help: Port device";

  messages[speed] = "Enter the baud rate of the serial connection between the Kam\n"
                    "and the computer here.  Unless you have good reason not to,\n"
                    "choose 9600 baud";
  captions[speed] = "kamplus help: Port speed";
}

PacketMessages::PacketMessages(void): SettingsMessagesBase(keepalive_mins + 1) {

  messages[vhf_packet_size] = "This sets the maximum length of packets sent from the Vhf port.\n"
                              "It can be set between 32 and 128 characters.  If none is specified,\n"
                              "the program defaults to 128";
  captions[vhf_packet_size] = "kamplus help: Vhf packet size";

  messages[hf_packet_size] = "This sets the maximum length of packets sent from the Hf port.\n"
                             "It can be set between 32 and 128 characters.  If none is specified,\n"
                             "the program defaults to 128";
  captions[hf_packet_size] = "kamplus help: Hf packet size";

  messages[keepalive_mins] = "This sets the interval between \"keep-alive\" packets (in minutes).\n"
                             "If none is specified, the program defaults to 10 minutes.\n"
                             "If you want to send keep-alive packets, check the checkbox.";
  captions[keepalive_mins] = "kamplus help: Keep-alive interval";
}

InterfaceMessages::InterfaceMessages(void): SettingsMessagesBase(no_prompt + 1) {

  messages[receive_cw] = "If you only want to transmit and not receive cw, and don't\n"
                         "want garbage cluttering the screen, check this box";
  captions[receive_cw] = "kamplus help: Display received CW";

  messages[sound_bell] = "If a received bell character (7) is to make a beep,\n"
                         "check this box";
  captions[sound_bell] = "kamplus help: Sound bell character";

  messages[no_prompt] = "If you do not want a prompt when sending a message via\n"
                        "Alt 0 to Alt 9, check this box (Note: this does not\n"
                        "affect the operation of F6)";
  captions[no_prompt] = "kamplus help: No message prompt";
}

CharsetMessages::CharsetMessages(void): SettingsMessagesBase(message + 1) {

  messages[message] = "This sets whether characters above value 127 are sent and\n"
                      "received using CP437 (the normal DOS/Windows character\n"
                      "set) or Latin-1 (the normal Unix character set).  The\n"
                      "character set used on the packet network is normally CP437";
  captions[message] = "kamplus help: Character set";
}

FontsizeMessages::FontsizeMessages(void): SettingsMessagesBase(message + 1) {

  messages[message] = "This will set the font size of text displayed in the\n"
                      "receive and send windows.  It does not change the\n"
                      "fontsize of the menu and status bars and dialogs.\n"
                      "That can be done by starting the program using the\n"
                      "-fontsize argument (see the README file for further details)";
  captions[message] = "kamplus help: Font size";
}

MiscMessages::MiscMessages(void): SettingsMessagesBase(autocq + 1) {

  messages[filedir] = "This is the directory where the program will write\n"
                      "capture.txt for text saved to file, and will look\n"
                      "for other files.";
  captions[filedir] = "kamplus help: File directory";

  messages[print_cmd] = "This is the command which prints from standard input.  If\n"
                        "none is specified, the program will default to lpr, which\n"
                        "will produce something on most systems (see 'man lpr').\n"
                        "If you want to force postscript printing and have GNU enscript\n"
                        "installed, use 'enscript -MA4 -B' for A4 size paper, and\n"
                        "'enscript -MLetter -B' for US letter size paper";
  captions[print_cmd] = "kamplus help: Print command";

  messages[autocq] = "Enter the number of seconds delay between the end\n"
                     "of one auto-cq call and the start of the next.  If\n"
                     "none is specified, the program will delay 90 seconds";
  captions[autocq] = "kamplus help: Autocq interval";
}

SettingsHelpDialog::SettingsHelpDialog(const int standard_size, const char* text,
				       const char* caption, QWidget* widget_p): QDialog(widget_p, caption, true) {


  QBoxLayout* top_layout_p = new QVBoxLayout(this, standard_size/2);

  QLabel* label_p = new QLabel(text, this);
  if (!label_p) {
    cerr << "Memory allocation error in SettingsHelpDialog::SettingsHelpDialog()" << endl;
    exit(MEM_ERROR);
  }
  label_p->setAlignment(AlignCenter);

  top_layout_p->addWidget(label_p);
  
  QPushButton* ok_button_p = new QPushButton("OK", this);
  if (!ok_button_p) {
    cerr << "Memory allocation error in PromptDialog::PromptDialog()" << endl;
    exit(MEM_ERROR);
  }

  QBoxLayout* button_layout_p = new QHBoxLayout(top_layout_p, standard_size);
  button_layout_p->addStretch(1);
  button_layout_p->addSpacing(standard_size/2);
  button_layout_p->addWidget(ok_button_p);
  button_layout_p->addSpacing(standard_size/2);
  button_layout_p->addStretch(1);
  
  ok_button_p->setDefault(true);
  ok_button_p->setFocus();

  QObject::connect(ok_button_p, SIGNAL(clicked()), this, SLOT(accept()));

  setCaption(caption);

  top_layout_p->activate();
  top_layout_p->freeze();
}
