/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

// pipes.cpp

#include <iostream>
#include <cstdlib>
#include <cstring>

#include "pipes.h"

Pipe_fifo::Pipe_fifo(fifo_mode mode) {
    int file_pipes[2];
    if (pipe(file_pipes) == -1) {
        cerr << "Cannot create pipe" << endl;
	exit(PIPE_ERROR);
    }
    else {
        read_fd = file_pipes[0];
	write_fd = file_pipes[1];
	if (mode == non_block) {
	    int fdflags = fcntl(read_fd, F_GETFL);
	    fdflags |= O_NONBLOCK;
	    fcntl(read_fd, F_SETFL, fdflags);
	}
    }
}

int Pipe_fifo::read(char* buffer, int max_number) {
    int result;
    if (!read_fd) result = -1;
    else if ((result = ::read(read_fd, buffer, max_number)) < 0) result = 0;  // call unix read() in file scope
    return result;
}      

int Pipe_fifo::read(void) {
    unsigned char item;
    if (read_fd && ::read(read_fd, &item, 1) > 0) return (int)item;   // call unix read() in file scope
    else return -1;
}

int Pipe_fifo::write(const char* buffer) {
    int length = strlen(buffer);
    if (length > PIPE_BUF || !write_fd) return -1;
    return write(buffer, length);
}

int Pipe_fifo::write(const char* buffer, int max_number) {
    int result;
    if (!write_fd) result = -1;
    else if ((result = ::write(write_fd, buffer, max_number)) < 0) result = 0;  // call unix write() in file scope
    return result;
}

void Pipe_fifo::make_writeonly(void) {
    if (read_fd) {
        close(read_fd);
	read_fd = 0;
    }
}

void Pipe_fifo::make_readonly(void) {
    if (write_fd) {
        close(write_fd);
	write_fd = 0;
    }
}
