/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef FILESEND_H
#define FILESEND_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <fstream>
#include <cstring>
#include <iomanip>
#include <strstream>
#include <ctime>
#include <csignal>
#include <cctype>
#include <cstdlib>
#include "prog_defs.h"
#include "buffers.h"
#include "dlist.h"
#include "tnc.h"

#include <qglobal.h>
#if QT_VERSION >= 300
#include "dialogs-qt3.h"
#include "widgets-qt3.h"
#else
#include "dialogs.h"
#include "widgets.h"
#endif

typedef unsigned char uchar;

#define SENDFILE_CHUNK 80

extern Prog_func prog_func;

extern "C" void cq_alarm_handler(int);

class FilesendBuffer: public FileBuffer {
    ifstream filein;
    enum {not_sending, loading_buffer, loading_complete} file_flag;
    Tnc* tnc_ptr;
    SendWin* sendwin_ptr;
    ReceiveWin* receivewin_ptr;
    UploadDialog* upload_dialog_p;
    bool convert_codes_flag;
    long bytes_sent;
    char sendwin_buffer[SENDFILE_CHUNK + 1];
public:
    bool open_file(const char*, bool);
    bool load_buffer(void);
    void show_bytes(void) {if (upload_dialog_p) upload_dialog_p->show_bytes(bytes_sent);}
    char front(Extract_mode);
    void end_loading(void) {file_flag = loading_complete; reset();}
    FilesendBuffer(Buffer_mode a, int b, int c, Tnc* d, SendWin* e, ReceiveWin* f, UploadDialog* g = 0):
                                     FileBuffer(a, b, c), file_flag(not_sending), tnc_ptr(d),
                                     sendwin_ptr(e), receivewin_ptr(f), upload_dialog_p(g),
                                     convert_codes_flag(FALSE), bytes_sent(0) {}
    ~FilesendBuffer(void) {delete upload_dialog_p;}
};

class CqsendBuffer: public FileBuffer {
    ifstream filein;
    enum {off, loading_cq_buffer, loading_cq_buffer_complete, waiting, close_down} autocq_flag;
    Tnc* tnc_ptr;
    MainScreen* mainscreen_ptr;
    SendWin* sendwin_ptr;
    ReceiveWin* receivewin_ptr;
    int rx_count;
    char sendwin_buffer[SENDFILE_CHUNK + 1];
public:
    bool load_buffer(void);
    void end_loading(void) {autocq_flag = close_down;}
    CqsendBuffer(Tnc* a, MainScreen* b, SendWin* c, ReceiveWin* d):
                         FileBuffer(FileBuffer::text, 0, 1), autocq_flag(off), tnc_ptr(a),
                                     mainscreen_ptr(b), sendwin_ptr(c), receivewin_ptr(d),
                                     rx_count(0) {}
    ~CqsendBuffer(void) {}
};

class BufferList: public DList<FileBuffer> {
public:
    enum Upload_status {keyboard, file};
private:
    Upload_status upload_status[MAXUSERS][2];
public:
    Upload_status get_upload_status(int stream, int port) const 
                                          {if (stream >= MAXUSERS || port > 1) return keyboard;
					   else return upload_status[stream][port];}
    void add(FileBuffer* file_b_p) {upload_status[file_b_p->get_stream()][file_b_p->get_port()] = file;
                                    DList<FileBuffer>::add(file_b_p);}
    const FileBuffer* extract(void) {const FileBuffer* file_b_p = DList<FileBuffer>::extract();
                                     upload_status[file_b_p->get_stream()][file_b_p->get_port()] = keyboard;
				     return file_b_p;}
    BufferList(void);
};

#endif
