/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include "buffers.h"


int Transmit_buffer::add_letter(char letter) {
  // this method will add a letter to the transmit buffer, for later sending to the Kam.
  // It also keeps track of the number of letters entered in the current line
  // If the buffer is full so the letter can't be added, it returns -1
  // Otherwise it returns the letter added
    if (Iqueue<char>::add_item(letter) == -1) return -1;
    if (letter == '\n') {
        line_lettercount = 0;
	foundCMDinbuffer = false;
    }
    else if (letter == 8 && line_lettercount) line_lettercount--; // we are to send a delete character
	                                                          // in pactor or gtor
    else if (letter == CMDinbuffer) {
        if (!foundCMDinbuffer) foundCMDinbuffer = true;
	else foundCMDinbuffer = false;
    }
    else if (!foundCMDinbuffer) line_lettercount++;
    return (uchar)letter;
}

int Transmit_buffer::extract_letter(void) {
  // this returns -1 if no letter is in the buffer to be extracted
  // otherwise it extracts and removes the letter at the front of the buffer
    if (Iqueue<char>::is_empty()) return -1;
    return (uchar)Iqueue<char>::front(remove);
}

int Transmit_buffer::view_letter(void) {
  // this returns -1 if no letter is in the buffer to be viewed (all have been extracted)
  // otherwise it returns the letter most recently added to the buffer but does not remove it
    if (Iqueue<char>::is_empty()) return -1;
    return (uchar)Iqueue<char>::back(view);
}

int Transmit_buffer::erase_letter(void) {
  // It returns 0 if we are at the beginning of a line so no letter can be erased, or if
  // all letters have been extracted from the buffer, but we are not using 
  // Pactor or Gtor so no delete can be sent to the station with which we are linked
  // (with Pactor or Gtor, can_transmit_delete_flag is true to indicate a delete can
  // be validly transmitted).
  
  // Otherwise, in Pactor and Gtor it returns -1 if the back letter in the buffer
  // can't be removed from the buffer because it has already been extracted and passed
  // to the Kam TNC, and there is something to be deleted on the current line.

  // If a letter has been erased from the buffer in the normal way, it is returned and
  // line_lettercount is decremented

    int temp;
    if (!line_lettercount) temp = 0;
    else if (Iqueue<char>::is_empty()) {
        if (!can_transmit_delete_flag) temp = 0;
	else temp = -1;
    }
    else {
        temp = (uchar)Iqueue<char>::back(remove);
	line_lettercount--;
    }
    return temp;
}

void Transmit_buffer::reset(void) {
    Iqueue<char>::reset();
    line_lettercount = 0;
}

