/* Copyright (C) 1999, 2000, 2001 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SENDWIN_H
#define SENDWIN_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <gtk--/table.h>
#include <gtk--/text.h>
#include <sigc++/object.h>
#include <sigc++/signal_system.h>

#include "prog_defs.h"


class MainScreen;

class SendWinText: public Gtk::Text {
protected:
  virtual gint button_press_event_impl(GdkEventButton*);
  virtual gint button_release_event_impl(GdkEventButton*);
public:
  SigC::Signal1<void, GdkEventButton*> mouse_right_clicked;
};

class SendWin: public Gtk::Table {
  SendWinText text;
  void del_block(void);
public:
  void scrollout(void);
  bool is_scrolling(void) const {return text.get_vadjustment()->get_value()
				   != text.get_vadjustment()->get_upper() - text.get_vadjustment()->get_page_size();}
  SendWin(int fontsize = Fontsize::medium);
  void write(const char*);
  void new_line(void) {write("\n"); scrollout();}
  void del_line(void);
  void backspace(void) {text.backward_delete(1);}
  void backspace(guint);
  void font_change(int);

  friend class MainScreen;
};

#endif
