/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

/*

The classes in this file provide the modeless dialogs which the
program uses.  These allow access to other program events and do not
appropriate the event loop.

These are all self-owning objects, which (via user input) control
their own destiny.  When closing they call `delete this'.  Such
modeless dialogs are one of the few cases where this is entirely safe.

These modeless dialogs must only be created on the heap.

*/

#ifndef MODELESS_DIALOGS_H
#define MODELESS_DIALOGS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <gtk--/window.h>
#include <gtk--/button.h>
#include <gtk--/label.h>
#include <gtk--/table.h>
#include <gtk--/box.h>
#include <gtk--/frame.h>
#include <gtk--/text.h>
#include <sigc++/object.h>
#include <sigc++/signal_system.h>

#include "prog_defs.h"

class Tnc;
class MainScreen;
class ReceiveWin;
class BufferList;

class DownloadDialog: public Gtk::Window {

  Gtk::Button end_button;
  Gtk::Label message_label;
  Gtk::Label bytes_intro_label;
  Gtk::Label bytes_label;
  Gtk::Table table;
  Gtk::HBox hbox;
  Gtk::Frame bytes_frame;
  Tnc* tnc_p;
  MainScreen* mainscreen_p;
  ReceiveWin* receivewin_p;
  int stream;
  int port;
protected:
  virtual gint delete_event_impl(GdkEventAny*) {return true;} // returning true prevents destroy sig being emitted
public:
  void end_download(void);
  void show_bytes(long); 
  DownloadDialog(const char*, Tnc*, MainScreen*, ReceiveWin*, int);
};

class UploadDialog: public Gtk::Window {

  Gtk::Button end_button;
  Gtk::Label message_label;
  Gtk::Label bytes_intro_label;
  Gtk::Label bytes_label;
  Gtk::Table table;
  Gtk::HBox hbox;
  Gtk::Frame bytes_frame;
  Tnc* tnc_p;
  BufferList& buffer_list;
  ReceiveWin* receivewin_p;
  int stream;
  int port;
protected:
  virtual gint delete_event_impl(GdkEventAny*) {return true;} // returning true prevents destroy sig being emitted
public:
  void end_upload(void);
  void show_bytes(long); 
  UploadDialog(const char*, long, Tnc*, BufferList&, ReceiveWin*, int);
};

class HelpDialog;

class HelpEditor: public Gtk::Text {
private:
  HelpEditor(void) {} // private class
                      // only HelpDialog can create an object
  friend class HelpDialog;
};

class HelpDialog: public Gtk::Window {
  HelpEditor editbox;
  Gtk::Button cancel_button;
  Gtk::Table table;
protected:
  virtual gint delete_event_impl(GdkEventAny*);
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  void kill_dialog(void);
  HelpDialog(int size);
};

class QsoCountDialog: public Gtk::Window {

  Gtk::Button dec_button;
  Gtk::Button inc_button;
  Gtk::Button quit_button;
  Gtk::Label count_intro_label;
  Gtk::Label count_label;
  Gtk::Table table;
  Gtk::HBox hbox;
  Gtk::Frame count_frame;
  void destroy_dialog(void);
protected:
  virtual gint delete_event_impl(GdkEventAny*) {return true;} // returning true prevents destroy sig being emitted
  virtual gint key_press_event_impl(GdkEventKey*);
public: 
  SigC::Signal0<void> inc;
  SigC::Signal0<void> dec;
  SigC::Signal0<void> quit_button_pressed;
  void show_qso_count(int);
  QsoCountDialog(int);
  ~QsoCountDialog(void);
};

#endif
