/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

/*

The class in this file is responsible for the main program window

It also controls the keyboard.

Dialog classes are generally found in the file dialogs.h/dialogs.cpp.

Except where the slots are local (for example, they relate to the
printing out or saving of selected text in the receive window), most
of the slot methods are found in file eventslots.h/eventslots.cpp.

*/

#ifndef MAINSCREEN_H
#define MAINSCREEN_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <gtk--/window.h>
#include <gtk--/menu.h>
#include <gtk--/menubar.h>
#include <gtk--/toolbar.h>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/togglebutton.h>
#include <gtk--/table.h>

#include "prog_defs.h"
#include "sendwin.h"
#include "info_bars.h"

class EventSlots;
class ReceiveWin;
class Tnc;
class Tnc_base;
class Pipe_fifo;
class Transmit_buffer;
class BufferList;


class MainScreen: public Gtk::Window {
public:
  enum HfStreamStatus {packet, tor};

private:
  bool letters_to_send_flag;
  bool flush_chars;
  int count;
  unsigned char info_byte;
  unsigned char tx_byte;
  int buffer_count;
  int beep_count;
  int interval_count;

  Gtk::Menu menu_popup;
  Gtk::MenuBar menu_bar;
  Gtk::Toolbar left_tool_bar;
  Gtk::Toolbar right_tool_bar;
  Gtk::HBox tool_bar;
  DisplayLine* display_line_p;
  StatusLine* status_line_p;
  SendWin sendwin;
  ReceiveWin* receivewin_p;
  EventSlots* event_slots_p;

  Gtk::MenuItem* upload_item_p;
  Gtk::MenuItem* download_item_p;
  Gtk::MenuItem* upload_7plus_item_p;
  Gtk::MenuItem* upload_binary_item_p;
  Gtk::MenuItem* menu_copy_item_p;
  Gtk::MenuItem* menu_print_selection_item_p;
  Gtk::MenuItem* menu_save_selection_item_p;
  Gtk::MenuItem* mouse_copy_item_p;
  Gtk::MenuItem* mouse_print_selection_item_p;
  Gtk::MenuItem* mouse_save_selection_item_p;
  Gtk::MenuItem* menu_set_print_mark_item_p;
  Gtk::MenuItem* menu_print_from_mark_item_p;
  Gtk::MenuItem* mouse_set_print_mark_item_p;
  Gtk::MenuItem* mouse_print_from_mark_item_p;
  Gtk::MenuItem* menu_qso_count_item_p;
  Gtk::MenuItem* mouse_qso_count_item_p;

  HfStreamStatus hf_stream_status;
  Gtk::Menu* hf_menu_p;
  Gtk::Menu* mouse_hf_menu_p;

  Gtk::Button* connect_button_p;
  Gtk::Button* disconnect_button_p;
  Gtk::ToggleButton* call_lock_button_p;
  Gtk::ToggleButton* capture_button_p;
  Gtk::ToggleButton* auto_cq_button_p;
  Gtk::ToggleButton* speed_lock_button_p;
  Gtk::Button* ident_button_p;
  Gtk::Button* sync_button_p;
  Gtk::Button* abort_button_p;
  Gtk::Button* rx_button_p;
  Gtk::Button* tx_button_p;
  Gtk::Button* change_speed_button_p;
  Gtk::ToggleButton* dx_cluster_button_p;

  bool setting_call_lock_button_flag;
  bool setting_capture_button_flag;
  bool setting_auto_cq_button_flag;
  bool setting_speed_lock_button_flag;
  bool setting_dx_cluster_button_flag;

  Tnc* tnc_p;
  Tnc_base* tnc_base_p;
  Pipe_fifo& receive_pipe;
  Transmit_buffer& tr_buffer;
  BufferList& buffer_list;

  enum {rx, tx} tx_status;
  void destroy_slot(void);
protected:
  virtual gint delete_event_impl(GdkEventAny*) {return false;} // returning false causes destroy sig to be emitted
  virtual gint key_press_event_impl(GdkEventKey*);
public:
  // these are used as slot methods
  void process_receive_pipe(gint, GdkInputCondition);
  gint timer_event_handler(void);
  void mouse_popup(GdkEventButton* event_p) {menu_popup.popup(event_p->button, event_p->time);}  
  void activate_textselected_items(void);
  void disactivate_textselected_items(void);

  // the following method is to enable objects of other classes and other functions
  // to use the public methods of ReceiveWin whilst only holding a MainScreen pointer
  //(in particular, to enable writing to the window)
  ReceiveWin* get_receivewin(void) const {return receivewin_p;}
  void show_packetmenu_streams(void);
  void show_tormenu_streams(void);

  bool setting_call_lock_button(void) const {return setting_call_lock_button_flag;}
  bool setting_capture_button(void) const {return setting_capture_button_flag;}
  bool setting_auto_cq_button(void) const {return setting_auto_cq_button_flag;}
  bool setting_speed_lock_button(void) const {return setting_speed_lock_button_flag;}
  bool setting_dx_cluster_button(void) const {return setting_dx_cluster_button_flag;}

  void display_capture_status(void);
  void display_current_stream(void);
  void display_connected_status(void);
  void display_mode(void);
  void display_send_mode_status(void);
  void display_callsign(void);
  void display_freebytes(void);

  void set_connect_button(void);
  void set_disconnect_button(void);
  void set_capture_button(void);
  void set_call_lock_button(void);
  void set_auto_cq_button(void);
  void set_speed_lock_button(void);
  void set_ident_button(void);
  void set_sync_button(void);
  void set_abort_button(void);
  void set_rx_button(void);
  void set_tx_button(void);
  void set_change_speed_button(void);
  void set_dx_cluster_button(void);

  void make_torline(void) {status_line_p->make_torline();}
  void update_file_load_items(void);
  void update_print_mark_items(void);
  void update_qso_counter_items(void);
  void update_lockinfo(void);
  void update_torinfo(unsigned char info = 255); // if info = 255, the tor info line will be updated from info_byte
  void update_txinfo(unsigned char tx = 255); // if tx = 255, the tx indication will be updated from tx_byte
  void beep(int count) {beep_count = count;}

  MainScreen(Tnc*, Tnc_base*, Pipe_fifo&, Transmit_buffer&, BufferList&,
	     int global_fontsize = 0, int win_fontsize = Fontsize::medium);
  ~MainScreen(void);
};

#endif
