/* Copyright (C) 1999, 2000, 2001 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <string>
#include <gtk--/style.h>

#include "info_bars.h"
#include "tnc.h"

DisplayLine::DisplayLine(int a):
               Gtk::HBox(false, 0), standard_size(a), red("red"),
               hiscall_base("  Call: "), hfmode_base("Hf Mode: "),
               capture_stream_base("Capture: "), hfsend_base("Hf Send: "),
               current_stream_base("Stream:"), hiscall_box(false, 0),
               hfmode_box(false, 0), capture_stream_box(false, 0) {

  hiscall_base.set_usize(0, standard_size);
  hiscall_label.set_usize(0, standard_size);
  hiscall_box.pack_start(hiscall_base, false, false, 0);
  hiscall_box.pack_start(hiscall_label, false, false, 0);

  int horiz_placement = 0;
  left_part.put(hiscall_box, horiz_placement, 0);
  horiz_placement += standard_size * 5;

  hfmode_base.set_usize(0, standard_size);
  hfmode_label.set_usize(0, standard_size);
  hfmode_box.pack_start(hfmode_base, false, false, 0);
  hfmode_box.pack_start(hfmode_label, false, false, 0);

  left_part.put(hfmode_box, horiz_placement, 0);
  horiz_placement += (standard_size * 7)/2;

  capture_stream_base.set_usize(0, standard_size);
  capture_stream_label.set_usize(0, standard_size);
  capture_stream_box.pack_start(capture_stream_base, false, false, 0);
  capture_stream_box.pack_start(capture_stream_label, false, false, 0);

  left_part.put(capture_stream_box, horiz_placement, 0);
  horiz_placement += (standard_size * 7)/2;

  hfsend_base.set_usize(0, standard_size);
  hfsend_label.set_usize(0, standard_size);
  hfsend_box.pack_start(hfsend_base, false, false, 0);
  hfsend_box.pack_start(hfsend_label, false, false, 0);

  left_part.put(hfsend_box, horiz_placement, 0);

  pack_start(left_part, false, false, 0);
  current_stream_base.set_usize(0, standard_size);
  current_stream_label.set_usize((standard_size * 3)/2, standard_size);

  // make the stream label display in red
  // Note: we need to take a copy of the existing style, as the existing
  // style is shared by all the program's widgets.  If we operate
  // directly on the Gtk::Style object returned (by pointer) by
  // Gtk::Widget::get_style(), say with Gtk::Style::set_fg() or
  // Gtk::Style::set_font(), we will alter it for everything!
  Gtk::Style* new_style_p = current_stream_label.get_style()->copy();
  new_style_p->set_fg(GTK_STATE_NORMAL, red);
  current_stream_label.set_style(*new_style_p);

  pack_end(current_stream_label, false, false, 0);
  pack_end(current_stream_base, false, false, 0);
}

void DisplayLine::write_call(const char* text) {
  string temp(text);
  if (temp.size() > 13) {
    temp.resize(12);
    temp += "..";
  }
  hiscall_label.set_text(temp);
}

StatusLine::StatusLine(Tnc* tnc_p_, int standard_size):
                         Gtk::HBox(false, 0), tnc_p(tnc_p_),
			 flexi_label("Press F1 for help"), torline_flag(false) {

  set_border_width(2);
  connected_status_label.set_usize(standard_size * 3, standard_size - 5);
  connected_status_frame.set_shadow_type(GTK_SHADOW_IN);
  connected_status_frame.add(connected_status_label);
  pack_start(connected_status_frame, false, false, 0);
  
  freebytes_label.set_usize((standard_size * 4)/3, standard_size - 5);
  freebytes_frame.set_shadow_type(GTK_SHADOW_IN);
  freebytes_frame.add(freebytes_label);
  pack_end(freebytes_frame, false, false, 0);

  flexi_label.set_usize(0, standard_size - 5);
  flexi_frame.set_shadow_type(GTK_SHADOW_IN);
  flexi_frame.add(flexi_label);
  pack_end(flexi_frame, true, true, 0);

  lock_label.set_usize((standard_size * 4)/3, standard_size - 5);
  lock_frame.set_shadow_type(GTK_SHADOW_IN);
  lock_frame.add(lock_label);

  tx_label.set_usize((standard_size * 4)/3, standard_size - 5);
  tx_frame.set_shadow_type(GTK_SHADOW_IN);
  tx_frame.add(tx_label);

  idle_label.set_usize((standard_size * 4)/3, standard_size - 5);
  idle_frame.set_shadow_type(GTK_SHADOW_IN);
  idle_frame.add(idle_label);

  err_label.set_usize((standard_size * 4)/3, standard_size - 5);
  err_frame.set_shadow_type(GTK_SHADOW_IN);
  err_frame.add(err_label);

  irs_label.set_usize((standard_size * 4)/3, standard_size - 5);
  irs_frame.set_shadow_type(GTK_SHADOW_IN);
  irs_frame.add(irs_label);

  speed_label.set_usize((standard_size * 4)/3, standard_size - 5);
  speed_frame.set_shadow_type(GTK_SHADOW_IN);
  speed_frame.add(speed_label);

  huff_label.set_usize((standard_size * 4)/3, standard_size - 5);
  huff_frame.set_shadow_type(GTK_SHADOW_IN);
  huff_frame.add(huff_label);
}

void StatusLine::make_torline(void) {
// check preconditions
  if (!tnc_p) return;

  if (tnc_p->tnc_func.active_port && tnc_p->tnc_func.hfmode != Tnc_func::packet) {
    if (!torline_flag) {
      torline_flag = true;

      pack_start(lock_frame, false, false, 0);
      pack_start(tx_frame, false, false, 0);
      pack_start(idle_frame, false, false, 0);
      pack_start(err_frame, false, false, 0);
      pack_start(irs_frame, false, false, 0);
      pack_start(speed_frame, false, false, 0);
      pack_start(huff_frame, false, false, 0);

      lock_frame.show_all();
      tx_frame.show_all();
      idle_frame.show_all();
      err_frame.show_all();
      irs_frame.show_all();
      speed_frame.show_all();
      huff_frame.show_all();
    }
    else {
      write_lock_status("");
      write_tx_status("");
      write_idle_status("");
      write_err_status("");
      write_irs_status("");
      write_speed_status("");
      write_huff_status("");
    }
  }
  else if (torline_flag) {
    torline_flag = false;
    remove(lock_frame);
    remove(tx_frame);
    remove(idle_frame);
    remove(err_frame);
    remove(irs_frame);
    remove(speed_frame);
    remove(huff_frame);

    lock_frame.hide_all();
    tx_frame.hide_all();
    idle_frame.hide_all();
    err_frame.hide_all();
    irs_frame.hide_all();
    speed_frame.hide_all();
    huff_frame.hide_all();

    write_lock_status("");
    write_tx_status("");
    write_idle_status("");
    write_err_status("");
    write_irs_status("");
    write_speed_status("");
    write_huff_status("");
  }
}
