/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef BUFFERS_H
#define BUFFERS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <fstream>
#include "prog_defs.h"
#include "iqueue.cpp"  // include entire template definition, to generate Iqueue<char> object

typedef unsigned char uchar;

class Transmit_buffer: private Iqueue<char> {
    int line_lettercount;  // used to indicate whether we are at the beginning of a line
    bool can_transmit_delete_flag;
    bool foundCMDinbuffer;
public:
    void set_can_transmit_delete(int setting) {can_transmit_delete_flag = setting;}
    int add_letter(char);
    int extract_letter(void);
    int view_letter(void);
    int erase_letter(void);
    int letters_free(void) const {return Iqueue<char>::is_free();}
    bool is_empty(void) const {return Iqueue<char>::is_empty();}
    int letters_used(void) const {return Iqueue<char>::is_used();}
    void reset(void);
    Transmit_buffer(void): Iqueue<char>(TR_BUFFER_SIZE, 0), line_lettercount(0),
        can_transmit_delete_flag(false), foundCMDinbuffer(false) {}
};

///////////////////////////////////////////////////////////////////////////////////////

class FileBuffer: public Iqueue<char> {
public:
    enum Buffer_mode{text, binary, s_plus};
private:
    Buffer_mode buffer_mode;
    int stream;
    int port;
public:
    Buffer_mode get_buffer_mode(void) const {return buffer_mode;}
    int get_stream(void) const {return stream;}
    int get_port(void) const {return port;}
    virtual void end_loading(void) = 0;
    virtual bool load_buffer(void) = 0;
    virtual void show_bytes(void) {}
    virtual char front(Extract_mode mode) {return Iqueue<char>::front(mode);}
    FileBuffer(Buffer_mode a, int b, int c): Iqueue<char>(FILE_BUFFER_SIZE, 0),
                 buffer_mode(a), stream(b), port(c) {}
    virtual ~FileBuffer(void){}
};


#endif
