/* Copyright (C) 2001 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <iostream>
#include <gtk--/main.h>

#include "settings_help.h"

string SettingsMessagesBase::get_caption(std::vector<std::string>::size_type index) {
  if (index > captions.size()) {
    cerr << "Yikes, the message index is too large in SettingsMessagesBase::get_caption.\n"
            "Please report the bug to the author" << endl;
    return string(); // return empty string
  }
  else return captions[index];
}

string SettingsMessagesBase::get_message(std::vector<std::string>::size_type index) {
  if (index > messages.size()) {
    cerr << "Yikes, the message index is too large in SettingsMessagesBase::get_message.\n"
            "Please report the bug to the author" << endl;
    return string(); // return empty string
  }
  else return messages[index];
}

IdentityMessages::IdentityMessages(void): SettingsMessagesBase(myselcall + 1) {

  messages[mycall] = "Enter your callsign here";
  captions[mycall] = "kamplus help: Callsign";

  messages[mypacketcall] = "The packet callsign cannot contain any '/' characters.  If you have "
                           "a callsign for RTTY/CW/Amtor/Pactor/G-Tor which contains a '/' "
                           "character, and so must use a different Packet callsign, enter the "
                           "callsign to be used for packet here.  Otherwise leave it blank";
  captions[mypacketcall] = "kamplus help: Packet callsign";

  messages[myselcall] = "You don't normally need to specify your selcall, because the program can work "
                        "it out automatically, but if you want a non-standard one, enter it here.  "
                        "Otherwise leave it blank, and let the program sort it out";
  captions[myselcall] = "kamplus help: Selcall";
}

ComMessages::ComMessages(void): SettingsMessagesBase(speed + 1) {

  messages[port] = "This indicates the serial port device (eg. ttyS0) to which the Kam is connected.  "
                   "Do not include the `/dev/' part of the device name -- ie state it as `ttyS1' or "
                   "`cua2', etc.  With Linux, ttyS0 equates to COM 1, ttyS1 to COM 2, and so on";
  captions[port] = "kamplus help: Port device";

  messages[speed] = "Enter the baud rate of the serial connection between the Kam and "
                    "the computer here.  Unless you have good reason not to, choose 9600 baud";
  captions[speed] = "kamplus help: Port speed";
}

PacketMessages::PacketMessages(void): SettingsMessagesBase(keepalive_mins + 1) {

  messages[vhf_packet_size] = "This sets the maximum length of packets sent from the Vhf port.  It can "
                              "be set between 32 and 128 characters.  If none is specified, the program "
                              "defaults to 128";
  captions[vhf_packet_size] = "kamplus help: Vhf packet size";

  messages[hf_packet_size] = "This sets the maximum length of packets sent from the Hf port.  It can "
                             "be set between 32 and 128 characters.  If none is specified, the program "
                             "defaults to 128";
  captions[hf_packet_size] = "kamplus help: Hf packet size";

  messages[keepalive_mins] = "This sets the interval between \"keep-alive\" packets (in minutes).  "
                             "If none is specified, the program defaults to 10 minutes.  "
                             "If you want to send keep-alive packets, check the checkbox.";
  captions[keepalive_mins] = "kamplus help: Keep-alive interval";
}

InterfaceMessages::InterfaceMessages(void): SettingsMessagesBase(no_prompt + 1) {

  messages[receive_cw] = "If you only want to transmit and not receive cw, and don't want "
                         "garbage cluttering the screen, check this box";
  captions[receive_cw] = "kamplus help: Display received CW";

  messages[sound_bell] = "If a received bell character (7) is to make a beep, check this box";
  captions[sound_bell] = "kamplus help: Sound bell character";

  messages[no_prompt] = "If you do not want a prompt when sending a message via Alt 0 to Alt 9, check this box "
                        "(Note: this does not affect the operation of F6)";
  captions[no_prompt] = "kamplus help: No message prompt";
}

CharsetMessages::CharsetMessages(void): SettingsMessagesBase(message + 1) {

  messages[message] = "This sets whether characters above value 127 are sent and received using CP437 "
                      "(the normal DOS/Windows character set) or Latin-1 (the normal Unix character set).  "
                      "The character set used on the packet network is normally CP437";
  captions[message] = "kamplus help: Character set";
}

FontsizeMessages::FontsizeMessages(void): SettingsMessagesBase(message + 1) {

  messages[message] = "This will set the font size of text displayed in the receive and send windows.  "
                      "It does not change the fontsize of the menu and status bars and dialogs.  That can "
                      "be done by starting the program using the -fontsize argument (see the README file "
                      "for further details)";
  captions[message] = "kamplus help: Font size";
}

MiscMessages::MiscMessages(void): SettingsMessagesBase(autocq + 1) {

  messages[filedir] = "This is the directory where the program will write capture.txt for text saved "
                      "to file, and will look for other files.";
  captions[filedir] = "kamplus help: File directory";

  messages[print_cmd] = "This is the command which prints from standard input.  If none is specified, "
                        "the program will default to lpr, which will produce something on most systems "
                        "(see 'man lpr').  If you want to force postscript printing and have GNU enscript "
                        "installed, use 'enscript -MA4 -B' for A4 size paper, and 'enscript -MLetter -B' "
                        "for US letter size paper";
  captions[print_cmd] = "kamplus help: Print command";

  messages[autocq] = "Enter the number of seconds delay between the end of one auto-cq call and the "
                     "start of the next - if none is specified, the program will delay 90 seconds";
  captions[autocq] = "kamplus help: Autocq interval";
}

SettingsHelpDialog::SettingsHelpDialog(const int standard_size, const string& text,
				       const string& caption, Gtk::Window& window):
                                            Gtk::Window(GTK_WINDOW_DIALOG), in_run_loop(false),
					    ok_button("OK"), label(text),
			                    table(2, 1, false), parent(window) {


  label.set_line_wrap(true);
  table.attach(label, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND,
	 GTK_FILL | GTK_EXPAND, standard_size/2, standard_size/4);

  table.attach(ok_button, 0, 1, 1, 2, GTK_EXPAND,
	 GTK_EXPAND, standard_size/2, standard_size/4);

  ok_button.clicked.connect(SigC::slot(this, &SettingsHelpDialog::kill_dialog));

  add(table);

  set_title(caption);
  set_transient_for(parent);
  parent.set_sensitive(false);
  set_modal(true);

  ok_button.set_usize((standard_size * 5)/2, (standard_size * 4)/5);
  set_border_width(standard_size/3);

  set_position(GTK_WIN_POS_CENTER);
  set_policy(false, false, false);

  show_all();
}

void SettingsHelpDialog::run(void) {
  in_run_loop = true;
  Gtk::Main::run();
}

void SettingsHelpDialog::kill_dialog(void) {
  parent.set_sensitive(true);
  hide_all();
  if (in_run_loop) Gtk::Main::quit();
  // if we have not called run(), then this dialog is self-owning and it is safe to call `delete this'
  else delete this;
}

gint SettingsHelpDialog::delete_event_impl(GdkEventAny*) {
  kill_dialog();
  return true; // returning true prevents destroy sig being emitted
}
