/* Copyright (C) 2001, 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SETTINGS_H
#define SETTINGS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <unistd.h>

#include <string>

#include <gtk--/window.h>
#include <gtk--/label.h>
#include <gtk--/table.h>
#include <gtk--/button.h>
#include <gtk--/notebook.h>
#include <gtk--/entry.h>
#include <gtk--/checkbutton.h>
#include <gtk--/box.h>
#include <gtk--/tooltips.h>
#include <gtk--/radiobutton.h>
#include <gtk--/frame.h>

#include "settings_help.h"
#include "prog_defs.h"

class IdentityTable: public Gtk::Table {
  IdentityMessages help_messages;
  Gtk::Label mycall_label;
  Gtk::Label mypacketcall_label;
  Gtk::Label myselcall_label;
  Gtk::Entry mycall_entry;
  Gtk::Entry mypacketcall_entry;
  Gtk::Entry myselcall_entry;
  Gtk::Button mycall_help_button;
  Gtk::Button mypacketcall_help_button;
  Gtk::Button myselcall_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_mycall(void) const {return mycall_entry.get_text();}
  std::string get_mypacketcall(void) const {return mypacketcall_entry.get_text();}
  std::string get_myselcall(void) const {return myselcall_entry.get_text();}
  void set_mycall(const std::string& mycall) {mycall_entry.set_text(mycall);}
  void set_mypacketcall(const std::string& mypacketcall) {mypacketcall_entry.set_text(mypacketcall);}
  void set_myselcall(const std::string& myselcall) {myselcall_entry.set_text(myselcall);}
  void clear(void);
  IdentityTable(const int);
};

class ComTable: public Gtk::Table {
  ComMessages help_messages;
  Gtk::Label port_label;
  Gtk::Entry port_entry;
  Gtk::Label device_message;
  Gtk::RadioButton b1200_button;
  Gtk::RadioButton b2400_button;
  Gtk::RadioButton b4800_button;
  Gtk::RadioButton b9600_button;
  Gtk::Table speed_table;
  Gtk::Frame speed_frame;
  Gtk::Button port_help_button;
  Gtk::Button speed_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_port(void) const {return port_entry.get_text();}
  std::string get_speed(void) const;
  void set_port(const std::string& port) {port_entry.set_text(port);}
  void set_speed(const int);
  void clear(void);
  ComTable(const int);
};

class PacketTable: public Gtk::Table {
  PacketMessages help_messages;
  Gtk::Label vhf_packet_size_label;
  Gtk::Label hf_packet_size_label;
  Gtk::Label keepalive_mins_label;
  Gtk::Entry vhf_packet_size_entry;
  Gtk::Entry hf_packet_size_entry;
  Gtk::Entry keepalive_mins_entry;
  Gtk::Button vhf_packet_size_help_button;
  Gtk::Button hf_packet_size_help_button;
  Gtk::Button keepalive_mins_help_button;
  Gtk::CheckButton check_button;
  Gtk::HBox check_box;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Label filler3;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_vhf_packet_size(void) const {return vhf_packet_size_entry.get_text();}
  std::string get_hf_packet_size(void) const {return hf_packet_size_entry.get_text();}
  std::string get_keepalive_mins(void) const {return keepalive_mins_entry.get_text();}
  bool get_keepalive(void) {return check_button.get_active();}
  void set_vhf_packet_size(const std::string& vhf_packet_size) {vhf_packet_size_entry.set_text(vhf_packet_size);}
  void set_hf_packet_size(const std::string& hf_packet_size) {hf_packet_size_entry.set_text(hf_packet_size);}
  void set_keepalive_mins(const std::string& keepalive_mins) {keepalive_mins_entry.set_text(keepalive_mins);}
  void set_keepalive(bool active) {check_button.set_active(active);}
  void clear(void);
  PacketTable(const int);
};

class InterfaceTable: public Gtk::Table {
  InterfaceMessages help_messages;
  Gtk::CheckButton receive_cw_button;
  Gtk::CheckButton sound_bell_button;
  Gtk::CheckButton no_prompt_button;
  Gtk::Label receive_cw_label;
  Gtk::Label sound_bell_label;
  Gtk::Label no_prompt_label;
  Gtk::HBox receive_cw_box;
  Gtk::HBox sound_bell_box;
  Gtk::HBox no_prompt_box;
  Gtk::Button receive_cw_help_button;
  Gtk::Button sound_bell_help_button;
  Gtk::Button no_prompt_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  bool get_receive_cw(void) {return receive_cw_button.get_active();}
  bool get_sound_bell(void) {return sound_bell_button.get_active();}
  bool get_no_prompt(void) {return no_prompt_button.get_active();}
  void set_receive_cw(bool active) {receive_cw_button.set_active(active);}
  void set_sound_bell(bool active) {sound_bell_button.set_active(active);}
  void set_no_prompt(bool active) {no_prompt_button.set_active(active);}
  void clear(void);
  InterfaceTable(const int);
};

class CharsetTable: public Gtk::Table {
  CharsetMessages help_messages;
  Gtk::RadioButton cp437_button;
  Gtk::RadioButton latin_1_button;
  Gtk::Label cp437_label;
  Gtk::Label latin_1_label;
  Gtk::HBox cp437_box;
  Gtk::HBox latin_1_box;
  Gtk::VBox charset_box;
  Gtk::Frame frame;
  Gtk::Button help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_charset(void) const;
  void set_charset(const int charset);
  void clear(void);
  CharsetTable(const int);
};

class FontsizeTable: public Gtk::Table {
  FontsizeMessages help_messages;
  Gtk::RadioButton small_button;
  Gtk::RadioButton medium_button;
  Gtk::RadioButton large_button;
  Gtk::RadioButton larger_button;
  Gtk::Label small_label;
  Gtk::Label medium_label;
  Gtk::Label large_label;
  Gtk::Label larger_label;
  Gtk::HBox small_box;
  Gtk::HBox medium_box;
  Gtk::HBox large_box;
  Gtk::HBox larger_box;
  Gtk::VBox fontsize_box;
  Gtk::Frame frame;
  Gtk::Button help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_fontsize(void) const;
  void set_fontsize(const int fontsize);
  void clear(void);
  FontsizeTable(const int);
};

class MiscTable: public  Gtk::Table {
  MiscMessages help_messages;
  Gtk::Label filedir_label;
  Gtk::Label print_cmd_label;
  Gtk::Label autocq_label;
  Gtk::Entry filedir_entry;
  Gtk::Entry print_cmd_entry;
  Gtk::Entry autocq_entry;
  Gtk::Button filedir_help_button;
  Gtk::Button print_cmd_help_button;
  Gtk::Button autocq_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_filedir(void) const {return filedir_entry.get_text();}
  std::string get_print_cmd(void) const {return print_cmd_entry.get_text();}
  std::string get_autocq(void) const {return autocq_entry.get_text();}
  void set_filedir(const std::string& filedir) {filedir_entry.set_text(filedir);}
  void set_print_cmd(const std::string& print_cmd) {print_cmd_entry.set_text(print_cmd);}
  void set_autocq(const std::string& autocq) {autocq_entry.set_text(autocq);}
  void clear(void);
  MiscTable(const int);
};

class SettingsDialog: public Gtk::Window {

  struct {
    std::string port, speed;
  } old_settings;

  const int standard_size;
  bool in_run_loop;
  bool is_home_config;
  std::string rcfile;

  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::Table window_table;
  Gtk::Notebook notebook;
  Gtk::Window& parent;

  IdentityTable identity_table;
  ComTable com_table;
  PacketTable packet_table;
  InterfaceTable interface_table;
  CharsetTable charset_table;
  FontsizeTable fontsize_table;
  MiscTable misc_table;

  void selected(bool);
  void read_config(bool search_localfile = true);
  bool write_config(void);
  bool get_prog_parm(const char*, std::string&, std::string&);
  bool find_prog_parm(const char*, const std::string&);
  bool get_rcfile_path(bool search_localfile = true);
  void get_reset_settings_prompt(void);
  void get_reset_settings(void);
  void show_help(const std::string& message, const std::string& caption);
  void strip(std::string&);
protected:
  virtual gint delete_event_impl(GdkEventAny*);
public:
  // this signal can be used to indicate that the OK button have been pressed
  // and ~/.efax-gtkrc has been rewritten
  SigC::Signal0<void> accepted;
  void run(void);
  SettingsDialog(const int standard_size, Gtk::Window& window);
};

// the run() method must be called on this dialog so that the result can be obtained
// (the result is in the return value of run())
class InitSettingsDialog: public Gtk::Window {
public:
  enum Result {rejected, accepted};
private:
  Result result;

  Gtk::Label message_label;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::Table window_table;

  void selected(bool);
  virtual bool write_config(void) = 0;
protected:
  const int standard_size;
  virtual gint delete_event_impl(GdkEventAny*);
  void attach_settings_widget(Gtk::Widget&);
  bool find_prog_parm(const char*, const std::string&);
  void strip(std::string&);
  std::string get_rcfile_path(void);
  void show_help(const std::string& message, const std::string& caption);
public:
  Result run(void);
  InitSettingsDialog(const int standard_size, const int fontsize = 0);
  virtual ~InitSettingsDialog(void) {}
};

// the run() method must be called on this dialog so that the result can be obtained
// (the result is in the return value of run())
class IdentitySettingsDialog: public InitSettingsDialog {
  IdentityTable identity_table;
  bool write_config(void);
public:
  IdentitySettingsDialog(const int standard_size, const int fontsize = 0);
};

// the run() method must be called on this dialog so that the result can be obtained
// (the result is in the return value of run())
class ComSettingsDialog: public InitSettingsDialog {
  ComTable com_table;
  bool write_config(void);
public:
  ComSettingsDialog(const int standard_size, const int speed, const std::string& port, const int fontsize = 0);
};

class FiledirTable: public  Gtk::Table {
  MiscMessages help_messages;
  Gtk::Label filedir_label;
  Gtk::Entry filedir_entry;
  Gtk::Button filedir_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const std::string&, const std::string&> show_help_sig;
  std::string get_filedir(void) const {return filedir_entry.get_text();}
  void set_filedir(const std::string& filedir) {filedir_entry.set_text(filedir);}
  void clear(void) {filedir_entry.set_text("");}
  FiledirTable(const int);
};

// the run() method must be called on this dialog so that the result can be obtained
// (the result is in the return value of run())
class FiledirSettingsDialog: public InitSettingsDialog {
  FiledirTable filedir_table;
  bool write_config(void);
public:
  FiledirSettingsDialog(const int standard_size, const int fontsize = 0);
};

#endif
