/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

/*

class Receivewin contains the window widgets for each stream.

Dialog classes are generally found in the file dialogs.h/dialogs.cpp.

Except where the slots are local (for example, they relate to the
printing out or saving of selected text in the receive window), most
of the slot methods are found in file eventslots.h/eventslots.cpp.

*/

#ifndef RECEIVEWIN_H
#define RECEIVEWIN_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <string>
#include <gtk--/table.h>
#include <gtk--/text.h>
#include <gtk--/paned.h>
#include <gtk--/widget.h>
#include <gtk--/window.h>
#include <sigc++/object.h>
#include <sigc++/signal_system.h>

#include "prog_defs.h"
#include "tnc.h"

class ReceiveWinText: public Gtk::Text {

protected:
  virtual gint button_press_event_impl(GdkEventButton*);
  virtual gint button_release_event_impl(GdkEventButton*);
public:
  SigC::Signal1<void, GdkEventButton*> mouse_right_clicked;
  SigC::Signal0<void, void> mouse_released;
};

class ReceiveWinNode: public Gtk::Table {
  ReceiveWinText text;
  bool is_frozen_flag;
public:
  void freeze(void);
  void thaw(void);
  void scrollup(void);
  void scrolldown(void);
  void scrollout(bool silent);
  bool is_frozen(void) const {return is_frozen_flag;}
  bool is_scrolling(void) const {return text.get_vadjustment()->get_value()
			  != text.get_vadjustment()->get_upper() - text.get_vadjustment()->get_page_size();}
  void del_block(void);
  ReceiveWinNode(int fontsize);

  friend class ReceiveWin;
};

class ReceiveWin: public SigC::Object {
  Gtk::VPaned& parent;
  Tnc* tnc_p;
  ReceiveWinNode* node_ptr[MAXUSERS][2];  // have a pointer for each stream/port;
  ReceiveWinNode* current_p;
  int standard_size;
  Gtk::Window& top_level_window;
  Gtk::Text_Helpers::Context red_context;
  Gtk::Text_Helpers::Context blue_context;
  Gtk::Text_Helpers::Context green_context;
  Gtk::Text_Helpers::Context purple_context;
public:
  SigC::Signal1<void, GdkEventButton*> mouse_right_clicked;
  SigC::Signal0<void, void> activate_textselected_items;
  SigC::Signal0<void, void> disactivate_textselected_items;
  operator Gtk::Widget&(void) const {return *current_p;}
  void raise(int stream, int port);
  void scrollup(void) {current_p->scrollup();}
  void scrolldown(void) {current_p->scrolldown();}
  void scrollout(bool silent = false) {current_p->scrollout(silent);}
  void check_scroll_condition(void) {if (current_p->is_frozen() && !current_p->is_scrolling()) current_p->thaw();}

  // here are some methods to be called via slots
  void copy(void);
  void print_selection_prompt(void);
  void print_scroll_buffer_prompt(void);
  void print_text(string);
  void set_textselected_items(void);
  void save_prompt(void);
  void save(string, string);

  void write(const char* text) {write(text, tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);}
  void write_red(const char* text) {write_red(text, tnc_p->tnc_func.active_stream(),
					      tnc_p->tnc_func.active_port);}
  void write_blue(const char* text) {write_blue(text, tnc_p->tnc_func.active_stream(),
						tnc_p->tnc_func.active_port);}
  void write_green(const char* text) {write_green(text, tnc_p->tnc_func.active_stream(),
						  tnc_p->tnc_func.active_port);}
  void write_purple(const char* text) {write_purple(text, tnc_p->tnc_func.active_stream(),
						    tnc_p->tnc_func.active_port);}
  void write(const char* text, int stream, int port, Gtk::Text_Helpers::Context* context_p = 0);
  void write_red(const char* text, int stream, int port) {write(text, stream, port, &red_context);}
  void write_blue(const char* text, int stream, int port) {write(text, stream, port, &blue_context);}
  void write_green(const char* text, int stream, int port) {write(text, stream, port, &green_context);}
  void write_purple(const char* text, int stream, int port) {write(text, stream, port, &purple_context);}

  void newline(void) {newline(tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);}
  void newline(int stream, int port) {write("\n", stream, port);}
  void del_letter(void) {del_letter(tnc_p->tnc_func.active_stream(), tnc_p->tnc_func.active_port);}
  void del_letter(int stream, int port);
  void font_change(int);

  ReceiveWin(Gtk::VPaned&, Tnc*, int, Gtk::Window&, int fontsize = Fontsize::medium);
  ~ReceiveWin(void);
};

#endif
