/* Copyright (C) 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef CHAR_FUNCS_H
#define CHAR_FUNCS_H

/*
 We need these because unfortunately int std::toupper(int) and int
std::isalpha(int) can no longer be used to instantiate the generic
algorithms, because of the templatised facet versions of these.  In
addition, we cannot just do a static_cast when we call the generic
algorithms to resolve the template, because where char is signed, the
conversion from signed char to int will give rise to undefined
behaviour, so we need to cast to unsigned char first.  (Even then, the
cast of the return value of int std::toupper(int) from int to char
will give rise to implementation defined, though not undefined,
behaviour.  In practice, it is fine in the context in which we use
it).

Using char toupper(char, const std::locale&) and bool isalpha(char,
const std::locale&) would be the best answer, but not all compilers
likely to be used support C++ locales at this stage (gcc-2.95 does
not).
*/

#include <cctype>

using std::toupper;
using std::isalpha;

inline char to_upper(char ch) {
  return toupper(static_cast<unsigned char> (ch));
}

inline int is_alpha(char ch) {
  return isalpha(static_cast<unsigned char> (ch));
}

#endif
