/* Copyright (C) 1999, 2000, 2001 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <gtk--/scrollbar.h>
#include <gtk--/adjustment.h>
#include <gdk--/font.h>

#include "sendwin.h"

#define MAX_CHARS 20000
#define DEL_BLOCK_SIZE 500

SendWin::SendWin(int fontsize): Gtk::Table(1, 2, false)
{
  attach(text, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND,
	 GTK_FILL | GTK_EXPAND | GTK_SHRINK, 0, 0);
  
  // put a VScrollbar in the upper right
  Gtk::Scrollbar* scrollbar_p = manage(new Gtk::VScrollbar(*(text.get_vadjustment())));
  attach(*scrollbar_p, 1, 2, 0, 1, GTK_FILL, GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);

  text.set_editable(true); // we don't really want to edit the window, but this will
                            // show the cursor
  text.set_usize(MIN_WIDTH, MIN_HEIGHT/3);
  text.unset_flags(GTK_CAN_FOCUS);

  if (!font_list[fontsize].empty()) text.set_context(Gdk_Font(font_list[fontsize]));
  else if (!font_list[Fontsize::medium].empty()) text.set_context(Gdk_Font(font_list[Fontsize::medium]));

  text.set_word_wrap(true);
  text.set_line_wrap(true);
}

void SendWin::write(const char* message) {
  // we get a smoother display if we don't freeze() before inserting text
  //text.set_point(text.get_length());
  text.insert(message);
  //scrollout();
  // and now delete some text at the beginning if the text stored is getting too big
  while (text.get_length() > MAX_CHARS + DEL_BLOCK_SIZE) del_block();
}

void SendWin::del_block(void) {
  text.set_editable(true);
  text.freeze();

  text.set_point(0);
  text.forward_delete(DEL_BLOCK_SIZE);

  text.thaw();
  scrollout();
  text.set_point(text.get_length());
  text.set_editable(false);
}

void SendWin::scrollout(void) {
  Gtk::Adjustment* adj_p = text.get_vadjustment();
  if (adj_p->get_value() != adj_p->get_upper() - adj_p->get_page_size()) {
    adj_p->set_value(adj_p->get_upper());
  }
}

void SendWin::backspace(guint count) {
  text.freeze();
  //text.set_point(text.get_length());
  text.backward_delete(count);
  text.thaw();
}

void SendWin::font_change(int size) {
  if (size >= 0 && size <= Fontsize::giant
      && !font_list[size].empty()) {
    text.set_context(Gdk_Font(font_list[size]));
  }
  else beep();
}

gint SendWinText::button_press_event_impl(GdkEventButton* event_p) {

  if (event_p->button == 3) mouse_right_clicked(event_p);
  return true;
}

gint SendWinText::button_release_event_impl(GdkEventButton*) {
  return true;
}
