/* Copyright (C) 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef READCLUSTER_H
#define READCLUSTER_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <cstring>
#include "dlist.cpp"  // contains template definitions
#include "prog_defs.h"

class Dx_spot_list;

class Dx_spot_node {
    int key;
    char* spot_text;
    bool operator==(const Dx_spot_node& node) const
                     {if (key == node.key && !strcmp(spot_text, node.spot_text)) return true;
		     return false;}
    Dx_spot_node(const char*); // private class - only Dx_spot_list objects can create them
public:
    friend class Dx_spot_list;
    ~Dx_spot_node(void) {delete[] spot_text;}
};

// Dx_spot_mode::key holds a simple key to provide a faster look-up
// when interating through the list of dx spots kept in
// Dx_spot_list::dx_node_list.  It is obtained by summing every third
// character of Dx_spot_mode::spot_text) as a simple first sift for
// Dx_spot_list::compare() - the algorithm to generate the key is
// primitive but perfectly adequate for this purpose




class Dx_spot_list {
    int count;
    DList<Dx_spot_node> dx_node_list;
public:
    // a new copy of each string passed to Dx_spot_list::add() is made
    // on the heap by the constructor of Dx_spot_node, so there are no
    // restrictions on the life/scope of any string to be added to the
    // list

    // if the dx spot string passed to Dx_spot_list::add() is unique,
    // it will be added to dx_node_list and Dx_spot_list::add() will
    // return 0.  If it is not unique, it will not be added to the list
    // and Dx_spot_list::add() will return -1
    int add(const char* dx_spot_p);
    void clear_list(void);
    Dx_spot_list(void): count(0) {}
    ~Dx_spot_list(void) {clear_list();}
};

#endif
