/* Copyright (C) 1999, 2000, 2001 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

/*

The classes in this file are responsible for the information display
bar and status bar.

*/

#ifndef INFO_BARS_H
#define INFO_BARS_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <gtk--/box.h>
#include <gtk--/fixed.h>
#include <gtk--/label.h>
#include <gtk--/frame.h>
#include <gdk--/color.h>

#include "prog_defs.h"

class Tnc;

class DisplayLine: public Gtk::HBox {
  int standard_size;
  const Gdk_Color red;
  
  Gtk::Label hiscall_base;
  Gtk::Label hfmode_base;
  Gtk::Label capture_stream_base;
  Gtk::Label hfsend_base;
  Gtk::Label current_stream_base;
  
  Gtk::Label hiscall_label;
  Gtk::Label hfmode_label;
  Gtk::Label capture_stream_label;
  Gtk::Label hfsend_label;
  Gtk::Label current_stream_label;
  
  Gtk::HBox hiscall_box;
  Gtk::HBox hfmode_box;
  Gtk::HBox capture_stream_box;
  Gtk::HBox hfsend_box;
  
  Gtk::Fixed left_part;
  
public:
  void write_call(const char* text);
  void write_hfmode(const char* text) {hfmode_label.set_text(text);}
  void write_capture(const char* text) {capture_stream_label.set_text(text);}
  void write_hfsend(const char* text) {hfsend_label.set_text(text);}
  void write_stream(const char* text) {current_stream_label.set_text(text);}
  DisplayLine(int);
};

class StatusLine: public Gtk::HBox {
  Tnc* tnc_p;

  Gtk::Label connected_status_label;
  Gtk::Label lock_label;
  Gtk::Label tx_label;
  Gtk::Label idle_label;
  Gtk::Label err_label;
  Gtk::Label irs_label;
  Gtk::Label speed_label;
  Gtk::Label huff_label;
  Gtk::Label freebytes_label;
  Gtk::Label flexi_label;
  
  Gtk::Frame connected_status_frame;
  Gtk::Frame lock_frame;
  Gtk::Frame tx_frame;
  Gtk::Frame idle_frame;
  Gtk::Frame err_frame;
  Gtk::Frame irs_frame;
  Gtk::Frame speed_frame;
  Gtk::Frame huff_frame;
  Gtk::Frame freebytes_frame;
  Gtk::Frame flexi_frame;
  
  int torline_flag;
public:
  void write_connected_status(const char* text) {connected_status_label.set_text(text);}
  void write_lock_status(const char* text) {lock_label.set_text(text);}
  void write_tx_status(const char* text) {tx_label.set_text(text);}
  void write_idle_status(const char* text) {idle_label.set_text(text);}
  void write_err_status(const char* text) {err_label.set_text(text);}
  void write_irs_status(const char* text) {irs_label.set_text(text);}
  void write_speed_status(const char* text) {speed_label.set_text(text);}
  void write_huff_status(const char* text) {huff_label.set_text(text);}
  void write_freebytes(const char* text) {freebytes_label.set_text(text);}
  void make_torline(void);
  StatusLine(Tnc*, int);
};


#endif
