/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef FILESEND_H
#define FILESEND_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <iostream>
#include <fstream>
#include <cstring>
#include <iomanip>
#include <strstream>
#include <ctime>
#include <csignal>
#include <cctype>
#include <cstdlib>
#include "prog_defs.h"
#include "buffers.h"
#include "dlist.h"
#include "modeless_dialogs.h"

typedef unsigned char uchar;

#define SENDFILE_CHUNK 80

class Tnc;
class MainScreen;
class SendWin;
class ReceiveWin;

extern "C" void cq_alarm_handler(int);

class FilesendBuffer: public FileBuffer {
  ifstream filein;
  enum {not_sending, loading_buffer, loading_complete} file_flag;
  Tnc* tnc_ptr;
  MainScreen* mainscreen_ptr;
  SendWin* sendwin_ptr;
  ReceiveWin* receivewin_ptr;
  int standard_size;
  UploadDialog* upload_dialog_p;
  bool convert_codes_flag;
  long bytes_sent;
  char sendwin_buffer[SENDFILE_CHUNK + 1];
public:
  bool open_file(const char*, bool);
  bool load_buffer(void);
  void show_bytes(void) {if (upload_dialog_p) upload_dialog_p->show_bytes(bytes_sent);}
  char front(Extract_mode);
  void end_loading(void) {file_flag = loading_complete; reset();}
  FilesendBuffer(Buffer_mode a, int b, int c, Tnc* d, MainScreen* e, SendWin* f,
		 ReceiveWin* g, int h, UploadDialog* i = 0):
                  FileBuffer(a, b, c), file_flag(not_sending), tnc_ptr(d),
                  mainscreen_ptr(e), sendwin_ptr(f), receivewin_ptr(g), standard_size(h),
                  upload_dialog_p(i), convert_codes_flag(false), bytes_sent(0) {}
  ~FilesendBuffer(void) {delete upload_dialog_p;}
};

class CqsendBuffer: public FileBuffer {
  ifstream filein;
  enum {off, loading_cq_buffer, loading_cq_buffer_complete, waiting, close_down} autocq_flag;
  Tnc* tnc_ptr;
  MainScreen* mainscreen_ptr;
  SendWin* sendwin_ptr;
  ReceiveWin* receivewin_ptr;
  int standard_size;
  int rx_count;
  char sendwin_buffer[SENDFILE_CHUNK + 1];
public:
  bool load_buffer(void);
  void end_loading(void) {autocq_flag = close_down;}
  CqsendBuffer(Tnc* a, MainScreen* b, SendWin* c, ReceiveWin* d, int e):
                       FileBuffer(FileBuffer::text, 0, 1), autocq_flag(off), tnc_ptr(a),
                       mainscreen_ptr(b), sendwin_ptr(c), receivewin_ptr(d),
                       standard_size(e), rx_count(0) {}
  ~CqsendBuffer(void) {}
};

class BufferList: public DList<FileBuffer> {
public:
  enum Upload_status {keyboard, file};
private:
  Upload_status upload_status[MAXUSERS][2];
public:
  Upload_status get_upload_status(int stream, int port) const 
                                        {if (stream >= MAXUSERS || port > 1) return keyboard;
					 else return upload_status[stream][port];}
  void add(FileBuffer* file_b_p) {upload_status[file_b_p->get_stream()][file_b_p->get_port()] = file;
                                  DList<FileBuffer>::add(file_b_p);}
  const FileBuffer* extract(void) {const FileBuffer* file_b_p = DList<FileBuffer>::extract();
                                   upload_status[file_b_p->get_stream()][file_b_p->get_port()] = keyboard;
				   return file_b_p;}
  BufferList(void);
};

#endif
