// endhost.cpp

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <string>
#include "com.h"
#include "prog_defs.h"

void configure_endhost(int&, string&);
bool get_prog_parm(const char*, string&, string&);

int main(void) {

    string port;
    int speed;

    configure_endhost(speed, port);
    Com com_obj(speed, port.c_str());

    unsigned char message[4] = {192, 'Q', 192, 0};
    sleep(1);
    com_obj.send(message);
    sleep(1);
    return 0;
}

void configure_endhost(int& speed, string& port) {
    char* home = getenv("HOME");
    ifstream filein;
    bool found_rcfile = false;
    string rcfile;
    if (home) {
        rcfile = home;
	rcfile += "/." RC_FILE;

#ifdef HAVE_IOS_NOCREATE
	filein.open(rcfile.c_str(), ios::in | ios::nocreate);
#else
	// we must have Std C++ so we probably don't need a ios::nocreate
	// flag on a read open to ensure uniqueness
	filein.open(rcfile.c_str(), ios::in);
#endif
	if (filein) found_rcfile = true;
	else filein.clear();
    }

    if (!found_rcfile) {

        rcfile = "/usr/local/etc/" RC_FILE;

#ifdef HAVE_IOS_NOCREATE
	filein.open(rcfile.c_str(), ios::in | ios::nocreate);
#else
	// we must have Std C++ so we probably don't need a ios::nocreate
	// flag on a read open to ensure uniqueness
	filein.open(rcfile.c_str(), ios::in);
#endif
	if (filein) found_rcfile = true;
	else filein.clear();
    }

    if (!found_rcfile) {

        rcfile = "/etc/" RC_FILE;

#ifdef HAVE_IOS_NOCREATE
	filein.open(rcfile.c_str(), ios::in | ios::nocreate);
#else
	// we must have Std C++ so we probably don't need a ios::nocreate
	// flag on a read open to ensure uniqueness
	filein.open(rcfile.c_str(), ios::in);
#endif

	if (filein) found_rcfile = true;
	else filein.clear();
    }

    if (!found_rcfile) {
        cerr << "Can't find or open file /etc/" RC_FILE << endl;
	cerr << "/usr/local/etc" RC_FILE " or file $HOME/." RC_FILE << endl;
        exit(FILEOPEN_ERROR);
    }

// now extract settings from file

    string file_read;
    string temp;
    bool speed_found_flag = false;

    while (getline(filein, file_read)) {

        if (!file_read.empty() && file_read[0] != '#') { // valid line to check
	    // now check for other comment markers
	    string::size_type pos = file_read.find_first_of('#');
	    if (pos != string::npos) file_read.resize(pos); // truncate
	
	    // look for "SERIALPORT:"
	    if (get_prog_parm("SERIALPORT:", file_read, port));

	    // look for "SPEED:"
	    else if (get_prog_parm("SPEED:", file_read, temp)) {
	        speed = atoi(temp.c_str());
		if (speed == 1200 || speed == 2400 || speed == 4800 || speed == 9600) {
		    speed_found_flag = true;
		}
	    }
	}
    }
    if (port.empty()) {
        cerr << "Serial port device (eg. ttyS0) must be specified in kamrc" << endl;
	cerr << "Include a 'SERIALPORT: xxxx' statement in that file, where xxxx\n"
	        "is the serial port used with the TNC" << endl;
	exit(3);
    }
    if (!speed_found_flag) {
        cerr << "No valid serial port speed specified in kamrc,\n"
	        "defaulting to 9600 baud" << endl;
	speed = 9600;
    }
    filein.close();
}

bool get_prog_parm(const char* name, string& line, string& result) {
// this function looks for a setting named `name' in the string `line'
// and returns the values stated after it in string `result'
// it returns `true' if the setting was found 
// if there are trailing spaces or tabs, string `line' will be modified
// string `result' is only modified if the `name' setting is found

  const string::size_type length = strlen(name);
  // we have to use std::string::substr() because libstdc++-2
  // doesn't support the Std-C++ std::string::compare() functions
  if (!line.substr(0, length).compare(name)) {
    // erase any trailing space or tab
    while (line.find_last_of(" \t") == line.size() - 1) line.resize(line.size() - 1);
    if (line.size() > length) {
      // ignore any preceding space or tab from the setting value given
      string::size_type pos = line.find_first_not_of(" \t", length); // pos now is set to beginning of setting value
      if (pos != string::npos) result.assign(line, pos, line.size() - pos);
    }
    return true;
  }
  return false;
}

#ifndef HAVE_ATTACH
#include "misc/fdstream.cpp" // we need to compile this with this file
#endif
