/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef DOWNLOAD_H
#define DOWNLOAD_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <fstream>
#include "modeless_dialogs.h"
#include "dlist.h"
#include "prog_defs.h"

#ifdef HAVE_ATTACH
typedef ofstream outfstream;
#else
#include "misc/fdstream.h"
typedef fdostream outfstream;
#endif

class DownloadFile {
public:
  enum Download_mode {binary, s_plus};
private:
  outfstream fileout;
  Download_mode download_mode;
  int stream;
  int port;
  DownloadDialog* download_dialog_p;
  long bytes_received;
  void dialog_take_ownership(void) {download_dialog_p = 0;} // if you call this, you are now responsible for
                                                     // deleting the object download_dialog_p was pointing to
                                                     // only friends can do that as this is a private method
public:
  friend void DownloadDialog::end_download(void);
  Download_mode get_download_mode(void) const {return download_mode;}
  int get_stream(void) const {return stream;}
  int get_port(void) const {return port;}
  bool open_file(const char*);
  void add_char(char letter) {fileout.put(letter); bytes_received++;}
  void show_bytes(void) {download_dialog_p->show_bytes(bytes_received);}
  DownloadFile(Download_mode a, int b, int c, DownloadDialog* d):
    download_mode(a), stream(b), port(c), download_dialog_p(d), bytes_received(0) {}
  ~DownloadFile(void) {fileout.close(); delete download_dialog_p;}
};

class DownloadList: public DList<DownloadFile> {
public:
  enum Download_status {off, on};
private:
  Download_status download_status[MAXUSERS][2];
public:
  Download_status get_download_status(int stream, int port) const 
                                         {if (stream >= MAXUSERS || port > 1) return off;
					  else return download_status[stream][port];}
  void add(DownloadFile* dload_f_p) {download_status[dload_f_p->get_stream()][dload_f_p->get_port()] = on;
                                     DList<DownloadFile>::add(dload_f_p);}
  const DownloadFile* extract(void) {const DownloadFile* dload_f_p = DList<DownloadFile>::extract();
                                     download_status[dload_f_p->get_stream()][dload_f_p->get_port()] = off;
				     return dload_f_p;}
  DownloadList(void);
};

class PrintFile {
  outfstream fileout;
  int stream;
  int port;
  char* filename;
public:
  int get_stream(void) const {return stream;}
  int get_port(void) const {return port;}
  bool start_store(void);
  void print(void);
  void cancel(void);
  int add_char(char letter);
  PrintFile(int a, int b):  stream(a), port(b), filename(0) {}
  ~PrintFile(void) {if (filename) cancel();}
};

class PrintList: public DList<PrintFile> {
public:
  enum Print_status {off, on};
private:
  Print_status print_status[MAXUSERS][2];

public:
  Print_status get_print_status(int stream, int port) const 
                                          {if (stream >= MAXUSERS || port > 1) return off;
					   else return print_status[stream][port];}
  void add(PrintFile* print_f_p) {print_status[print_f_p->get_stream()][print_f_p->get_port()] = on;
                                  DList<PrintFile>::add(print_f_p);}
  const PrintFile* extract(void) {const PrintFile* print_f_p = DList<PrintFile>::extract();
                                  print_status[print_f_p->get_stream()][print_f_p->get_port()] = off;
				  return print_f_p;}
  PrintList(void);
};

inline int PrintFile::add_char(char letter) {
  if (filename) {
    fileout.put(letter);
    return 0;
  }
  else return -1;
}

#endif
