/* Copyright (C) 1999, 2000, 2001, 2002 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef COM_H
#define COM_H

#ifndef CONFIG_H
#define CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <csignal>
#include <iostream>
#include <iomanip>
#include <strstream>
#include <fstream>
#include <cstdlib>
#include <termios.h>
#include <cstring>
#include "prog_defs.h"

#ifndef LOCK_DIR
#define LOCK_DIR "/var/lock"
#endif

typedef unsigned char uchar;

class Com {
    int comfd;
    termios startsettings;
    const char* lockfile_name;
public:
    Com(int speed = 0, const char* port = 0, void (*error_dialog)(const char*) = 0);
    ~Com(void);
    ssize_t send(const uchar* buffer, size_t send_size) {return write(comfd, buffer, send_size);}
    ssize_t send(const uchar* text) {return write(comfd, text, strlen((const char*)text));}
    ssize_t send(uchar letter) {return send(&letter, 1);} // do not use this in a loop -
                                                          // it is not buffered
    ssize_t receive(uchar* buffer, size_t buffer_size) {return read(comfd, buffer, buffer_size);}
    static int check_port(const char* port = 0, void (*error_dialog)(const char*) = 0);
};

// Usage:

// pass the com object constructor the port name, and the speed (which
// may be 300, 600, 1200, 2400, 4800 or 9600 baud) and any error dialog
// display function to show error messages in, say, X Window (if no
// special error dialog is needed just allow the default NULL pointer
// to be assigned to the error_dialog function pointer).  Any such dialog
// should be modal to prevent the program exiting before the dialog is
// displayed.  Whether or not an error dialog function is assigned to
// error_message, any com errors will also be reported to the standard
// error stream object

// if no port name is given, the object will default to /dev/modem

// if no speed is given, or a speed of 0 is given, the object will default
// to 9600 baud

// int check_port() is made static so that lock files can be checked before the
// com object is created - this can be useful if the com object is to be created
// in a separate child process, and this source of error is to be checked before forking.
// It returns 0 if there are no lock file problems, otherwise it returns -1.

// The port name to be passed to check_port() is the same as the value to be passed
// to the constructor of a com object.  As in the case of the constructor of
// the com object, an error dialog display funtion be assigned to the
// error_dialog function pointer to call a function which shows error
// messages in, say, X Window (if no special error dialog is needed
// just allow the default NULL pointer to be assigned).  Any such dialog
// should be modal to prevent the program exiting before the dialog is
// displayed.  Whether or not an error dialog function is assigned to
// error_message, any com errors will also be reported to the standard
// error stream object

#endif
