/****************************************************************************
 *                                                                          *
 * update.c : Support-Routines for MakeFST.                                 *
 * Created: 28.06.95                                                        *
 *                                                                          *
 * (c) Mario Lorenz, DL5MLO. This code is put under the ALAS.               *
 * See file COPYING for details!                                            *
 *                                                                          *
 * This provides the routines to update the datafiles for makefst.c.        *
 * It is based (which means, in this case, only minor changes were made)    *
 * on the original maputil.c - Code by Karsten, DC7OS.                      *
 *                                                                          *
 ****************************************************************************/

#include "globals.h"
#include "toollib.h"
#include "stdlib.h"

/* Prototypes: */

int AddStation(char *str);
int DeleteStation(char *str);
int ModifyStation(char *str);
int AddLink(char *str);
int DeleteLink(char *str);
int ModifyLink(char *str);
int DoUpdate(void);



/*
 *       Append Station data
 */

int AddStation(char *str)
{
   
   if (AnzDigi == MaxGetDigi)
     {
	fprintf(stderr,"Internal Error: NoMem (should never happen)\n");
	fflush(stderr);
	return TRUE;
     }
   else
     {
	ExtrField(dliste[AnzDigi].call,str,1,9);
	MakeCall(dliste[AnzDigi].call);
	ExtrField(dliste[AnzDigi].line,str,2,1);
	ExtrField(dliste[AnzDigi].stat,str,3,2);
	ExtrField(dliste[AnzDigi].date,str,4,4);
	ExtrField(dliste[AnzDigi].type,str,5,2);
	ExtrField(dliste[AnzDigi].soft,str,6,2);
	ExtrField(dliste[AnzDigi].hard,str,7,2);
	ExtrField(dliste[AnzDigi].qrg,str,8,9);
	ExtrField(dliste[AnzDigi].baud,str,9,6);
	ExtrField(dliste[AnzDigi].sysop,str,10,6);
	strupr(dliste[AnzDigi].sysop);
	ExtrField(dliste[AnzDigi].loc,str,11,6);
	strupr(dliste[AnzDigi].loc);
	ExtrField(dliste[AnzDigi].qth,str,12,36);
	ExtrField(dliste[AnzDigi].info,str,13,48);
	/* Adjustments */
	if ((strcmp(dliste[AnzDigi].type,"LN") == 0) && (abs(atof(dliste[AnzDigi].qrg) + 1.0) > 0.0001))
	  strcpy(dliste[AnzDigi].type,"DI");
	if ((strcmp(dliste[AnzDigi].type,"DI") == 0) &&
	    (abs(atof(dliste[AnzDigi].qrg) + 1.0) > 0.0001) &&
	    (strcmp(dliste[AnzDigi].baud,"") == 0))
	    strcpy(dliste[AnzDigi].type,"LN");
        if (atoi(dliste[AnzDigi].line) > 0)
	  {
	     strcpy(dliste[AnzDigi].type,"");
	     strcpy(dliste[AnzDigi].soft,"");
	     strcpy(dliste[AnzDigi].hard,"");
	  }
	AnzDigi++;
     }
   return FALSE;
}

/*
 *       Erases Digi from list
 */
int DeleteStation(char *str)
{
   char call[19], line[2];
   long i;
   int  c;
   
   if (((c = CountCommas(str)) > 2) && strict)
     {
	fprintf(stderr,"Wrong ammount of colons in line\n  %s\n",str);
	fflush(stderr);
	return TRUE;
     }
   ExtrField(call,str,1,9);
   MakeCall(call);
   if (c >= 1)
     {
	ExtrField(line,str,2,1);
	if (strcmp(line,"") == 0) strcpy(line,"0");
     }
   else
     strcpy(line,"0");
   if (strcmp(line,"0") == 0)
     {
	for (i = 0;i < AnzLink; i++)
	  if ((strcmp(lliste[i].call1,call) == 0) ||
	      (strcmp(lliste[i].call2,call) == 0))
	  memcpy(lliste[i].call1,lliste[--AnzLink].call1,sizeof(LINK));
     }
   i = SearchDigi(call,line);
   if (i != ERROR)
     memcpy(dliste[i].call,dliste[--AnzDigi].call,sizeof(DIGI));
   if (strcmp(line,"0") == 0)
     while (strcmp(dliste[i+1].call,call) == 0)
     memcpy(dliste[++i].call,dliste[--AnzDigi].call,sizeof(DIGI));
return FALSE;
}
/*
 * Test if for newer entry
 */
int newer(char *d1, char *d2)
{
   if (atoi(d1) == 0) strcpy(d1,aktdate);
   return strcmp(d1,d2);
}

 

/*
 *      Modify Station data
 *       Also if only appending data, at first there will be looked
 *       whether changes already have been made.
 */
int ModifyStation(char *str)
{
   DIGI d;
   long i;
   
   if ((CountCommas(str) != 12) && strict)
     {
	fprintf(stderr,"Error:Wrong ammount of commas in line:\n  %s\n",str);
	fflush(stderr);
	return TRUE;
     }
   ExtrField(d.call,str,1,9);
   MakeCall(d.call);
   ExtrField(d.line,str,2,1);
   i = SearchDigi(d.call,d.line);
   if (i != ERROR)
     {
	ExtrField(d.stat,str,3,2);
	strupr(d.stat);
	ExtrField(d.date,str,4,4);
	ExtrField(d.type,str,5,2);
	ExtrField(d.soft,str,6,2);
	ExtrField(d.hard,str,7,2);
	ExtrField(d.qrg,str,8,9);
	ExtrField(d.baud,str,9,6);
	ExtrField(d.sysop,str,10,6);
	strupr(d.sysop);
	ExtrField(d.loc,str,11,6);
	strupr(d.loc);
	ExtrField(d.qth,str,12,36);
	ExtrField(d.info,str,13,48);
	if (atoi(d.line) > 0)
	  {
	     d.type[0] = d.soft[0] = d.hard[0] = ' ';
	     d.type[1] = d.soft[1] = d.hard[1] = '\0';
	  }
	if (strcmp(d.type,"LN") == 0) strcpy(d.baud,"      ");
	if (newer(d.date,dliste[i].date))
	  {
	     StrCopy(dliste[i].stat,d.stat);
	     StrCopy(dliste[i].date,d.date);
	     StrCopy(dliste[i].type,d.type);
	     StrCopy(dliste[i].soft,d.soft);
	     StrCopy(dliste[i].hard,d.hard);
	     StrCopy(dliste[i].qrg,d.qrg);
	     StrCopy(dliste[i].baud,d.baud);
	     StrCopy(dliste[i].sysop,d.sysop);
	     StrCopy(dliste[i].loc,d.loc);
	     StrCopy(dliste[i].qth,d.qth);
	     StrCopy(dliste[i].info,d.info);
	     if ((strcmp(dliste[i].type,"DI") == 0) && (abs(atof(dliste[i].qrg) + 1.0) < 0.0001) &&
		 (strcmp(dliste[i].baud,"") == 0)) strcpy(dliste[i].type,"LN");
	  }
	return FALSE;
     }
   else
     return AddStation(str);
}
	     
	      

/*
 *      Appends link to the list
 */
int AddLink(char *str)
{
   char c1[19];
   if (AnzLink == MaxGetLink)
     {
	fehler=TRUE;
	fprintf(stderr,"Internal Error: NoMem (should never happen)\n");
	fflush(stderr);
	return TRUE;
     }
   ExtrField(lliste[AnzLink].call1,str,1,9);
   ExtrField(lliste[AnzLink].call2,str,2,9);
   MakeCall(lliste[AnzLink].call1);
   MakeCall(lliste[AnzLink].call2);
   if (strcmp(lliste[AnzLink].call1,lliste[AnzLink].call2) > 0)
     {
	strcpy(c1,lliste[AnzLink].call1);
	strcpy(lliste[AnzLink].call1,lliste[AnzLink].call2);
	strcpy(lliste[AnzLink].call2,c1);
     }
   ExtrField(lliste[AnzLink].stat,str,3,2);
   strupr(lliste[AnzLink].stat);
   ExtrField(lliste[AnzLink].date,str,4,4);
   ExtrField(lliste[AnzLink].baud,str,5,6);
   if (hm50flag) ExtrField(lliste[AnzLink].typ,str,6,2);
   else strcpy(lliste[AnzLink].typ,"");
   if (strcmp(lliste[AnzLink].stat,"") == 0) strcpy(lliste[AnzLink].stat,"OK");
   AnzLink++;
   return FALSE;
}

/*
 *   This deletes an existing link
 */
int DeleteLink(char *str)
{
   char c1[19], c2[19];
   long i;
   
   if ((CountCommas(str) > 2) && strict)
     {
	fprintf(stderr,"Wrong ammount of colons in line\n  %s\n",str);
	fflush(stderr);
	return TRUE;
     }
   
   ExtrField(c1,str,1,9);
   MakeCall(c1);
   ExtrField(c2,str,2,9);
   MakeCall(c2);
   strupr(c2);
   if (strcmp(c1,c2) > 0) i = SearchLink(c2,c1);
   else i = SearchLink(c1,c2);
   if (i != ERROR)
     memcpy(lliste[i].call1,lliste[--AnzLink].call1,sizeof(LINK));
   return FALSE;
}

 
/*
 *      Changes existing link entries...
 */
int ModifyLink(char *str)
{
   char         c1[19], c2[19], stat[3], date[5], baud[7], typ[3];
   long i;
   int k;
   k=CountCommas(str);
   hm50flag |= (k == 5);
  
   if (( k != (hm50flag ? 5 : 4)) && strict)
      {
	fprintf(stderr,"Wrong ammount of colons in line:\n  %s\n",str);
	fflush(stderr);
	return TRUE;
     }
   ExtrField(c1,str,1,9);
   MakeCall(c1);
   ExtrField(c2,str,2,9);
   MakeCall(c2);
   if (strcmp(c1,c2) > 0) i = SearchLink(c2,c1);
   else i = SearchLink(c1,c2);
   if (i != ERROR)
     {
	ExtrField(stat,str,3,2);
	strupr(stat);
	ExtrField(date,str,4,4);
	ExtrField(baud,str,5,6);
	if (k == 5) ExtrField(typ,str,6,2); else strcpy(typ,"");
	if (newer(date,lliste[i].date))
	  {
	     if (!((atol(baud) == 999999l) &&
		   (strcmp(lliste[i].stat,"WI") == 0)))
	       {
		  StrCopy(lliste[i].stat,stat);
		  StrCopy(lliste[i].date,date);
		  StrCopy(lliste[i].baud,baud);
		  StrCopy(lliste[i].typ,typ);
	       }
	  }
	return FALSE;
     }
   else return AddLink(str);
}

/*
 * Read Update-File and modify the data according to it
 */
int DoUpdate(void)
{
   FILE *handle;
   char str[255], what[3];
   int flag=FALSE;
   
   if ((handle = fopen(updname,"r")) == NULL)
     {
	fprintf(stderr,"\nUnable to open %s\n",updname);
	fflush(stderr);
	return TRUE;
     }
   
   if (verbose) printf("Updating......................");fflush(stdout);
   while ( !feof(handle) && !flag )
     {
	get(handle,str);
	entfsp(str);
	if (str[0] != '\0')
	  {
	     what[0] = str[0]; what[1] = str[1]; what[2] = '\0';
	     entf(str,3);
	     strupr(what);
	     if (what[0] != '#')
	       {
		  entfsp(str);
		  if (strcmp(what,"AS") == 0) flag=ModifyStation(str);
		  else if (strcmp(what,"MS") == 0) flag=ModifyStation(str);
		  else if (strcmp(what,"DS") == 0) flag=DeleteStation(str);
		  else if (strcmp(what,"AL") == 0) flag=ModifyLink(str);
		  else if (strcmp(what,"ML") == 0) flag=ModifyLink(str);
		  else if (strcmp(what,"DL") == 0) flag=DeleteLink(str);
		  else if (strict)
		    {
		       fprintf(stderr,"Error: Cannot handle command: %s\nin line:%s\n",what,str);fflush(stderr);
		       flag = TRUE;
		    }
	       }
	  }
     }
   fclose(handle);
   if (!flag)
     {
	qsort(dliste,AnzDigi,sizeof(DIGI),(int)cmpdigi);
	qsort(lliste,AnzLink,sizeof(LINK),(int)cmplink);
     }
   if (verbose && !flag) printf("                    OK.\n\n");
   else printf("\n");
   fflush(stdout);
   return flag;
}
   
    
