/****************************************************************************
 *                                                                          *
 * Toollib.c : Support-Routines for MakeFST.                                *
 * Created: 28.06.95                                                        *
 *                                                                          *
 * (c) Mario Lorenz, DL5MLO. This code is put under the ALAS.               *
 * See file COPYING for details!                                            *
 *                                                                          *
 * This provides some support routines for makefst.c. It is based on        *
 * the original maputil.c/infutil.c - Code by Karsten, DC7OS.               *
 *                                                                          *
 ****************************************************************************/

#include "globals.h"

/* Prototypes */

long SearchDigi(const char *DigiName, const char *line);
long SearchLink(const char *c1, const char *c2);
long SearchDigi2(const char *DigiName);
int cmpdigi(DIGI *s1, DIGI *s2);
int cmplink(LINK *l1, LINK *l2);
void strupr(char *s1);

int  CountColons(char *str);
char *entf(char *str, int n);
char *entfsp(char *str);
void get(FILE *fil, char *str);
void ExtrField(char *d, char *s, int n, int len);
void MakeCall(char *s);
void StrCopy(char *s1, const char *s2);


/*
 *    Searches for a digipeater in dliste and returns the index.
 *    Since the list is not sorted, only linear search works :-(
 */

long SearchDigi(const char *DigiName, const char *line)
{
   
   s9      call1;
   long    i;
   long    ret = ERROR;
   
   strcpy(call1,DigiName);
   strupr(call1);
   
   for (i = 0;(i < AnzDigi) && (ret == ERROR);i ++)
     if ((strcmp(dliste[i].call,call1) == 0) &&
	 (strcmp(dliste[i].line,line) == 0)) ret = i;
   return ret;
}

/*
 * Now the same, but for links...
 */
long SearchLink(const char *c1, const char *c2)
{
   
   long    i;
   long    ret = ERROR;
   
   for (i = 0; (i < AnzLink) && (ret == ERROR); i++)
     if ((strcmp(lliste[i].call1,c1) == 0) &&
	 (strcmp(lliste[i].call2,c2) == 0)) ret = i;
   return ret;
}

/* 
 * This ist the fast BinarySearch algorithm which can be used when the
 * array is sorted..
 */
long SearchDigi2(const char *DigiName)
{
   s9     call1;
   long   l=0,
   r=AnzDigi,
   x;
   int    result;
   strcpy(call1,DigiName);
   strupr(call1);
   
   while (r >= l)
     {
	x = (l+r)/2;
	result=strcmp(dliste[x].call,call1);
	if (result==0) return (x - atoi(dliste[x].line));
	if (result>0) r=x-1; else l=x+1;
     }
   
      return ERROR;
}

/*
 *  cmpdigi -> compare digipeaters, for QSORT
 */
int cmpdigi(DIGI *s1, DIGI *s2)
{
   int result;
   if ((result=strcmp(s1->call, s2->call)) != 0) return result;
   return atoi(s1->line) - atoi(s2->line);
}

/*
 * cmplink -> compare links, for QSORT
 */
int cmplink(LINK *l1, LINK *l2)
{
   int  r = strcmp(l1->call1,l2->call1);
   if (r != 0) return r;
   return strcmp(l1->call2,l2->call2);
}


/*
 * toupper for strings
 */
void strupr(char *s1)
{
   while (*s1 != '\0')
     {
	*s1=toupper(*s1);
	s1++;
     }
}


/*
 * Count the commas in a string
 */
int CountCommas(char *str)
{
   int i=0;
   while (*str!='\0') if (*str++ ==',') i++;
   return i;
}


/*
 * remove n chars from the beginning of line
 */
char *entf(char *str, int n)
{
   int i = n;
   while (str[i] != '\0')
     {
	str[i-n] = str[i];
	i += 1;
     }
   str[i-n] = '\0';
   return str;
}

/*
 * remove spaces from the beginning of a string
 */
char *entfsp(char *str)
{
   int i = 0;
   if (strcmp(str,"") != 0)
     {
	while (str[i] == ' ') i += 1;
	if (i > 0) entf(str,i);
     }
   return str;
}

/*
 * reads max. 255 chars until EOL from FILE
 */
void get(FILE *fil, char *str)
{
   char *ptr;
   fgets(str,255,fil);
   if (feof(fil)==FALSE)
     {
	if ((ptr=strchr(str,'\n'))!= NULL) *ptr='\0';   /* remove \n */
	if ((ptr=strchr(str,'\r'))!= NULL) *ptr='\0';   /* and \r */
     }
   else str[0]='\0';
}

/*
 * Extracts information from a field
 */
void ExtrField(char *desti, char *source, int field, int len)
{
   int currcomma=1,currlen=0;
   desti[0]='\0';
   while (*source!='\0')
     {
	if (*source==',') currcomma++;
	else if ((currcomma==field) && (currlen <=len) && ((*source!=' ') || (currlen!=0)))
	  {
	     strncat(desti,source,1); /* If current field, and len <= allowed len, */
	     currlen++;    /* and the char is not a leading space, add it*/
	  }
	source++;
     }
   while((currlen >0) &&(desti[currlen-1]==' ')) currlen--;
   if (currlen >= 0) desti[currlen]='\0'; 
}

/*
 * Makes a callsign of exactly 9 chars length
 */
void MakeCall(char *s)
{
   strupr(s);
   strncat(s,"         ",(9 - strlen(s)));
}

/*
 * copies s2 to s1 if s2 is not empty
 */
void StrCopy(char *s1, const char *s2)
{
   if (s2[0]!='\0') strcpy(s1,s2);
   /* Remove QuestionMarks */
   if (strchr(s1,'?') != NULL) s1[0]='\0';
}



 
