/****************************************************************************
 *                                                                          *
 * maputil.h : Definitions for makefst.c                                    *
 * Created: 28.06.95                                                        *
 *                                                                          *
 * (c) Mario Lorenz, DL5MLO. This code is put under the ALAS.               *
 * See file COPYING for details!                                            *
 *                                                                          *
 *                                                                          *
 ****************************************************************************/
#ifndef _MAPUTIL_H_ 
#define _MAPUTIL_H_ 1

#include "version.h"

/* The includes which should always be there */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <linux/limits.h>

/*  Some basic definitions */
#define         FALSE   0
#define         TRUE    !FALSE

#define         ERROR   -100l         
#define         FINOTF          -101
#define         NOMEM           -102

/* The sizes of the different data-fields. See dataform.txt */
#define size_call 9
#define size_line 1
#define size_stat 2
#define size_date 4
#define size_type 2
#define size_soft 2
#define size_hard 2
#define size_qrg 9
#define size_baud 6
#define size_sysop 6
#define size_loc 6
#define size_qth 36
#define size_info 48

/* Definition for .LNK-File, if not same as in stn-file */
#define size_lbaud 8
#define USAGEERROR 255

#define MILLION 1000000l

typedef struct {
   char call[size_call+1],                   /* the nodecallsign */
        line[size_line+1],                   /* Linenumber */
        stat[size_stat+1],                   /* State */
        date[size_date+1],                   /* Date */
        type[size_type+1],                   /* Type */
        soft[size_soft+1],                   /* Software */
        hard[size_hard+1],                   /* Hardware */
        qrg[size_qrg+1],                     /* QRG */
        baud[size_baud+1],                   /* Baudrate */
        sysop[size_sysop+1],                 /* Callsign of Sysop */
        loc[size_loc+1],                     /* Locator */
        qth[size_qth+1],                     /* QTH  */
        info[size_info+1];                   /* Text */
   long index;                               /* pointer to .STN-Position*/
 } DIGI;

typedef struct {
   char call1[size_call+1],     /* First Linkpartner */
   call2[size_call+1],     /* Second Linkpartner */
   stat[size_stat+1],      /* Link state */
   date[size_date+1],      /* Date */
   baud[size_lbaud+1],     /* Linkbaudrate */
   typ[size_type+1];        /* Link-Type */
   int  flag;
} LINK;

typedef char s9[10], s6[7];


#endif /* _MAPUTIL_H_ */
