/*************************************************************************
 *   MAKEFST.C                                                           *
 * Program for updating and checking Hammap-Datafiles                    *
 * and generating the .FST-Fastload file for DIGIINFO.                   *
 * This code is copyrighted and put under the ALAS-License.              *
 * See file COPYING for details!                                         *
 * Autor:    Mario Lorenz, DL5MLO                                        *
 * Date: 28.06.95                                                        * 
 * Based upon makefst.c and maputil.c by Karsten Heddenhausen, DC7OS     *
 *************************************************************************/

/* Includes */
#include "maputil.h"
#include "toollib.h"
#include "files.h"
#include "update.h"
#include "fstconvert.h"

/* globale Variablen */

char   mapname[PATH_MAX];
char   linkname[PATH_MAX];
char   updname[PATH_MAX];
char   fstname[PATH_MAX];
char   aktdate[10];
DIGI   *dliste;
LINK   *lliste;
di_DIGI *di_dliste;
di_LINK *di_lliste;
long   AnzDigi;
long   AnzLink;
long   di_AnzDigi;
long   di_AnzLink;
long   MaxGetDigi;
long   MaxGetLink;
int    verbose;
int    redflag;
int    oldflag;           /* Flags for cmdline options*/
int    updflag;
int    fstflag;
int    strict;            /* strict checking of Syntax */
int    fehler;
int    ln;
int    nomemflag;
int    dlflag;
int    hm50flag;



/*
 * print usage information
 */
void usage(int exitstatus)
{
   fprintf(stderr,"\nData converter for DIGIINFO/Linux,\n");
   fprintf(stderr,"based upon ATARI-Versions by Karsten Heddenhausen, DC7OS\n");
   fprintf(stderr,"This program is put under the General License for Amateur Radio Software (ALAS)!\n");
   fprintf(stderr,"See file COPYING for details.\n\n");
   fprintf(stderr,"usage: makefst [-vost] <map-name> [<update name>]\n");
   fprintf(stderr,"\n");
   fprintf(stderr,"flags:   -v     verbose\n");
 /*  fprintf(stderr,"         -r     remove redundant data\n"); */
   fprintf(stderr,"         -o     backup old data to *.bak\n");
   fprintf(stderr,"         -s     do strict syntax check\n");
   fprintf(stderr,"         -f     generate .fst- file (default)\n\n");
   exit(exitstatus);
} 	

/*
 *	The main - routine
*/	
int main(int argc, char *argv[])
{	
   char *p;
   int argcnt = 1;
   int argcnt2;
   int errflag;
   printf("MakeFST Version %s by Mario Lorenz, DL5MLO\n",VERSION);
   
   
   if ((argc < 2) || (argc > 7))  	/* wrong ammount of parameters, HELP! */
     usage(USAGEERROR);                 /* quit*/
   else
     {
	hm50flag = oldflag = redflag = FALSE;
	nomemflag = updflag = fstflag = strict = FALSE;
	mapname[0]=updname[0]='\0';
	for (argcnt=1; argcnt <  argc; argcnt++)
	  {
	     if (argv[argcnt][0]=='-')
	       {
		  argcnt2=1;        /* analyze first char */
		  while (argv[argcnt][argcnt2] !='\0')
		    {
		       switch (argv[argcnt][argcnt2])
			 {
			  case 'v':                     /* Verbose Flag */
			    verbose = TRUE;
			    break;
/*			  case 'r':                       Remove Redundant 
			    redflag = TRUE;
			    break;                       */
			  case 'o':                      /* Backup Flag */
			    oldflag = TRUE;
			    break;
			  case 'f':                      /* Create FST-File */
			    fstflag = TRUE;
			    break;
			  case 's':                      /* Strict Syntax check*/
			    strict = TRUE;
			    break;
			  default:
			    fprintf(stderr," -%c: Invalid option\n",argv[argcnt][argcnt2]);fflush(stderr);
			    usage(USAGEERROR);
			 }
		       argcnt2++;
		    }
	       }
	     else
	       {
		  if (mapname[0]=='\0') /* No Mapname yet */
		  strcpy(mapname,argv[argcnt]);
	          else
		    {
		       if(updname[0]=='\0') /* No Updname yet*/
			 {
			    strcpy(updname,argv[argcnt]);
			    updflag=TRUE;
			 }
		       
		       else 
			 {
			    fprintf(stderr,"Too many file-arguments!");
			    fflush(stderr);
			    usage(USAGEERROR);
			 }
		    }
	       }
	  }
	if (mapname[0]=='\0')             /* we have no file argument */
	strcpy(mapname,"digiinfo");           /* So use default */  
	if ((p = strchr(mapname,'.')) != NULL) *(p-1) = '\0';
	strcpy(linkname,mapname);
	strcpy(fstname,mapname);
	strcat(mapname,".stn");
	strcat(linkname,".lnk");
	strcat(fstname,".fst");
	if (strchr(updname,'.') == NULL) strcat(updname,".upd");
	if ((!redflag) && (!updflag)) fstflag = TRUE;
	
	if (verbose)
          {
	     printf("\nstation data: %s\n",mapname);
	     printf("link data   : %s\n",linkname);
	     if (updflag) printf("update data : %s\n",updname);
	     printf("\n");
	     if (fstflag) printf("FST file    : %s",fstname);
	     if (oldflag) printf("Old files will be backed up.\n");
/*	     if (redflag) printf("Redundant data will be removed.\n"); */
	     puts("\n");
	  }
	
 /*  In all cases, we need to load the data into memory. This is equivalent
  *  to having both the Station- and the Link-File in memory. Under LinuX,
  *  or other systems providing virtual memory, this should not be a problem.
  *  Under plain DOS, it will. */
   
	errflag =FALSE;
   
	if (!errflag) errflag=LoadStnData(); /* Load stations */
	if (!errflag) errflag=LoadLnkData(); /* Load links */
	if ((!errflag) && updflag) errflag=DoUpdate(); /*Update everything */
	/*   if ((!errflag) && redflag) !errflag=DoRemRed();  remove redundant entries */
	if (!errflag) errflag=SaveStnData(); /* STN-Data need to be saved*/
	if (!errflag) errflag=SaveLnkData(); /* LNK-Data need to be saved */
	if ((!errflag) && fstflag) errflag=convertFST(); /* convert FSTs */
	if ((!errflag) && fstflag) errflag=SaveFST();  /* FST needs to be saved */
	if (errflag) fputs("There were errors.\n",stderr); fflush(stderr);
     }
   return 0;
}
