/*************************************************************************
 * fstconvert.c                                                          *
 * Generating of FST structure in memory. This will go away soon...      *
 *                                                                       *
 * This code is copyrighted and put under the ALAS-License.              *
 * See file COPYING for details!                                         *
 * Autor:    Mario Lorenz, DL5MLO                                        *
 * Date: 22.07.95                                                        *
 * Based upon makefst.c by Karsten Heddenhausen, DC7OS                   *
 *************************************************************************/

#include "globals.h"
#include "di_mini.h"
#include "toollib.h"
#include "maputil.h"

/* Prototypes */
int convertFST(void);
long di_SearchDigi(const char *DigiName);
int di_digicmp(di_DIGI *s1, di_DIGI *s2);

/*
 * Returns Index of Digi in di_dliste table. ERROR if not found.
 */
long di_SearchDigi(const char *DigiName)
{
   long   l=0,
   r=di_AnzDigi,
   x;
   int    result;
   while (r >= l)
     {
	x = (l+r)/2;
	result=strcmp(di_dliste[x].call,DigiName);
	if (result==0) return x;
	if (result>0) r=x-1; else l=x+1;
     }
   return ERROR;
}

/*
 * di_digicmp is a comparison for qsort()
 */ 
int di_digicmp(di_DIGI *s1, di_DIGI *s2)
{
   return strcmp(s1->call,s2->call);
}
/*
 * Link-Compare for QuickSort
 */
int di_linkcmp(di_LINK *s1, di_LINK *s2)
{
   
      if (s1->LinkStart < s2->LinkStart) return -1;
      else if (s1->LinkStart > s2->LinkStart) return 1;
      else if (s1->LinkEnd < s2->LinkEnd) return -1;
      else if (s1->LinkEnd > s2->LinkEnd) return 1;
      return 0;
}



/*
 * convertFST() converts the digiinfo.stn/diginfo.fst structures which are
 * in memory into FST structures. It uses the same memory with some not
 * gentlemen-like rehacking. Why allocating another meg of core ?
 */
int convertFST(void)
{
   long i;
   di_DIGI tmp_DIGI;
   di_LINK tmp_LINK;
   di_AnzDigi=0; di_AnzLink=0;
   
   if (verbose) printf("Generating FST Tables.........\n");fflush(stdout);
   di_dliste=(di_DIGI*)dliste;
   di_lliste=(di_LINK*)lliste;
   for(i=0;i < AnzDigi; i++)
     {
	tmp_DIGI.info=dliste[i].index;
	strcpy(tmp_DIGI.call,dliste[i].call);
	if (strstr("DI,LN,GW",dliste[i].type) != NULL)
	  tmp_DIGI.typ = _DIGI;
	else if (strcmp(dliste[i].type,"MB") == 0) tmp_DIGI.typ = _BOX;
	else if (strcmp(dliste[i].type,"DX") == 0) tmp_DIGI.typ = _DX;
	else if (strcmp(dliste[i].type,"TI") == 0) tmp_DIGI.typ = _TCPIP;
	else if (strcmp(dliste[i].type,"WX") == 0) tmp_DIGI.typ = _WX;
	else if (strcmp(dliste[i].type,"MF") == 0) tmp_DIGI.typ = _MF;
	else tmp_DIGI.typ = _SONST;
	
	if (strcmp(dliste[i].stat,"OK") != 0) tmp_DIGI.typ=_NOK;
	if (strstr("BC,BM",dliste[i].type) != NULL) tmp_DIGI.typ = 255 - tmp_DIGI.typ;
	strcpy(tmp_DIGI.qth,dliste[i].loc);
	memcpy(&di_dliste[di_AnzDigi],&tmp_DIGI,sizeof(di_DIGI));  /* Copy it */
	if (di_SearchDigi(tmp_DIGI.call)==di_AnzDigi)di_AnzDigi++; /* Not in List */ 
	 
     }
   
   if(verbose)
     {
	printf("%li digis processed, %li taken.\n",AnzDigi,di_AnzDigi);
        printf("Sorting digi table............"); fflush(stdout);
     }
   qsort(di_dliste,di_AnzDigi,sizeof(di_DIGI),(int)di_digicmp);
   if(verbose) printf("                    OK.\n"); fflush(stdout);
   /* Now sort in the links */
  di_AnzLink=0; 
  for (i=0; i<AnzLink; i++)
     {
	if ((ERROR != (tmp_LINK.LinkStart=di_SearchDigi(lliste[i].call1)))
	    && (ERROR != (tmp_LINK.LinkEnd=di_SearchDigi(lliste[i].call2))))
     	  {
	     tmp_LINK.LinkBaud = atol(lliste[i].baud);
	     if (tmp_LINK.LinkBaud == 0) tmp_LINK.LinkBaud = 1200;
	     if (strcmp(lliste[i].stat,"OK") == 0) tmp_LINK.LinkStat = _OK;
	     else if (strcmp(lliste[i].stat,"TE") == 0) tmp_LINK.LinkStat = _TEST;
	     else if (strcmp(lliste[i].stat,"PL") == 0) tmp_LINK.LinkStat = _PLAN;
	     else if (strcmp(lliste[i].stat,"IS") == 0) tmp_LINK.LinkStat = _INSTAB;
	     else tmp_LINK.LinkStat = _DEFEKT;
	     if (hm50flag)
	       {
		  if (strcmp(lliste[i].typ,"WI") == 0) tmp_LINK.LinkStat |= _DRAHT;
		  else if (strstr("NT,SL",lliste[i].typ) != NULL) tmp_LINK.LinkStat |= _INSAT;
		  else if (strstr("VF,UF,SF",lliste[i].typ) != NULL) tmp_LINK.LinkStat |= _VUS;
		  else if (strcmp(lliste[i].typ,"BU") == 0) tmp_LINK.LinkStat |= _BUS;
	       }
	     else if (strcmp(lliste[i].typ,"WI") == 0) tmp_LINK.LinkStat |= _DRAHT;
	     else tmp_LINK.LinkStat |= _VUS;
	    memcpy(&di_lliste[di_AnzLink++],&tmp_LINK,sizeof(di_LINK));
	    memcpy(&di_lliste[di_AnzLink++],&tmp_LINK,sizeof(di_LINK));
	    /* add link in both directions! */
	    di_lliste[di_AnzLink-1].LinkStart=di_lliste[di_AnzLink-2].LinkEnd;
	    di_lliste[di_AnzLink-1].LinkEnd=di_lliste[di_AnzLink-2].LinkStart;
	  }
	else 
	  if (verbose)
	      printf("Following Link not taken: %s <--> %s\n",lliste[i].call1,lliste[i].call2); 
     }
   if (verbose)	printf("%li links processed, %li taken.\n",AnzLink,(di_AnzLink/2));
   fflush(stdout);
   if (AnzLink!=di_AnzLink/2)
     {
	fprintf(stderr,"Internal error: Not all processed links have been used for the fastload-file.\n");
	fprintf(stderr,"This should never happen, since all data is sorted correctly.\n");
	fprintf(stderr,"So this is either a program bug, or your stn/lnk files are corrupt.....\n");
	fflush(stderr);
        return TRUE;
     }
   if(verbose)	printf("Sorting link data.............");fflush(stdout);
   qsort(di_lliste,di_AnzLink,sizeof(di_LINK),(int)di_linkcmp);
   if (verbose) printf("                    OK.\n\n");fflush(stdout);
   return FALSE;
}

	        

