/*************************************************************************
 *   files.c                                                             *
 * Filehandling for makefst. Loading/Saving data files                   *
 *                                                                       *
 * This code is copyrighted and put under the ALAS-License.              *
 * See file COPYING for details!                                         *
 * Autor:    Mario Lorenz, DL5MLO                                        *
 * Date: 28.06.95                                                        *
 * Based upon makefst.c and maputil.c by Karsten Heddenhausen, DC7OS     *
 *************************************************************************/

#include "globals.h"
#include "toollib.h"
#include "maputil.h"
#include "di_mini.h"

/* Prototypes */
int LoadStnData(void);
int LoadLnkData(void);
int SaveStnData(void);
int SaveLnkData(void);
int SaveFST(void);

/*
 *	load digipeater-data
 */
int LoadStnData(void)
{
   FILE	*handle,*uhandle;
   char	line[255];
   long 	i = 0;
   int 	flag,tmpint;
   long	len=0;
   int  c_AS=0, c_MS=0, c_DS=0; 
   int     b1, b2, b3;
   double  qrg, minus1 = (double)-1.0;
   
   if (verbose) printf("Scanning digipeater data......");fflush(stdout);
   if ((handle = fopen(mapname,"r")) == NULL)
     {
	fprintf(stderr,"\nUnable to open file: %s\n",mapname);fflush(stderr);
	return(TRUE);
     }
   /* Count lines in stn-file */
   while ((tmpint = getc(handle)) != EOF) if ((char)tmpint=='\n') len++;
   fseek(handle,0,SEEK_SET);                      /* Rewind */
   if (verbose) printf("                    %-5li lines counted.\n",len); fflush(stdout);
   if (updflag)
     {
	if(verbose) printf("Scanning update file for digipeater updates:\n");fflush(stdout);
	if((uhandle=fopen(updname,"r"))==NULL)
	  {
	     fprintf(stderr,"\nUnable to open file: %s\n",updname);fflush(stderr);
	     return(TRUE);
	  }
	while ((!feof(uhandle)))
	  {
	     get(uhandle,line); /* Load line of upd-file */
	     if (line[0]!='\0')
	       {
		  entfsp(line);
		  if (strncmp(line,"AS:",3)==0) c_AS++;
		  if (strncmp(line,"MS:",3)==0) c_MS++;
		  if (strncmp(line,"DS:",3)==0) c_DS++;
	       }
	  }
	fclose(uhandle);
	if (verbose)
	  {
	   printf("Counted %-4i adds, %-4i mods, %-4i removes.\n",c_AS,c_MS,c_DS);
	   fflush(stdout);
	  }
	len+=c_AS;
	if (len < 0) 
	  {
	     fprintf(stderr,"ERROR: There are more stations to be deleted than available\n");
	     fprintf(stderr,"Please check your data-files!\n");
	     fflush(stderr);
	     return TRUE;
	  }
     }
   MaxGetDigi=len;
   if (verbose) printf("Allocating %-7li bytes memory for %-5li Digis..",(MaxGetDigi * sizeof(DIGI)),MaxGetDigi);fflush(stdout);
   flag = ((dliste = (DIGI *)malloc(MaxGetDigi*sizeof(DIGI))) != NULL); 
   if (!flag)
     {
	fprintf(stderr,"\nNot enough memory for digipeatertable!\n");
	fflush(stderr);
	return TRUE;
     }
   if (verbose)
     {
	printf(" OK.\nLoading digipeater-data......."); fflush(stdout);
     }
	
   while (!feof(handle)) 
     {
	get(handle,line);
	if (line[0] != '\0')
	  {
	     ExtrField(dliste[i].call,line,1,9);
	     MakeCall(dliste[i].call);
	     ExtrField(dliste[i].line,line,2,1);
	     ExtrField(dliste[i].stat,line,3,2);
	     strupr(dliste[i].stat);
	     ExtrField(dliste[i].date,line,4,4);
	     ExtrField(dliste[i].type,line,5,2);
	     strupr(dliste[i].type);
	     ExtrField(dliste[i].soft,line,6,2);
	     strupr(dliste[i].soft);
	     ExtrField(dliste[i].hard,line,7,2);
	     strupr(dliste[i].hard);
	     ExtrField(dliste[i].qrg,line,8,9);
	     ExtrField(dliste[i].baud,line,9,6);
	     ExtrField(dliste[i].sysop,line,10,6);
	     strupr(dliste[i].sysop);
	     ExtrField(dliste[i].loc,line,11,6);
	     strupr(dliste[i].loc);
	     ExtrField(dliste[i].qth,line,12,36);
	     ExtrField(dliste[i].info,line,13,48);
	     /* some adjustments can be done here..*/
	     if (strcmp(dliste[i].stat,"")==0)
	       strcpy(dliste[i].stat,"OK");
	     if ((strcmp(dliste[i].type,"LN") == 0) && (abs(atof(dliste[i].qrg) - minus1) > 0.0001))
	       strcpy(dliste[i].type,"DI");
	     b1 = (strcmp(dliste[i].type,"DI") == 0);
	     qrg = atof(dliste[i].qrg);
	     b2 = (abs(qrg - minus1) < 0.0001);
	     b3 = (strcmp(dliste[i].baud,"") == 0);
	     if ( b1 & b2 & b3 )
	       strcpy(dliste[i].type,"LN");
	     if (atoi(dliste[i].line) > 0) 
	       {
		  strcpy(dliste[i].type,"");
		  strcpy(dliste[i].soft,"");
		  strcpy(dliste[i].hard,"");
	       }
	     i++;
	  };
     }
   if (verbose)
	  {
	     printf("                    %-5li digipeaters loaded.\n",i);
	     fflush(stdout);
	  }
   fclose(handle);
   AnzDigi = i;
   if (verbose) printf("Sorting Digipeatertable......."); fflush(stdout);
   qsort(dliste,AnzDigi,sizeof(DIGI),(int)cmpdigi);
   if (verbose) printf("                    OK.\n"); fflush(stdout);
   return FALSE;
}

/*
 *	load link list
 */
int LoadLnkData(void)
{
   FILE	*handle,*uhandle;
   char	line[255];
   long	i = 0;
   int	flag,tmpint;
   long	len=0;
   s9	call;
   int	c_AL=0, c_ML=0, c_DL=0;
   
   if (verbose) printf("Scanning link data............"); fflush(stdout);
   if ((handle = fopen(linkname,"r")) == NULL)
     {
	fprintf(stderr,"\nUnable to open file: %s \n",linkname);
	return TRUE;
     };
   /* Count lines in .LNK-File */
   while ((tmpint = getc(handle)) != EOF) if ((char)tmpint=='\n') len++;
   fseek(handle,0,SEEK_SET);                            /* Rewind */
   if (verbose) printf("                    %-5li lines counted.\n",len);fflush(stdout);
   if (updflag)
     {
	if(verbose) printf("Scanning update file for link updates:\n");fflush(stdout);
	if((uhandle=fopen(updname,"r"))==NULL)
	  {
	     fprintf(stderr,"\nUnable to open file: %s",updname);
	     fflush(stderr);
             return TRUE;
	  }
	while ((!feof(uhandle)))
	  {
	     get(uhandle,line); /* Load line of upd-file */
	     if (line[0]!='\0')
	       {
		  entfsp(line);
		  if (strncmp(line,"AL:",3)==0) c_AL++;
		  if (strncmp(line,"ML:",3)==0) c_ML++;
		  if (strncmp(line,"DL:",3)==0) c_DL++;
	       }
	  }
	fclose(uhandle);
	if (verbose)
	  {
	     printf("\nCounted %-4i adds, %-4i mods, %-4i removes.\n",c_AL,c_ML,c_DL);
	     fflush(stdout);
	  }
	len=len+c_AL;
	if (len < 0) 
	  {
	     fprintf(stderr,"ERROR: There are more links to be deleted than available\n");
	     fprintf(stderr,"Please check your data-files!\n");
	     fflush(stderr);
	     return TRUE;
	  }
     }
   MaxGetLink=len;
   if (verbose) printf("Allocating %-7li bytes memory for %-5li Links..",MaxGetLink * sizeof(LINK),MaxGetLink);fflush(stdout);
	
   flag = ((lliste = (LINK *)malloc(MaxGetLink*sizeof(LINK))) != NULL); 
   if (!flag)
     {
	fprintf(stderr,"Not enough memory for Linktable!\n");
	fflush(stderr);
	return TRUE;
     }
   if (verbose)
     {
	printf(" OK.\nLoading link-data............."); fflush(stdout);
     }
   
   while (!feof(handle))
     {
	get(handle,line);
	if (line[0] != '\0')
	  {
	     if (i ==  0) hm50flag = (CountCommas(line) == 5);
	     ExtrField(lliste[i].call1,line,1,9);
	     MakeCall(lliste[i].call1);
	     ExtrField(lliste[i].call2,line,2,9);
	     MakeCall(lliste[i].call2);
	     if (strcmp(lliste[i].call1,lliste[i].call2) >0)
	       {
		  strcpy(call,lliste[i].call1);
		  strcpy(lliste[i].call1,lliste[i].call2);
		  strcpy(lliste[i].call2,call);
	       }
	     ExtrField(lliste[i].stat,line,3,2);
	     strupr(lliste[i].stat);
	     ExtrField(lliste[i].date,line,4,4);
	     ExtrField(lliste[i].baud,line,5,8);
	     if (hm50flag) ExtrField(lliste[i].typ,line,6,2);
	     else strcpy(lliste[i].typ,"");
	     strupr(lliste[i].typ);
	     if (strcmp(lliste[i].stat,"") == 0)
	       strcpy(lliste[i].stat,"OK");
	     
	     i++;
	  };
     };
   if (verbose) printf("                    %-5li links loaded.\n",i);
   fclose(handle);
   AnzLink = i;
   if (verbose) printf("Sorting link data.............");fflush(stdout);
   qsort(lliste,AnzLink,sizeof(LINK),(int)cmplink);
   if (verbose) printf("                    OK.\n\n");fflush(stdout);
   return FALSE;
}

/*
 * Writes new .stn-File
 */
int SaveStnData()
{
   FILE         *handle;
   long         i;
   char         newname[PATH_MAX];
 
   
   strcpy(newname,mapname); /* copy mapname */
   strcat(newname,".bak");  /* append .bak */
   if (rename(mapname,newname))  /* If Error (<>0) */
     {
	fprintf(stderr,"Error making backup of %s\n",mapname);fflush(stderr);
	return TRUE;
     }
   
   unlink(mapname);
   if ((handle = fopen(mapname,"w")) == NULL)
     {
	fprintf(stderr,"Unable to write new station data!\n");fflush(stderr);
	rename(newname,mapname); /* put backup back */
	return TRUE;
     }
   
   if (verbose) printf("Saving new digipeater data....");fflush(stdout);
   for (i = 0; i < AnzDigi; i++)
     {
	entfsp(dliste[i].qrg);
	if (abs(atof(dliste[i].qrg) + 1.0) < 0.0001) strcpy(dliste[i].baud,"");
	entfsp(dliste[i].baud);
	dliste[i].index=ftell(handle);
	fprintf(handle,"%-9s,%-1s,%-2s,%-4s,%-2s,%-2s,%-2s,%9s,%6s,%-6s,%-6s,%-36s,%-48s\n",
		dliste[i].call,dliste[i].line,dliste[i].stat,dliste[i].date,dliste[i].type,
		dliste[i].soft,dliste[i].hard,dliste[i].qrg,dliste[i].baud,dliste[i].sysop,
		dliste[i].loc,dliste[i].qth,dliste[i].info);
     }
   if (verbose) printf("                    OK, %-7li bytes written.\n",ftell(handle));
   fflush(stdout);
   fflush(handle);
   fclose(handle);
   if (!oldflag) unlink(newname);       /* Don't keep backup */
   
   return FALSE;
   
}


/*
 *      writes new .LNK-File
 */
int SaveLnkData(void)
{
   FILE *handle;
   long i;
   char newname[PATH_MAX];
   
   strcpy(newname,linkname); /* copy linkname */
   strcat(newname,".bak");  /* append .bak */
   if (rename(linkname,newname))
     {
	fprintf(stderr,"Error making backup of %s\n",linkname);fflush(stderr);
	return TRUE;
     }
   unlink(linkname);
   if ((handle = fopen(linkname,"w")) == NULL)
     {
	fprintf(stderr,"Unable to write new link data!\n");fflush(stderr);
	rename(newname,linkname); /* put backup back */
	return TRUE;
     }
   if (verbose) printf("Saving new link data..........");fflush(stdout);
   for (i = 0; i < AnzLink; i++)
     {
	entfsp(lliste[i].baud);
	if (hm50flag)
	  fprintf(handle,"%-9s,%-9s,%-2s,%-4s,%8s,%-2s\n",
		  lliste[i].call1,lliste[i].call2,lliste[i].stat,
		  lliste[i].date,lliste[i].baud,lliste[i].typ);
	else
	  fprintf(handle,"%-9s,%-9s,%-2s,%-4s,%8s\n",
		  lliste[i].call1,lliste[i].call2,lliste[i].stat,
		  lliste[i].date,lliste[i].baud);
       
     }
   if (verbose) printf("                    OK, %-7li bytes written.\n\n",ftell(handle));
   fflush(stdout);
   fflush(handle);
   fclose(handle);
   if (!oldflag) unlink (newname); /* dont keep backup */
  
   return FALSE;
}
   
   
   
/*
 * SaveFST()  - This routine saves the .FST-File
 */

int SaveFST(void)
{
   FILE *handle;
   char newname[PATH_MAX];
   
   strcpy(newname,fstname); /* copy fstname */
   strcat(newname,".bak");  /* append .bak */
   rename(fstname,newname);
   unlink(fstname);
   if ((handle = fopen(fstname,"wb")) == NULL)
     {
	fprintf(stderr,"Unable to write new FST file!\n");fflush(stderr);
	rename(newname,fstname); /* put backup back */
	return TRUE;
     }
   if (verbose) printf("Saving new FST file...........");fflush(stdout);
       
   fwrite(&di_AnzDigi,sizeof(di_AnzDigi),1ul,handle);
   fwrite(&di_AnzLink,sizeof(di_AnzLink),1ul,handle);
   fwrite(mapname,sizeof(mapname),1ul,handle);
   fwrite((di_DIGI *)dliste,sizeof(di_DIGI),(size_t)di_AnzDigi,handle);
   fwrite((di_LINK *)lliste,sizeof(di_LINK),(size_t)di_AnzLink,handle);
      
   if (verbose) printf("                    OK, %-7li bytes written.\n\n",ftell(handle));
   fflush(stdout);
   fflush(handle);
   fclose(handle);
   if (!oldflag) unlink (newname); /* dont keep backup */
   return FALSE;
}
