/*****************************************************************************
 *                          DIGIINFO.C                                       *
 * Originally from Holger, DH4DAI, rewritten in C and modified for the       *
 * new data-format by Karsten, DC7OS.                                        *
 * LinuX-Port by Mario, DL5MLO on 02.06.95                                   *
 * Some minor changes by Harald D01JHS on 15.02.02                           *
 * This code is copyrighted (copylefted) under the                           *
 * Public License for Amateur Radio Software (ALAS)                          *
 * See File COPYING for Details                                              *
 *                                                                           * 
 * THERE ARE NO WARRANTIES OF ANY KIND. USE THIS SOFTWARE AT YOUR OWN RISK!  *
 *                                                                           *
 * ***************************************************************************
 * Atari-Version (on which this one is based uppon):                         *
 * created: 		02.12.92 - ??                                        *
 * Author:    		Karsten Heddenhausen DC7OS                           *
 * Tested: 		GurDT 	DL4ZBZ                                       *
 *           		Oli   	DH0OAE                                       *
 *           		Peter 	DF1LX                                        *
 *           		Chris 	PE1NIB                                       *
 * Ideas:       	Patrick	DF3VI                                        *
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <limits.h>
#include <linux/limits.h>
#include "digiinfo.h"
#include "infutil.h"

/* global variables */

long        AnzDigi,AnzLink;          /* Obergrenzen */
DIGI        *dliste;                  /* Datenfelder */
LINK        *lliste;
char        mapname[PATH_MAX],             /* Dateinamen */
            linkname[PATH_MAX];
long        MaxKM;                    /* Umkreis um Loc-Feld */
s6          OwnLoc;                   /* eigener Loc */
long        *LinkMask, *DigiMask;     /* zum maskieren von Daten */
long        *route;                   /* da geht's lang */
int         spr,                      /* eingestellte Sprache */
            defaultsprache;
            
			
SPRACHE     fstr[MAXSPR];             /* Formatstrings fuer einzelne Sprachen */
s80	    cmdargs[200];              /* Argumente  beim Aufruf als Kopie */

/* following extern definitions are nothing but a quick hack to split
 *  digiinfo into separate .o files. This was neccessary due some bug in GCC 
 */
extern s130 pref[MAXSPR];
extern void initstr();
extern void KurzAnleitung();


#ifdef TEST
FILE	*test;
#endif

/* #include "digispr.c" */


/*
 * Laengen- und Breitengrad aus QTH-Kenner berechnen
 */
void QthInKoor(double *lg,double *bg,char *loc)
{
   double l,b;
   l = ((int)loc[0] - 74) * 20.0;
   l += ((int)loc[2] - 48) * 2.0;
   l += ((int)loc[4] - 65) / 12.0;
   *lg = fmod(l * PI / 180.0, 2 * PI);
   b = ((int)loc[1] - 74) * 10.0;
   b += ((int)loc[3] - 48);
   b += ((int)loc[5] - 65) / 24.0;
   *bg = fmod(b * PI / 180.0, 2 * PI);
}

/*
 * Abstand zwischen 2 durch Locator gegebenen Punkten
 */
long DistDir(double l1, double b1, double l2, double b2)
{
   double  gamma;

   gamma = cos(b2) * cos(b1) * cos(l1-l2) + sin(b1) * sin(b2);
   if (gamma < 1.0) return 6378.38 * acos(gamma);
   return 0.0;
}



/*
 * 	Berechnet Wert fuer Linkqualitaet
*/
double CalcQual(unsigned long b, unsigned int s)
{
   double q;
   unsigned long   bi = b / 100;
   
   if ((b == 999999l) && ((s & _DRAHT) == 0)) bi = 192l;
   if ((s & _BUS) != 0) bi = 10000l;
   /*	q = 235 + log(bi/12)/log(2) * 20/ 6.379378367; */
   if (bi <=10) q = 180;
   else if (bi <= 12) q = 235;
   else if (bi <= 24) q = 237;
   else if (bi <= 48) q = 240;
   else if (bi <= 96) q = 244;
   else if (bi <= 192) q = 246;
   else if (bi <= 384) q = 250;
   else if (bi <= 768) q = 252;
   else q = 254;
   if ((s & _INSTAB) != 0) q *= 0.9;
   return q;
}

/*
 * Ueberprueft, ob Locator "passt"
 */
int CheckLocator(const char *loc)
{
   int h;
   h = (loc[0] >= 'A') && (loc[0] <= 'Z');
   h &= ((loc[1] >= 'A') && (loc[1] <= 'Z'));
   h &= ((loc[2] >= '0') && (loc[2] <= '9'));
   h &= ((loc[3] >= '0') && (loc[3] <= '9'));
   h &= ((loc[4] >= 'A') && (loc[4] <= 'Z'));
   h &= ((loc[5] >= 'A') && (loc[5] <= 'Z'));
   return h;
}

long Dist(long i, long j)
{
   double l1, b1, l2, b2;
   if (CheckLocator(dliste[i].qth) && CheckLocator(dliste[j].qth))
     {
	QthInKoor(&l1,&b1,dliste[i].qth);
	QthInKoor(&l2,&b2,dliste[j].qth);
	return DistDir(l1,b1,l2,b2);
     }
   else return WrongDist;
}

/*
 * Schnell-Lade-Datei laden
 * Dazu wird aus der abgespeicherten Anzahl Digis und Links der
 * Speicherbedarf errechnet und reserviert.
*/
int LoadFST(void)
{
   FILE	*handle;
   char	name[512];
   char tmpname[PATH_MAX];
   strcpy(name,HOME);
   strcat(name,"/digiinfo.fst");
   

   if ((handle = fopen(name,"rb")) != NULL)
     {
	fread(&AnzDigi,sizeof(AnzDigi),1ul,handle);
	fread(&AnzLink,sizeof(AnzLink),1ul,handle);
	fread(tmpname,sizeof(mapname),1ul,handle);
	strcpy(mapname,HOME);
	strcat(mapname,"/");
	strncat(mapname,tmpname,sizeof(mapname));
	if ((dliste = (DIGI *)malloc(AnzDigi*DSize)) == NULL)
	  return NOMEM;
	if ((lliste = (LINK *)malloc(AnzLink*LSize)) == NULL)
	  return NOMEM;
	fread(dliste,DSize,(size_t)AnzDigi,handle);
	fread(lliste,LSize,(size_t)AnzLink,handle);
	fclose(handle);
     }
   else return FINOTF;


   return TRUE;
}

int Erstelle_FST(void)
{
   printf(fstr[spr].zeile[34]);
   return FALSE;
}

/*
 * Digis in der Umgebung des angegebenen Locator
 */
void LocatorInfo(const char *s)
{
   long	i;
   s9		str;
   long	d;
   double l1,b1,l2,b2;
   
   strcpy(str,s);
   str[6] = '\0';
   
   QthInKoor(&l1,&b1,str);
   QthInKoor(&l2,&b2,OwnLoc);
   printf(fstr[spr].zeile[0],OwnLoc,str,DistDir(l1,b1,l2,b2));
   
   printf(fstr[spr].zeile[1],MaxKM,str);
   fflush(stdout);
   
   for (i = 0l;i < AnzDigi;i++)
     {
	QthInKoor(&l2,&b2,dliste[i].qth);
	if ((d = DistDir(l1,b1,l2,b2)) < MaxKM)
	  {
		  printf(fstr[spr].zeile[2],dliste[i].call,d);
	     
	  };
     };
   
   fflush(stdout);
}

char *TypAbk(char *abk, const char *s)
{
   if (strcmp(s,"DI") == 0) strcpy(abk,"Digipeater");
   else if (strcmp(s,"MB") == 0) strcpy(abk,"Mailbox");
   else if (strcmp(s,"LN") == 0) strcpy(abk,"Link-Node");
   else if (strcmp(s,"GW") == 0) strcpy(abk,"Gateway");
   else if (strcmp(s,"DX") == 0) strcpy(abk,"DX-Cluster");
   else if (strcmp(s,"TI") == 0) strcpy(abk,"TCP/IP-Server");
   else if (strcmp(s,"UN") == 0) strcpy(abk,fstr[spr].zeile[3]);
   else if (strcmp(s,"WX") == 0) strcpy(abk,fstr[spr].zeile[4]);
   else if (strcmp(s,"MF") == 0) strcpy(abk,fstr[spr].zeile[36]);
   else strcpy(abk,fstr[spr].zeile[5]);
   return abk;
}

char *SoftAbk(char *str, const char *s)
{
   strcpy(str,s);	
   if (strcmp(s,"FN") == 0) strcpy(str,"FlexNet");
   else if (strcmp(s,"TH") == 0) strcpy(str,"TheNet");
   else if (strcmp(s,"TO") == 0) strcpy(str,"ROSE-Node");
   else if (strcmp(s,"TN") == 0) strcpy(str,"TheNetNode");
   else if (strcmp(s,"KN") == 0) strcpy(str,"KAM-Node");
   else if (strcmp(s,"WA") == 0) strcpy(str,"WAMPES");
   else if (strcmp(s,"OE") == 0) strcpy(str,"OE5DXL-Node");
   else if (strcmp(s,"BC") == 0) strcpy(str,"BayCom");
   else if (strcmp(s,"DW") == 0) strcpy(str,"DigiWare");
   else if (strcmp(s,"SN") == 0) strcpy(str,"SNet");
   else if (strcmp(s,"DB") == 0) strcpy(str,"DieBox");
   else if (strcmp(s,"FB") == 0) strcpy(str,"FBB-Server");
   else if (strcmp(s,"BM") == 0) strcpy(str,"BayCom-Box");
   else if (strcmp(s,"G8") == 0) strcpy(str,"G8BPQ-Switch");
   else if (strcmp(s,"W0") == 0) strcpy(str,"W0RLI-Box");
   else if (strcmp(s,"DP") == 0) strcpy(str,"DigiPoint");
   else if (strcmp(s,"RN") == 0) strcpy(str,"ROSE/FPAC-Node");
   else if (strcmp(s,"AK") == 0) strcpy(str,"AK1A-DX-Cluster");
   else if (strcmp(s,"NL") == 0) strcpy(str,"NETCHL");
   else if (strcmp(s,"NS") == 0) strcpy(str,"NOS");
   else if (strcmp(s,"SU") == 0) strcpy(str,"SuperVozelj");
   else if (strcmp(s,"WN") == 0) strcpy(str,"WX-Net");
   else if (strcmp(s,"UX") == 0) strcpy(str,"UNIX");
   else strcpy(str,fstr[spr].zeile[5]);
   return str;
}

char *StatAbk(char *s, char *str)
{
   strcpy(s,str);
   if (strcmp(str,"OK") == 0) strcpy(s,"");
   else if (strcmp(str,"TE") == 0) strcpy(s,fstr[spr].zeile[6]);
   else if (strcmp(str,"PL") == 0) strcpy(s,fstr[spr].zeile[7]);
   else if (strcmp(str,"IS") == 0) strcpy(s,fstr[spr].zeile[8]);
   else if (strcmp(str,"DF") == 0) strcpy(s,fstr[spr].zeile[9]);
   else strcpy(s,fstr[spr].zeile[17]);
   return s;
}

char *CheckQrg(char *str, const char *s)
{
   double  f = atof(s);
   
   strcpy(str,s);
   if (f <= 0.0) strcpy(str,"      ");
   
   return str;
}

char *CheckBaud(char *str, const char *s)
{
   unsigned long b = atol(s);
   
   strcpy(str,s);
   if (b == 999999l) strcpy(str,"      ");
   if (b == 0l) strcpy(str,"1200");
   
   return str;
}

/* 
 * Zeigt moegliche Linkstrecken an
 */
void ShowLinks(long nr)
{
   long	l, nr2;
   double  l1, b1, l2, b2;
   long	d;
   
   QthInKoor(&l1,&b1,dliste[nr].qth);
   
   for (l = 0l; l <=AnzLink; l++)
     {
	if(lliste[l].LinkStart > nr) break;
	if (lliste[l].LinkStart == nr) 
	  {	
	     nr2 = lliste[l].LinkEnd;
	     QthInKoor(&l2,&b2,dliste[nr2].qth);
	     d = DistDir(l1,b1,l2,b2);
	     if ((d < WrongDist) && (CheckLocator(dliste[nr].qth)) && (CheckLocator(dliste[nr2].qth))) 
	       if (d > 0) printf(fstr[spr].zeile[11],dliste[nr2].call,d);
	     else printf(fstr[spr].zeile[12],dliste[nr2].call);
	     else printf(fstr[spr].zeile[13],dliste[nr2].call);
	     if (lliste[l].LinkBaud == 999999l) 
	       if ((dliste[nr].typ > 128) && (dliste[nr2].typ > 128));
	     else
	       printf(" %s ",fstr[spr].zeile[14]);
	     else if ((lliste[l].LinkStat & TYP) == _BUS) printf("                ");
	     else printf(" %8lu Baud ",lliste[l].LinkBaud);		
	     switch (lliste[l].LinkStat & STATUS)
	       {
		case  _OK:		/* printf(""); */
		  break;
		case _TEST:		printf(" %s",fstr[spr].zeile[15]);
		  break;
		case _PLAN:		printf(" %s",fstr[spr].zeile[16]);
		  break;
		case _DEFEKT:	printf(" %s",fstr[spr].zeile[9]);
		  break;
		case _INSTAB:  printf(" %s",fstr[spr].zeile[8]);
	       }
	     if ((lliste[l].LinkStat & TYP) == _DRAHT) printf(" %s\n",fstr[spr].zeile[17]);
	     else printf("\n");
	     fflush(stdout);
	  }
     }
}

/* 
 * Sucht, ob Infos vorhanden sind
 */
int InfoSuche(const char *s)
{
   char	line[255];
   int		flag = FALSE,f = FALSE, test=FALSE;
   FILE	*dat;
   s9		call1;
   long	nr;
   s2		l;
   
   flag = ((nr = SucheDigi(s)) >= 0l);
   if (flag)
     {
	printf(fstr[spr].zeile[18],s);
	fflush(stdout);		
	dat = fopen(mapname,"r");
	fseek(dat,dliste[nr].info,SEEK_SET);
	do
	  {
	     get(dat,line);
	     if (line[0] != '\0')
	       {
		  CountCommas(line);
		  ExtrFeld(call1,line,1,9);
		  MakeCall(call1);
		  if (strcmp(call1,s) == 0)
		    {
		       char typ[3],sw[3],qrg[10],baud[7];
		       char qth[36],info[48], was1[30], was2[30], st[30];
		       
		       ExtrFeld(typ,line,3,2);
		       StatAbk(st,typ);
		       ExtrFeld(l,line,2,2);
		       if (atoi(l) == 0) test = (strcmp(typ,"OK") != 0);
		       if (!f) 
			 {
			    ExtrFeld(qth,line,12,36);
			    ExtrFeld(info,line,13,48);
			    ExtrFeld(typ,line,5,2);
			    ExtrFeld(sw,line,6,2);
			    TypAbk(was1,typ);
			    SoftAbk(was2,sw);
			    printf(fstr[spr].zeile[19],was1,was2);
			    printf(fstr[spr].zeile[20],qth,dliste[nr].qth,st,info);
			    printf("%s:\n",fstr[spr].zeile[21]);
			    f = TRUE;
			 }
		       ExtrFeld(qrg,line,8,10);
		       if (strcmp(qrg,"") != 0)
			 {
			    ExtrFeld(baud,line,9,7);
			    CheckQrg(was1,qrg);
			    CheckBaud(was2,baud);
			    if (!test)
			      if (atof(was1) > 0.0)
			      printf("%20s MHz %s Baud     %s\n",was1,was2,st);
			    else printf("%s\n",fstr[spr].zeile[22]);
			    else
			      if (atof(was1) > 0.0)
			      printf("%20s MHz %s Baud\n",was1,was2);
			    else printf("%s\n",fstr[spr].zeile[22]);						
			 }
		    }
	       }
	  } while ((strcmp(call1,s) <= 0) && (!feof(dat)));
	fclose(dat);
	printf("%s",fstr[spr].zeile[37]);
	ShowLinks(nr);
	fflush(stdout);
     };
   return flag;
}

/*
 * Sucht Digis mit dem angegebenem Prefix
 */
void PrefixSuche(const char *s)
{
   long	i,j = 0;
   s9		call1,str;
   int		l;
   
   strcpy(str,s); 
   i = 0;
   while (str[i] != ' ') i += 1;
   str[i] = '\0';
   l  = (int)strlen(str);
   printf("%s:\n",fstr[spr].zeile[23]);
   fflush(stdout);
   for (i=0;i<AnzDigi;i++)
     {
	mid(call1,dliste[i].call,1,l);
	if (strcmp(call1,str) == 0)
	  {
	     printf("%-12s",dliste[i].call);
	     if (((j += 1l) % 6) == 0) printf("\n");
	  };
     }
   printf("\n");
   fflush(stdout);
}	

/*
 * Welche Infos werden denn benoetigt
 */
void DigiInfos(const char *s)
{
   char 	str[19];
      
   strcpy(str,s);
   MakeCall(str);
   if (CheckLocator(str)) LocatorInfo(str);
   else if (!InfoSuche(str)) PrefixSuche(str);
}

/*
 * Autorouter, aus dem Pascal-Programm von Holger DH4DAI und dem
 * von ihm angegebenem Buch entnommen
*/
int AutoRoute(long a, long b)
{
   long	i, j, k, d, dd, max, ka;
   long	*kant, *next, *rn;
   int 	f2;
   
   rn = (long *)calloc(AnzLink, sizeof(long));
   kant = (long *)calloc(AnzLink, sizeof(long));
   next = (long *)calloc(AnzLink, sizeof(long));
   
   route[0] = 0l;
   j = 0;
   
   for (k = 0; k < AnzLink; k++)
     {
	ka = lliste[k].LinkStart;
	if (ka != j) 
	  {
	     kant[ka] = k;
	     j = ka;
	  }
     }
   max =  LONG_MAX;					/* ziemlich viel :-) */
   for (i = 0; i < AnzDigi; i++)
     {
	next[i] = 0;
	rn[i] = max;
     }
   rn[a] = 0;
   i = a;
   next[a] = -1;
   do
     {
	ka = kant[i];
	for (k = ka; k < AnzLink; k++)
	  {
	     if (lliste[k].LinkStart != i) k = AnzLink;
	     else
	       {
		  if (dliste[j].typ > 128) dliste[j].typ = 255 - dliste[j].typ;
		  j = lliste[k].LinkEnd;
		  if ((!LinkMask[k]) && (!DigiMask[j]) 
		      && ((dliste[j].typ == _DIGI) || (dliste[j].typ ==_TCPIP) || (dliste[j].typ == 255 - _DIGI) || (j == b)) 
		      && ((lliste[k].LinkStat & STATUS) < 3)
		      ) 
		    {
		       d = rn[i] + (255 - (int)CalcQual(lliste[k].LinkBaud,lliste[k].LinkStat));
		       if (d < rn[j])
			 {
			    rn[j] = d;
			    route[j] = i;
			    if (next[j] == 0)
			      {
				 next[j] = next[a];
				 next[a] = j;
			      }
			 }
		    }
	       }
	  }
	if (next[a] < 0) return -1;
	ka = a;
	d = max;
	do
	  {
	     i = next[ka];
	     dd = rn[i];
	     if (dd < d)
	       {
		  j = ka;
		  d = dd;
	       }
	     ka = i;
	  } while (next[i] > 0);
	i = next[j];
	next[j] = next[i];
     } while (i != b);
   ka = b;
   i = 1;
   do
     {
	rn[i] = ka;
	f2 = (ka == a);
	if (!f2)
	  {
	     ka = route[ka];
	     i += 1;
	  }
     } while (!f2);
   ka = i;
   for (i = 0;i < ka; i++) route[i] = rn[ka - i];
   return ka;
}

/*
 * Ausgabe eines Links
 */
void ShowLink(long i, long j, double *q, long *d)
{
   long 			l = 0l;
   unsigned long	b;
   
   while ((l < AnzLink) && ((lliste[l].LinkStart != i) ||
			    (lliste[l].LinkEnd != j))) l += 1l;
  
     if (((b = lliste[l].LinkBaud) == 999999l) || ((lliste[l].LinkStat&(_DRAHT | _BUS)) != 0) )
     printf("<----> ");
   else printf("<%2ldk%1ld> ",b/1000,(b%1000)/100);
   *q *= CalcQual(lliste[l].LinkBaud,lliste[l].LinkStat&STATUS) / 255.0;
   *d += Dist(i,j);
}

/*
 * Autorouter aufrufen und Daten passend ausgeben
 */
void routing(const char *d1, const char *d2)
{
   char 	str[19];
   long	DigiA, DigiB;
   long	DistDirekt, dist;
   int		ka, items, i;
   double	qual;
   
   
   items=4;
   strcpy(str,d1);
   MakeCall(str);
   DigiA = SucheDigi(str);
   strcpy(str,d2);
   MakeCall(str);
   DigiB = SucheDigi(str);
   if ((DigiA != ERROR) && (DigiB != ERROR))
     {
	ka = AutoRoute(DigiA, DigiB);
	printf(fstr[spr].zeile[24],dliste[DigiA].call,dliste[DigiB].call);
	if ((ka > 0) && (ka < LinkDepth + 1))
	  {
	     DistDirekt = Dist(DigiA,DigiB);
	     qual = 1.0;
	     dist = 0l;
	     printf("       "); 
	     for (i = 0; i < ka-1; i++)
	       {
		  printf("%s ",dliste[route[i]].call);
		  if (((i + 1) % items) == 0) printf("\n");
		  ShowLink(route[i],route[i+1],&qual,&dist);
	       }
	     printf("%s\n\n",dliste[route[i]].call);
	     if (DistDirekt < WrongDist)
	       printf("%s %ld km\n",fstr[spr].zeile[25],DistDirekt);
	     if (dist < WrongDist)
	       {
		  printf("%s %ld km\n",fstr[spr].zeile[26],dist);
		  if (dist != 0.0)
		    printf("%s %5.2f %c  \n",fstr[spr].zeile[27],
			    (double)DistDirekt/(double)dist * 100.0,'%');
		  else
		    printf("%s 100.00 %c  \n",fstr[spr].zeile[27],'%');
	       }
	     printf("%s : %5.2f %c  \n",fstr[spr].zeile[28],qual * 100,'%');
	  }
	else printf("%s\n",fstr[spr].zeile[29]);
     }
   else
     {
	if (DigiA == ERROR) printf("%s %s\n",d1,fstr[spr].zeile[30]);
	if (DigiB == ERROR) printf("%s %s\n",d2,fstr[spr].zeile[30]);
     }
}

int MaskLink(int d1, int d2)
{
   long	i;
   for (i = 0; i < AnzLink; i++)
     {
	if ((lliste[i].LinkStart == d1) && (lliste[i].LinkEnd == d2)) LinkMask[i] = TRUE;
	if ((lliste[i].LinkStart == d2) && (lliste[i].LinkEnd == d1)) LinkMask[i] = TRUE;
     }
   return 0;
}

int masking(int anz, const s80 parms[])
{
   long	d1, d2;
   char 	digi1[20], digi2[20];
   int		i,p;
   for (i = 3; i < anz; i++)
     {
	strcpy(digi1,parms[i]);
	p = strpos(digi1,'/');
	if (p < 0)
	  {
	     MakeCall(digi1);
	     if ((d1 = SucheDigi(digi1)) != ERROR) DigiMask[d1] = TRUE;
	  }
	else
	  {
	     strcpy(digi2,digi1);
	     entf(digi2,p);
	     MakeCall(digi2);
	     digi1[p-1] = '\0';
	     MakeCall(digi1);
	     d1 = SucheDigi(digi1);
	     d2 = SucheDigi(digi2);
	     if ((d1 != ERROR) && (d2 != ERROR)) MaskLink(d1,d2);
	  }
     }
   return 0;
}

int masking2(void)
{
   long	d1, d2;
   char 	digi1[20], digi2[20];
   int		p;
   FILE    *tmpmask;
   char    tmpname[512];
   
   strcpy(tmpname,HOME);
   strcat(tmpname,"/digiinfo.msk");
   
   if ((tmpmask = fopen(tmpname,"r")) != NULL)
     {
	while (!feof(tmpmask))
	  {
	     get(tmpmask,digi1);
	     if (digi1[0] != '\0')
	       {
		  strupr(digi1);
		  p = strpos(digi1,'/');
		  if (p < 0)
		    {
		       MakeCall(digi1);
		       if ((d1 = SucheDigi(digi1)) != ERROR) DigiMask[d1] = TRUE;
		    }
		  else
		    {
		       strcpy(digi2,digi1);
		       entf(digi2,p);
		       MakeCall(digi2);
		       digi1[p-1] = '\0';
		       MakeCall(digi1);
		       d1 = SucheDigi(digi1);
		       d2 = SucheDigi(digi2);
		       if ((d1 != ERROR) && (d2 != ERROR)) MaskLink(d1,d2);
		    }
	       }
	  }
     }
   return 0;	
}

/*
 * Ein kleines Hauptprogramm muss auch da sein
*/	
int main(int argc, const char *argv[])
{
   char	dummy[512];
   int 	pc = argc, p,
   erstellt = TRUE; 
   FILE	*globals;
   
   for (p = 0; p < pc; p++) 
     {
	strcpy(cmdargs[p],argv[p]);
     }
   for (p=1; p< pc; p++)
     {
	strupr(cmdargs[p]);
     }
   
   initstr();
   
   strcpy(dummy,HOME);
   strcat(dummy,"/digiinfo.inf");
   
   if ((globals = fopen(dummy,"r")) == NULL)
     {
	printf("%s\n",fstr[_G_].zeile[32]);
	strcpy(OwnLoc,MYLOC);
	MaxKM = MYMAXKM;
	defaultsprache = _G_;
     }
   else
     {
	get(globals,dummy);
	strcpy(OwnLoc,dummy);
	strupr(OwnLoc);
	if (!CheckLocator(OwnLoc)) strcpy(OwnLoc,MYLOC);
	get(globals,dummy);
	MaxKM = atol(dummy);
	if (MaxKM == 0) MaxKM = MYMAXKM;
	get(globals,dummy);
	defaultsprache = atoi(dummy);
	if (defaultsprache >= MAXSPR) defaultsprache = _G_;
	spr=defaultsprache;
	get (globals,dummy);
	if (dummy[0]!='\0')    /* environ-line exists */
	  if (getenv(dummy)!=NULL)
	  {
	     int i;
	     char pre[4];
	     strcpy(pre,",");
	     strncat(pre,getenv(dummy),2); /* get first two chars */
	     strupr(pre);
	     strcat(pre,",");
	     for (i = 0; i < MAXSPR; i++)
	       if (strstr(pref[i],pre) != NULL)  spr = i;
	  }
     }		
   
     if (cmdargs[pc-1][0] == '-')
     {
	int i;
	char pre[4];
	strcpy(pre,",");
	strncat(pre,&cmdargs[pc-1][1],2); /* get first two chars of callsign */
	strcat(pre,",");
	for (i = 0; i < MAXSPR; i++)
	  if (strstr(pref[i],pre) != NULL)  spr = i;
	pc--;
     }

   printf(fstr[spr].zeile[33],VERSION);
   fflush(stdout);
   
   if (pc == 1) KurzAnleitung();
   else
     {
	if (LoadFST() < 0) erstellt = Erstelle_FST();
	
	if (erstellt)	
	  {
	     
	     switch (pc)
	       {
		case 2	:	DigiInfos(cmdargs[1]);
		  break;
		default	:	route = (long *)calloc(AnzLink, sizeof(long));
		  DigiMask = (long *)calloc(AnzDigi, sizeof(long));
		  LinkMask = (long *)calloc(AnzLink, sizeof(long));
		  if (pc > 3) masking(pc,cmdargs);
		  masking2();
		  routing(cmdargs[1], cmdargs[2]);
		  free(route);
		  free(DigiMask);
		  free(LinkMask);
	       };
	     free(lliste);
	     free(dliste);
	  };
     };
   fflush(stdout);
   
   
   
   return 0;
}

