/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*  xconvers.h  convers-client 	dl3bzn
 *		parts by dk5sg (convers 2.53)
 *		23.10.94
 */


#include <sys/types.h>
#include <stdio.h>      	/* must be before pwd.h */
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>

#include "buildsaddr.h"
#include "xconvers.h" 
#include "menu_util.h"
#include "menu.h"
#include "file.h"
#include "text.h"
#include "misc.h"


/* globals */
extern 	char *optarg;
extern 	int optind;
extern String fallbackResources[];

int 		socket_fd = 0;		/* socket filedescriptor */
FILE		*log_stream = NULL;	/* steam for recording file */
XtAppContext	app_context;


/*---------------------------------------------------------------------------
 *   CreateForm   create everything
 */
void CreateForm(parent, app_w)
	Widget		parent;
 	AppWidgets	*app_w;
{
  Widget	form, menu, comm, sep;
  char		title[30];
  Arg		arg[10];
  Cardinal	n;

  sprintf(title,"xconvers (0.4.1)");
  n = 0;
  XtSetArg(arg[n], XmNdialogTitle, XmStringCreate(title, XmSTRING_DEFAULT_CHARSET)); n++;
  form = XmCreateForm(parent, "base", arg, n);
  XtManageChild(form);
  app_w->form = form;

  comm = CreateCommands(form, app_w);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++;
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;  
  XtSetArg(arg[n], XmNbottomWidget, comm); n++;  
  XtSetArg(arg[n], XmNbottomOffset, 5); n++;
  sep = XmCreateSeparator(form, "separator", arg, n);
  XtManageChild(sep);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++; 
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++; 
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;  
  XtSetArg(arg[n], XmNbottomWidget, sep); n++;  
  XtSetArg(arg[n], XmNbottomOffset, 5); n++;
  app_w->line = XmCreateText(form, "line", arg, n);

  menu = CreatePulldownMenu(form, app_w);

  n = 0;
  XtSetArg(arg[n], XmNleftAttachment, XmATTACH_FORM); n++; 
  XtSetArg(arg[n], XmNtopAttachment, XmATTACH_WIDGET); n++; 
  XtSetArg(arg[n], XmNtopWidget, menu); n++; 
  XtSetArg(arg[n], XmNbottomAttachment, XmATTACH_WIDGET); n++; 
  XtSetArg(arg[n], XmNbottomWidget, app_w->line); n++; 
  XtSetArg(arg[n], XmNrightAttachment, XmATTACH_FORM); n++; 
  XtSetArg(arg[n], XmNeditMode, XmMULTI_LINE_EDIT);  n++;
  XtSetArg(arg[n], XmNeditable, False);  n++;
  app_w->text = XmCreateScrolledText(form, "text", arg, n);

  XtManageChild(app_w->text);
  XtManageChild(app_w->line);

  /* -- add callbacks -- */
  XtAddCallback(app_w->line, XmNactivateCallback, (XtCallbackProc)HandleLineCB, app_w);
}

/*---------------------------------------------------------------------------
 * handle_XtEvents	handle all queued Xt-Events 
 */
void handle_XtEvents(void)
{
  XEvent	event;

  while(XtAppPending(app_context)) {
    XtAppNextEvent(app_context, &event);
    XtDispatchEvent(&event);
  }
}

/*---------------------------------------------------------------------------
 *   main   
 */
int main(argc, argv)
	int argc;
	char **argv;
{
  Widget		app_shell;	/* Application shell */
  static AppWidgets	*app_widgets;	/* used in other functions */
  static Settings	*settings;	/* settings (server, port,...) */

  char *cp;
  char *name = 0;
  char *note = 0;
  char buffer[2048];
  unsigned char c;
  char outbuf[2048];
  int outcnt = 0;
  int i, ch;
  int size;
  int errflag = 0;
  char *col = 0;
  fd_set actread;
  fd_set chkread;
  struct passwd *pw; 
  struct timeval wait_time;

  /* -- initialize toolkit -- */
  app_shell = XtAppInitialize(&app_context, APPLCLASS, NULL, 0, &argc, argv,
			      fallbackResources, NULL, 0); 

  app_widgets = (AppWidgets*)XtMalloc(sizeof(AppWidgets));
  CreateForm(app_shell, app_widgets);	 	/* create form */
  app_widgets->file_box = NULL;
   
  XtRealizeWidget(app_shell);

  signal(SIGPIPE, SIG_IGN); 

  /* -- set name -- */
  if (!note && (pw = getpwuid(getuid()))) {
    name = pw->pw_name;
    note = pw->pw_gecos;
    if ((cp = strchr(note, ','))) *cp = 0;
  }
  if (!note || !*note) note = "@";

  /* -- store (default) settings -- */
  settings = (Settings*)XtMalloc(sizeof(Settings));	
  strcpy(settings->server, ResourceText(app_widgets->form, "defaultServer", "localhost"));
  strcpy(settings->port, ResourceText(app_widgets->form, "defaultPort","3600"));
  strcpy(settings->name, ResourceText(app_widgets->form, "defaultName", name));
  strcpy(settings->pnote, ResourceText(app_widgets->form, "defaultPnote", note));
  strcpy(settings->channel, ResourceText(app_widgets->form, "defaultChannel", "0"));
  app_widgets->set = settings;

  /* -- additional command line options -- */
  while ((ch = getopt(argc, argv, "c:p:s:")) != EOF)
    switch (ch) {
      case 'c': strcpy(settings->channel, optarg);		break;
      case 'p': strcpy(settings->pnote, optarg);
		break;
      case 's': if((col=strchr(optarg, ':')) == NULL ) {  errflag = 1; break; }
  	        if(*(char*)++col) strcpy(settings->port, col);
	        *(col-1) = 0;
  	        if(*optarg) strcpy(settings->server, optarg);
      	        break;
      case '?': errflag = 1;	break;
    }

  if (errflag || optind < argc ) {
    fprintf(stderr, "usage: xconvers [-s host:service] [-c channel] [-p personal_note]\n");
    stop("");
  }

  /* -- Input / Output (socket) -- */
  for( ; ; )	{			/* endless loop */
     if(socket_fd) {
  	FD_ZERO(&chkread);
  	FD_SET(socket_fd, &chkread); 
     }
     else usleep(10000L);		/* wait 10 milliseconds */

     while(socket_fd) {			/* while connected */
       wait_time.tv_sec = 0L;
       wait_time.tv_usec = 10000L;
       actread = chkread;
       select(socket_fd+1, &actread, 0, 0, &wait_time);
       /* -- Output -- */
       if (FD_ISSET(socket_fd, &actread)) {
         size = read(socket_fd, buffer, sizeof(buffer));	/* read from socket */
         if (size <= 0) stop("");				/* wrong? (quit  /q)  */
         /* -- output char -- */
         for (i = 0; i < size; i++) {
	   c = buffer[i];
	   if (c != '\r') outbuf[outcnt++] = c;		/* fill outputbuf. (LF ignor.) */
	   if (c == '\n' || c == '\r' || outcnt == sizeof(outbuf)) { /* CR or buffer full? */
             outbuf[outcnt] = 0;
	     insert(outbuf, app_widgets);
	     outcnt = outbuf[0] = 0;		/* empty outbuf.*/
	   }
         } /* for... output char */
       } /* else... Output */
       handle_XtEvents();
     } /* while(socket_fd) while connected */
     handle_XtEvents();
  } /* for(;;) endless loop */
exit(0);
}

