/* SCCS-info %W% %E% */

/*--------------------------------------------------------------------*/
/*                                                                    */
/*              VCG : Visualization of Compiler Graphs                */
/*              --------------------------------------                */
/*                                                                    */
/*   file:         main.h                                             */
/*   version:      1.00.00                                            */
/*   creation:     1.4.1993                                           */
/*   author:       I. Lemke  (...-Version 0.99.99)                    */
/*                 G. Sander (Version 1.00.00-...)                    */
/*                 Universitaet des Saarlandes, 66041 Saarbruecken    */
/*                 ESPRIT Project #5399 Compare                       */
/*   description:  Top level program                                  */
/*   status:       in work                                            */
/*                                                                    */
/*--------------------------------------------------------------------*/


/* $Id: main.h,v 3.11 1994/08/08 16:01:47 sander Exp $ */

/*
 *   Copyright (C) 1993, 1994 by Georg Sander, Iris Lemke, and
 *                               the Compare Consortium 
 *
 *  This program and documentation is free software; you can redistribute 
 *  it under the terms of the  GNU General Public License as published by
 *  the  Free Software Foundation;  either version 2  of the License,  or
 *  (at your option) any later version.
 *
 *  This  program  is  distributed  in  the hope that it will be useful,
 *  but  WITHOUT ANY WARRANTY;  without  even  the  implied  warranty of
 *  MERCHANTABILITY  or  FITNESS  FOR  A  PARTICULAR  PURPOSE.  See  the
 *  GNU General Public License for more details.
 *
 *  You  should  have  received a copy of the GNU General Public License
 *  along  with  this  program;  if  not,  write  to  the  Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  The software is available per anonymous ftp at ftp.cs.uni-sb.de.
 *  Contact  sander@cs.uni-sb.de  for additional information.
 */


/* $Log: main.h,v $
 * Revision 3.11  1994/08/08  16:01:47  sander
 * Attributes xraster, xlraster, yraster added.
 *
 * Revision 3.10  1994/08/05  12:13:25  sander
 * Treelayout added. Attributes "treefactor" and "spreadlevel" added.
 * Scaling as abbreviation of "stretch/shrink" added.
 *
 * Revision 3.9  1994/08/02  15:36:12  sander
 * CHECKNODE option added to allow tracing of properties
 * of one single node.
 *
 * Revision 3.8  1994/06/07  14:09:59  sander
 * Splines implemented.
 * HP-UX, Linux, AIX, Sun-Os, IRIX compatibility tested.
 * The tool is now ready to be distributed.
 *
 * Revision 3.7  1994/05/17  16:39:10  sander
 * attribute node_align added to allow nodes to be centered in the levels.
 *
 * Revision 3.6  1994/05/16  08:56:03  sander
 * shape attribute (boxes, rhombs, ellipses, triangles) added.
 *
 * Revision 3.5  1994/05/05  08:20:30  sander
 * Algorithm late labels added: If labels are inserted
 * after partitioning, this may yield a better layout.
 *
 * Revision 3.4  1994/04/27  16:05:19  sander
 * Some general changes for the PostScript driver.
 * Horizontal order added. Bug fixes of the folding phases:
 * Folding of nested graphs works now.
 *
 * Revision 3.3  1994/03/04  19:11:24  sander
 * Specification of levels per node added.
 * X11 geometry behaviour (option -geometry) changed such
 * that the window is now opened automatically.
 *
 * Revision 3.2  1994/03/03  14:12:21  sander
 * median centering heuristics added to reduce crossings.
 *
 * Revision 3.1  1994/03/01  10:59:55  sander
 * Copyright and Gnu Licence message added.
 * Problem with "nearedges: no" and "selfloops" solved.
 *
 * Revision 2.4  1994/01/21  19:33:46  sander
 * VCG Version tested on Silicon Graphics IRIX, IBM R6000 AIX and Sun 3/60.
 * Option handling improved. Option -grabinputfocus installed.
 * X11 Font selection scheme implemented. The user can now select a font
 * during installation.
 * Sun K&R C (a nonansi compiler) tested. Some portabitility problems solved.
 *
 * Revision 2.3  1994/01/03  15:29:06  sander
 * First complete X11 version.
 *
 */

#ifndef MAIN_H
#define MAIN_H

/*--------------------------------------------------------------------*/

/* See main.c for explanation
 * --------------------------
 */


/* from parser -------------------------------------------*/
extern FILE     *yyin;

void   line_directive _PP((char *text));
char  *my_itoa        _PP((int x));
void   syntaxerror    _PP((int line,int pos,char *mesge));
void   warning        _PP((int line,int pos,char *mesge));

#define SYERR(x,m) syntaxerror(xfirst_line(x),xfirst_column(x),m)

/* from device --------------------------------------------*/
void gs_wait_message	_PP((int c));

/*---------------------------------------------------------*/

/* Global Variables
 * ----------------
 */

extern char short_banner[];

#ifdef X11
extern char *Xmydiplayname;
extern char *Xmygeometry;
extern int  Xmyborderwidth;
extern char *Xmybackingstore;
#endif

extern int    gblargc;
extern char **gblargv;

extern int silent;
extern int nr_max_errors;
extern int fastflag;
extern int summarize_double_edges;
extern int max_baryiterations;
extern int max_mediumshifts;
extern int max_centershifts;
extern int max_edgebendings;
extern int layout_downfactor; 
extern int layout_upfactor; 
extern int layout_nearfactor; 
extern int layout_flag;
extern int crossing_heuristics;
extern int local_unwind;
extern int near_edge_layout;
extern int fine_tune_layout;
extern int touch_file;
extern int edge_label_phase;
extern int nwdumping_phase;

#define TREE_LAYOUT 20

extern unsigned char redmap[];
extern unsigned char greenmap[];
extern unsigned char bluemap[];

extern int maxDepth;
extern int ScreenWidth;
extern int ScreenHeight;
extern int colored;

extern int V_xmin;
extern int V_xmax;
extern int V_ymin;
extern int V_ymax;

extern char Dataname[];
extern char filename[];

#define MAXCLASS  16

extern int G_xymax_final;
extern char *G_title;
extern int G_x, G_y;
extern int G_width, G_height;
extern int G_width_set, G_height_set;
extern int G_xmax, G_ymax;
extern int G_xbase, G_ybase;
extern int G_xspace, G_yspace;
extern int G_orientation;
extern int G_folding;
extern int G_invisible[];
extern int G_color;
extern int G_displayel;
extern int G_dirtyel;
extern int G_shrink, G_stretch;
extern int G_yalign;
extern int G_dspace;
extern int G_spline;
extern int G_flat_factor;

extern int G_xraster;
extern int G_yraster;
extern int G_dxraster;

extern char    *fold_label;   
extern int     fold_textm;   
extern int     fold_width;  
extern int     fold_height;
extern int     fold_borderw;      
extern int     fold_xpos;        
extern int     fold_ypos;       
extern int     fold_color;     
extern int     fold_textc;    
extern int     fold_borderc; 
extern int     fold_shrink; 
extern int     fold_stretch;       
extern char    *fold_info1;       
extern char    *fold_info2;      
extern char    *fold_info3;     
extern int     fold_level;
extern int     fold_shape;
extern int     fold_horder;

extern char    *fold_elabel;
extern int     fold_lstyle;
extern int     fold_thick;
extern int     fold_ecolor;
extern int     fold_arrows;

extern int  info_name_available;
extern char *info_names[3];
extern int  max_nr_classes;
extern int  class_name_available;
extern char **class_names;


extern int grabinputfocus;

extern int locFlag;

/*  Prototypes
 *  ----------
 */

int  main 		_PP((int argc, char *argv[]));
void Fatal_error	_PP((char *x, char *y));
void parse_part		_PP((void));
void visualize_part	_PP((void));
void relayout		_PP((void));

/*--------------------------------------------------------------------*/
 
#endif /* MAIN_H */


