/* SCCS-info %W% %E% */

/*--------------------------------------------------------------------*/
/*                                                                    */
/*              VCG : Visualization of Compiler Graphs                */
/*              --------------------------------------                */
/*                                                                    */
/*   file:         main.c                                             */
/*   version:      1.00.00                                            */
/*   creation:     1.4.1993                                           */
/*   author:       I. Lemke  (...-Version 0.99.99)                    */
/*                 G. Sander (Version 1.00.00-...)                    */  
/*                 Universitaet des Saarlandes, 66041 Saarbruecken    */
/*                 ESPRIT Project #5399 Compare                       */
/*   description:  Top level program                                  */
/*   status:       in work                                            */
/*                                                                    */
/*--------------------------------------------------------------------*/

#ifndef lint
static char *id_string="$Id: main.c,v 3.13 1994/08/08 16:01:47 sander Exp $";
#endif


/*
 *   Copyright (C) 1993, 1994 by Georg Sander, Iris Lemke, and
 *                               the Compare Consortium 
 *
 *  This program and documentation is free software; you can redistribute 
 *  it under the terms of the  GNU General Public License as published by
 *  the  Free Software Foundation;  either version 2  of the License,  or
 *  (at your option) any later version.
 *
 *  This  program  is  distributed  in  the hope that it will be useful,
 *  but  WITHOUT ANY WARRANTY;  without  even  the  implied  warranty of
 *  MERCHANTABILITY  or  FITNESS  FOR  A  PARTICULAR  PURPOSE.  See  the
 *  GNU General Public License for more details.
 *
 *  You  should  have  received a copy of the GNU General Public License
 *  along  with  this  program;  if  not,  write  to  the  Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  The software is available per anonymous ftp at ftp.cs.uni-sb.de.
 *  Contact  sander@cs.uni-sb.de  for additional information.
 */


/* 
 * $Log: main.c,v $
 * Revision 3.13  1994/08/08  16:01:47  sander
 * Attributes xraster, xlraster, yraster added.
 *
 * Revision 3.12  1994/08/05  12:13:25  sander
 * Treelayout added. Attributes "treefactor" and "spreadlevel" added.
 * Scaling as abbreviation of "stretch/shrink" added.
 *
 * Revision 3.11  1994/08/03  14:03:59  sander
 * Version Number to 1.1 changed.
 *
 * Revision 3.10  1994/08/02  15:36:12  sander
 * Local crossing unwinding implemented.
 *
 * Revision 3.9  1994/06/07  14:09:59  sander
 * Splines implemented.
 * HP-UX, Linux, AIX, Sun-Os, IRIX compatibility tested.
 * The tool is now ready to be distributed.
 *
 * Revision 3.8  1994/05/17  16:35:59  sander
 * attribute node_align added to allow nodes to be centered in the levels.
 *
 * Revision 3.7  1994/05/16  08:56:03  sander
 * shape attribute (boxes, rhombs, ellipses, triangles) added.
 *
 * Revision 3.6  1994/05/05  08:20:30  sander
 * Algorithm late labels added: If labels are inserted
 * after partitioning, this may yield a better layout.
 *
 * Revision 3.5  1994/04/27  16:05:19  sander
 * Some general changes for the PostScript driver.
 * Horizontal order added. Bug fixes of the folding phases:
 * Folding of nested graphs works now.
 *
 * Revision 3.4  1994/03/04  19:11:24  sander
 * Specification of levels per node added.
 * X11 geometry behaviour (option -geometry) changed such
 * that the window is now opened automatically.
 *
 * Revision 3.3  1994/03/03  14:12:21  sander
 * median centering heuristics added to reduce crossings.
 *
 * Revision 3.2  1994/03/02  11:48:54  sander
 * Layoutalgoritms mindepthslow, maxdepthslow, minindegree, ... mandegree
 * added.
 * Anchors and nearedges are not anymore allowed to be intermixed.
 * Escapes in strings are now allowed.
 *
 * Revision 3.1  1994/03/01  10:59:55  sander
 * Copyright and Gnu Licence message added.
 * Problem with "nearedges: no" and "selfloops" solved.
 *
 * Revision 2.4  1994/01/21  19:33:46  sander
 * VCG Version tested on Silicon Graphics IRIX, IBM R6000 AIX and Sun 3/60.
 * Option handling improved. Option -grabinputfocus installed.
 * X11 Font selection scheme implemented. The user can now select a font
 * during installation.
 * Sun K&R C (a nonansi compiler) tested. Some portabitility problems solved.
 *
 * Revision 2.3  1994/01/03  15:29:06  sander
 * First complete X11 version.
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "globals.h"
#include "grammar.h"
#include "alloc.h"
#include "usrsignal.h"
#include "folding.h"
#include "steps.h"
#include "main.h"
#include "timing.h"

/*--------------------------------------------------------------------*/

/* Prototypes
 * ==========
 */

/*  These functions are device dependent. Instead including all external
 *  device dependent h-files, we declare them here as external. This
 *  simplifies the selection of the device.
 *  Depending on the device, these functions are implemented in sunvdev.c 
 *  or X11dev.c.
 */

extern void display_part	_PP((void));
extern void setScreenSpecifics  _PP((void));
extern void gs_exit             _PP((int x));

static char *SpecFatal_error	_PP((char *x, char *y));


/* Global variables
 * ================
 */

#define BANNER "USAAR Visualization Tool V.1.1 (C) 1993, 1994 I.Lemke/G.Sander & Compare\n$Revision: 3.13 $ $Date: 1994/08/08 16:01:47 $"

char short_banner[128];

/* Special flags for X11 */

#ifdef X11
char *Xmydiplayname = NULL;
char *Xmygeometry   = NULL;
int  Xmyborderwidth = 2;
char *Xmybackingstore = NULL;
extern char Xfontname[512];
#endif

/*  Flag: indicates that we should be silent
 */

int silent = 0;

/*  Maximal number of parse errors
 */

int nr_max_errors = 16;

/*  Flag to suppress various tests
 */

int fastflag = 0;

/*  Flag to summarize multiple edges without label between same nodes.
 */

int summarize_double_edges = 0;

/*  Layout flag:  To change the layout may reduce the number of crossings, 
 *  but it takes. The standard layout is the fastest.
 *
 *    0   ->  fast standard tree traversal layout
 *    1   ->  maximize depth of the layout (tree traversal heuristic)
 *    2   ->  minimize depth of the layout (tree traversal heuristic)
 *    3   ->  topological order layout, minimize backward edges 
 *    4   ->  maximize depth of the layout (very slow) 
 *    5   ->  minimize depth of the layout (very slow) 
 *    6   ->  presort according increasing indegree  
 *    7   ->  presort according decreasing indegree  
 *    8   ->  presort according increasing outdegree 
 *    9   ->  presort according decreasing outdegree 
 *    10  ->  presort according increasing degree 
 *    11  ->  presort according decreasing degree 
 */

int layout_flag = 0;

/* Crossing heuristics:
 *
 *    0   ->  barycentering
 *    1   ->  mediancentering
 */

int crossing_heuristics = 0;

/* Local crossing unwinding: 1 = yes, 0 = not
 */

int local_unwind = 1;

/*  Near edges allowed: 1 = yes, 0 = not 
 */

int near_edge_layout = 1;

/*  Fine tuning allowed: 1 = yes, 0 = no
 */

int fine_tune_layout = 1;

/*  When to add (nondirty) edge labels:
 *  Phase 0 = directly after folding
 *  Phase 1 = after partitioning
 */

int edge_label_phase = 0;
 
/*  Number of iteration used for barycentering layout
 */

int max_baryiterations = MAXINT;

/*  Number of iteration used for the initial medium shifting
 *  that calculates x positions.
 */

int max_mediumshifts = 100;

/*  Number of iteration used for the calculation of x positions.
 */

int max_centershifts = 100;

int nwdumping_phase = 0;

/*  Number of iterations during the calculation of bendings.
 */

int max_edgebendings = 100;

/* Layoutfactors that influence the centering of nodes in step3.
 * Normally,  (down,up,near) = (1,1,1)  is appropriate.
 * For trees, (down,up,near) = (10,1,5) gives better layouts.
 * (1,1,1) enforces nodes to be positioned central to all surrounding
 * nodes.
 * (10,1,5) enforces nodes to be positioned central to their successors.
 * (1,10,5) enforces nodes to be positioned central to their predecessors.
 */

int layout_downfactor = 1;
int layout_upfactor   = 1;
int layout_nearfactor = 1;

/*  Edges can be drawn as splines, if G_spline is 1.
 *  G_flat_factor is the factor how splines should be bend.
 */

int G_spline = 0;
int G_flat_factor = 70;


/*  Flag, indicates that after displaying, the specification file
 *  should be touched. For Animation only.
 */

int touch_file = 0;

/*  Flag for X11 only. Indicates that VCG should grab the input focus.
 */

int grabinputfocus;


/*  Color maps
 *  ----------
 *  See alloc.h for color names
 */

unsigned char redmap[CMAPSIZE] = {
	  255, 0, 255, 0, 255, 255, 0, 85, 0, 128, 0, 128, 128,
	  0, 255, 170, 128, 255, 128, 255, 255, 128, 238, 64, 127,
	  240, 160, 154, 255, 255, 218, 0 
};

unsigned char greenmap[CMAPSIZE] = {
	  255, 0, 0, 255, 255, 0, 255, 85, 0, 0, 128, 128, 0,
	  128, 215, 170, 128, 128, 255, 255, 128, 255, 130, 224,
	  255, 230, 32, 205, 192, 165, 112, 0 
};

unsigned char bluemap[CMAPSIZE] = {
	  255, 255, 0, 0, 0, 255, 255, 85, 128, 0, 0, 0, 128,
	  128, 0, 170, 255, 128, 128, 128, 255, 255, 238, 208, 212,
	  140, 240, 50, 203, 0, 214, 0 
};

/*  Screen Specifics
 *  ----------------
 */

int 	maxDepth;           /* Depth of the frame buffer         */
int	ScreenWidth;	    /* Size of the screen                */
int   	ScreenHeight;
int	colored=-1; 	    /* Color screen (1) or BW screen (0) */


/*  Layout Parameters
 *  -----------------
 */

int 	V_xmin;		    /* Minimal and maximal co-ordinates */
int	V_xmax;		    /* that are visible                 */
int	V_ymin;
int	V_ymax;


/*  File Specifics 
 *  --------------
 *  Because of C-stile line directives, the file name used by the
 *  parser for error messages is not always the same as the filename
 *  of the actal input file. 
 */

char	Dataname[1024];     /* Filename that is actual input        */
char    filename[1024];     /* Filename from the view of the parser */ 


/*  Global Graph Attributes 
 *  -----------------------
 */

int	G_xymax_final = 0;

char    *G_title;		/* title of the global graph          */
int     G_x, G_y;		/* window location on the root screen */
int     G_width, G_height;	/* size of the open part of window    */ 
int     G_width_set;		/* indicates that the width  was set. */
int     G_height_set;		/* indicates that the height was set. */
int     G_xmax, G_ymax;		/* maximal size of window             */
int     G_xbase, G_ybase;	/* location of the origin (0,0)       */
int     G_xspace, G_yspace;	/* offset of drawing area             */
int     G_orientation;		/* top-to-bottom, or left-to-right    */
int     G_folding;		/* global graph folded (1) or not (0) */
int     G_color;		/* background color                   */
int     G_displayel;		/* edge labels drawn (1) or not (0)   */
int     G_dirtyel;		/* edge labels dirty (1) or not (0)   */
int     G_shrink, G_stretch;	/* global scaling factors             */
int     G_yalign;
int 	G_dspace;		/* space between dummy nodes	      */

int 	G_xraster;		/* x-raster for real nodes            */
int 	G_yraster;		/* y-raster for real nodes	      */
int 	G_dxraster;		/* x-raster for dummy nodes	      */


/* Default values of folded nodes. This initialization indicates that
 * folded nodes have only a thick border.
 */

char    *fold_label = NULL;     /* folded node label            */
int     fold_textm  = -1;       /* folded node textmode         */
int     fold_width  = -1;       /* folded node width            */
int     fold_height = -1;       /* folded node height           */
int     fold_borderw = 4;       /* folded node border width     */
int     fold_xpos    = 0;       /* folded node x position       */
int     fold_ypos    = 0;       /* folded node y position       */
int     fold_color   = -1;      /* folded node background color */
int     fold_textc   = -1;      /* folded node text color       */
int     fold_borderc = -1;      /* folded node border color     */
int     fold_shrink  = -1;      /* folded node shrink factor    */
int     fold_stretch = -1;      /* folded node stretch factor   */
char    *fold_info1  = NULL;    /* folded node info field 1     */
char    *fold_info2  = NULL;    /* folded node info field 2     */
char    *fold_info3  = NULL;    /* folded node info field 3     */
int 	fold_level = -1;	/* folded node level            */
int 	fold_shape = -1;	/* folded node shape            */
int 	fold_horder = -1;	/* folded node horizontal order */

/* Default values of folded edges. This initialization indicates that
 * folded edges are thick. 
 */
 
char    *fold_elabel=NULL;        /* folded edge label          */
int     fold_lstyle =-1;          /* folded edge line style     */
int     fold_thick  =3;           /* folded edge thickness      */
int     fold_ecolor =-1;          /* folded edge color          */
int     fold_arrows =-1;          /* folded edge arrowsize      */


/*	The names of the info fields. If info_name_available, 
 *      info_names is set to a table of strings we use in the 
 *      interaction menu.
 */

int 	info_name_available;
char 	*info_names[3];

/*	The names of the edge classes. If class_name_available, 
 *      class_names is set to a table of strings we use in the 
 *      interaction menu.
 */


int     max_nr_classes;
int 	class_name_available;
char 	**class_names = NULL;

/* the following flag indicates whether all nodes to be visualized
 * have already locations, or not. If not, then we must layout the
 * graph.
 */

int     locFlag;


/*--------------------------------------------------------------------*/
/*  Main routines 						      */
/*--------------------------------------------------------------------*/


/*  The main program
 *  ================
 */

int 	gblargc;
char	**gblargv;

#define nextarg()   (++i<argc?argv[i]:(SpecFatal_error(\
      "argument missing in command line !","Try option -h")))

int main(argc, argv)
int 	argc;
char	*argv[];
{
	int i,give_help,give_version,from_stdin;
	char *c;
	char testvar;

	gblargc = argc;
	gblargv = argv;

#ifdef NOINPUTFOCUS
	grabinputfocus = 0;
#else
	grabinputfocus = 1;
#endif

	strcpy(short_banner,
		"USAAR Visualization Tool VCG/XVCG V.1.1 $Revision: 3.13 $");
	c = short_banner;
	while (*c++) if (*c=='$') *c = ' ';

	G_xmax = G_ymax = -1;
	set_signal();
	give_help = give_version = from_stdin = 0;
	Dataname[0]=0;
	if ( argc <= 1) {
		PRINTF("Filename: ");
		if (scanf("%s", Dataname)!=1) {
			FPRINTF(stderr,"Input failed\n");
			return(-1);
		}
	}
	else {  /* Get arguments from the command line */
		i = 1;
		while (i<argc) {
			if (strcmp(argv[i],"-h") == 0)      give_help++;
			else if (strcmp(argv[i],"-H") == 0) give_help++;
			else if (strcmp(argv[i],"-?") == 0) give_help++;
			else if (strcmp(argv[i],"-v") == 0) give_version++;
			else if (strcmp(argv[i],"-V") == 0) give_version++;
			else if (strcmp(argv[i],"-a") == 0) 
				touch_file = atoi(nextarg()); 
			else if (strcmp(argv[i],"-A") == 0) 
				touch_file = atoi(nextarg()); 
			else if (strcmp(argv[i],"-b") == 0)
				max_baryiterations = atoi(nextarg()); 
			else if (strcmp(argv[i],"-B") == 0)
				max_baryiterations = atoi(nextarg()); 
			else if (strcmp(argv[i],"-c") == 0)
				max_centershifts = atoi(nextarg()); 
			else if (strcmp(argv[i],"-C") == 0)
				max_centershifts = atoi(nextarg()); 
			else if (strcmp(argv[i],"-d+") == 0)
				layout_flag = 1;
			else if (strcmp(argv[i],"-D+") == 0)
				layout_flag = 1;
			else if (strcmp(argv[i],"-d++") == 0)
				layout_flag = 4;
			else if (strcmp(argv[i],"-D++") == 0)
				layout_flag = 4;
			else if (strcmp(argv[i],"-d-") == 0)
				layout_flag = 2;
			else if (strcmp(argv[i],"-D-") == 0)
				layout_flag = 2;
			else if (strcmp(argv[i],"-d--") == 0)
				layout_flag = 5;
			else if (strcmp(argv[i],"-D--") == 0)
				layout_flag = 5;
			else if (strcmp(argv[i],"-d0") == 0)
				layout_flag = 3;
			else if (strcmp(argv[i],"-D0") == 0)
				layout_flag = 3;
			else if (strcmp(argv[i],"-dminindeg") == 0)
				layout_flag = 6;
			else if (strcmp(argv[i],"-Dminindeg") == 0)
				layout_flag = 6;
			else if (strcmp(argv[i],"-dmaxindeg") == 0)
				layout_flag = 7;
			else if (strcmp(argv[i],"-Dmaxindeg") == 0)
				layout_flag = 7;
			else if (strcmp(argv[i],"-dminoutdeg") == 0)
				layout_flag = 8;
			else if (strcmp(argv[i],"-Dminoutdeg") == 0)
				layout_flag = 8;
			else if (strcmp(argv[i],"-dmaxoutdeg") == 0)
				layout_flag = 9;
			else if (strcmp(argv[i],"-Dmaxoutdeg") == 0)
				layout_flag = 9;
			else if (strcmp(argv[i],"-dmindeg") == 0)
				layout_flag = 10;
			else if (strcmp(argv[i],"-Dmindeg") == 0)
				layout_flag = 10;
			else if (strcmp(argv[i],"-dmaxdeg") == 0)
				layout_flag = 11;
			else if (strcmp(argv[i],"-Dmaxdeg") == 0)
				layout_flag = 11;
			else if (strcmp(argv[i],"-dtree") == 0)
				layout_flag = TREE_LAYOUT;
			else if (strcmp(argv[i],"-Dtree") == 0)
				layout_flag = TREE_LAYOUT;
			else if (strcmp(argv[i],"-e") == 0)
				nr_max_errors = atoi(nextarg()); 
			else if (strcmp(argv[i],"-E") == 0)
				nr_max_errors = atoi(nextarg()); 
			else if (strcmp(argv[i],"-f") == 0) fastflag = 1;
			else if (strcmp(argv[i],"-F") == 0) fastflag = 1;
			else if (strcmp(argv[i],"-l") == 0) 
				local_unwind = 1-local_unwind;
			else if (strcmp(argv[i],"-L") == 0) 
				local_unwind = 1-local_unwind;
			else if (strcmp(argv[i],"-m") == 0)
				max_mediumshifts = atoi(nextarg()); 
			else if (strcmp(argv[i],"-M") == 0)
				max_mediumshifts = atoi(nextarg()); 
			else if (strcmp(argv[i],"-n") == 0)
				max_edgebendings = atoi(nextarg()); 
			else if (strcmp(argv[i],"-N") == 0)
				max_edgebendings = atoi(nextarg()); 
			else if (strcmp(argv[i],"-s") == 0) 
				summarize_double_edges = 1;
			else if (strcmp(argv[i],"-S") == 0) 
				summarize_double_edges = 1;
			else if (strcmp(argv[i],"-spline") == 0) 
				G_spline = 1;
			else if (strcmp(argv[i],"-SPLINE") == 0) 
				G_spline = 1;
			else if (strcmp(argv[i],"-t") == 0) 
				fine_tune_layout = 0;
			else if (strcmp(argv[i],"-T") == 0) 
				fine_tune_layout = 0;
			else if (strcmp(argv[i],"-SILENT") == 0) 
				silent = 1;
			else if (strcmp(argv[i],"-silent") == 0) 
				silent = 1;
			else if (strcmp(argv[i],"-latelabels") == 0)
				edge_label_phase = 1;
			else if (strcmp(argv[i],"-LATELABELS") == 0)
				edge_label_phase = 1;
			else if (strcmp(argv[i],"-median") == 0)
				crossing_heuristics = 1;
			else if (strcmp(argv[i],"-MEDIAN") == 0)
				crossing_heuristics = 1;
			else if (strcmp(argv[i],"-nocolors") == 0) 
				colored = 0;
			else if (strcmp(argv[i],"-blackwhite") == 0) 
				colored = 0;
#ifdef X11
			else if (strcmp(argv[i],"-display") == 0) 
				Xmydiplayname = nextarg();
			else if (strcmp(argv[i],"-geometry") == 0) 
				Xmygeometry = nextarg();
			else if (strcmp(argv[i],"-bw") == 0) 
				Xmyborderwidth = atoi(nextarg());
			else if (strcmp(argv[i],"-bs") == 0) 
				Xmybackingstore = nextarg();
			else if (strcmp(argv[i],"-font") == 0) 
				strcpy(Xfontname, nextarg());
			else if (strcmp(argv[i],"-grabinputfocus") == 0) 
				grabinputfocus = 1-grabinputfocus;
#endif
			else if (strcmp(argv[i],"-") == 0)  from_stdin++;
			else if (argv[i][0]=='-')  	    give_help++;
			else strncpy(Dataname, argv[i], 1023);
			i++;
		}
	}
	Dataname[1023] = 0;
	if (from_stdin) strcpy(Dataname,"-");

	if (give_version) {
		PRINTF("VCG/XVCG - USAAR Visualization Tool V.1.1\n");
		PRINTF("-----------------------------------------\n");
		PRINTF("$Revision: 3.13 $ $Date: 1994/08/08 16:01:47 $\n");

		PRINTF("Copyright (C) 1993, 1994 I.Lemke/G.Sander & the Compare Consortium.\n");
		PRINTF("This software is supported by the ESPRIT project 5399 Compare.\n");
		PRINTF("We thank the Compare Consortium for the permission to distribute\n");
		PRINTF("this software freely. VCG/XVCG comes with ABSOLUTELY NO WARRANTY.\n");
		PRINTF("You are welcome to redistribute XVCG under certain conditions.\n");
		PRINTF("See the file `COPYING' for details.\n");
		PRINTF("Contact  sander@cs.uni-sb.de  for additional information.\n\n");

		if (Dataname[0]) PRINTF("Input specification: %s\n\n", Dataname);
	}

	if ((!Dataname[0])&&(!give_help)) {
		PRINTF("Filename: ");
		if (scanf("%s", Dataname)!=1) {
			FPRINTF(stderr,"Input failed\n");
			return(-1);
		}
	}
	strncpy(filename,Dataname, 1023);
	filename[1023] = 0;

	if (give_help) {
		PRINTF("%s\n",BANNER);
		PRINTF("Usage:   %s [options] [filename]\n",argv[0]);	
		PRINTF("Options: -h/-H/-?     help.\n");
		PRINTF("Options: -v/-V        print version and copyright.\n");
		PRINTF("Options: -a/-A <num>  Animation handler. <num> > 0 means:\n");
		PRINTF("                      touch input file after display\n");
		PRINTF("                      and sleep for <num> seconds.\n");
		PRINTF("                      <num> < 0 means: send signal USRSIG1\n");
		PRINTF("                      to the caller after display.\n");
		PRINTF("Options: -b/-B <num>  maximal number of iterations\n");
		PRINTF("                      used for bary centering layout\n");
		PRINTF("                      or for median centering layout.\n");
		PRINTF("Options: -c/-C <num>  maximal number of iterations\n");
		PRINTF("                      of center shifts (default: 100).\n");
		PRINTF("Options: -d+/-D+      maximize depth of the layout.\n");
		PRINTF("Options: -d-/-D-      minimize depth of the layout.\n");
		PRINTF("Options: -d++/-D++    maximize depth of the layout (very slow).\n");
		PRINTF("Options: -d--/-D--    minimize depth of the layout (very slow).\n");
		PRINTF("Options: -d0/-D0      minimize backward edges.\n");
		PRINTF("                      This may yield less crossings.\n");
		PRINTF("Options: -dminindeg/  presort the nodes, i.e. layout\n");
		PRINTF("         -Dminindeg   minimal indegrees first.\n");
		PRINTF("Options: -dmaxindeg/  presort the nodes, i.e. layout\n");
		PRINTF("         -Dmaxindeg   maximal indegrees first.\n");
		PRINTF("Options: -dminoutdeg/ presort the nodes, i.e. layout\n");
		PRINTF("         -Dminoutdeg  minimal outdegrees first.\n");
		PRINTF("Options: -dmaxoutdeg/ presort the nodes, i.e. layout\n");
		PRINTF("         -Dmaxoutdeg  maximal outdegrees first.\n");
		PRINTF("Options: -dmindeg/    presort the nodes, i.e. layout\n");
		PRINTF("         -Dmindeg     minimal degrees first.\n");
		PRINTF("Options: -dmaxdeg/    presort the nodes, i.e. layout\n");
		PRINTF("         -Dmaxdeg     maximal degrees first.\n");
		PRINTF("Options: -dtree/      specialized layout for trees.\n");
		PRINTF("         -Dtree       It does not work with non-trees.\n");
		PRINTF("Options: -e/-E <num>  maximal number of parse errors.\n");
		PRINTF("Options: -f/-F        switch fast & dirty & ugly mode on\n");
		PRINTF("                      (implies -b 2 -c 2 -m 2 -n 2).\n");
		PRINTF("Options: -l/-L        switch local crossing optimization\n");
		PRINTF("                      off or on (default: on).\n");
		PRINTF("Options: -m/-M <num>  maximal number of iterations\n");
		PRINTF("                      of medium shifts (default: 100).\n");
		PRINTF("Options: -n/-N <num>  maximal number of iterations\n");
		PRINTF("                      of edge bendings (default: 100).\n");
		PRINTF("Options: -s/-S        switch edge summary layout on.\n");
		PRINTF("Options: -t/-T        switch fine tuning layout off.\n");
		PRINTF("Options: -spline      use splines instead of polygons\n");
		PRINTF("                      to draw edges. WARNING: Drawing\n");
		PRINTF("                      splines is very slow.\n");
		PRINTF("Options: -median      use median instead of barycenter to\n");
		PRINTF("                      minimize crossings. Median is often faster,\n");
		PRINTF("                      doesn't eliminates so mucch crossings.\n");
		PRINTF("Options: -latelabels  create labels after partitioning\n");
		PRINTF("                      of edges (may reduce the number of\n");
		PRINTF("                      crossings).\n");
		PRINTF("Options: -silent      be silent during layout.\n");
		PRINTF("Options: -nocolors    don't use colors.\n");
		PRINTF("Options: -blackwhite  don't use colors.\n");
		PRINTF("Options: -            read from stdin\n");
#ifdef X11
		PRINTF("Special X11 options:\n");
		PRINTF("Options: -display <host:dpy> the X11 server to contact.\n");
		PRINTF("Options: -geometry <geom>    the size/location of the window.\n");
		PRINTF("Options: -bw <num>           the border width of the window.\n");
		PRINTF("Options: -bs NotUseful       the kind of backing store for the window\n");
		PRINTF("Options: -bs WhenMapped      (default is `NotUseful').\n");
		PRINTF("Options: -bs Always\n");
		PRINTF("Options: -font <xfont>       (default is `%s').\n",Xfontname);
		if (!grabinputfocus)
		PRINTF("Options: -grabinputfocus     grab the input focus actively.\n"); 
		else
		PRINTF("Options: -grabinputfocus     avoid to grab the input focus actively.\n"); 
#endif
		exit(0);
	}

	if (fastflag) {
		max_baryiterations = 2;
		max_mediumshifts = 2;
		max_centershifts = 2;
		max_edgebendings = 2;
	}

	testvar = -1;
	if (testvar != -1) {
		FPRINTF(stderr,"Warning: On this system, chars are unsigned.\n");
		FPRINTF(stderr,"This may yield problems with the graph folding operation.\n");
	}

	if (!silent) { FPRINTF(stdout,"Wait "); FFLUSH(stdout); }
	parse_part();
	visualize_part();

	/* Display part calls the display device driver. This is a 
	 * device dependent function !!!
	 * The device driver is basically a loop that draws the graph and
	 * reacts on interaction, until the FINISHING interaction is 
	 * selected.
	 */

	display_part();

	return(0); 
}


/*--------------------------------------------------------------------*/

/*  Fatal Errors 
 *  ============
 *  Note: the parser uses internally the function fatal_error which is
 *  different.
 */

void Fatal_error(x,y)
char *x;
char *y;
{
      	FPRINTF(stderr,"Fatal error: %s %s !\n",x,y);
      	FPRINTF(stderr,"Aborted !\n");
        gs_exit(-1);
}

static char *SpecFatal_error(x,y)
char *x;
char *y;
{
      	FPRINTF(stderr,"Fatal error: %s %s !\n",x,y);
      	FPRINTF(stderr,"Aborted !\n");
        gs_exit(-1);
	/* NOTREACHED */
	return(x);
}

/*--------------------------------------------------------------------*/

/*  Call of the parser
 *  ==================
 */

void	parse_part()
{
	int 	errs,i;

	start_time();
	debugmessage("parse_part","");

	/* We start from the scratch */

	info_name_available = 0;
	for (i=0; i<3; i++) info_names[i]=NULL;

	free_memory();
	yyin = NULL;

	if ( strcmp(Dataname,"-")==0 ) yyin = stdin;
	else {
	 	yyin = fopen(Dataname,"r");
		if (yyin == NULL) Fatal_error("Cannot open",Dataname);
       	}
        errs = parse();

        if ((yyin)&&(yyin!=stdin)) fclose(yyin);

        if (errs>0) Fatal_error("Syntax error","");
	assert((Syntax_Tree!=NULL));

	stop_time("parse_part");
}


/*--------------------------------------------------------------------*/

/*  Call of the visualizer 
 *  ======================
 */

#ifdef X11
static char geom_buffer[128];
#endif

void	visualize_part()
{
	debugmessage("visualize_part","");

	/* Init of the default values */

        G_title         = myalloc(256);
       	strncpy(G_title,Dataname,254);
	G_title[255] = 0;
        G_x             = -1;
        G_y             = -1;

	/* Check the output device */
        setScreenSpecifics(); 	/* this sets G_width, G_height */
	G_width_set  = 0;	/* because they are not set by */
	G_height_set = 0;	/* the specification           */

	if (!G_xymax_final) G_xmax = G_width+10;
        if (!G_xymax_final) G_ymax = G_height+10;
        G_xbase         = 5;
        G_ybase         = 5;
        G_dspace        = 0;
        G_xspace        = 20;
        G_yspace        = 70;
        G_orientation   = TOP_TO_BOTTOM;
        G_folding       = 0;
        G_color         = WHITE;
        G_displayel     = NO;
        G_dirtyel       = NO;
        G_shrink        = 1;
        G_stretch       = 1;
	G_yalign        = AL_CENTER;
	G_xraster	= 1;
 	G_yraster	= 1;
 	G_dxraster	= 1;

	/* No edge class is hidden: initialize this */

	clear_hide_class();

	/* Check colors */

	if (colored==-1) {
        	if (maxDepth == 1)       colored = 0;
        	else /* maxDepth == 8 */ colored = 1;
	}

	/*  Analyze specification and allocate graph */

	step0_main();
	if (nr_errors!=0) Fatal_error("Wrong specification","");
	check_graph_consistency();

#ifdef X11
	if (!Xmygeometry) {
		if ((G_width_set)&&(G_height_set)) {
			if ((G_x != -1) && (G_y != -1)) 
				SPRINTF(geom_buffer,"%dx%d+%d+%d",
					G_width,G_height,G_x,G_y);
			else 	SPRINTF(geom_buffer,"%dx%d",G_width,G_height);
			Xmygeometry   = geom_buffer;
		}
		else if ((G_x != -1) && (G_y != -1)) {
				SPRINTF(geom_buffer,"+%d+%d",
					G_x,G_y);
			Xmygeometry   = geom_buffer;
		}
	}
#endif

	/* Set drawing area */

	G_xymax_final = 1;
        V_xmin = 0;
        V_xmax = G_xmax;
        V_ymin = 0;
        V_ymax = G_ymax + COFFSET;

	relayout();
}


/* Relayout the graph 
 * ------------------
 */

void relayout()
{
	debugmessage("relayout","");
        start_time();
	free_all_lists();
        if (nr_errors==0) folding();
        stop_time("folding");

        if (!locFlag) {

		if (G_dxraster<=0) G_dxraster = 1;
		if (G_xraster<=0)  G_xraster  = 1;
		if (G_xraster % G_dxraster) {
			G_xraster = (G_xraster/G_dxraster) * G_dxraster;
		}
	
		/* Calculate new layout */

                step1_main();
		if (nr_errors!=0) Fatal_error("Wrong specification","");

		/* step1_main calls tree_main, if TREE_LAYOUT.
		 */

		if (layout_flag != TREE_LAYOUT) {
                	step2_main();
			if (nr_errors!=0) Fatal_error("Wrong specification","");
                	step3_main();
			if (nr_errors!=0) Fatal_error("Wrong specification","");
		}
        	step4_main();
		if (nr_errors!=0) Fatal_error("Wrong specification","");
	}
	else {
		/* Prepare given layout: calculate co-ordinate of edges 
 		 * width and height of nodes etc.
		 */ 

		prepare_nodes();
	}
}
	
/*--------------------------------------------------------------------*/
