/* SCCS-info %W% %E% */

/*--------------------------------------------------------------------*/
/*								      */
/*		VCG : Visualization of Compiler Graphs		      */ 
/*		--------------------------------------		      */ 
/*								      */
/*   file:	   drawlib2.c					      */
/*   version:	   1.00.00					      */
/*   creation:	   14.4.93					      */
/*   author:	   I. Lemke  (...-Version 0.99.99)		      */ 
/*		   G. Sander (Version 1.00.00-...)		      */ 
/*		   Universitaet des Saarlandes, 66041 Saarbruecken    */
/*		   ESPRIT Project #5399 Compare 		      */ 
/*   description:  Library of drawing routines, part 2		      */ 
/*		   of edges					      */
/*   status:	   in work					      */
/*								      */
/*--------------------------------------------------------------------*/


#ifndef INCLUDE_DRAW 
#ifndef lint
static char *id_string="$Id: drawlib2.c,v 1.1 1994/06/07 14:09:59 sander Exp $";
#endif
#endif


/*
 *   Copyright (C) 1993, 1994 by Georg Sander, Iris Lemke, and
 *                               the Compare Consortium 
 *
 *  This program and documentation is free software; you can redistribute 
 *  it under the terms of the  GNU General Public License as published by
 *  the  Free Software Foundation;  either version 2  of the License,  or
 *  (at your option) any later version.
 *
 *  This  program  is  distributed  in  the hope that it will be useful,
 *  but  WITHOUT ANY WARRANTY;  without  even  the  implied  warranty of
 *  MERCHANTABILITY  or  FITNESS  FOR  A  PARTICULAR  PURPOSE.  See  the
 *  GNU General Public License for more details.
 *
 *  You  should  have  received a copy of the GNU General Public License
 *  along  with  this  program;  if  not,  write  to  the  Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  The software is available per anonymous ftp at ftp.cs.uni-sb.de.
 *  Contact  sander@cs.uni-sb.de  for additional information.
 */


/* 
 * $Log: drawlib2.c,v $
 * Revision 1.1  1994/06/07  14:09:59  sander
 * Initial revision
 *
 */

/************************************************************************
 *  This file contains the 2nd part of the drawlibrary. It contains a
 *  routine to draw a character.
 ************************************************************************/
 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "globals.h"
#include "main.h"
#include "alloc.h"
#include "grprint.h"
#include "drawlib.h"



#ifdef DRAWLIB_TOO_LARGE 


/*  Prototypes
 *  ---------- 
 */

int		mysetto 	_PP((int x,int y));
int		mymoveto	_PP((int x,int y,int c));



/*  Draw a character
 *
 */

void gs_draw_char(c,col)
int c, col;
{
	switch(c) {
	case '!': 
		mysetto(3,2); 
		mymoveto(3,8,col);
		mysetto(3,11); 
		mymoveto(3,11,col);
		break;
	case '?': 
		mysetto(1,4); 
		mymoveto(1,3,col); 
		mymoveto(2,2,col);
		mymoveto(5,2,col); 
		mymoveto(6,3,col); 
		mymoveto(6,4,col);
		mymoveto(4,7,col); 
		mymoveto(4,8,col); 
		mysetto(4,11);
		mymoveto(4,11,col);
		break;
	case '"': 
		mysetto(2,2); 
		mymoveto(2,4,col);
		mysetto(5,2); 
		mymoveto(5,4,col);
		break;
	case '`': 
		mysetto(2,2); 
		mymoveto(2,3,col); 
		mymoveto(4,5,col);
		break;
	case '\'': 
		mysetto(4,2); 
		mymoveto(4,3,col); 
		mymoveto(2,5,col);
		break;
	case ':': 
		mysetto(4,5); 
		mymoveto(5,5,col);
		mymoveto(5,6,col); 
		mymoveto(4,6,col); 
		mymoveto(4,5,col);
		mysetto(4,10); 
		mymoveto(5,10,col);
		mymoveto(5,11,col); 
		mymoveto(4,11,col); 
		mymoveto(4,10,col);
		break;
	case ';': 
		mysetto(4,5); 
		mymoveto(5,5,col);
		mymoveto(5,6,col); 
		mymoveto(4,6,col); 
		mymoveto(4,5,col);
		mysetto(4,10); 
		mymoveto(5,10,col);
		mymoveto(5,11,col); 
		mymoveto(4,11,col); 
		mymoveto(4,10,col);
		mysetto(5,11); 
		mymoveto(5,12,col); 
		mymoveto(3,14,col);
		break;
	case ',': 
		mysetto(4,10); 
		mymoveto(5,10,col);
		mymoveto(5,11,col); 
		mymoveto(4,11,col); 
		mymoveto(4,10,col);
		mysetto(5,11); 
		mymoveto(5,12,col); 
		mymoveto(3,14,col);
		break;
	case '.': 
		mysetto(4,10); 
		mymoveto(5,10,col);
		mymoveto(5,11,col); 
		mymoveto(4,11,col); 
		mymoveto(4,10,col);
		break;
	case '=': 
		mysetto(1,5); 
		mymoveto(6,5,col);
		mysetto(1,9); 
		mymoveto(6,9,col);
		break;
	case '-': 
		mysetto(1,7); 
		mymoveto(6,7,col);
		break;
	case '+': 
		mysetto(0,7); 
		mymoveto(6,7,col);
		mysetto(3,10); 
		mymoveto(3,4,col);
		break;
	case '*': 
		mysetto(1,5); 
		mymoveto(2,6,col);
		mymoveto(4,6,col); 
		mymoveto(5,7,col);
		mysetto(3,4); 
		mymoveto(3,8,col);
		mysetto(1,7); 
		mymoveto(2,6,col);
		mymoveto(4,6,col); 
		mymoveto(5,5,col);
		break;
	case '@': 
		mysetto(6,10); 
		mymoveto(5,11,col);
		mymoveto(3,11,col); 
		mymoveto(1,9,col); 
		mymoveto(1,4,col);
		mymoveto(3,2,col); 
		mymoveto(4,2,col); 
		mymoveto(6,4,col);
		mymoveto(6,7,col); 
		mymoveto(5,8,col); 
		mymoveto(4,8,col);
		mymoveto(3,7,col); 
		mymoveto(3,6,col); 
		mymoveto(4,5,col);
		mymoveto(5,5,col); 
		mymoveto(6,6,col);
		break;
	case '|': 
		mysetto(3,1); 
		mymoveto(3,12,col);
		break;
	case '&': 
		mysetto(6,7); 
		mymoveto(3,11,col);
		mymoveto(1,11,col); 
		mymoveto(0,10,col);
		mymoveto(0,7,col); 
		mymoveto(4,4,col);
		mymoveto(4,3,col); 
		mymoveto(3,2,col);
		mymoveto(2,2,col); 
		mymoveto(1,3,col);
		mymoveto(1,4,col); 
		mymoveto(2,5,col);
		mymoveto(4,9,col); 
		mymoveto(4,10,col);
		mymoveto(6,11,col);
		break;
	case '^': 
		mysetto(1,5); 
		mymoveto(3,3,col);
		mymoveto(4,3,col); 
		mymoveto(6,5,col);
		break;
	case '%': 
		mysetto(0,3); 
		mymoveto(1,2,col); 
		mymoveto(2,2,col);
		mymoveto(3,3,col); 
		mymoveto(3,4,col); 
		mymoveto(2,5,col);
		mymoveto(1,5,col); 
		mymoveto(0,4,col); 
		mymoveto(0,3,col);
		mysetto(3,9); 
		mymoveto(4,8,col); 
		mymoveto(5,8,col);
		mymoveto(6,9,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(4,11,col); 
		mymoveto(3,10,col); 
		mymoveto(3,9,col);
		mysetto(6,2); 
		mymoveto(1,11,col);
		break;
	case '$': 
		mysetto(5,4); 
		mymoveto(5,3,col);
		mymoveto(4,2,col); 
		mymoveto(2,2,col); 
		mymoveto(1,3,col);
		mymoveto(1,4,col); 
		mymoveto(3,6,col); 
		mymoveto(4,6,col);
		mymoveto(5,8,col); 
		mymoveto(5,10,col); 
		mymoveto(4,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col); 
		mymoveto(1,9,col);
		mysetto(3,1); 
		mymoveto(3,12,col);
		break;
	case '#': 
		mysetto(1,11); 
		mymoveto(3,2,col);
		mysetto(1,5); 
		mymoveto(7,5,col);
		mysetto(0,9); 
		mymoveto(6,9,col);
		mysetto(4,11); 
		mymoveto(6,2,col);
		break;
	case '~': 
		mysetto(1,4); 
		mymoveto(2,3,col); 
		mymoveto(3,3,col);
		mymoveto(4,4,col); 
		mymoveto(5,4,col); 
		mymoveto(6,3,col);
		break;
	case '(': 
		mysetto(5,1); 
		mymoveto(2,4,col);
		mymoveto(2,9,col); 
		mymoveto(5,12,col); 
		break;
	case ')': 
		mysetto(2,1); 
		mymoveto(5,4,col);
		mymoveto(5,9,col); 
		mymoveto(2,12,col); 
		break;
	case '[': 
		mysetto(5,1); 
		mymoveto(2,1,col);
		mymoveto(2,13,col); 
		mymoveto(5,13,col);
		break;
	case ']': 
		mysetto(2,1); 
		mymoveto(5,1,col);
		mymoveto(5,13,col); 
		mymoveto(2,13,col);
		break;
	case '{': 
		mysetto(6,1); 
		mymoveto(4,1,col); 
		mymoveto(3,2,col);
		mymoveto(3,6,col); 
		mymoveto(2,7,col); 
		mymoveto(1,7,col);
		mymoveto(2,7,col); 
		mymoveto(3,8,col); 
		mymoveto(3,12,col);
		mymoveto(4,13,col); 
		mymoveto(6,13,col);
		break;
	case '}': 
		mysetto(1,1); 
		mymoveto(3,1,col); 
		mymoveto(4,2,col);
		mymoveto(4,6,col); 
		mymoveto(5,7,col); 
		mymoveto(6,7,col);
		mymoveto(5,7,col); 
		mymoveto(4,8,col); 
		mymoveto(4,12,col);
		mymoveto(3,13,col); 
		mymoveto(1,13,col);
		break;
	case '<': 
		mysetto(6,1); 
		mymoveto(1,6,col);
		mymoveto(6,11,col); 
		break;
	case '>': 
		mysetto(1,1); 
		mymoveto(6,6,col);
		mymoveto(1,11,col); 
		break;
	case '/': 
		mysetto(0,12); 
		mymoveto(6,1,col);
		break;
	case '\\': 
		mysetto(0,1); 
		mymoveto(6,12,col);
		break;
	case '_': 
		mysetto(0,12); 
		mymoveto(6,12,col); 
		break;
	case '0': 
		mysetto(2,10); 
		mymoveto(2,3,col);
		mymoveto(3,2,col); 
		mymoveto(5,2,col);
		mymoveto(6,3,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(3,11,col); 
		mymoveto(2,10,col);
		break;
	case '1': 
		mysetto(2,11); 
		mymoveto(6,11,col);
		mysetto(4,11); 
		mymoveto(4,2,col); 
		mymoveto(2,4,col);
		break;
	case '2': 
		mysetto(1,4); 
		mymoveto(1,3,col);
		mymoveto(2,2,col); 
		mymoveto(5,2,col);
		mymoveto(6,3,col); 
		mymoveto(6,4,col); 
		mymoveto(1,11,col);
		mymoveto(6,11,col);
		break;
	case '3': 
		mysetto(1,4); 
		mymoveto(1,3,col);
		mymoveto(2,2,col); 
		mymoveto(5,2,col);
		mymoveto(6,3,col); 
		mymoveto(6,5,col); 
		mymoveto(5,6,col);
		mymoveto(3,6,col);
		mysetto(5,6); 
		mymoveto(6,7,col); 
		mymoveto(6,10,col);
		mymoveto(5,11,col); 
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		mymoveto(1,9,col);
		break;
	case '4': 
		mysetto(5,11); 
		mymoveto(5,2,col);
		mymoveto(0,8,col); 
		mymoveto(6,8,col);
		break;
	case '5': 
		mysetto(6,2); 
		mymoveto(1,2,col); 
		mymoveto(1,6,col);
		mymoveto(5,6,col); 
		mymoveto(6,7,col); 
		mymoveto(6,10,col);
		mymoveto(5,11,col); 
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		mymoveto(1,9,col);
		break;
	case '6': 
		mysetto(6,3); 
		mymoveto(5,2,col); 
		mymoveto(2,2,col);
		mymoveto(1,3,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col); 
		mymoveto(6,7,col);
		mymoveto(5,6,col); 
		mymoveto(1,6,col);
		break;
	case '7': 
		mysetto(1,3); 
		mymoveto(1,2,col); 
		mymoveto(6,2,col);
		mymoveto(4,10,col); 
		mymoveto(4,11,col);
		break;
	case '8': 
		mysetto(1,5); 
		mymoveto(1,3,col);
		mymoveto(2,2,col); 
		mymoveto(5,2,col);
		mymoveto(6,3,col); 
		mymoveto(6,5,col); 
		mymoveto(5,6,col);
		mymoveto(2,6,col);  
		mymoveto(1,5,col);
		mysetto(5,6); 
		mymoveto(6,7,col); 
		mymoveto(6,10,col);
		mymoveto(5,11,col); 
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		mymoveto(1,7,col); 
		mymoveto(2,6,col);
		break;
	case '9': 
		mysetto(1,10); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col);
		mymoveto(6,3,col); 
		mymoveto(5,2,col); 
		mymoveto(2,2,col);
		mymoveto(1,3,col);  
		mymoveto(1,6,col);  
		mymoveto(2,7,col);
		mymoveto(6,7,col);
		break;
	case 'a': 
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(4,5,col);
		mymoveto(5,6,col); 
		mymoveto(5,10,col); 
		mymoveto(6,11,col);
		mysetto(5,10); 
		mymoveto(4,11,col); 
		mymoveto(2,11,col);
		mymoveto(1,10,col); 
		mymoveto(1,9,col); 
		mymoveto(2,8,col);
		mymoveto(5,8,col);
		break;
	case 'b': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		break;
	case 'c': 
		mysetto(6,6); 
		mymoveto(5,5,col); 
		mymoveto(2,5,col);
		mymoveto(1,6,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col);
		break;
	case 'd': 
		mysetto(6,2); 
		mymoveto(6,11,col);
		mysetto(6,6); 
		mymoveto(5,5,col); 
		mymoveto(2,5,col);
		mymoveto(1,6,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col);
		break;
	case 'e': 
		mysetto(1,8); 
		mymoveto(6,8,col); 
		mymoveto(6,6,col);
		mymoveto(5,5,col); 
		mymoveto(2,5,col);
		mymoveto(1,6,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col);
		break;
	case 'f': 
		mysetto(1,6); 
		mymoveto(5,6,col);
		mysetto(3,11); 
		mymoveto(3,3,col); 
		mymoveto(4,2,col);
		mymoveto(5,2,col); 
		mymoveto(6,3,col);
		break;
	case 'g': 
		mysetto(6,6); 
		mymoveto(5,5,col); 
		mymoveto(2,5,col);
		mymoveto(1,6,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col);
		mysetto(6,5); 
		mymoveto(6,13,col); 
		mymoveto(5,14,col);
		mymoveto(2,14,col); 
		mymoveto(1,13,col);
		break;
	case 'h': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,11,col);
		break;
	case 'i': 
		mysetto(4,2); 
		mymoveto(4,1,col);
		mysetto(2,5); 
		mymoveto(4,5,col); 
		mymoveto(4,11,col);
		break;
	case 'j': 
		mysetto(5,2); 
		mymoveto(5,1,col);
		mysetto(3,5); 
		mymoveto(5,5,col); 
		mymoveto(5,13,col);
		mymoveto(4,14,col); 
		mymoveto(2,14,col);
		mymoveto(1,13,col);
		break;
	case 'k': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,9); 
		mymoveto(2,9,col); 
		mymoveto(5,6,col);
		mysetto(2,9); 
		mymoveto(6,11,col);
		break;
	case 'l': 
		mysetto(2,2); 
		mymoveto(4,2,col); 
		mymoveto(4,11,col);
		break;
	case 'm': 
		mysetto(0,11); 
		mymoveto(0,5,col);
		mymoveto(2,5,col); 
		mymoveto(3,6,col); 
		mymoveto(3,11,col);
		mysetto(3,6); 
		mymoveto(4,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,11,col);
		break;
	case 'n': 
		mysetto(1,11); 
		mymoveto(1,5,col);
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,11,col);
		break;
	case 'o': 
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col); 
		mymoveto(1,6,col);
		break;
	case 'p': 
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col); 
		mymoveto(1,5,col);
		mymoveto(1,15,col);
		break;
	case 'q': 
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col); 
		mymoveto(1,6,col);
		mysetto(6,5); 
		mymoveto(6,15,col);
		break;
	case 'r': 
		mysetto(1,11); 
		mymoveto(1,5,col);
		mysetto(1,6); 
		mymoveto(2,5,col); 
		mymoveto(5,5,col);
		mymoveto(6,6,col);
		break;
	case 's': 
		mysetto(6,6); 
		mymoveto(5,5,col); 
		mymoveto(2,5,col);
		mymoveto(1,6,col); 
		mymoveto(1,7,col); 
		mymoveto(2,8,col);
		mymoveto(5,8,col); 
		mymoveto(6,9,col); 
		mymoveto(6,10,col);
		mymoveto(5,11,col); 
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		break;
	case 't': 
		mysetto(1,5); 
		mymoveto(4,5,col);
		mysetto(3,3); 
		mymoveto(3,10,col); 
		mymoveto(4,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col);
		break;
	case 'u': 
		mysetto(6,5); 
		mymoveto(6,11,col);
		mysetto(6,10); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col); 
		mymoveto(1,5,col);
		break;
	case 'v': 
		mysetto(1,5);
		mymoveto(4,11,col); 
		mymoveto(6,5,col);
		break;
	case 'w': 
		mysetto(0,5); 
		mymoveto(0,10,col); 
		mymoveto(1,11,col);
		mymoveto(2,11,col); 
		mymoveto(3,10,col); 
		mymoveto(3,7,col);
		mysetto(3,10); 
		mymoveto(4,11,col); 
		mymoveto(5,11,col);
		mymoveto(6,10,col); 
		mymoveto(6,5,col);
		break;
	case 'x': 
		mysetto(1,5); 
		mymoveto(1,6,col); 
		mymoveto(6,10,col);
		mymoveto(6,11,col);
		mysetto(1,11); 
		mymoveto(1,10,col); 
		mymoveto(6,6,col);
		mymoveto(6,5,col);
		break;
	case 'y': 
		mysetto(1,5); 
		mymoveto(4,12,col);
		mysetto(6,5); 
		mymoveto(4,12,col); 
		mymoveto(2,15,col);
		mymoveto(1,14,col);
		break;
	case 'z': 
		mysetto(1,5); 
		mymoveto(6,5,col); 
		mymoveto(1,11,col);
		mymoveto(6,11,col);
		break;
	case 'A': 
		mysetto(1,11); 
		mymoveto(1,8,col); 
		mymoveto(3,2,col);
		mymoveto(4,2,col); 
		mymoveto(6,8,col); 
		mymoveto(6,11,col);
		mysetto(1,8); 
		mymoveto(6,8,col);
		break;
	case 'B': 
		mysetto(1,11); 
		mymoveto(1,2,col); 
		mymoveto(4,2,col);
		mymoveto(5,3,col); 
		mymoveto(5,5,col); 
		mymoveto(4,6,col);
		mymoveto(1,6,col);
		mysetto(4,6); 
		mymoveto(6,8,col); 
		mymoveto(6,10,col);
		mymoveto(5,11,col); 
		mymoveto(1,11,col);
		break;
	case 'C': 
		mysetto(6,4); 
		mymoveto(6,3,col); 
		mymoveto(5,2,col);
		mymoveto(2,2,col);
		mymoveto(1,3,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col); 
		mymoveto(6,9,col);
		break;
	case 'D': 
		mysetto(1,2); 
		mymoveto(1,11,col); 
		mymoveto(4,11,col);
		mymoveto(6,9,col); 
		mymoveto(6,4,col); 
		mymoveto(4,2,col);
		mymoveto(1,2,col);
		break;
	case 'E': 
		mysetto(1,2); 
		mymoveto(1,11,col); 
		mymoveto(6,11,col);
		mysetto(1,2); 
		mymoveto(6,2,col);
		mysetto(1,6); 
		mymoveto(5,6,col);
		break;
	case 'F': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,2); 
		mymoveto(6,2,col);
		mysetto(1,6); 
		mymoveto(5,6,col);
		break;
	case 'G': 
		mysetto(6,4); 
		mymoveto(6,3,col); 
		mymoveto(5,2,col);
		mymoveto(2,2,col);
		mymoveto(1,3,col); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(4,11,col); 
		mymoveto(6,10,col);
		mysetto(6,11); 
		mymoveto(6,7,col);
		mymoveto(4,7,col);
		break;
	case 'H': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(6,2); 
		mymoveto(6,11,col);
		mysetto(1,6); 
		mymoveto(6,6,col);
		break;
	case 'I': 
		mysetto(1,2); 
		mymoveto(5,2,col);
		mysetto(3,2); 
		mymoveto(3,11,col);
		mysetto(1,11); 
		mymoveto(5,11,col);
		break;
	case 'J': 
		mysetto(3,2); 
		mymoveto(6,2,col);
		mysetto(5,2); 
		mymoveto(5,10,col);
		mymoveto(4,11,col); 
		mymoveto(2,11,col);
		mymoveto(1,10,col); 
		mymoveto(1,9,col);
		break;
	case 'K': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,7); 
		mymoveto(6,2,col);
		mysetto(1,7); 
		mymoveto(6,11,col);
		break;
	case 'L': 
		mysetto(1,2); 
		mymoveto(1,11,col); 
		mymoveto(6,11,col);
		break;
	case 'M': 
		mysetto(0,11); 
		mymoveto(0,2,col); 
		mymoveto(3,9,col);
		mymoveto(6,2,col); 
		mymoveto(6,11,col);
		break;
	case 'N': 
		mysetto(1,11); 
		mymoveto(1,2,col); 
		mymoveto(6,11,col);
		mymoveto(6,2,col);
		break;
	case 'O': 
		mysetto(1,10); 
		mymoveto(1,3,col);
		mymoveto(2,2,col); 
		mymoveto(5,2,col);
		mymoveto(6,3,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		break;
	case 'P': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,2); 
		mymoveto(5,2,col); 
		mymoveto(6,3,col);
		mymoveto(6,5,col); 
		mymoveto(5,6,col); 
		mymoveto(1,6,col);
		break;
	case 'Q': 
		mysetto(1,10); 
		mymoveto(1,3,col);
		mymoveto(2,2,col); 
		mymoveto(5,2,col);
		mymoveto(6,3,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col);
		mysetto(2,11); 
		mymoveto(5,14,col); 
		mymoveto(6,14,col);
		break;
	case 'R': 
		mysetto(1,2); 
		mymoveto(1,11,col);
		mysetto(1,2); 
		mymoveto(5,2,col); 
		mymoveto(6,3,col);
		mymoveto(6,5,col); 
		mymoveto(5,6,col); 
		mymoveto(1,6,col);
		mysetto(3,6); 
		mymoveto(6,11,col);
		break;
	case 'S': 
		mysetto(6,4); 
		mymoveto(6,3,col);
		mymoveto(5,2,col); 
		mymoveto(2,2,col); 
		mymoveto(1,3,col);
		mymoveto(1,4,col); 
		mymoveto(3,6,col); 
		mymoveto(4,6,col);
		mymoveto(6,8,col); 
		mymoveto(6,10,col); 
		mymoveto(5,11,col);
		mymoveto(2,11,col); 
		mymoveto(1,10,col); 
		mymoveto(1,9,col);
		break;
	case 'T': 
		mysetto(0,2); 
		mymoveto(6,2,col);
		mysetto(3,2); 
		mymoveto(3,11,col);
		break;
	case 'U': 
		mysetto(1,2); 
		mymoveto(1,10,col); 
		mymoveto(2,11,col);
		mymoveto(5,11,col); 
		mymoveto(6,10,col); 
		mymoveto(6,2,col);
		break;
	case 'V': 
		mysetto(1,2); 
		mymoveto(3,11,col); 
		mymoveto(4,11,col);
		mymoveto(6,2,col);
		break;
	case 'W': 
		mysetto(0,2); 
		mymoveto(2,11,col);
		mymoveto(3,5,col); 
		mymoveto(4,11,col); 
		mymoveto(6,2,col);
		break;
	case 'X': 
		mysetto(1,2); 
		mymoveto(1,3,col);
		mymoveto(6,10,col); 
		mymoveto(6,11,col);
		mysetto(1,11); 
		mymoveto(1,10,col);
		mymoveto(6,3,col); 
		mymoveto(6,2,col);
		break;
	case 'Y': 
		mysetto(0,2); 
		mymoveto(3,7,col); 
		mymoveto(6,2,col);
		mysetto(3,7); 
		mymoveto(3,11,col);
		break;
	case 'Z': 
		mysetto(1,2); 
		mymoveto(6,2,col);
		mymoveto(6,4,col); 
		mymoveto(1,9,col); 
		mymoveto(1,11,col);
		mymoveto(6,11,col);
		break;
	}
}

#endif /* DRAWLIB_TOO_LARGE  */

