/* SCCS-info %W% %E% */

/*--------------------------------------------------------------------*/
/*								      */
/*		VCG : Visualization of Compiler Graphs		      */
/*		--------------------------------------		      */
/*								      */
/*   file:	   X11dev.c					      */
/*   version:	   1.00.00					      */
/*   creation:	   9.4.93					      */
/*   author:	   I. Lemke  (...-Version 0.99.99)		      */
/*		   G. Sander (Version 1.00.00-...)		      */
/*		   Universitaet des Saarlandes, 66041 Saarbruecken    */
/*		   ESPRIT Project #5399 Compare 		      */
/*   description:  Device driver for X11    			      */
/*   status:	   in work					      */
/*								      */
/*--------------------------------------------------------------------*/

#ifndef lint
static char *id_string="$Id: X11dev.c,v 3.14 1994/08/09 10:44:03 sander Exp $";
#endif

/*
 *   Copyright (C) 1993, 1994 by Georg Sander, Iris Lemke, and
 *                               the Compare Consortium 
 *
 *  This program and documentation is free software; you can redistribute 
 *  it under the terms of the  GNU General Public License as published by
 *  the  Free Software Foundation;  either version 2  of the License,  or
 *  (at your option) any later version.
 *
 *  This  program  is  distributed  in  the hope that it will be useful,
 *  but  WITHOUT ANY WARRANTY;  without  even  the  implied  warranty of
 *  MERCHANTABILITY  or  FITNESS  FOR  A  PARTICULAR  PURPOSE.  See  the
 *  GNU General Public License for more details.
 *
 *  You  should  have  received a copy of the GNU General Public License
 *  along  with  this  program;  if  not,  write  to  the  Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  The software is available per anonymous ftp at ftp.cs.uni-sb.de.
 *  Contact  sander@cs.uni-sb.de  for additional information.
 */


/* 
 * $Log: X11dev.c,v $
 * Revision 3.14  1994/08/09  10:44:03  sander
 * Spline drawing visibility check added.
 *
 * Revision 3.13  1994/08/08  16:01:47  sander
 * rubberband for pick position operation added.
 * Order of follow edge operation changed: The first edge
 * of a reached node is now the edge we come from.
 *
 * Revision 3.12  1994/08/05  14:27:31  sander
 * Negative values of G_width, etc. corrected.
 *
 * Revision 3.11  1994/08/02  15:36:12  sander
 * Minor change. Some debugmessages added.
 *
 * Revision 3.10  1994/06/07  14:09:59  sander
 * Splines implemented.
 * HP-UX, Linux, AIX, Sun-Os, IRIX compatibility tested.
 * The tool is now ready to be distributed.
 *
 * Revision 3.9  1994/05/16  08:56:03  sander
 * shape attribute (boxes, rhombs, ellipses, triangles) added.
 *
 * Revision 3.8  1994/05/05  12:03:00  sander
 * Follow edge action speedup by a special drawing routine.
 *
 * Revision 3.7  1994/05/05  08:20:30  sander
 * The following dialog boxes added: Center title, Graph layout,
 * Edge Class selection.
 *
 * Revision 3.6  1994/04/27  16:05:19  sander
 * PostScript driver added. New print-dialog box with rubberband.
 *
 * Revision 3.5  1994/04/19  15:17:33  sander
 * Scrollbars for X11 added.
 *
 * Revision 3.4  1994/03/04  19:11:24  sander
 * Specification of levels per node added.
 * X11 geometry behaviour (option -geometry) changed such
 * that the window is now opened automatically.
 *
 * Revision 3.3  1994/03/03  14:12:21  sander
 * Shift the unconnected parts together after the layout.
 *
 * Revision 3.2  1994/03/02  11:48:54  sander
 * Layoutalgoritms mindepthslow, maxdepthslow, minindegree, ... mandegree
 * added.
 * Anchors and nearedges are not anymore allowed to be intermixed.
 * Escapes in strings are now allowed.
 *
 * Revision 3.1  1994/03/01  10:59:55  sander
 * Copyright and Gnu Licence message added.
 * Problem with "nearedges: no" and "selfloops" solved.
 *
 * Revision 1.6  1994/02/14  11:03:24  sander
 * Menu point `Node Information -> Statistics' added.
 * It is now possible to get a statistics of the visibility
 * of nodes and edges.
 *
 * Revision 1.5  1994/02/11  08:19:01  sander
 * The problem with animations in X11 is solved:
 * The window opens and closes now automatically.
 *
 * Revision 1.4  1994/02/10  15:55:00  sander
 * With X11, the output of '/' does not work.
 * Solved.
 *
 * Revision 1.3  1994/01/21  19:33:46  sander
 * VCG Version tested on Silicon Graphics IRIX, IBM R6000 AIX and Sun 3/60.
 * Option handling improved. Option -grabinputfocus installed.
 * X11 Font selection scheme implemented. The user can now select a font
 * during installation.
 * Sun K&R C (a nonansi compiler) tested. Some portabitility problems solved.
 *
 */

/************************************************************************
 * Device driver for X11    
 * ---------------------
 * This module contains basically the interaction main loop, that displays 
 * the graph, reacts on interactions, handles menues, restart actions.
 *
 * This file provides the following functions:
 * ------------------------------------------
 *    display_part()          interaction main loop  
 *    setScreenSpecifics()    initializes the device and ask for device
 *			      specifics 
 *    gs_line(x1,y1,x2,y2,c)  draws a line of color c
 *                            from (x1,y1) to (x2,y2)
 *    gs_rectangle(x,y,w,h,c) draws a filled rectangle of
 *                            color c at (x,y) with size w and h
 *    gs_exit(x)	      exit the program, i.e. clean up and abort
 *    gs_open()	      	      open the device window
 *    gs_close()      	      open the device window
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "globals.h"

#ifdef X11 

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xproto.h>
#include <ctype.h>
#include <math.h>

#include "main.h"
#include "alloc.h"
#include "steps.h"
#include "drawlib.h"
#include "draw.h"
#include "folding.h"
#include "grprint.h"
#include "usrsignal.h"
#include "X11devpb.h"
#include "X11devla.h"
#include "X11devcl.h"
#include "X11devti.h"
#include "X11devfs.h"


/*--------------------------------------------------------------------*/

#undef  EVENT_DEBUG
#define GNUCOPYRIGHT

/* Types
 * -----
 */

/* Menu Items */

typedef struct gs_MenuItem_str {
	Drawable mi_dw;
	Window	 mi_win;
	char 	 mi_selected;
	char 	 mi_selectable;
	char    *mi_txt;
	struct	 gs_Menu_str *mi_submenu;
} *gs_MenuItem;

/* Menu */

typedef struct gs_Menu_str {
	Drawable     m_dw;
	Window	     m_win;
	GC           m_GC;
	XGCValues    m_GCvalues;
	int	     m_width;
	int	     m_height;
	int	     m_len;
	int          m_x;
	int	     m_y;
	char	     m_visible;
	gs_MenuItem  m_item[1];
} *gs_Menu;


#define MENUITEM_DW(x)	((x)->mi_dw)
#define MENUITEM_WIN(x)	((x)->mi_win)
#define MENUITEM_SEL(x)	((x)->mi_selected)
#define MENUITEM_EXP(x)	((x)->mi_selectable)
#define MENUITEM_TXT(x)	((x)->mi_txt)
#define MENUITEM_SUB(x)	((x)->mi_submenu)
#define MENUITEM_HEIGHT 20

#define MENU_DW(x)      ((x)->m_dw)
#define MENU_WIN(x)     ((x)->m_win)
#define MENU_GC(x)      ((x)->m_GC)
#define MENU_GCVAL(x)   ((x)->m_GCvalues)
#define MENU_WIDTH(x)	((x)->m_width)
#define MENU_HEIGHT(x)	((x)->m_height)
#define MENU_LEN(x)	((x)->m_len)
#define MENU_X(x)	((x)->m_x)
#define MENU_Y(x)	((x)->m_y)
#define MENU_VIS(x)	((x)->m_visible)
#define MENU_ITEM(x,i)  ((x)->m_item[(i)-1])



/* Prototypes
 * ----------
 */

#ifdef FAST_X11_DRAWING
void X11_fast_line _PP((int x1,int y1,int x2,int y3,int t,int c));
void X11_fast_dashedline 
		_PP((int x1,int y1,int x2,int y3,int t,int c,int dashlen));
void X11_fast_dottedline 
		_PP((int x1,int y1,int x2,int y3,int t,int c,int dashlen));
void X11_fast_ellipse       _PP((int x,int y,int w,int h,int t,int c));
void X11_fast_filledellipse _PP((int x,int y,int w,int h,int c1, int c2));
#endif


extern void print_all_ps _PP((char *fb, int x1, int y1, int x2, int y2));

void setScreenSpecifics	_PP((void));
void gs_wait_message	_PP((int c));
void InitDevice		_PP((void));
void display_part	_PP((void));
void gs_exit		_PP((int x));
void gs_line		_PP((int fx,int fy,int tx,int ty,int c));
void gs_rectangle	_PP((int x,int y,int w,int h,int c));
void gs_open		_PP((void));
void gs_close		_PP((void));

#undef DRAWDEBUG
#ifdef DRAWDEBUG
void debug_display_part _PP((void));
#endif

static void	ExitDevice		_PP((void));
static void 	setColormap		_PP((void));
static void 	mapColorIndex		_PP((int i,int r,int g,int b));

static void 	ask_window_size		_PP((Window w));

static void	allocateFrame		_PP((void));
static void	allocateMyPixwin	_PP((void));
static void	allocateMyPanel		_PP((void));
static void	allocateScrollbars	_PP((void));

static void set_sizehints _PP((XSizeHints *hp,int mw,int mh,int dw,int dh,int dx,int dy,char *geom));
static int  parse_backing_store	_PP((char *s));

static void	displayCanvas		_PP((void));
static void	buildCanvas		_PP((void));
void 	show_buffer		_PP((void));

#ifdef EVENT_DEBUG
static void prologue	_PP((XEvent *eventp, char *event_name));
#else
#define prologue(a,b)   
#endif

static void 	normalize_scaling	_PP((void));
static void 	set_normal_cursor	_PP((void));
static void	set_busy_cursor		_PP((void));
static void 	set_select_cursor	_PP((void));
static void 	set_fold_cursor		_PP((void));
static void 	set_text_cursor		_PP((void));
static void 	set_leftscroll_cursor	_PP((void));
static void 	set_lowerscroll_cursor	_PP((void));
static void 	set_leftpos_cursor	_PP((void));
static void 	set_lowerpos_cursor	_PP((void));
static void 	reset_cursor		_PP((void));

static void 	clear_panel		_PP((void));
static void 	clear_from_xy_panel	_PP((int x,int y));
static void 	panel_outp		_PP((char *x,char *y,char *z));
static void 	panel_event		_PP((char *x));

static char 	*read_text		_PP((char *msg,int ypos,int mode));

/* Menu handling */

static gs_Menu	allocate_Menu		_PP((int len, char *itemtab[]));

static gs_Menu 	alloc_Menu _PP((int width,int height,int itemw,int itemh,int len,char *itemtab[]));
static gs_MenuItem alloc_MenuItem _PP((int width,int height,int itemw,int itemh,Window win,int pos,char *entry));
static void install_SubMenu	_PP((gs_Menu r, int i, gs_Menu s, Window *t));

static void 	gs_Hide_MenuItem	_PP((gs_Menu m, int i));
static void 	gs_Expose_MenuItem	_PP((gs_Menu m, int i));
static void 	gs_NewText_MenuItem	_PP((gs_Menu m, int i, char *s));
static void 	gs_check_allmenues	_PP((void));
static void 	gs_draw_menu		_PP((gs_Menu m, int x, int y));
static void 	gs_draw_menuitem	_PP((gs_Menu m, int i));
static void 	gs_draw_submenu		_PP((gs_Menu rootm,int i));
static void 	gs_hide_menu		_PP((gs_Menu m));
static void	gs_hide_all_menus	_PP((void));
static int 	gs_check_menureturn	_PP((gs_Menu m));
static int 	gs_check_menuselect	_PP((Window w,gs_Menu m));
static void 	gs_unselect_allmenus	_PP((void));
static void 	gs_unselect_menu	_PP((gs_Menu m));
static void 	gs_redraw_menu		_PP((gs_Menu m));
static int 	gs_check_vis_changed	_PP((gs_Menu m));
static void 	gs_handle_menu_selection _PP((void));

/* Event handling */

static void 	window_main_loop	_PP((void));
static void 	do_KeyPress		_PP((XEvent *eventp));
static void 	do_minimalKeyPress	_PP((XEvent *eventp));
static void 	do_ButtonPress 		_PP((XEvent *eventp));
static void 	do_ButtonRelease 	_PP((XEvent *eventp));
static void     do_EnterNotify 		_PP((XEvent *eventp));
static void 	do_LeaveNotify 		_PP((XEvent *eventp));
static void 	do_Expose		_PP((XEvent *eventp));
static void 	do_ConfigureNotify	_PP((XEvent *eventp));
static void 	do_MotionNotify		_PP((XEvent *eventp));

/* Auxiliaries */

static void	resizeWindow		_PP((void));
static void 	position_abs_scrollbars	_PP((void));
static void 	position_nor_scrollbars	_PP((void));
static void     read_leftscrollbar	_PP((int val));
static void     read_lowerscrollbar	_PP((int val));
static void     read_leftabsscrollbar	_PP((int val));
static void     read_lowerabsscrollbar	_PP((int val));
static void     read_rightscrollbar	_PP((int val));
static char 	*int_to_str		_PP((int n));
char 	*class_num 		_PP((int n));
static char 	*act_info_num		_PP((int n));
static void 	xtextout		_PP((int y,char *msg));
static void 	xinttextout		_PP((int y,char *msg,int i));

/* Ruler management */

static void	ruler_paint				_PP((void));
static void	set_upper_ruler				_PP((void));
static void	set_lower_ruler				_PP((void));
static void	set_left_ruler				_PP((void));
static void	set_right_ruler				_PP((void));
static void	set_h_scale				_PP((int w, int h));
static void	set_v_scale				_PP((int w, int h));
static void	set_value				_PP((int x, int y, char *s));


/* Interactions */

static void 	dispatch_interaction	_PP((gs_Menu m,int item));
static void 	handle_frame_menu	_PP((int item));
static void 	handle_fold_menu	_PP((int item));
static void 	handle_scroll_menu	_PP((int item));
static void 	handle_info_menu	_PP((int item));
static void 	handle_scale_menu	_PP((int item));
static void 	handle_export_menu	_PP((int item));

static void 	default_handler		_PP((XEvent *event));

static void	m_fold_subgraph		_PP((void));
static void	m_unfold_subgraph	_PP((void));
static void	m_fold_region		_PP((void));
static void	m_fold_p2_region	_PP((void));
static void	m_unfold_region		_PP((void));
static void	m_position		_PP((void));
static void	m_pic_position		_PP((void));
void		m_center_node		_PP((GNODE v,int invis));
static int  	m_wait_until_button	_PP((int e));
static void	m_follow_edge		_PP((void));
static void	m_follow_p2_edge	_PP((void));
static void 	m_fetch_region		_PP((void));
static void 	draw_rubberband		_PP((int a,int b,int c,int d));
static void	m_loadsave		_PP((void));
void		m_reload		_PP((void));

static int 	is_readeable		_PP((char *fname));
static int 	is_writable		_PP((char *fname));

static void 	next_follow_edge	_PP((void));
static GNODE 	search_target_node	_PP((GNODE v,GEDGE e));

/* Auxiliaries for interactions */

static void	reset_menues		_PP((void));
static void 	finish_selection	_PP((void));
static void 	handle_selected_node	_PP((GNODE v));
static void	complete_relayout	_PP((void));	

/* Font buffering */

void 		enable_font_buffering	_PP((void));
void 		disable_font_buffering	_PP((void));
int 		set_fontbuffer		_PP((int stretch, int shrink));
void 		draw_fast_char		_PP((int a,int c,int x,int y));
void 		finish_fast_chars	_PP((void));

static void 	alloc_all_fontbuffers 	_PP((void));
static Pixmap 	alloc_fontbuffer	_PP((void));
static void 	fill_fontbuffer		_PP((int buf, int stretch, int shrink));
static void 	new_scale_fontbuffers 	_PP((int stretch, int shrink));
static void 	charbuffer_draw		_PP((int c));


/* Variables
 * ---------
 */

/* Root displays */

static Display *root_display;	/* Root display          */
static int      root_screen;	/* and its screen number */
static Colormap colormap;	/* and its color map     */
static unsigned long carray[CMAPSIZE]; /* and our update */

/* Windows */

static int win_exposed;

static Window	frame_window;
static Window	pix_window;
static Window	panel_window;
static Pixmap   pix_buffer;

static Window	leftscrollbar;
static Window	leftscrolltmb;
static Window	lowerscrollbar;
static Window	lowerscrolltmb;
static Window	rightscrollbar;

static Window	leftabsscrollbar;
static Window	leftabsscrolltmb;
static Window	lowerabsscrollbar;
static Window	lowerabsscrolltmb;
static Window	rightscrolltmb;

static Window	foldregion_touch;
static Window	scroll_touch;
static Window	info_touch;
static Window	scale_touch;
static Window	export_touch;

/* Offsets, the inner pix_window has relatively to the frame_window */

/* #define PIXW_XOFFSET  24 */
#define PIXW_XOFFSET  34 
#define PIXW_YOFFSET  82

#define SCROLLBAR_LEN 20
 
/* Drawable and graphic contexts */

static  Drawable        pix_dw = -1;
static  GC              pix_GC;
static  XGCValues       pix_GCvalues;
static  Drawable        panel_dw = -1;
static  GC              panel_GC;
static  XGCValues       panel_GCvalues;
static  Pixmap 		vcg_icon;

/* Menu's */

static  gs_Menu 	frame_menu;

#define FRAME_MENULEN 16 
static char *frame_menutab[] = {
	"Fold Subgraph       ",
	"Unfold Subgraph     ",
	"Expose/Hide Edges...",
	"Fold Region         ",
	"Unfold Region       ",
	"Scroll              ",
	"Node Information    ",
	"Position            ",
	"Pick Position       ",
	"Center Node...      ",
	"Follow Edge         ",
	"Ruler on            ",
	"Layout...           ",
	"Scale               ",	
	"File                ",
    	"Quit                "	
};

static 	gs_Menu		foldregion_menu;

static char **class_menutab;


static  gs_Menu 	scroll_menu;

#define SCROLL_MENULEN 13 
static char *scroll_menutab[] = {
	"left",		
	"right",	
	"up",		
	"down",		
	"lleft",	
	"rright",	
	"uup",		
	"ddown",	
	"llleft",	
	"rrright",	
	"uuup",		
	"dddown",	
	"origin"	
};


static  gs_Menu		info_menu;

#define INFO_MENULEN  9
static char *info_menutab[INFO_MENULEN];

static 	gs_Menu		scale_menu;

#define SCALE_MENULEN 10
static char *scale_menutab[] = {
	"normal",
	"400 %",
	"200 %",
	"150 %",
	"90 %",
	"80 %",
	"70 %",
	"60 %",
	"50 %",
	"25 %"
};

static 	gs_Menu		export_menu;

#define EXPORT_MENULEN 4
static char *export_menutab[] = {
	"Load...        ",	
	"Reload         ",	
	"Save to file...",
	"Export image...",
};



/*----------------*/

/* the mouse buttons */

#define G_MOUSE_LEFT  1
#define G_MOUSE_RIGHT 3


/* the panel font */

char Xfontname[512] = VCG_DEFAULT_FONT;

static  XFontStruct *panel_font = NULL;

/* the cursors */

static Cursor standard_cursor;     /* Remembered old cursor        */
static Cursor workingCursor;	   /* If the tool is busy          */
static Cursor selectCursor;	   /* If a node should be selected */ 
static Cursor foldCursor;	   /* If a node should be folded   */ 
static Cursor textCursor;	   /* If text input is required    */ 
static Cursor leftscrollCursor;    /* Scroll cursor <->            */
static Cursor lowerscrollCursor;   /* Scroll cursor <->            */
static Cursor leftposCursor;       /* Scroll cursor  ->            */
static Cursor lowerposCursor;      /* Scroll cursor  ->            */
static int    act_cursor;

#define STD_CURSOR 1
#define WOR_CURSOR 2
#define SEL_CURSOR 3
#define FOL_CURSOR 4
#define TXT_CURSOR 5

/* Flag, whether the device is already initialized */

static int device_there = 0;

/* this flag indicates whether the panel is already available
 * for output.
 */

static int panel_there = 0;

/* this counter is used to generate a message that the user 
 * should wait.
 */

static int waitcnt=0;

/* Flag for the animation handler */

int anim_flag = 0;

/* Flag indicates whether the ruler should be drawn.
 */

static int V_ruler = 0;

/* Flag, indicating that a node was selected 
 */

static int selected_flag = 0;

/* Flag to select which info is needed about a node */

static int info_val;
static int truesize;

/* State during the follow_edge command
 */

static GEDGE   act_follow_edge = NULL;
static GNODE   act_follow_node = NULL;
static GNODE   act_follow_target = NULL;
static GEDGE   last_follow_edge = NULL;
static int follow_state;

/* Flag, indicating what to do with file operations: 
 * load or save in different formats
 */

static int load_save_flag;

#define LS_LOAD      0
#define LS_SAVEASCII 1
#define LS_SAVEPPM   2
#define LS_SAVEPS    3


/*--------------------------------------------------------------------*/
/*  Pixmaps                                                           */
/*--------------------------------------------------------------------*/

/* the VCG icon */

static unsigned char icon_image[] = { 
/* Format_version=1, Width=64, Height=64, Depth=1, Valid_bits_per_item=16
 */
 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x08,0x00,0x00,0x00,0x00,
 0x00,0xc0,0x03,0x08,0x00,0x00,0x00,0x00,0x01,0xc0,0x03,0x08,0x00,0x00,0x00,
 0x00,0x01,0xc0,0x03,0x08,0x00,0x00,0x00,0x00,0x01,0xc0,0x03,0x08,0x00,0x00,
 0x00,0x00,0x01,0xc0,0x03,0x08,0x00,0x00,0x00,0x00,0x01,0xc0,0x03,0x08,0x00,
 0x00,0x00,0x00,0x01,0xc0,0x03,0x08,0x00,0x00,0x00,0x00,0x01,0xc0,0xfb,0xff,
 0x0f,0x00,0x00,0xff,0xff,0xc1,0x0b,0x00,0x08,0x00,0x00,0x01,0x00,0xc1,0x0b,
 0x00,0x08,0x00,0x00,0x01,0x00,0xc1,0x0b,0x00,0x08,0x00,0x00,0x01,0x00,0xc1,
 0x0b,0x21,0x08,0x00,0x00,0x41,0x04,0xc1,0x0b,0x10,0x08,0x00,0x00,0x01,0x02,
 0xc1,0x0b,0x55,0x08,0x00,0x00,0x31,0x12,0xc1,0x0b,0x00,0x08,0x00,0x00,0x01,
 0x01,0xc1,0x0b,0x00,0x08,0x00,0x00,0x01,0x00,0xc1,0x0b,0x00,0x08,0x00,0x00,
 0x01,0x00,0xc1,0xfb,0xff,0x0f,0x00,0x00,0x01,0x00,0xc1,0x03,0xe0,0x00,0x00,
 0x00,0xff,0xff,0xc1,0x03,0x00,0x07,0x00,0x00,0xf0,0x00,0xc0,0x03,0x00,0x78,
 0x00,0x00,0x0e,0x00,0xc0,0x03,0x00,0x80,0x03,0xc0,0x01,0x00,0xc0,0x03,0x00,
 0x00,0x1c,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x60,0x06,0x00,0x00,0xc0,0x03,
 0x00,0x40,0x55,0x55,0x05,0x00,0xc0,0x03,0x00,0x20,0x00,0x00,0x08,0x00,0xc0,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x20,0x40,0x00,0x08,0x00,
 0xc0,0x03,0x00,0x00,0x08,0x04,0x00,0x00,0xc0,0x03,0x00,0x20,0x84,0x48,0x08,
 0x00,0xc0,0x03,0x00,0x00,0x20,0x28,0x00,0x00,0xc0,0x03,0x00,0x20,0x00,0x00,
 0x08,0x00,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x20,0x00,
 0x00,0x08,0x00,0xc0,0x03,0x00,0x40,0x55,0x55,0x05,0x00,0xc0,0x03,0x00,0x00,
 0x60,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x18,0x00,0x00,0x00,0xc0,0x03,0x00,
 0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,
 0x00,0x00,0x07,0x07,0x3f,0xf0,0xc3,0x03,0x00,0x30,0x06,0x82,0x60,0x08,0xc6,
 0x03,0x00,0x08,0x0c,0x41,0x40,0x04,0xc4,0x03,0xf8,0xff,0x0c,0x41,0x00,0x04,
 0xc0,0x03,0x08,0x00,0x0c,0x61,0x00,0x06,0xc0,0x03,0x08,0x00,0x98,0x60,0x00,
 0x06,0xc0,0x03,0x08,0x08,0x98,0x60,0x00,0x06,0xc0,0x03,0x88,0x00,0x98,0x60,
 0x00,0x06,0xc0,0x03,0x08,0x12,0x30,0x60,0x00,0x86,0xcf,0x03,0x08,0x21,0x70,
 0x60,0x00,0x06,0xc6,0x03,0x08,0x00,0x70,0x40,0x00,0x04,0xc6,0x03,0x08,0x00,
 0x20,0xc0,0x40,0x0c,0xc6,0x03,0x08,0x00,0x20,0x80,0x21,0x18,0xc6,0x03,0xf8,
 0xff,0x20,0x00,0x1f,0xf0,0xc1,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,
 0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,
 0x03,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
 0xc0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
 0xff,0xff
};


/*--------------------------------------------------------------------*/
/*  Check the screen device                                           */
/*--------------------------------------------------------------------*/

/* We look into the frame buffer: how many colors are available?
 * What is the size of the framebuffer?
 * maxDepth, ScreenWidth, ScreenHeight are set according to this.
 * G_width and G_height are preinitialized with appropriate values.
 */

static int ScreenOpen = 0;

void setScreenSpecifics()
{
	int i;
 
	if (ScreenOpen) return;
	ScreenOpen = 1;
	root_display = XOpenDisplay(Xmydiplayname);
	if (!root_display) {
		FPRINTF(stderr,"Unable to open display %s\n",
			XDisplayName(Xmydiplayname));
		gs_exit(1);
	}
	root_screen = XDefaultScreen (root_display);

	maxDepth	= XDisplayPlanes(root_display,root_screen);
	ScreenWidth	= XDisplayWidth(root_display,root_screen);
	G_width 	= ScreenWidth-100;
	ScreenHeight	= XDisplayHeight(root_display,root_screen); 
	G_height	= ScreenHeight-100;	
	colormap 	= XDefaultColormap(root_display,root_screen);
	carray[0] 	= XWhitePixel(root_display, root_screen);
	for (i = 1; i < CMAPSIZE; i++)
        	carray[i] = XBlackPixel(root_display, root_screen);

}


/*--------------------------------------------------------------------*/
/*  Interaction main loop                                             */
/*--------------------------------------------------------------------*/

/* Initialize the device
 * =====================
 * allocate all frames, windows and menues, display the graph,
 * then go into the interaction main loop. 
 */

static int not_firstcall = 0;
static int no_buffer = 0;

void	display_part()
{
	debugmessage("display_part","");

	/* semaphore: we come only once to here */
	if (not_firstcall) return;
	not_firstcall = 1;
	no_buffer = 1;

	/* first: initialize the device */

	debugmessage("before InitDevice","");
	InitDevice();
	debugmessage("after InitDevice","");

	displayCanvas();
	enable_signal();
	touch_specification();

	/* Now we set the input focus to us and
 	 * go into the interaction main loop 
	 */

	resizeWindow();
	no_buffer = 0;
	show_buffer();
	if (grabinputfocus)
		XSetInputFocus(root_display,frame_window,
				RevertToParent,CurrentTime);

	window_main_loop();

	ExitDevice();
}


/* This is only used for debugging. See step2.c
 * --------------------------------------------
 */

#ifdef DRAWDEBUG
void	debug_display_part()
{
	displayCanvas();
	enable_signal();
	touch_specification();
	/* window_main_loop(); */
}
#endif

/* Initialize the device 
 * ---------------------
 */

void 	InitDevice()
{
	/* first: initialize the device */

	debugmessage("InitDevice","");
	if (device_there) return;
	device_there = 1;
	win_exposed = 0;

	allocateFrame();
	alloc_all_fontbuffers();

	if (colored) setColormap();

	debugmessage("before x11_init_dialog InitDevice","");
	x11_init_dialog(root_display, root_screen);
	debugmessage("before x11_init_layout InitDevice","");
	x11_init_layout_dialog(root_display, root_screen);
	debugmessage("before x11_init_classes InitDevice","");
	x11_init_classes_dialog(root_display, root_screen);
	debugmessage("before x11_init_title InitDevice","");
	x11_init_title_dialog(root_display, root_screen);
	debugmessage("before x11_init_fisel InitDevice","");
	x11_init_fisel_dialog(root_display, root_screen);

	debugmessage("before set_busy_cursor InitDevice","");
	set_busy_cursor();
	debugmessage("end of InitDevice","");
}

/* Exit the device
 * ---------------
 * It is enough to deallocate the root frame, because all its 
 * childs are deallocated automatically.
 */

static void	ExitDevice()
{
	if (!device_there) return; 
	XDestroyWindow(root_display,frame_window);
	x11_destroy_dialog(root_display, root_screen);
	x11_destroy_layout_dialog(root_display, root_screen);
	x11_destroy_classes_dialog(root_display, root_screen);
	x11_destroy_title_dialog(root_display, root_screen);
	x11_destroy_fisel_dialog(root_display, root_screen);
    	XCloseDisplay (root_display);
}


/* Exit all
 * --------
 */

void	gs_exit(x)
int x;
{
	if (device_there) ExitDevice();
	PRINTF("\n");
	exit(x);
}


/* Set the colormap
 * ----------------
 */

static void setColormap()
{
	int i;

	for (i = 1; i < CMAPSIZE; i++)
        	mapColorIndex(i,(int)redmap[i],
			    	(int)greenmap[i],
			    	(int)bluemap[i]);
}


/* Change index i in the color map to the appropriate r, g, b value.
 * ----------------------------------------------------------------
 * Try to get closed as possible to the wanted color.
 */

static void mapColorIndex(i, r, g, b)
int     i;
int     r, g, b;
{
        int     stat;
        XColor  tmp;

        if (i >= CMAPSIZE) return;

        tmp.red   = (unsigned short)(r / 255.0 * 65535);
        tmp.green = (unsigned short)(g / 255.0 * 65535);
        tmp.blue  = (unsigned short)(b / 255.0 * 65535);
        tmp.flags = 0;
        tmp.pixel = (unsigned long)i;
 
        if ((stat = XAllocColor(root_display, colormap, &tmp)) == 0) {
                FPRINTF(stderr, "XAllocColor failed (status = %d)\n", stat);
		FPRINTF(stderr, "If you have a lot of color tools running, which use\n");
		FPRINTF(stderr, "a lot of DIFFERENT colors, it comes to this situation.\n");
		FPRINTF(stderr, "Usually, if you have a small frame buffer with a lookup\n");
		FPRINTF(stderr, "table with only 256 colors, and for instance you put a colored\n"); 
		FPRINTF(stderr, "picture as background image on your X11 desktop,\n"); 
		FPRINTF(stderr, "the color allocation fails. The VCG tool needs 32 colors such\n");
		FPRINTF(stderr, "that all other programs on the desktop should only use 224\n");
		FPRINTF(stderr, "colors, or they should use the same colors as the VCG tool.\n");
		FPRINTF(stderr, "As alternative, you can use the option -nocolors.\n");

                gs_exit(1);
        }
        carray[i] = tmp.pixel;
 
        XFlush(root_display);
}


/*--------------------------------------------------------------------*/
/*  Window management                                                 */
/*--------------------------------------------------------------------*/

/* Ask size of a window w
 * ======================
 * The return values are in window_width and window_height.
 */

static int window_width;
static int window_height;

static void ask_window_size(w)
Window w;
{
	XWindowAttributes retWindowAttributes;

	debugmessage("ask_window_size","");
        if (!XGetWindowAttributes(root_display, w, &retWindowAttributes)) {
                FPRINTF(stderr,"Can't get window attributes.");
                gs_exit(1);
        }

        window_width  = retWindowAttributes.width;
        window_height = retWindowAttributes.height;
}
  
/*--------------------------------------------------------------------*/
/*  Window allocation funtions                                        */
/*--------------------------------------------------------------------*/

/* Allocate root frame
 * -------------------
 * The root frame contains all other display objects.
 */

static void	allocateFrame()
{
	XSetWindowAttributes attr;
	XSizeHints hints;
	unsigned long mask = 0L;
	XAnyEvent event;
	int i;

	/* select for all events */
	attr.event_mask = KeyPressMask           | 
			  ButtonPressMask        | ButtonReleaseMask  |
			  EnterWindowMask        | 
                          ExposureMask           | StructureNotifyMask | 
                          SubstructureNotifyMask | 
                          FocusChangeMask        | OwnerGrabButtonMask;

	attr.background_pixel = XWhitePixel(root_display,root_screen);
	attr.border_pixel = XBlackPixel(root_display,root_screen);

        set_sizehints (&hints, 200, 200, G_width, G_height, 0, 0, 
			Xmygeometry);

	mask |= (CWBackPixel | CWBorderPixel | CWEventMask);

	if (Xmybackingstore) {
		attr.backing_store = parse_backing_store (Xmybackingstore);
		mask |= CWBackingStore;
	}

        frame_window = XCreateWindow (root_display, 
				      RootWindow(root_display, root_screen), 
				      hints.x, hints.y,
                           	      hints.width, hints.height, 
				      Xmyborderwidth, (int)CopyFromParent,
                                      InputOutput, 
				      (Visual *)CopyFromParent,
                           	      mask, &attr);

	/* Create icon */

	vcg_icon = XCreateBitmapFromData(
		root_display,
		frame_window,
		(char *)icon_image,
		64,64);

	/* Open Font */

	panel_font = XLoadQueryFont(root_display,Xfontname);
	if (!panel_font) 
		Fatal_error("Font not found. Please use option -font","");

        XSetStandardProperties(root_display,
                frame_window,
                "VCG",
                "VCG",
                vcg_icon,
                gblargv,
                gblargc,
                &hints
        );

	allocateMyPixwin();
	allocateMyPanel();
	allocateScrollbars();
	frame_menu  = allocate_Menu(FRAME_MENULEN,frame_menutab);

	if (class_menutab) free(class_menutab);
	class_menutab = (char **)malloc(max_nr_classes*sizeof(char *));
	if (!class_menutab) Fatal_error("memory exhausted","");
	for (i=1; i<=max_nr_classes; i++) 
		class_menutab[i-1] = class_num(i);
	foldregion_menu = allocate_Menu(max_nr_classes,class_menutab);
	scroll_menu = allocate_Menu(SCROLL_MENULEN,scroll_menutab);
	for (i=1; i<=6; i++) 
		info_menutab[i-1] = act_info_num(i);
	info_menutab[6] = "Layout Attributes";
	info_menutab[7] = "Label of Node";
	info_menutab[8] = "Statistics";
	info_menu   = allocate_Menu(INFO_MENULEN,  info_menutab);
	scale_menu  = allocate_Menu(SCALE_MENULEN, scale_menutab);
	export_menu = allocate_Menu(EXPORT_MENULEN,export_menutab);

	install_SubMenu(frame_menu,4, foldregion_menu,&foldregion_touch);
	install_SubMenu(frame_menu,6, scroll_menu,     &scroll_touch);
	install_SubMenu(frame_menu,7, info_menu,      &info_touch);
	install_SubMenu(frame_menu,14,scale_menu,     &scale_touch);
	install_SubMenu(frame_menu,15,export_menu,    &export_touch);

        XMapRaised(root_display, frame_window);
        XFlush(root_display);

        /*
         * Wait for Exposure event.
         */
/*
        do { XNextEvent(root_display, (XEvent *)&event);
        } while (  (event.type != Expose || event.window!=pix_window) 
                 &&(event.type != MapNotify || event.window!=pix_window));
 */
#ifndef ULTRIX
#ifndef AIX
        do { XNextEvent(root_display, (XEvent *)&event);
        } while (event.type != Expose || event.window!=pix_window);
#endif
#endif

 
	standard_cursor   = XCreateFontCursor(root_display,XC_left_ptr);
	selectCursor      = XCreateFontCursor(root_display,XC_hand1);
	foldCursor        = XCreateFontCursor(root_display,XC_crosshair);
	workingCursor     = XCreateFontCursor(root_display,XC_watch);
	textCursor        = XCreateFontCursor(root_display,XC_xterm);
	leftscrollCursor  = XCreateFontCursor(root_display,
						XC_sb_v_double_arrow);
	lowerscrollCursor = XCreateFontCursor(root_display,
						XC_sb_h_double_arrow);
	leftposCursor     = XCreateFontCursor(root_display,
						XC_sb_right_arrow);
	lowerposCursor    = XCreateFontCursor(root_display,
						XC_sb_up_arrow);
	set_leftscroll_cursor();
	set_lowerscroll_cursor();
	set_leftpos_cursor();
	set_lowerpos_cursor();
}


/* Allocate PixWindow 
 * ------------------
 * The PixWindow is the real drawing area.
 */


static void	allocateMyPixwin()
{
	XSetWindowAttributes attr;
	unsigned long mask = 0L;

	ask_window_size(frame_window);

	if ( G_xmax < window_width    )	G_xmax = window_width;
	if ( G_ymax < window_height-60)	G_ymax = window_height-60;

	/* select for all events */
	attr.event_mask = KeyPressMask           | ButtonMotionMask   |
			  ButtonPressMask        | ButtonReleaseMask  |
			  EnterWindowMask        | 
                          ExposureMask           | StructureNotifyMask | 
                          SubstructureNotifyMask | 
                          FocusChangeMask        | OwnerGrabButtonMask;

	attr.background_pixel = XWhitePixel(root_display,root_screen);
	attr.border_pixel = XBlackPixel(root_display,root_screen);

	mask |= (CWBackPixel | CWBorderPixel | CWEventMask);

        pix_window = XCreateWindow (root_display, 
				    frame_window, 
				    20,2,
                                    window_width- PIXW_XOFFSET, 
				    window_height-PIXW_YOFFSET,
				    2, (int)CopyFromParent,
                                    InputOutput, 
				    (Visual *)CopyFromParent,
                           	    mask, &attr);

/*        pix_window = XCreateSimpleWindow (root_display, frame_window, 20, 2,
 *                                   window_width- PIXW_XOFFSET, 
 *				    window_height-PIXW_YOFFSET,
 *                                    2,
 *				    XBlackPixel(root_display,root_screen),
 *				    XWhitePixel(root_display,root_screen));
 */

        XMapWindow (root_display, pix_window);

	pix_dw = (Drawable)pix_window;
	pix_GC = XDefaultGC(root_display, root_screen);
        pix_GCvalues.graphics_exposures = False;
        XChangeGC(root_display, pix_GC, GCGraphicsExposures, &pix_GCvalues);
	pix_dw = (Drawable)pix_window;

	/* We buffer this window */

        pix_buffer = XCreatePixmap(root_display,
                        (Drawable)pix_window,
                        (unsigned int)G_xmax+1,
                        (unsigned int)G_ymax+1,
                        (unsigned int)maxDepth);


	pix_dw = (Drawable)pix_buffer;
	if (panel_font)
		XSetFont(root_display,pix_GC,panel_font->fid);
}


/* Allocate PanelWindow 
 * --------------------
 * The PanelWindow is used for text output.
 */


static void	allocateMyPanel()
{
	ask_window_size(frame_window);

        panel_window = XCreateSimpleWindow (root_display, frame_window, 2, 
				    window_height-60+4,
                                    window_width-6, 50,
                                    2,
				    XBlackPixel(root_display,root_screen),
				    XWhitePixel(root_display,root_screen));

        XMapWindow (root_display, panel_window);

	panel_dw = (Drawable)panel_window;
	panel_GC = XDefaultGC(root_display, root_screen);
        panel_GCvalues.graphics_exposures = False;
        XChangeGC(root_display, panel_GC, GCGraphicsExposures, &panel_GCvalues);
	panel_dw = (Drawable)panel_window;
	if (panel_font)
		XSetFont(root_display,panel_GC,panel_font->fid);

	panel_there = 1;
}


/* Allocate Scrollbars
 * -------------------
 */


static int act_x_pos, act_y_pos;

static void	allocateScrollbars()
{
	XSetWindowAttributes attr;
	unsigned long mask = 0L;

	ask_window_size(frame_window);

	act_x_pos = act_y_pos = 0;

	/* select for all events */
	attr.event_mask = KeyPressMask           | ButtonMotionMask   |
			  ButtonPressMask        | ButtonReleaseMask  |
			  EnterWindowMask        | LeaveWindowMask    |
                          ExposureMask           | ResizeRedirectMask | 
                          SubstructureNotifyMask | 
                          FocusChangeMask        | OwnerGrabButtonMask;

	attr.background_pixel = XWhitePixel(root_display,root_screen);
	attr.border_pixel = XBlackPixel(root_display,root_screen);

	mask |= (CWBackPixel | CWBorderPixel | CWEventMask);

        leftscrollbar = XCreateWindow (root_display, frame_window, 11,2, 
                                    8, window_height-PIXW_YOFFSET,
                                    1, (int)CopyFromParent,
				    InputOutput,
				    (Visual *)CopyFromParent,
				    mask, &attr);
        leftscrolltmb = XCreateSimpleWindow (root_display, leftscrollbar, 0,0, 
                                    6, SCROLLBAR_LEN,
                                    1,
				    XWhitePixel(root_display,root_screen),
				    XBlackPixel(root_display,root_screen));
        lowerscrollbar = XCreateWindow (root_display, frame_window, 
				    20, window_height-PIXW_YOFFSET+5, 
                                    window_width-PIXW_XOFFSET+2, 8,
                                    1, (int)CopyFromParent,
				    InputOutput,
				    (Visual *)CopyFromParent,
				    mask, &attr);
        lowerscrolltmb = XCreateSimpleWindow (root_display, lowerscrollbar,0,0, 
                                    SCROLLBAR_LEN, 6,
                                    1,
				    XWhitePixel(root_display,root_screen),
				    XBlackPixel(root_display,root_screen));

        leftabsscrollbar = XCreateWindow (root_display, frame_window, 2,2, 
                                    8, window_height-PIXW_YOFFSET,
                                    1, (int)CopyFromParent,
				    InputOutput,
				    (Visual *)CopyFromParent,
				    mask, &attr);
        leftabsscrolltmb = XCreateSimpleWindow(root_display,leftabsscrollbar, 
				    0, 0, 6, SCROLLBAR_LEN,
                                    1,
				    XWhitePixel(root_display,root_screen),
				    XBlackPixel(root_display,root_screen));
        lowerabsscrollbar = XCreateWindow (root_display, frame_window, 
				    20, window_height-PIXW_YOFFSET+14, 
                                    window_width-PIXW_XOFFSET+2, 8,
                                    1, (int)CopyFromParent,
				    InputOutput,
				    (Visual *)CopyFromParent,
				    mask, &attr);
        lowerabsscrolltmb = XCreateSimpleWindow(root_display,lowerabsscrollbar,
				    0, 0, SCROLLBAR_LEN, 6,
                                    1,
				    XWhitePixel(root_display,root_screen),
				    XBlackPixel(root_display,root_screen));
        rightscrollbar = XCreateWindow (root_display, frame_window, 
				    window_width-11,2, 
                                    8, window_height-PIXW_YOFFSET,
                                    1, (int)CopyFromParent,
				    InputOutput,
				    (Visual *)CopyFromParent,
				    mask, &attr);
        rightscrolltmb = XCreateSimpleWindow (root_display, rightscrollbar,0,0, 
                                    6, SCROLLBAR_LEN,
                                    1,
				    XWhitePixel(root_display,root_screen),
				    XBlackPixel(root_display,root_screen));

        XMapWindow (root_display, leftscrolltmb);
        XMapWindow (root_display, leftscrollbar);
        XMapWindow (root_display, lowerscrolltmb);
        XMapWindow (root_display, lowerscrollbar);
        XMapWindow (root_display, leftabsscrolltmb);
        XMapWindow (root_display, leftabsscrollbar);
        XMapWindow (root_display, lowerabsscrolltmb);
        XMapWindow (root_display, lowerabsscrollbar);
        XMapWindow (root_display, rightscrolltmb);
        XMapWindow (root_display, rightscrollbar);
 	position_abs_scrollbars();
}



/* Initialize hint structure
 * -------------------------
 * This algorithm is taken from xlib xbiff
 */

#define maximum(a,b) ((a) > (b) ? (a) : (b))

static void set_sizehints (hintp, min_width, min_height, defwidth, defheight, defx, defy, geom)
XSizeHints *hintp;
int min_width, min_height, defwidth, defheight, defx, defy;
char *geom;
{
	int geom_result;

	hintp->width = hintp->min_width = min_width;
	hintp->height = hintp->min_height = min_height;
	hintp->flags = PMinSize;
	hintp->x = hintp->y = 0;
	geom_result = NoValue;
	if (geom != NULL) {
		geom_result = XParseGeometry (geom, &hintp->x, &hintp->y,
				      (unsigned int *)&hintp->width,
				      (unsigned int *)&hintp->height);
		if ((geom_result&WidthValue) && (geom_result&HeightValue)) {
			hintp->width =maximum(hintp->width, hintp->min_width);
			hintp->height=maximum(hintp->height,hintp->min_height);
			hintp->flags |= USSize;
		}
		if ((geom_result & XValue) && (geom_result & YValue)) {
			hintp->flags += USPosition;
		}
    	}
	if (!(hintp->flags & USSize)) {
		hintp->width = defwidth;
		hintp->height = defheight;
		hintp->flags |= PSize;
    	}

/*
 *   	if (!(hintp->flags & USPosition)) {
 *		hintp->x = defx;
 *		hintp->y = defy;
 *		hintp->flags |= PPosition;
 *   	}
 */

	if (geom_result & XNegative) {
		hintp->x = DisplayWidth (root_display, 
				DefaultScreen (root_display)) + 
				hintp->x - hintp->width;
    	}
    	if (geom_result & YNegative) {
		hintp->y = DisplayHeight (root_display, 
				DefaultScreen (root_display)) + 
				hintp->y - hintp->height;
    	}
}

/* Check which backing store algorithm needed.
 * -------------------------------------------
 */

static int parse_backing_store(s)
char *s;
{
    int len = strlen (s);
    char *cp;

    for (cp = s; *cp; cp++) {
        if (isascii (*cp) && isupper (*cp)) *cp = tolower (*cp);
    }

    if (strncmp (s, "notuseful", len) == 0) return(NotUseful);
    if (strncmp (s, "whenmapped", len) == 0) return(WhenMapped);
    if (strncmp (s, "always", len) == 0) return(Always);
    return(0);
}


/*--------------------------------------------------------------------*/
/*  Drawing primitives                                                */
/*--------------------------------------------------------------------*/

/* Draw a line
 * -----------
 * from fx,fy to tx,ty with color c.
 */

void	gs_line(fx, fy, tx, ty, c)
int	fx, fy, tx, ty, c;
{
	XSetForeground(root_display, pix_GC, carray[c]);
	XDrawLine(root_display,
                pix_dw,
                pix_GC,
                fx-V_xmin, fy-V_ymin,
                tx-V_xmin, ty-V_ymin
        );
	XSync(root_display, 0);
}

/* Draw a rectangle
 * ----------------
 * at (x,y) with width w, height h and color c
 */

void 	gs_rectangle(x, y, w, h, c)
int	x, y, w, h, c;
{
	XSetForeground(root_display, pix_GC, carray[c]);
	XFillRectangle(root_display,
                pix_dw,
                pix_GC,
		x-V_xmin, 
		y-V_ymin, 
		w, h);
	XSync(root_display, 0);
}


/* Draw a fast line using X11 special features
 * -------------------------------------------
 * from fx,fy to tx,ty with color c and thickness t.
 */

#ifdef FAST_X11_DRAWING

void	X11_fast_line(fx, fy, tx, ty, t, c)
int	fx, fy, tx, ty, t, c;
{
	XSetForeground(root_display, pix_GC, carray[c]);
	XSetLineAttributes(root_display, pix_GC, (t>0?t-1:0), 
		LineSolid, CapRound, JoinRound);
	XDrawLine(root_display,
                pix_dw,
                pix_GC,
                fx-V_xmin, fy-V_ymin,
                tx-V_xmin, ty-V_ymin
        );
	XSync(root_display, 0);
	XSetLineAttributes(root_display, pix_GC, 0, 
		LineSolid, CapRound, JoinRound);
}

#endif


/* Draw a fast dashed line using X11 special features
 * --------------------------------------------------
 * from fx,fy to tx,ty with color c and thickness t.
 * The length of the dashes is d.
 */

#ifdef FAST_X11_DRAWING

void	X11_fast_dashedline(fx, fy, tx, ty, t, c, d)
int	fx, fy, tx, ty, t, c, d;
{
	char dash_list[2];

	if (d<1) d = 1;
	dash_list[0]=d;
	dash_list[1]=d;
	XSetForeground(root_display, pix_GC, carray[c]);
	XSetLineAttributes(root_display, pix_GC, (t>0?t-1:0), 
		LineOnOffDash, CapRound, JoinRound);
	XSetDashes(root_display, pix_GC, 0, dash_list, 2); 
	XDrawLine(root_display,
                pix_dw,
                pix_GC,
                fx-V_xmin, fy-V_ymin,
                tx-V_xmin, ty-V_ymin
        );
	XSync(root_display, 0);
	XSetLineAttributes(root_display, pix_GC, 0, 
		LineSolid, CapRound, JoinRound);
}

#endif


/* Draw a fast dotted line using X11 special features
 * --------------------------------------------------
 * from fx,fy to tx,ty with color c and thickness t.
 * The length of the spaces between the dottes is d.
 */

#ifdef FAST_X11_DRAWING

void	X11_fast_dottedline(fx, fy, tx, ty, t, c, d)
int	fx, fy, tx, ty, t, c, d;
{
	char dash_list[2];

	if (d<1) d = 1;
	if (d<t) d = t;
	dash_list[0]=1;
	dash_list[1]=d;
	XSetForeground(root_display, pix_GC, carray[c]);
	XSetLineAttributes(root_display, pix_GC, (t>0?t-1:0), 
		LineOnOffDash, CapRound, JoinRound);
	XSetDashes(root_display, pix_GC, 0, dash_list, 2); 
	XDrawLine(root_display,
                pix_dw,
                pix_GC,
                fx-V_xmin, fy-V_ymin,
                tx-V_xmin, ty-V_ymin
        );
	XSync(root_display, 0);
	XSetLineAttributes(root_display, pix_GC, 0, 
		LineSolid, CapRound, JoinRound);
}

#endif


/* Draw a fast ellipse as border using X11 special features
 * --------------------------------------------------------
 * (x,y) is the left upper point of the bounding box around the
 * ellipse, and w and h are the width and height, and c and t
 * the color and thickness. 
 */ 

#ifdef FAST_X11_DRAWING

void X11_fast_ellipse(x,y,w,h,t,c)
int	x, y, w, h, t, c;
{
	XSetLineAttributes(root_display, pix_GC, (t>0?t-1:0), 
		LineSolid, CapRound, JoinRound);
	XSetForeground(root_display, pix_GC, carray[c]);
	XDrawArc(root_display,
		pix_dw,
                pix_GC,
		x-V_xmin, y-V_ymin,
		w,h,
		0, 360*64);
	XSync(root_display, 0);
	XSetLineAttributes(root_display, pix_GC, 0, 
		LineSolid, CapRound, JoinRound);
}

#endif

/* Draw a fast filled ellipse using X11 special features
 * -----------------------------------------------------
 * (x,y) is the left upper point of the bounding box around the 
 * ellipse, and w and h are the width and height, and c1 and c2 
 * the colors.
 */

#ifdef FAST_X11_DRAWING

void X11_fast_filledellipse(x,y,w,h,c1,c2)
int     x, y, w, h, c1, c2;
{
	XSetForeground(root_display, pix_GC, carray[c2]);
	XFillArc(root_display,
		pix_dw,
                pix_GC,
		x-V_xmin, y-V_ymin,
		w,h,
		180*64, 360*64);
	XSync(root_display, 0);
	XSetForeground(root_display, pix_GC, carray[c1]);
	XFillArc(root_display,
		pix_dw,
                pix_GC,
		x-V_xmin, y-V_ymin,
		w,h,
		0, 180*64);
	XSync(root_display, 0);
}

#endif

/*--------------------------------------------------------------------*/
/*  Canvas displaying                                                 */
/*--------------------------------------------------------------------*/

/* display the graph in the pixwin
 * -------------------------------
 */

static void	displayCanvas()
{
	buildCanvas();
	reset_menues(); 
}


/* build the pixwin
 * ----------------
 * This is used to refresh the pixwin after any change like scaling,
 * scrolling etc.
 */

static void	buildCanvas()
{
	int old_cursor;

	debugmessage("buildCanvas","");
	old_cursor = act_cursor;
	set_busy_cursor(); 
	if (!colored) 
		XSetForeground(root_display, pix_GC, carray[WHITE]);
	else	XSetForeground(root_display, pix_GC, carray[G_color]);
	XFillRectangle(root_display,
                pix_dw,
                pix_GC,
		0, 
		0, 
		G_xmax, G_ymax);

	draw_main();
	waitcnt=0;

	clear_panel();
	show_buffer();
	act_cursor = old_cursor;
	reset_cursor();
}


void show_buffer()
{
	if (no_buffer) return;

	ask_window_size(frame_window);
	if (act_x_pos+window_width- PIXW_XOFFSET>G_xmax) 
		act_x_pos=G_xmax-window_width +PIXW_XOFFSET;
	if (act_y_pos+window_height-PIXW_YOFFSET>G_ymax) 
		act_y_pos=G_ymax-window_height+PIXW_YOFFSET;

        XCopyArea(root_display,
                pix_dw,
                pix_window,
                pix_GC,
                act_x_pos, act_y_pos,
		window_width  - PIXW_XOFFSET,
		window_height - PIXW_YOFFSET,
                0, 0
        );
        XSync(root_display, 0);
	if ( V_ruler )	ruler_paint(); 
        XSync(root_display, 0);
}



/*--------------------------------------------------------------------*/
/*  Event handling                                                    */
/*--------------------------------------------------------------------*/

/* The main loop for interaction
 * =============================
 */


static void window_main_loop()
{
	int notready = 1;
	XEvent event;

	set_normal_cursor();
	while (notready) {

		XNextEvent (root_display, &event);

		if (event.type != Expose) win_exposed = 0;

		switch (event.type) {
	  	case KeyPress:
	   		prologue (&event, "KeyPress");
	    		do_KeyPress (&event);
	    		break;
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
	    		do_ButtonPress (&event);
	    		break;
	  	case ButtonRelease:
	    		prologue (&event, "ButtonRelease");
	    		do_ButtonRelease (&event);
	    		break;
	  	case EnterNotify:
	    		prologue (&event, "EnterNotify");
			do_EnterNotify(&event);
	    		break;
	  	case LeaveNotify:
	    		prologue (&event, "LeaveNotify");
			do_LeaveNotify(&event);
	    		break;
	  	case FocusIn:
	    		prologue (&event, "FocusIn");
	    		break;
	  	case FocusOut:
	    		prologue (&event, "FocusOut");
	    		break;
	  	case Expose:
	    		prologue (&event, "Expose");
	    		do_Expose (&event);
	    		break;
	  	case ConfigureNotify:
	    		prologue (&event, "ConfigureNotify");
	    		do_ConfigureNotify (&event);
	    		break;
	  	case MotionNotify:
	    		prologue (&event, "MotionNotify");
			do_MotionNotify(&event);
	    		break;
	  	case GravityNotify:
	  	case CirculateRequest:
	  	case PropertyNotify:
	  	case SelectionClear:
	  	case SelectionRequest:
	  	case SelectionNotify:
	  	case ColormapNotify:
	  	case ClientMessage:
	  	case MappingNotify:
	  	case CreateNotify:
	  	case DestroyNotify:
	  	case CirculateNotify:
	  	case VisibilityNotify:
	 	case KeyRelease:
	  	case KeymapNotify:
	  	case NoExpose:
	  	case GraphicsExpose:
	    		/* prologue (&event, "Unhandled"); */
	    		break;
		}
    	}
}


#ifdef EVENT_DEBUG

/* For debugging only: Print event message
 * ---------------------------------------
 */

static void prologue (eventp, event_name)
XEvent *eventp;
char *event_name;
{
	XAnyEvent *e = (XAnyEvent *) eventp;

	panel_event(event_name);
	PRINTF ("\n%s event, serial %ld, synthetic %s, window 0x%lx,\n",
	    event_name, e->serial, e->send_event ? "Yes" : "No", e->window);
}

#endif /* EVENT_DEBUG */



/* Standard Keypress Event
 * -----------------------
 * These are allowed if we are in the main loop.
 */

static void do_KeyPress (eventp)
XEvent *eventp;
{
    	XKeyEvent *e = (XKeyEvent *) eventp;
    	KeySym ks;
    	int nbytes, i;
    	char str[256+1];

    	nbytes = XLookupString (e, str, 256, &ks, NULL);
    	if (nbytes < 0) nbytes = 0;
    	if (nbytes > 256) nbytes = 256;
    	str[nbytes] = '\0';

	i = 0;
	if (nbytes==1) {
		switch (str[0]) {
		case '1': /* Expose or hide class 1 */
		case '2': /* Expose or hide class 2 */
		case '3': /* Expose or hide class 3 */
		case '4': /* Expose or hide class 4 */
		case '5': /* Expose or hide class 5 */
		case '6': /* Expose or hide class 6 */
		case '7': /* Expose or hide class 7 */
		case '8': /* Expose or hide class 8 */
		case '9': /* Expose or hide class 9 */
			i = str[0]-'0';	
			if (i<1) return;
			if (i>max_nr_classes) return;
			if (hide_class[i-1]==0) 
				hide_class[i-1] = 1;
		 	else	hide_class[i-1] = 0;
			complete_relayout();
			return;
		case 'p':
			m_pic_position();
			return;
		case 'P':
			m_position();
			return;
		case 'j':
		case 'J':
			info_val = 3;
			i = 1;
			/* Fall through */
		case 'i': 
			if (!i) info_val = 1;
			i = 1;
			/* Fall through */
		case 'I': 
			if (!i) info_val = 2;
			truesize = 1;
			handle_info_menu(info_val);
			return;
		case 'e':
		case 'E':
			m_follow_edge();
			return;
		case 'n':
		case 'N':
			m_center_node(x11_print_title_dialog(),1);
			return;
		case 'f':
		case 'F':
			load_save_flag = LS_LOAD;
			clear_panel();
			m_loadsave();
			return;
		case 'g':
		case 'G':
			m_reload();
			return;
		case 'l': /* Label of Edges */
		case 'L': /* Label of Edges */
			if (x11_print_layout_dialog()) complete_relayout();
			else show_buffer();
			return;
		case 'q': /* Quit */
		case 'Q': /* Quit */
			gs_exit(0);
			return;
#ifdef DRAWDEBUG
		case ' ': /* Debug */
			step3_main(); 
			return;
#endif 
		default: do_minimalKeyPress(eventp);
			reset_menues();
			return;
		}
	}
	else do_minimalKeyPress(eventp);
}

/* Minimal Keypress Event
 * ----------------------
 * These are always allowed because they do not cause a relayout.
 */

static void do_minimalKeyPress (eventp)
XEvent *eventp;
{
    	XKeyEvent *e = (XKeyEvent *) eventp;
    	KeySym ks;
    	int nbytes;
    	char str[256+1];
	int redraw_necessary;
	int xx,yy; 

    	nbytes = XLookupString (e, str, 256, &ks, NULL);
    	if (nbytes < 0) nbytes = 0;
    	if (nbytes > 256) nbytes = 256;
    	str[nbytes] = '\0';

	redraw_necessary = 0;
	if (ks==0xff54) { /* Down */
		V_ymin += 256;
		V_ymax = V_ymin+G_ymax+COFFSET;
		redraw_necessary = 1;
	}
	else if (ks==0xff53) { /* Right */
		V_xmin += 256;
		V_xmax = V_xmin+G_xmax;
		redraw_necessary = 1;
	}
	else if (ks==0xff52) { /* Up */
		V_ymin -= 256;
		V_ymax = V_ymin+G_ymax+COFFSET;
		redraw_necessary = 1;
	}
	else if (ks==0xff51) { /* Left */
		V_xmin -= 256;
		V_xmax = V_xmin+G_xmax;
		redraw_necessary = 1;
	}
	else if (nbytes==1) {
		switch (str[0]) {
		case 'd':  /* R10: left */
		case 'D':  /* R10: left */
			V_xmin -= 256;
			V_xmax = V_xmin+G_xmax;
			redraw_necessary = 1;
			break;
		case 'c':  /* R12: right */
		case 'C':  /* R12: right */
			V_xmin += 256;
			V_xmax = V_xmin+G_xmax;
			redraw_necessary = 1;
			break;
		case 'a':  /* R8: up */
		case 'A':  /* R8: up */
			V_ymin -= 256;
			V_ymax = V_ymin+G_ymax+COFFSET;
			redraw_necessary = 1;
			break;
		case 'b':  /* R14: down */
		case 'B':  /* R14: down */
			V_ymin += 256;
			V_ymax = V_ymin+G_ymax+COFFSET;
			redraw_necessary = 1;
			break;
		case 'o':  /* origin */
		case 'O':  /* origin */
			redraw_necessary = 1;
			V_xmin = 0;
			V_ymin = 0;
			V_xmax = V_xmin+G_xmax;
			V_ymax = V_ymin+G_ymax+COFFSET;
			break;
		case 'q': /* Quit */
		case 'Q': /* Quit */
			gs_exit(0);
			break;
		case '0':  /* normal */
			redraw_necessary = 1;
			xx = V_xmin * G_shrink/G_stretch;
			yy = V_ymin * G_shrink/G_stretch;
			G_stretch = 1;
			G_shrink  = 1;
			V_xmin = xx * G_stretch/G_shrink;
			V_ymin = yy * G_stretch/G_shrink;
			V_xmax = V_xmin+G_xmax;
			V_ymax = V_ymin+G_ymax+COFFSET;
			normalize_scaling();
			break;
		case '-':  /* shrink */
			redraw_necessary = 1;
			xx = V_xmin * G_shrink/G_stretch;
			yy = V_ymin * G_shrink/G_stretch;
			G_stretch *= 2;
			G_shrink  *= 3;
			normalize_scaling();
			V_xmin = xx * G_stretch/G_shrink;
			V_ymin = yy * G_stretch/G_shrink;
			V_xmax = V_xmin+G_xmax;
			V_ymax = V_ymin+G_ymax+COFFSET;
			break;
		case '_':  /* shrink */
			redraw_necessary = 1;
			xx = V_xmin * G_shrink/G_stretch;
			yy = V_ymin * G_shrink/G_stretch;
			G_shrink  *= 2;
			normalize_scaling();
			V_xmin = xx * G_stretch/G_shrink;
			V_ymin = yy * G_stretch/G_shrink;
			V_xmax = V_xmin+G_xmax;
			V_ymax = V_ymin+G_ymax+COFFSET;
			break;
		case '+':  /* stretch */
			redraw_necessary = 1;
			xx = V_xmin * G_shrink/G_stretch;
			yy = V_ymin * G_shrink/G_stretch;
			G_stretch *= 3;
			G_shrink  *= 2;
			normalize_scaling();
			V_xmin = xx * G_stretch/G_shrink;
			V_ymin = yy * G_stretch/G_shrink;
			V_xmax = V_xmin+G_xmax;
			V_ymax = V_ymin+G_ymax+COFFSET;
			break;
		case '=':  /* stretch */
			redraw_necessary = 1;
			xx = V_xmin * G_shrink/G_stretch;
			yy = V_ymin * G_shrink/G_stretch;
			G_stretch *= 2;
			normalize_scaling();
			V_xmin = xx * G_stretch/G_shrink;
			V_ymin = yy * G_stretch/G_shrink;
			V_xmax = V_xmin+G_xmax;
			V_ymax = V_ymin+G_ymax+COFFSET;
			break;
		case 'r' : /* ruler */
		case 'R' : /* ruler */
			V_ruler = 1-V_ruler;
			clear_panel();
			show_buffer();
			break;
		}
	}
	if (redraw_necessary) {
		position_abs_scrollbars();
		disable_signal(); 
       		buildCanvas(); 
       		enable_signal();
	}
}


/* Button Press shows the main menu
 * --------------------------------
 */

static Window act_scroll_window = 0;
 
static void do_ButtonPress (eventp)
XEvent *eventp;
{
	XButtonEvent *e = (XButtonEvent *) eventp;
	Window w;

	w = e->window;
	act_scroll_window = w; 
	if (w==leftscrollbar)          return; 
	else if (w==lowerscrollbar)    return; 
	else if (w==leftabsscrollbar)  return;
	else if (w==lowerabsscrollbar) return;
	else if (w==rightscrollbar)    return; 

	gs_check_allmenues();
	gs_draw_menu(frame_menu,e->x,e->y);
}

/* Button Release handles the selection in the main menu
 * -----------------------------------------------------
 */

static void do_ButtonRelease (eventp)
XEvent *eventp;
{
	XButtonEvent *e = (XButtonEvent *) eventp;

	if (act_scroll_window && (act_scroll_window!=e->window)) {
		position_nor_scrollbars();
		position_abs_scrollbars();
	}
	else if (act_scroll_window==leftscrollbar) 
		read_leftscrollbar(e->y);
	else if (act_scroll_window==lowerscrollbar) 
		read_lowerscrollbar(e->x);
	else if (act_scroll_window==leftabsscrollbar) 
		read_leftabsscrollbar(e->y);
	else if (act_scroll_window==lowerabsscrollbar) 
		read_lowerabsscrollbar(e->x);
	else if (act_scroll_window==rightscrollbar) 
		read_rightscrollbar(e->y);

	if (act_scroll_window==leftscrollbar) {
		show_buffer();
		act_scroll_window = 0; 
		return;
	} 
	else if (act_scroll_window==lowerscrollbar) {
		show_buffer();
		act_scroll_window = 0; 
		return;
	}
	else if (act_scroll_window==leftabsscrollbar) {
		disable_signal(); 
       		buildCanvas(); 
       		enable_signal();
		act_scroll_window = 0; 
		return;
	} 
	else if (act_scroll_window==lowerabsscrollbar) {
		disable_signal(); 
       		buildCanvas(); 
       		enable_signal();
		act_scroll_window = 0; 
		return;
	}
	else if (act_scroll_window==rightscrollbar) {
		disable_signal(); 
       		buildCanvas(); 
       		enable_signal();
		act_scroll_window = 0; 
		return;
	} 
	gs_handle_menu_selection();
}


/* Touch new menu point
 * --------------------
 * We first check which point was selected. Then we check whether this
 * causes a change of the visibility of the menu. A change of the 
 * visibility happens if a submenu previous visible is folded now.
 * Then we redraw the menu by highlighting the selected part, and
 * optinally by showing a selected submenu.
 * If the visibility was changed, we must redraw the whole menu.
 */

static void do_EnterNotify (eventp)
XEvent *eventp;
{
    	XCrossingEvent *e = (XCrossingEvent *) eventp;
	Window w;
	int    vis;

	w = e->window;

	vis = 0;
	if (w==foldregion_touch)	{gs_draw_submenu(frame_menu,4);  return; }
	else if (w==scroll_touch)	{gs_draw_submenu(frame_menu,6);  return; }
	else if (w==info_touch)		{gs_draw_submenu(frame_menu,7);  return; }
	else if (w==scale_touch)	{gs_draw_submenu(frame_menu,14); return; }
	else if (w==export_touch)	{gs_draw_submenu(frame_menu,15); return; }
	if (MENU_VIS(frame_menu)) {
		(void)gs_check_menuselect(w,frame_menu);
		if ((vis=gs_check_vis_changed(frame_menu))>0) show_buffer();
		gs_redraw_menu(frame_menu);
		if (vis) gs_draw_menu(	frame_menu,
					MENU_X(frame_menu),		
					MENU_Y(frame_menu));
	}
}


/* Untouch menu point
 * ------------------
 * The menupoint is not anymore selected.
 */ 

static void do_LeaveNotify (eventp)
XEvent *eventp;
{
	gs_unselect_allmenus();
}


/* Expose a window
 * ---------------
 * Only for the frame window, we have to redraw the contents.
 */

static void do_Expose (eventp)
XEvent *eventp;
{
	XExposeEvent *e = (XExposeEvent *) eventp;

	if (  (e->window==pix_window)
	    ||(e->window==frame_window)) {
		if ((!win_exposed)&&(e->width>10) && (e->height>10)) {
		  	show_buffer();
		  	win_exposed = 1;
		}
	}
	else win_exposed = 0;
}


/* Resize or move a window
 * -----------------------
 */

static void do_ConfigureNotify (eventp)
XEvent *eventp;
{
	int width,height,done;
	XConfigureEvent *e = (XConfigureEvent *) eventp;

	if (e->window==frame_window) {
		width = e->width;
		height = e->height;
		done = 0;
		if (G_xmax<width)  { width  = G_xmax; done = 1; }
		if (G_ymax<height) { height = G_ymax; done = 1; }
		if (done)
			XResizeWindow(root_display,frame_window,width,height);

		XMoveResizeWindow(root_display,pix_window,
				20,2,width-PIXW_XOFFSET,height-PIXW_YOFFSET);
		XMoveResizeWindow(root_display,panel_window,
				2,height-60+4,width-6,50);

		XMoveResizeWindow(root_display,leftabsscrollbar,
				2,2,8,height-PIXW_YOFFSET);
		XMoveResizeWindow(root_display,leftscrollbar,
				11,2,8,height-PIXW_YOFFSET);
		XMoveResizeWindow(root_display,lowerscrollbar,
				20, height-PIXW_YOFFSET+5, 
			        width-PIXW_XOFFSET+2, 8);
		XMoveResizeWindow(root_display,lowerabsscrollbar,
				20, height-PIXW_YOFFSET+14, 
				width-PIXW_XOFFSET+2, 8);
		XMoveResizeWindow(root_display,rightscrollbar,
				width-11,2,
				8,height-PIXW_YOFFSET);

		position_nor_scrollbars();
		position_abs_scrollbars();
		gs_hide_all_menus();
	}
}


/* Motion with pressed button 
 * --------------------------
 */

static void do_MotionNotify (eventp)
XEvent *eventp;
{
	XMotionEvent *e = (XMotionEvent *) eventp;

	if (act_scroll_window==leftscrollbar) {
		read_leftscrollbar(e->y);
		show_buffer();
	}
	else if (act_scroll_window==lowerscrollbar) {
		read_lowerscrollbar(e->x);
		show_buffer();
	}
	else if (act_scroll_window==leftabsscrollbar) {
		read_leftabsscrollbar(e->y);
	}
	else if (act_scroll_window==lowerabsscrollbar) {
		read_lowerabsscrollbar(e->x);
	}
	else if (act_scroll_window==rightscrollbar) {
		read_rightscrollbar(e->y);
	}
}



/*--------------------------------------------------------------------*/
/*  Normalize G_shrink and G_stretch                                  */
/*--------------------------------------------------------------------*/

/* This is done to minimize rounding errors if to often 
 * the scaling is changed.
 */

static void normalize_scaling()
{
	if (G_shrink<0) G_shrink   *= -1;
	if (G_stretch<0) G_stretch *= -1;
	if (G_shrink==G_stretch) G_shrink = G_stretch = 1;
	if (G_shrink ==0) G_shrink=1;
	if (G_stretch==0) G_stretch=1;
	if (G_stretch > G_shrink) {
		if (G_shrink * 5000 < G_stretch) {
			G_shrink = 1;
			G_stretch = 5000;
		}
		G_stretch = G_stretch * 60 / G_shrink;
		G_shrink  = 60;
	}
	if (G_stretch < G_shrink) {
		if (G_shrink > G_stretch * 5000) {
			G_shrink =  5000;
			G_stretch = 1;
		}
		G_shrink  = G_shrink * 60 / G_stretch;
		G_stretch = 60;
	}
	while ((G_shrink%2==0) && (G_stretch%2==0)) {
		G_shrink   = G_shrink/2;
		G_stretch  = G_stretch/2;
	}
	while ((G_shrink%3==0) && (G_stretch%3==0)) {
		G_shrink   = G_shrink/3;
		G_stretch  = G_stretch/3;
	}
	while ((G_shrink%5==0) && (G_stretch%5==0)) {
		G_shrink   = G_shrink/5;
		G_stretch  = G_stretch/5;
	}
	while ((G_shrink%7==0) && (G_stretch%7==0)) {
		G_shrink   = G_shrink/7;
		G_stretch  = G_stretch/7;
	}
	if (G_shrink ==0) G_shrink=1;
	if (G_stretch==0) G_stretch=1;
	new_scale_fontbuffers(G_stretch,G_shrink);
}




/*--------------------------------------------------------------------*/
/*  Cursor management                                                 */
/*--------------------------------------------------------------------*/

static void set_normal_cursor()
{
	XDefineCursor(root_display,frame_window,standard_cursor);
	act_cursor = STD_CURSOR;
}

static void set_busy_cursor()
{
	XDefineCursor(root_display,frame_window,workingCursor);
	XDefineCursor(root_display,leftabsscrollbar,workingCursor);
	XDefineCursor(root_display,lowerabsscrollbar,workingCursor);
	XDefineCursor(root_display,leftscrollbar,workingCursor);
	XDefineCursor(root_display,lowerscrollbar,workingCursor);
	XDefineCursor(root_display,rightscrollbar,workingCursor);
	act_cursor = WOR_CURSOR;
}

static void set_select_cursor()
{
	XDefineCursor(root_display,frame_window,selectCursor);
	act_cursor = SEL_CURSOR;
}

static void set_fold_cursor()
{
	XDefineCursor(root_display,frame_window,foldCursor);
	act_cursor = FOL_CURSOR;
}

static void set_text_cursor()
{
	XDefineCursor(root_display,frame_window,textCursor);
	act_cursor = TXT_CURSOR;
}

static void set_leftscroll_cursor()
{
	XDefineCursor(root_display,leftscrollbar, leftscrollCursor);
	XDefineCursor(root_display,rightscrollbar,leftscrollCursor);
}

static void set_lowerscroll_cursor()
{
	XDefineCursor(root_display,lowerscrollbar,lowerscrollCursor);
}

static void set_leftpos_cursor()
{
	XDefineCursor(root_display,leftabsscrollbar,leftposCursor);
}

static void set_lowerpos_cursor()
{
	XDefineCursor(root_display,lowerabsscrollbar,lowerposCursor);
}



static void reset_cursor()
{
	switch (act_cursor) {
	case STD_CURSOR : set_normal_cursor(); break;
	case WOR_CURSOR : set_busy_cursor();   break;
	case SEL_CURSOR : set_select_cursor(); break;
	case FOL_CURSOR : set_fold_cursor();   break;
	case TXT_CURSOR : set_text_cursor();   break;
	}

	/* For the scrollbars */
	set_leftscroll_cursor();
	set_lowerscroll_cursor();
	set_leftpos_cursor();
	set_lowerpos_cursor();
}


/*--------------------------------------------------------------------*/
/*  Panel messages                                                    */
/*--------------------------------------------------------------------*/

/* Clear the panel
 * ---------------
 */

static void clear_panel()
{
	clear_from_xy_panel(0,0);
}


/* Clear the panel starting at special x position
 * ----------------------------------------------
 */

static void clear_from_xy_panel(x,y)
int x;
int y;
{
	ask_window_size(panel_window);

	if (x>window_width) return;

	XSetForeground(root_display, panel_GC, carray[WHITE]);
	XFillRectangle(root_display,
                panel_dw,
                panel_GC,
		x, 
		y, 
		window_width-x, 
		window_height-y
	);
}


/* Write a message into the panel
 * ------------------------------
 * The message can be concatenated by x, y, and z.
 */

static char mbuffer[80];

static void 	panel_outp(x,y,z)
char *x;
char *y;
char *z;
{
	int  i;

	clear_panel();
	XSetForeground(root_display, panel_GC, carray[BLACK]);
	i = 0;
	while ((*x)&&(i<79)) 	mbuffer[i++]=*x++;
	while ((*y)&&(i<79)) 	mbuffer[i++]=*y++;
	while ((*z)&&(i<79)) 	mbuffer[i++]=*z++;
	while (i<79) 		mbuffer[i++]=' ';
	mbuffer[79] = 0;
	XDrawString(root_display,panel_dw,panel_GC,5,18,mbuffer,strlen(mbuffer));
	XSync(root_display, 0);
}

/* Write an event message into the panel
 * -------------------------------------
 */

static char ebuffer[20];

static void 	panel_event(x)
char *x;
{
	int  i;

	clear_from_xy_panel(730,0);

	XSetForeground(root_display, panel_GC, carray[BLACK]);
	i = 0;
	while ((*x)&&(i<19)) 	ebuffer[i++]=*x++;
	while (i<19) 		ebuffer[i++]=' ';
	ebuffer[19] = 0;
	XDrawString(root_display,panel_dw,panel_GC,730,18,
		ebuffer,strlen(ebuffer));
	XSync(root_display, 0);
}


/* Write a Waitmessage into the panel
 * ----------------------------------
 */

void gs_wait_message(c)
int c;
{
	int i;

	waitcnt++;
	if (!panel_there) {
		if (silent) return;
		FPRINTF(stdout,"\b.%c",c); 
		FFLUSH(stdout);
		return;
	}

	clear_panel();
	XSetForeground(root_display, panel_GC, carray[BLACK]);
	strcpy(mbuffer,"Wait  .");
	for (i=5; i<6+waitcnt; i++) {
		if (i>=70) { waitcnt=0; break; }
		mbuffer[i] = '.';		
	}
	mbuffer[i-1]=c;
	mbuffer[i]=0;
	XDrawString(root_display,panel_dw,panel_GC,5,18,mbuffer,i);
	XSync(root_display, 0);
}


/*--------------------------------------------------------------------*/
/*  Panel Input                                                       */
/*--------------------------------------------------------------------*/

/* Read text in the panel
 * ----------------------
 * First msg is printed at position ypos.
 * If mode = 1, we allow only digits as input.
 */

static char *read_text(msg,ypos,mode)
char *msg;
int  ypos;
int  mode;
{
	int i,j;
	int xpos,xoripos;
	int old_cursor;
	XEvent event;
    	XKeyEvent *e;
    	KeySym ks;
    	char str[256+1];

	xpos = 5;
	XSetForeground(root_display, panel_GC, carray[BLACK]);
	i = 0;
	while ((*msg)&&(i<79)) 	mbuffer[i++]=*msg++;
	mbuffer[i] = 0;
	XDrawString(root_display,panel_dw,panel_GC,xpos,ypos,
			mbuffer,strlen(mbuffer));
	XSync(root_display, 0);
	xpos += XTextWidth(panel_font,mbuffer,strlen(mbuffer));
	xoripos = xpos;

	old_cursor = act_cursor;
	set_text_cursor();

	j = 0;
	mbuffer[j]=0;
	ks =0;
	while (ks!=0xff0d) {
		if (j>78) j=78;
		clear_from_xy_panel(xpos,ypos-16);
		XSetForeground(root_display, panel_GC, carray[BLACK]);
		XDrawString(root_display,panel_dw,panel_GC,xpos,ypos,
			"_",1);
		XSync(root_display, 0);

		XNextEvent (root_display, &event);
		switch (event.type) {
	  	case KeyPress: 	break;
		default: 	default_handler(&event);
				continue;
		}

		clear_from_xy_panel(xpos,ypos-16);
		XSetForeground(root_display, panel_GC, carray[BLACK]);
    		e = (XKeyEvent *)&event;
    		i = XLookupString (e, str, 256, &ks, NULL);
    		if (i < 0)    i = 0;
    		if (i > 256)  i = 256;
    		str[i] = 0;
		if (ks==0xff0d)      { mbuffer[j]=0; }
		else if (ks==0xff0a) { mbuffer[j]=0; }
		else if (ks==0xff08) { j--; if (j<0) j=0; mbuffer[j]=0; }
		else if (ks==0xffff) { j--; if (j<0) j=0; mbuffer[j]=0; }
		else if (i==1) { 
			if ((mode==1)&&((str[0]<'0')||(str[0]>'9'))) continue; 
			if (  (mode==2) 
			    &&((str[0]<'0')||(str[0]>'9'))
			    &&(str[0]!=' ')&&(str[0]!=','))
				continue; 
			mbuffer[j++]=str[0];
			mbuffer[j]  =0;
			XDrawString(root_display,panel_dw,panel_GC,xpos,ypos,
				str,1);
			XSync(root_display, 0);
		}
		xpos = xoripos + XTextWidth(panel_font,mbuffer,strlen(mbuffer));
	}
	mbuffer[j]=0;
	act_cursor = old_cursor;
	reset_cursor();
	return(mbuffer);
}



/*--------------------------------------------------------------------*/
/*  Menu Memory allocation                                            */
/*--------------------------------------------------------------------*/

/* General note: Menu's are allocated only once. Thus we use malloc
 * instead of our internal memory allocation mechanism, because 
 * speed is not important here and the menus are needed until the program
 * is finished.
 */

/* Allocate Menu 
 * -------------
 * A Menu is simply a window containing several subwindows. 
 * len is the len of itemtab.
 */


static gs_Menu	allocate_Menu(len,itemtab)
int len;
char *itemtab[];
{
	int 	itemlen,h,i;

	ask_window_size(frame_window);

	itemlen = 0;
	for (i=0;i<len;i++) {
		h = XTextWidth(panel_font,itemtab[i],strlen(itemtab[i]));
		if (h>itemlen) itemlen = h;
	}	
	itemlen += 6;

	return(alloc_Menu(
			window_width,
			window_height,
			itemlen,
			MENUITEM_HEIGHT,
			len,
			itemtab)
	      );
}


/* Allocate a menu window
 * ----------------------
 * width and height are the position points to get the menu invisible.
 * itemw and itemh are the size of each item.
 * len is the size of the itemtab, which are the entry strings.
 */

static gs_Menu alloc_Menu(width,height,itemw,itemh,len,itemtab)
int width;
int height;
int itemw;
int itemh;
int len;
char *itemtab[];
{
	int i;
	gs_Menu m;
	Window  w;

	m = (gs_Menu)malloc(sizeof(struct gs_Menu_str)+len*sizeof(gs_MenuItem));
	if (!m) Fatal_error("memory exhausted","");

        w = XCreateSimpleWindow (root_display, frame_window, width+1, 
				    height+1,
                                    itemw, len*itemh,
                                    1,
				    XBlackPixel(root_display,root_screen),
				    XWhitePixel(root_display,root_screen));

	MENU_WIN(m)    = w;
	MENU_WIDTH(m)  = itemw;
	MENU_HEIGHT(m) = len*itemh;
	MENU_VIS(m)    = 0;
	MENU_LEN(m)    = len;
	MENU_DW(m)     = (Drawable)w;
	MENU_GC(m)     = XDefaultGC(root_display, root_screen);
        MENU_GCVAL(m).graphics_exposures = False;
        XChangeGC(root_display, MENU_GC(m), GCGraphicsExposures, &MENU_GCVAL(m));
	MENU_DW(m)     = (Drawable)w;
	if (panel_font)
		XSetFont(root_display,MENU_GC(m),panel_font->fid);

	for (i=1;i<=len;i++) {
		MENU_ITEM(m,i) = alloc_MenuItem(width,height,
					itemw,itemh,
					w,i,itemtab[i-1]);
	} 

        XMapWindow(root_display, w);

	return(m);
}


/* Allocate a menu item 
 * --------------------
 * width and height are the position points to get the menu invisible.
 * itemw and itemh are the size of each item.
 * len is the size of the itemtab, which are the entry strings.
 */

static gs_MenuItem alloc_MenuItem(width,height,itemw,itemh,win,pos,entry)
int width;
int height;
int itemw;
int itemh;
Window win;
int pos;
char *entry;
{
	gs_MenuItem m;
	Window      w;
	XSetWindowAttributes attr;
	unsigned long mask = 0L;

	m = (gs_MenuItem)malloc(sizeof(struct gs_MenuItem_str));
	if (!m) Fatal_error("memory exhausted","");

	/* select for all events */
	attr.event_mask = KeyPressMask           | 
			  ButtonPressMask        | ButtonReleaseMask  |
			  EnterWindowMask        | LeaveWindowMask    |
                          ExposureMask           | ResizeRedirectMask | 
                          SubstructureNotifyMask | 
                          FocusChangeMask        | OwnerGrabButtonMask;

	attr.background_pixel = XWhitePixel(root_display,root_screen);
	attr.border_pixel = XBlackPixel(root_display,root_screen);

	mask |= (CWBackPixel | CWBorderPixel | CWEventMask);

        w = XCreateWindow (root_display,win, 
				      0, (pos-1)*itemh,
                                      itemw, itemh,
				      1, (int)CopyFromParent,
                                      InputOutput, 
				      (Visual *)CopyFromParent,
                           	      mask, &attr);

        XMapWindow(root_display, w);

	MENUITEM_WIN(m) = w;
	MENUITEM_DW(m)  = (Drawable)w;
	MENUITEM_SEL(m) = 0;
	MENUITEM_EXP(m) = 1;
	MENUITEM_TXT(m) = entry;
	MENUITEM_SUB(m)	= NULL;

	return(m);
}


/* Install a submenu toucher 
 * -------------------------
 */


static void install_SubMenu(root_menu,item,sub_menu,sub_touch)
gs_Menu root_menu;
int item;
gs_Menu sub_menu;
Window *sub_touch;
{
	Window      w;
	unsigned long mask = 0L;
	XSetWindowAttributes attr;
	gs_MenuItem mi;

	mi = MENU_ITEM(root_menu,item);

	/* select for all events */
	attr.event_mask = KeyPressMask           | 
			  ButtonPressMask        | ButtonReleaseMask  |
			  EnterWindowMask        | LeaveWindowMask    |
                          ExposureMask           | ResizeRedirectMask | 
                          SubstructureNotifyMask | 
                          FocusChangeMask        | OwnerGrabButtonMask;

	attr.background_pixel = XWhitePixel(root_display,root_screen);
	attr.border_pixel = XBlackPixel(root_display,root_screen);

	mask |= (CWBackPixel | CWBorderPixel | CWEventMask);

        w = XCreateWindow (root_display,MENUITEM_WIN(mi), 
				      MENU_WIDTH(root_menu)-30,0,
                                      30, MENUITEM_HEIGHT,
				      0,(int)CopyFromParent,
                                      InputOutput, 
				      (Visual *)CopyFromParent,
                           	      mask, &attr);

        XMapWindow(root_display, w);

	*sub_touch = w;
	MENUITEM_SUB(mi)  = sub_menu;
}


 
/*--------------------------------------------------------------------*/
/*  Menu Drawing and Management                                       */
/*--------------------------------------------------------------------*/

/* Hide and expose a menu item
 * ---------------------------
 */

static void gs_Hide_MenuItem(m,i)
gs_Menu m;
int     i;
{
	MENUITEM_EXP(MENU_ITEM(m,i)) = 0;
}

static void gs_Expose_MenuItem(m,i)
gs_Menu m;
int     i;
{
	MENUITEM_EXP(MENU_ITEM(m,i)) = 1;
}

static void gs_NewText_MenuItem(m,i,s)
gs_Menu m;
int     i;
char *s;
{
	MENUITEM_TXT(MENU_ITEM(m,i)) = s;
}


static void gs_check_allmenues()
{
	if (V_ruler) 
		gs_NewText_MenuItem(frame_menu,12,"Ruler off           ");
	else
		gs_NewText_MenuItem(frame_menu,12,"Ruler on            ");

	/* if (G_displayel) {
	 *	gs_NewText_MenuItem(layout_menu,1,"Label of edges off");
	 * }	
	 */
}


/* Menu Drawing Functions
 * ======================
 */

/* Draw a menu at position x,y
 * ---------------------------
 */

static void gs_draw_menu(m,x,y)
gs_Menu m;
int x;
int y;
{
	int 	i;
	int 	xpos,  ypos;

	ask_window_size(frame_window);

	xpos = x;
	ypos = y;
	if (xpos+MENU_WIDTH(m)  > window_width)  
		    xpos = window_width - MENU_WIDTH(m);
	if (ypos+MENU_HEIGHT(m) > window_height) 
		    ypos = window_height- MENU_HEIGHT(m);
	if (xpos<0) xpos = 0;
	if (ypos<0) ypos = 0;
	
	XMoveWindow(root_display,MENU_WIN(m),xpos,ypos);
	if (!MENU_VIS(m)) XMapRaised(root_display,MENU_WIN(m));
	MENU_VIS(m) = 1;
	MENU_X(m) = xpos;
	MENU_Y(m) = ypos;

	for (i=1; i<=MENU_LEN(m); i++) gs_draw_menuitem(m,i);
}


/* Draw a submenu of a menu
 * ------------------------
 * rootm is the root menu.
 */

static void gs_draw_submenu(rootm,i)
gs_Menu rootm;
int i;
{
	int xpos,ypos;
	gs_MenuItem mi;

	xpos = MENU_X(rootm)+MENU_WIDTH(rootm)-19;
	ypos = MENU_Y(rootm)+MENUITEM_HEIGHT*(i-1);

	MENUITEM_SEL(MENU_ITEM(rootm,i)) = 1;
	mi = MENU_ITEM(rootm,i);
	if (MENUITEM_SUB(mi)) 
		gs_draw_menu(MENUITEM_SUB(mi),xpos,ypos);
}


/* Draw a menu item 
 * ----------------
 */

static void gs_draw_menuitem(m,i)
gs_Menu m;
int i;
{
	gs_MenuItem mi;

	mi = MENU_ITEM(m,i);
	if (MENUITEM_EXP(mi)==0) MENUITEM_SEL(mi)=0; 
	if (MENUITEM_SEL(mi)) 
		XSetForeground(root_display, MENU_GC(m), carray[BLACK]);
	else    XSetForeground(root_display, MENU_GC(m), carray[WHITE]);

	XFillRectangle(root_display,MENUITEM_DW(mi),MENU_GC(m),
		0,0,
		MENU_WIDTH(m),MENUITEM_HEIGHT);
	if (m==frame_menu) {
		switch (i) {
		case 4:
			XFillRectangle(root_display,
				(Drawable)foldregion_touch,MENU_GC(m),
				0,0,30,MENUITEM_HEIGHT);
			break;
		case 6:
			XFillRectangle(root_display,
				(Drawable)scroll_touch,MENU_GC(m),
				0,0,30,MENUITEM_HEIGHT);
			break;
		case 7:
			XFillRectangle(root_display,
				(Drawable)info_touch,MENU_GC(m),
				0,0,30,MENUITEM_HEIGHT);
			break;
		case 14:
			XFillRectangle(root_display,
				(Drawable)scale_touch,MENU_GC(m),
				0,0,30,MENUITEM_HEIGHT);
			break;
		case 15:
			XFillRectangle(root_display,
				(Drawable)export_touch,MENU_GC(m),
				0,0,30,MENUITEM_HEIGHT);
			break;
		}
	}

	if (MENUITEM_SEL(mi)) 
		XSetForeground(root_display, MENU_GC(m), carray[WHITE]);
	else    XSetForeground(root_display, MENU_GC(m), carray[BLACK]);

	XDrawString(root_display,MENUITEM_DW(mi),MENU_GC(m),3,15,
			MENUITEM_TXT(mi),strlen(MENUITEM_TXT(mi)));

	if (m==frame_menu) {
		switch (i) {
		case 4:
			XDrawString(root_display,
				(Drawable)foldregion_touch,MENU_GC(m),
				0,15,"=>",2);
			break;
		case 6:
			XDrawString(root_display,
				(Drawable)scroll_touch,MENU_GC(m),
				0,15,"=>",2);
			break;
		case 7:
			XDrawString(root_display,
				(Drawable)info_touch,MENU_GC(m),
				0,15,"=>",2);
			break;
		case 14:
			XDrawString(root_display,
				(Drawable)scale_touch,MENU_GC(m),
				0,15,"=>",2);
			break;
		case 15:
			XDrawString(root_display,
				(Drawable)export_touch,MENU_GC(m),
				0,15,"=>",2);
			break;
		}
	}


	if (m == frame_menu) {
		if (MENUITEM_EXP(mi)==0) {
			XDrawLine(root_display,MENUITEM_DW(mi),MENU_GC(m),
				0,0,MENU_WIDTH(m)-30,MENUITEM_HEIGHT);
			XDrawLine(root_display,MENUITEM_DW(mi),MENU_GC(m),
				MENU_WIDTH(m)-30,0,0,MENUITEM_HEIGHT);
		}
	}
	else {
		if (MENUITEM_EXP(mi)==0) {
			XDrawLine(root_display,MENUITEM_DW(mi),MENU_GC(m),
				0,0,MENU_WIDTH(m),MENUITEM_HEIGHT);
			XDrawLine(root_display,MENUITEM_DW(mi),MENU_GC(m),
				MENU_WIDTH(m),0,0,MENUITEM_HEIGHT);
		}
	}
	XSync(root_display, 0);
}


/* Redraw a menu
 * -------------
 * We assume that the menu itself is currently already drawn, but
 * its state has changed.
 * This recursive function traverses a menu and all its submenus.
 * The unselected submenues are hidden. 
 * The selected items are highlighted. The submenus that become
 * visible are drawn.
 */

static void gs_redraw_menu(m)
gs_Menu m;
{
	int i;
	gs_MenuItem mi;

	if (MENU_VIS(m)) {
		for (i=1; i<=MENU_LEN(m); i++) {
			mi = MENU_ITEM(m,i);
			if (MENUITEM_SUB(mi)) {
				if (!MENUITEM_SEL(mi)) {
					MENU_VIS(MENUITEM_SUB(mi))=0;
					gs_hide_menu(MENUITEM_SUB(mi));
				}
			}
		}
		for (i=1; i<=MENU_LEN(m); i++) {
			mi = MENU_ITEM(m,i);
			if (MENUITEM_SEL(mi)) gs_draw_menuitem(m,i);
			if (MENUITEM_SUB(mi)) {
				if (MENUITEM_SEL(mi)) {
					gs_redraw_menu(MENUITEM_SUB(mi)); 
				}
			}
		}
	}
}


/* Menu hiding
 * ===========
 */

/* Hide menu 
 * ---------
 */

static void gs_hide_menu(m)
gs_Menu m;
{
	MENU_VIS(m) = 0;
	XUnmapWindow(root_display,MENU_WIN(m));
}



/* Hide all menus
 * --------------
 */

static void gs_hide_all_menus()
{
	gs_hide_menu(frame_menu);
	gs_hide_menu(foldregion_menu);
	gs_hide_menu(scroll_menu);
	gs_hide_menu(info_menu);
	gs_hide_menu(scale_menu);
	gs_hide_menu(export_menu);
 	show_buffer();
}


/* Check whether the visibility of a menu has changed.
 * --------------------------------------------------
 * The visibility of a menu has changed if a submenu is unselected 
 * now and was selected previously. Then we return 1.
 * The reason that we call this a change of visibility is, that the
 * shape of the menu has changed now and we must redraw the background. 
 */

static int gs_check_vis_changed(m)
gs_Menu m;
{
	int i;
	gs_MenuItem mi;

	if (MENU_VIS(m)) {
		for (i=1; i<=MENU_LEN(m); i++) {
			mi = MENU_ITEM(m,i);
			if (MENUITEM_SUB(mi)) {
				if (!MENUITEM_SEL(mi)) { 
					if (MENU_VIS(MENUITEM_SUB(mi))) 
						return(1);
				}
				if (gs_check_vis_changed(MENUITEM_SUB(mi))) 
					return(1);
			}
		}
	}
	return(0);
}


/* Check which menupoint is selected 
 * ---------------------------------
 * A menupoint is selected if it is touched, or if there it is
 * a submenu containing the touched point. w is the touched window.
 * We return 1 if a a point of the menu m is selected. 
 */

static int gs_check_menuselect(w,m)
Window w;
gs_Menu m;
{ 
	int i,found,found1;

	found = 0;
	if (MENU_VIS(m)) {
		for (i=1; i<=MENU_LEN(m); i++) {
			found1 = 0;
			if (MENUITEM_WIN(MENU_ITEM(m,i))==w) found1 = 1;
			if (MENUITEM_SUB(MENU_ITEM(m,i))) 
				found1 |= gs_check_menuselect(w,
					 MENUITEM_SUB(MENU_ITEM(m,i)));
			if (found1) MENUITEM_SEL(MENU_ITEM(m,i)) = 1;
			else MENUITEM_SEL(MENU_ITEM(m,i)) = 0;
			found |= found1;
		}
	}
	return(found);
}


/* Calculate the selected menu item
 * ================================
 * and handle the selection.
 */

static void gs_handle_menu_selection()
{
	int     retitem;
	gs_Menu retmenu;

	retitem = -1;
	if ((retitem==-1) && ((retitem=gs_check_menureturn(foldregion_menu))!=-1)) 
		retmenu = foldregion_menu;
	if ((retitem==-1) && ((retitem=gs_check_menureturn(scroll_menu))    !=-1)) 
		retmenu = scroll_menu;
	if ((retitem==-1) && ((retitem=gs_check_menureturn(info_menu))      !=-1)) 
		retmenu = info_menu;
	if ((retitem==-1) && ((retitem=gs_check_menureturn(scale_menu))     !=-1)) 
		retmenu = scale_menu;
	if ((retitem==-1) && ((retitem=gs_check_menureturn(export_menu))    !=-1)) 
		retmenu = export_menu;
	if ((retitem==-1) && ((retitem=gs_check_menureturn(frame_menu))     !=-1)) 
		retmenu = frame_menu;
	gs_unselect_allmenus();
	gs_hide_all_menus();
	dispatch_interaction(retmenu,retitem);
}


/* Check the return value of one menu
 * ----------------------------------
 */

static int gs_check_menureturn(m)
gs_Menu m;
{
	int retitem;
	int i;

	retitem = -1;
	if (MENU_VIS(m)) {
		for (i=1; i<=MENU_LEN(m); i++) {
			if (MENUITEM_SEL(MENU_ITEM(m,i))) {
				retitem = i;
			}
			MENUITEM_SEL(MENU_ITEM(m,i)) = 0;
		}
	}
	return(retitem);
}



/* Menu point unselecting
 * ======================
 */

/* Unselect all menu points
 * ------------------------
 */

static void gs_unselect_allmenus()
{
	gs_unselect_menu(foldregion_menu);
	gs_unselect_menu(scroll_menu); 
	gs_unselect_menu(info_menu); 
	gs_unselect_menu(scale_menu); 
	gs_unselect_menu(export_menu); 
	gs_unselect_menu(frame_menu);
}


/* Unselect a menu point 
 * ---------------------
 */

static void gs_unselect_menu(m)
gs_Menu m;
{ 
	int i;

	if (MENU_VIS(m)) {
		for (i=1; i<=MENU_LEN(m); i++) {
			if (MENUITEM_SEL(MENU_ITEM(m,i))) {
				MENUITEM_SEL(MENU_ITEM(m,i)) = 0;
				gs_draw_menuitem(m,i);
			}
		}
	}
}


/*--------------------------------------------------------------------*/
/*  Window resizing procedure                                         */
/*--------------------------------------------------------------------*/

/* If we resize the window, we must take care that the panel stays
 * visible. Otherwise, the user could not see messages, etc.
 */

static void	resizeWindow()
{
	int width,height;
	int no_xy, no_wh;

	width  = G_width;
	height = G_height;

	if (G_xmax<width)  { width = G_xmax;  }
	if (G_ymax<height) { height = G_ymax; }

	no_xy = 0;
	no_wh = 0;
	if (G_x==-1) { G_x = 0; no_xy = 1; }
	if (G_y==-1) { G_y = 0; no_xy = 1; }
	if (!G_width_set)  no_wh = 1;
	if (!G_height_set) no_wh = 1;

	if (no_xy) {
		if (no_wh) {
			ask_window_size(frame_window);
			if ((G_xmax<window_width)||(G_ymax<window_height))
				XResizeWindow(root_display,frame_window,
					width,height);
		}
		else XResizeWindow(root_display,frame_window,width,height);
	}
	else {
		if (no_wh) {
			ask_window_size(frame_window);
			if ((G_xmax<window_width)||(G_ymax<window_height))
				XMoveResizeWindow(root_display,frame_window,
					G_x,G_y,width,height);
			else	XMoveResizeWindow(root_display,frame_window,
					G_x,G_y,window_width,window_height);
		}
		else XMoveResizeWindow(root_display,frame_window,
				G_x,G_y,width,height);
	}

	XMoveResizeWindow(root_display,pix_window,20,2,
		width-PIXW_XOFFSET,height-PIXW_YOFFSET);
	XMoveResizeWindow(root_display,panel_window,2,height-60+4,
		width-6,50);

	XMoveResizeWindow(root_display,leftabsscrollbar,
				2,2,8,height-PIXW_YOFFSET);
	XMoveResizeWindow(root_display,leftscrollbar,
				11,2,8,height-PIXW_YOFFSET);
	XMoveResizeWindow(root_display,lowerscrollbar,
				20, height-PIXW_YOFFSET+5, 
			        width-PIXW_XOFFSET+2, 8);
	XMoveResizeWindow(root_display,lowerabsscrollbar,
				20, height-PIXW_YOFFSET+14, 
				width-PIXW_XOFFSET+2, 8);
	XMoveResizeWindow(root_display,rightscrollbar,
				width-11,2,
				8,height-PIXW_YOFFSET);

	position_nor_scrollbars();
	position_abs_scrollbars();

	gs_hide_all_menus();
}



static void read_leftscrollbar(val)
int val;
{
	ask_window_size(frame_window);
	if (val<0) val=0;
	if (val+SCROLLBAR_LEN >= window_height-PIXW_YOFFSET+2) 
		val = window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2;
	XMoveResizeWindow(root_display,leftscrolltmb, 0,val,6,SCROLLBAR_LEN);
	if (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2==0) act_y_pos=0;
	else act_y_pos = val * (G_ymax-window_height+PIXW_YOFFSET) 
				/ (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2);
	panel_outp("Scrolling","","");
}


static void read_lowerscrollbar(val)
int val; 
{
	ask_window_size(frame_window);
	if (val<0) val=0;
	if (val+SCROLLBAR_LEN >= window_width-PIXW_XOFFSET) 
		val = window_width-PIXW_XOFFSET-SCROLLBAR_LEN;
	XMoveResizeWindow(root_display,lowerscrolltmb, val,0,SCROLLBAR_LEN,6);
	if (window_width-PIXW_XOFFSET-SCROLLBAR_LEN==0) act_x_pos=0;
	else act_x_pos = val * (G_xmax-window_width+PIXW_XOFFSET) 
				/ (window_width-PIXW_XOFFSET-SCROLLBAR_LEN);
	panel_outp("Scrolling","","");
}


static void read_leftabsscrollbar(val)
int val;
{
	char buf[15];

	ask_window_size(frame_window);
	if (val<0) val=0;
	if (val+SCROLLBAR_LEN >= window_height-PIXW_YOFFSET+2) 
		val = window_height-PIXW_YOFFSET -SCROLLBAR_LEN-2;
	XMoveResizeWindow(root_display,leftabsscrolltmb,0,val,6,SCROLLBAR_LEN);
	if (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2==0) V_ymin = 0;
	else V_ymin = val * (maximal_ypos*G_stretch/G_shrink
				-window_height+PIXW_YOFFSET)
		     / (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2);
	if (V_ymin<0) V_ymin = 0;
	V_ymax = V_ymin+G_ymax+COFFSET;
	SPRINTF(buf,"(%d,%d)",V_xmin,V_ymin);
	panel_outp("Position to co-ordinate (x,y) = ",buf,"");
}


static void read_lowerabsscrollbar(val)
int val;
{
	char buf[15];

	ask_window_size(frame_window);
	if (val<0) val=0;
	if (val+SCROLLBAR_LEN >= window_width-PIXW_XOFFSET) 
		val = window_width-PIXW_XOFFSET-SCROLLBAR_LEN;
	XMoveResizeWindow(root_display,lowerabsscrolltmb,val,0,SCROLLBAR_LEN,6);
	if (window_width-PIXW_XOFFSET-SCROLLBAR_LEN==0) V_xmin = 0;
	else V_xmin = val * (maximal_xpos*G_stretch/G_shrink
				-window_width+PIXW_XOFFSET)
		     / (window_width-PIXW_XOFFSET-SCROLLBAR_LEN);
	if (V_xmin<0) V_xmin = 0;
	V_xmax = V_xmin+G_xmax;
	SPRINTF(buf,"(%d,%d)",V_xmin,V_ymin);
	panel_outp("Position to co-ordinate (x,y) = ",buf,"");
}


static void read_rightscrollbar(val)
int val;
{
	int z;
	double factor;
	char buf[15];

	ask_window_size(frame_window);
	z = (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2)/2;
	if (val<0) val=0;
	if (val+SCROLLBAR_LEN >= window_height-PIXW_YOFFSET+2) 
		val = window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2;
	XMoveResizeWindow(root_display,rightscrolltmb, 0,val,6,SCROLLBAR_LEN);
	if (z==0) factor = 1;
	else factor = exp((double)(3*(val-z))/(double)z);
	G_stretch = gstoint(factor*1000); 
	G_shrink  = 1000;
	SPRINTF(buf,"%d.%d %%",G_stretch/10,G_stretch%10);
	panel_outp("Scaling to ",buf,"");
	normalize_scaling();

}



static void position_nor_scrollbars()
{
	int val;

	ask_window_size(frame_window);

	/* This is the inverse of the read_leftscrollbar-formula 
	 */
	if (G_ymax-window_height+PIXW_YOFFSET==0) val = 30000;
	else val=act_y_pos * (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2)
		      		/ (G_ymax-window_height+PIXW_YOFFSET);
	if (val<0) val = 0;
	if (val+SCROLLBAR_LEN >= window_width-PIXW_YOFFSET+2) 
		val = window_width-PIXW_YOFFSET-SCROLLBAR_LEN-2;
	XMoveResizeWindow(root_display,leftscrolltmb, 0,val,6,SCROLLBAR_LEN);

	/* This is the inverse of the read_lowerscrollbar-formula 
	 */
	if (G_xmax-window_width+PIXW_XOFFSET==0) val = 30000;
	else val=act_x_pos * (window_width-PIXW_XOFFSET-SCROLLBAR_LEN)
		      / (G_xmax-window_width+PIXW_XOFFSET);
	if (val<0) val = 0;
	if (val+SCROLLBAR_LEN >= window_width-PIXW_XOFFSET) 
		val = window_width-PIXW_XOFFSET-SCROLLBAR_LEN;
	XMoveResizeWindow(root_display,lowerscrolltmb, val,0,SCROLLBAR_LEN,6);
}


static void position_abs_scrollbars()
{
	int val;
	int z;

	ask_window_size(frame_window);

	/* This is the inverse of the read_leftabsscrollbar-formula 
	 */
	
	if (maximal_ypos*G_stretch/G_shrink-window_height+PIXW_YOFFSET==0)
		val = 30000;
	else val = V_ymin*(window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2) / 
		(maximal_ypos*G_stretch/G_shrink-window_height+PIXW_YOFFSET);
	if (val<0) val = 0;
	if (val+SCROLLBAR_LEN >= window_height-PIXW_YOFFSET+2) 
		val = window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2;
	XMoveResizeWindow(root_display,
		leftabsscrolltmb, 0,val,6,SCROLLBAR_LEN);

	/* This is the inverse of the read_lowerabsscrollbar-formula 
	 */

	if (maximal_xpos*G_stretch/G_shrink-window_width+PIXW_XOFFSET==0)
		val = 30000;
	else val = V_xmin*(window_width-PIXW_XOFFSET-SCROLLBAR_LEN) / 
		(maximal_xpos*G_stretch/G_shrink-window_width+PIXW_XOFFSET);
	if (val<0) val = 0;
	if (val+SCROLLBAR_LEN >= window_width-PIXW_XOFFSET) 
		val = window_width-PIXW_XOFFSET-SCROLLBAR_LEN;
	XMoveResizeWindow(root_display,
		lowerabsscrolltmb, val,0,SCROLLBAR_LEN,6);

	/* This is the inverse of the read_rightscrollbar-formula 
	 */
	z = (window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2)/2;
	if (G_stretch==0) val = 0;
	else if (G_shrink==0)  val = 2*z;
	else val = gstoint(log((double)G_stretch/(double)G_shrink)*(double)z/3)+z;
	if (val<0) val = 0;
	if (val+SCROLLBAR_LEN >= window_height-PIXW_YOFFSET+2) 
		val = window_height-PIXW_YOFFSET-SCROLLBAR_LEN-2;
	XMoveResizeWindow(root_display,
		rightscrolltmb, 0,val,6,SCROLLBAR_LEN);
}


/*--------------------------------------------------------------------*/
/*  Display window open and close                                     */
/*--------------------------------------------------------------------*/

/* These functions are used to allow the animation interface to
 * open or close the window. 
 */

static int is_closed = 0;

void	gs_open()
{
	if (is_closed) {
		XMapRaised(root_display,frame_window);
		XSync(root_display,True);
		is_closed = 0;
	}
}


void	gs_close()
{
	if (!is_closed) {
		XIconifyWindow(root_display, frame_window, root_screen);
		XSync(root_display,True);
		is_closed = 1;
	}
}

/*--------------------------------------------------------------------*/
/*  Auxiliaries with strings                                          */
/*--------------------------------------------------------------------*/

/* Convertion of integers to strings
 * =================================
 */

/* Convert an integer to a string of 4 digits
 * ------------------------------------------
 * It is important that each time the string memory is newly allocated.
 */

static char 	*int_to_str(n)
int	n;
{
	char *r;

	r = (char *)myalloc(5);
	if ((n<-9999)||(n>99999)) return("*");
	SPRINTF(r, "%d", n);
	return (r);
}

/* Convert an integer to a string of 4 digits for the class field
 * --------------------------------------------------------------
 * It is important that each time the string memory is newly allocated.
 */

char 	*class_num(n)
int	n;
{
	char *r;

	assert((n>0)&&(n<=max_nr_classes));
	if (class_name_available && class_names[n-1]) {
		return(class_names[n-1]);
	}
	r = (char *)myalloc(7);
	if ((n<-999)||(n>9999)) n = 0;
	SPRINTF(r, " %d", n);
	return (r);
}

/* Convert an integer to a string of 4 digits for the info field
 * -------------------------------------------------------------
 * It is important that each time the string memory is newly allocated.
 */

static char 	*act_info_num(n)
int	n;
{
	char *r;
	int  sc;

	if (n>3) { sc=1; n=n-3; } 
	else       sc=0;  
	
	assert((n>0)&&(n<=3));

	if (info_name_available && info_names[n-1]) {
		r = myalloc(strlen(info_names[n-1])+20);
		if (sc) SPRINTF(r, "%s (scaled)", info_names[n-1]);
		else    SPRINTF(r, "%s (normal)", info_names[n-1]);
		return(r);
	}
	r = (char *)myalloc(20);
	if ((n<-999)||(n>9999)) n = 0;
	if (sc) SPRINTF(r, "%d (scaled)", n);
	else    SPRINTF(r, "%d (normal)", n);
	return (r);
}



/*--------------------------------------------------------------------*/
/*  Management of the ruler                                           */
/*--------------------------------------------------------------------*/

/* Paint all rulers
 * ================
 * Here, we do not use the buffer, but paint into the unbuffered window
 * directly. The reason is, that painting the rulers is so fast that
 * we can do it to refresh the window. 
 * On the other side, we do not need to reconstruct the buffer if we
 * switch the ruler off: we simply reshow the buffer. That's faster.
 */

static void	ruler_paint()
{
	set_upper_ruler();
	set_lower_ruler();
	set_left_ruler ();
	set_right_ruler();
}


/* Upper, lower, left and right rulers
 * -----------------------------------
 */

static void	set_upper_ruler()
{
	int	l, i, j;
	char	*s;

	if ((G_color == BLACK) && (colored))
		XSetForeground(root_display, pix_GC, carray[WHITE]);
	else	XSetForeground(root_display, pix_GC, carray[BLACK]);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, 
			0, 10, G_xmax, 10);

	j = V_xmin + 100 + act_x_pos;
	i = 100;
	while (j < V_xmax) {
		set_h_scale(i,10);
		s = (char *)int_to_str((int)(j*G_shrink/G_stretch));
		l = strlen(s);
		if ( l%2 == 0 ) set_value(i-l*4,30,s);
		else 		set_value(i-(l-1)*4-4,30,s);
		i += 100;
		j += 100;
	}
}


static void	set_lower_ruler()
{
	int	l, i, j;
	char	*s;

	ask_window_size(frame_window);

	if ((G_color == BLACK) && (colored))
		XSetForeground(root_display, pix_GC, carray[WHITE]);
	else	XSetForeground(root_display, pix_GC, carray[BLACK]);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, 
			0,window_height-10-PIXW_YOFFSET,
			G_xmax,window_height-10-PIXW_YOFFSET);

	j = V_xmin + 100 + act_x_pos;
	i = 100;
	while (j < V_xmax) {
		set_h_scale(i,window_height-10-PIXW_YOFFSET);
		s = (char *)int_to_str((int)(j*G_shrink/G_stretch));
		l = strlen(s);
		if ( l%2 == 0 ) set_value(i-l*4,window_height-16-PIXW_YOFFSET,s);
		else 		set_value(i-(l-1)*4-4,window_height-16-PIXW_YOFFSET,s);
		i += 100;
		j += 100;
	}
}


static void	set_left_ruler()
{
	int	i, j;
	char	*s;

	if ((G_color == BLACK) && (colored))
		XSetForeground(root_display, pix_GC, carray[WHITE]);
	else	XSetForeground(root_display, pix_GC, carray[BLACK]);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, 
			10,0,10,G_ymax);

	j = V_ymin + 100 + act_y_pos;
	i = 100;
	while (j < V_ymax) {
		set_v_scale(10,i);
		s = (char *)int_to_str((int)(j*G_shrink/G_stretch));
		set_value(16,i+4,s);
		i += 100;
		j += 100;
	}
}


static void	set_right_ruler()
{
	int	l, i, j;
	char	*s;

	ask_window_size(frame_window);

	if ((G_color == BLACK) && (colored))
		XSetForeground(root_display, pix_GC, carray[WHITE]);
	else	XSetForeground(root_display, pix_GC, carray[BLACK]);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, 
			window_width-PIXW_XOFFSET-10,0,window_width-PIXW_XOFFSET-10,G_ymax);

	j = V_ymin + 100 + act_y_pos;
	i = 100;
	while (i < V_ymax) {
		set_v_scale(window_width-PIXW_XOFFSET-10,i);
		s = (char *)int_to_str((int)(j*G_shrink/G_stretch));
		l = strlen(s);
		set_value(window_width-PIXW_XOFFSET-16-l*8,i+4,s);
		i += 100;
		j += 100;
	}
}


/* Set a horizontal and vertical scale line item
 * ---------------------------------------------
 */

static void	set_h_scale(x,y)
int	x, y;
{
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, x,y-5,x,y+5);
}


static void	set_v_scale(x,y)
int	x, y;
{
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, x-5,y,x+5,y);
}


/* Draw a scaling number that is given as string s
 * -----------------------------------------------
 */

static void	set_value(x,y,s)
int	x, y;
char	*s;
{
	XDrawString(root_display,(Drawable)pix_window,pix_GC, 
		    x, y, s, strlen(s));
}



/*--------------------------------------------------------------------*/
/*  Interactions                                                      */
/*--------------------------------------------------------------------*/

/* Dispatcher 
 * ----------
 */

static void dispatch_interaction(m,item)
gs_Menu m;
int item;
{
	if (item==-1) return;
	MENUITEM_SEL(MENU_ITEM(m,item)) = 0;
	if (m==frame_menu)           handle_frame_menu(item);
	else if (m==foldregion_menu) handle_fold_menu(item); 
	else if (m==scroll_menu)     handle_scroll_menu(item); 
	else if (m==info_menu)       handle_info_menu(item); 
	else if (m==scale_menu)      handle_scale_menu(item); 
	else if (m==export_menu)     handle_export_menu(item); 
}


/* Analyse buttons
 * ---------------
 * As side effect, we fill button_x and button_y with the position.
 */

static int button_x, button_y;

int which_button(eventp)
XEvent *eventp;
{
	XButtonEvent *e = (XButtonEvent *) eventp;

	button_x = e->x+act_x_pos;
	button_y = e->y+act_y_pos;
	return(e->button);
}


/* Frame menu handler
 * ------------------
 */

static void handle_frame_menu(item)
int item;
{
	switch(item) {
	case 1:
		panel_outp("Fold Subgraph  ","","");
		m_fold_subgraph(); 
		break;
	case 2:	panel_outp("Unfold Subgraph","","");
		m_unfold_subgraph(); 
		break;
	case 3:	panel_outp("Expose/Hide Edges","",""); 
		if (x11_print_classes_dialog()) complete_relayout();
		else show_buffer();
		break;
	case 4:	panel_outp("Fold Region    ","",""); 
		handle_fold_menu(1);
		break;
	case 5:	panel_outp("Unfold Region  ","",""); 
		m_unfold_region(); 
		break;
	case 6:	/* Scroll */
		break;
	case 7:	panel_outp("Node Info      ","",""); 
		handle_info_menu(7); 
		break;
	case 8:	panel_outp("XY-Position    ","",""); 
		m_position(); 
		break;
	case 9:panel_outp("Mouse Position ","","");  
		m_pic_position(); 
		break;
	case 10:panel_outp("Center Node    ","","");  
		m_center_node(x11_print_title_dialog(),1);
		break;
	case 11:panel_outp("Follow Edge    ","","");  
		m_follow_edge(); 
		break;
	case 12:/* Ruler */
		V_ruler = 1-V_ruler;
		clear_panel();
		show_buffer();
		break;
	case 13:/* Layout */
		if (x11_print_layout_dialog()) complete_relayout();
		break;
	case 14:/* Scale */ 
		break; 
	case 15:panel_outp("File           ","","");  
		handle_export_menu(1);
		break; 
	case 16:/* "Quit" */
		gs_exit(0);
		break;
	}
}



/* Region fold menu handler
 * ------------------------
 * If we do fold region, we store in foldregion_class the class to fold.
 */

static int foldregion_class;

static void handle_fold_menu(item)
int item;
{
	int		value;

	panel_outp("Fold Region","",""); 
	foldregion_class = value = item;
	m_fold_region();
}


/* Macros for try again messages
 * -----------------------------
 */

#define TRY_AGAIN_MESSAGE(x,y) panel_outp(x,y," Try again !")


/* Fold subgraph event handler
 * ===========================
 * Wait for a selection of a node with the left mouse button.
 * Selections that do not touch a node have no effect.
 * Pushing another button than the right button stops this
 * procedure.
 */ 


static void	m_fold_subgraph()
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	panel_outp("Select nodes: ",
		   "the subgraphs the selected nodes belongs to are folded.",
		   ""
		  );

	old_cursor = act_cursor;
	set_fold_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v && NROOT(v)) {
					NSTATE(NROOT(v)) = 2;
					add_sgfoldstart(NROOT(v));
					buildCanvas();
					handle_selected_node(v);
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not a node or ",
				        "it is not part of a subgraph.");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				finish_selection();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}



/* Unfold subgraph event handler
 * =============================
 * Wait for a selection of a node with the left mouse button.
 * Selections that do not touch a node have no effect.
 * Pushing another button than the right button stops this
 * procedure.
 */ 

static void	m_unfold_subgraph()
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	panel_outp("Select summary nodes: ",
		   "the subgraphs of these nodes are shown explicitly.",
		   ""
		  );

	old_cursor = act_cursor;
	set_select_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v  && NSGRAPH(v)) {
					NSTATE(v) = 0;
					add_sgunfoldstart(v);
					handle_selected_node(v);
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not a node or ",
					"it is not a subgraph summary node.");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				finish_selection();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}


/* Fold region Event handler 
 * =========================
 */ 

/* Selection of Foldstoppers
 * -------------------------
 * We have selected a class of edges to fold, which is in
 * the variable foldregion_class. Now we need the selection
 * of foldstoppers.
 * The actual curser is the select curser.
 * Wait for a selection of a node with the left mouse button.
 * Selections that do not touch a node have no effect.
 * Pushing another button than the right button starts the
 * selection of the foldstarter.
 */

static void	m_fold_region()
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	panel_outp("Select nodes: ",
		   "the 'Fold Region' operation stops at these nodes.",
		   ""
		  );

	old_cursor = act_cursor;
	set_select_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v) {
					add_foldstop(v);
					handle_selected_node(v);
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not an appropriate node.","");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				m_fold_p2_region();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}


/* Selection of the Foldstarter
 * ----------------------------
 * We have selected a class of edges to fold, which is in
 * the variable foldregion_class, and a set of fold stoppers.
 * The actual curser is the fold curser.
 * Wait for a selection of a node with the left mouse button.
 * Selections that do not touch a node have no effect.
 * Pushing another button than the right button stops this
 * procedure.
 */

static void	m_fold_p2_region()
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	panel_outp("Select nodes: ",
		   "the 'Fold Region' operation starts from these nodes.",
		   ""
		  );

	/* the fold stopper alone don't cause a relayout
	 */
	if (selected_flag) selected_flag = -1;

	old_cursor = act_cursor;
	set_fold_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v) {
					NFOLDING(v) = foldregion_class;
					add_foldstart(v);
					handle_selected_node(v);
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not an appropriate node.","");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				finish_selection();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}



/* Unfold region Event handler 
 * ===========================
 * Wait for a selection of a node with the left mouse button.
 * Selections that do not touch a node have no effect.
 * Pushing another button than the right button stops this
 * procedure.
 */ 

static void	m_unfold_region()
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	panel_outp("Select a node: ",
		   "the region of this summary node is unfolded.",
		   ""
		  );

	old_cursor = act_cursor;
	set_select_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v && NREGREPL(v)) {
					add_unfoldstart(v);
					handle_selected_node(v);
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not a node or ",
					"it is not a region summary node.");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				finish_selection();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}


/* Scroll Menu Handler
 * ===================
 */

static void handle_scroll_menu(item)
int item;
{
	switch(item) {
	case 1:	/* "left" */
		V_xmin -= 32;
		V_xmax = V_xmin+G_xmax;
		break;
	case 2:	/* "right" */
		V_xmin += 32;
		V_xmax = V_xmin+G_xmax;
		break;
	case 3:	/* "up" */
		V_ymin -= 32;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	case 4:	/* "down" */
		V_ymin += 32;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	case 5:	/* "lleft" */
		V_xmin -= 256;
		V_xmax = V_xmin+G_xmax;
		break;
	case 6:	/* "rright" */
		V_xmin += 256;
		V_xmax = V_xmin+G_xmax;
		break;
	case 7:	/* "uup" */
		V_ymin -= 256;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	case 8:	/* "ddown" */
		V_ymin += 256;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	case 9:	/* "llleft" */
		V_xmin -= G_width;
		V_xmax = V_xmin+G_xmax;
		break;
	case 10:/* "rrright" */
		V_xmin += G_width;
		V_xmax = V_xmin+G_xmax;
		break;
	case 11:/* "uuup" */
		V_ymin -= G_height;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	case 12:/* "dddown" */
		V_ymin += G_height;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	case 13:/* "origin" */
		V_xmin = 0;
		V_xmax = V_xmin+G_xmax;
		V_ymin = 0;
		V_ymax = V_ymin+G_ymax+COFFSET;
		break;
	}
	position_abs_scrollbars();
	disable_signal(); 
        displayCanvas(); 
        enable_signal();
}


/* Info Menu Handler
 * =================
 */

static void handle_info_menu(item)
int item;
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	info_val = item;
	truesize = 1;
	if (info_val == 9) {
		old_cursor = act_cursor;
		show_buffer();
		set_select_cursor();
		panel_outp("Press button to continue.","","");
		if (!colored) 
			XSetForeground(root_display, pix_GC, carray[WHITE]);
		else	XSetForeground(root_display, pix_GC, carray[G_color]);
		XFillRectangle(root_display,
               	 	(Drawable)pix_window,
              	  	pix_GC,
			0, 
			0, 
			G_xmax, G_ymax);
		if ((G_color == BLACK) && (colored))
			XSetForeground(root_display, pix_GC, carray[WHITE]);
		else	XSetForeground(root_display, pix_GC, carray[BLACK]);
		xtextout(1,"Statistics:");
		XSync(root_display, 0);
		statistics();

		xinttextout(2,"Number of visible real  nodes: ............... %d",
				st_nr_vis_nodes);
		xinttextout(3,"Number of visible dummy nodes: ............... %d",
				st_nr_vis_dummies);
		xinttextout(4,"Number of visible label nodes: ............... %d",
				st_nr_vis_labels);
		xinttextout(5,"Number of invisible nodes: ................... %d",
				st_nr_invis_nodes);
		xinttextout(6,"Number of invisible graph summary nodes:...... %d",
				st_nr_invis_graphs);
		xinttextout(7,"Number of visible edges (excluding nearedges): %d",
				st_nr_vis_edges);
		xinttextout(8,"Number of visible nearedges (+ anchordummies): %d",
				st_nr_vis_nearedges);
		xinttextout(9,"Number of invisible edges: ................... %d",
				st_nr_invis_edges);
		xinttextout(10,"Maximal indegree  of a visible node: ......... %d",
				st_max_indeg);
		xinttextout(11,"Maximal outdegree of a visible node: ......... %d",
				st_max_outdeg);
		xinttextout(12,"Maximal degree    of a visible node: ......... %d",
				st_max_degree);
		xinttextout(13,"Number of crossings in this layout: .......... %d",
				nr_crossings);
		xtextout(14,   "(except the crossings at anchor points)");
		xinttextout(15,"Maximal x co-ordinate: ....................... %d",
				maximal_xpos);
		xinttextout(16,"Maximal y co-ordinate: ....................... %d",
				maximal_ypos);

		XSync(root_display, 0);
		(void)m_wait_until_button(0);
		show_buffer();
		clear_panel();
		finish_selection();
		act_cursor = old_cursor;
 		reset_cursor();
		return;
	}
	if ((info_val!=7) && (info_val!=8) && (info_val>3)) { 
		info_val -= 3;
		truesize = 0;
	}
	panel_outp("Select a node ",
		   "to get information about this node.",
		   ""
		  );

	old_cursor = act_cursor;
	set_select_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v) {
					set_busy_cursor();
     				  	gs_setto(NX(v) * G_stretch / G_shrink,
       	       					NY(v) * G_stretch / G_shrink );
					selected_flag = -1;
					if (truesize) gs_infobox(v,1,1,info_val);
					else          gs_infobox(v,G_stretch,G_shrink,info_val);
					show_buffer();
					set_select_cursor();
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not an appropriate node.","");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				finish_selection();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}


/* Print a text into the pixwindow at position y*19
 * ------------------------------------------------
 */

static void xtextout(y,msg)
int  y;
char *msg;
{
	XDrawString(root_display,(Drawable)pix_window,pix_GC, 
		    15, y*19, msg, strlen(msg));
}


/* Print a text and integer into the pixwindow at position y*19
 * ------------------------------------------------------------
 */


static void xinttextout(y,msg,i)
int  y;
char *msg;
int i;
{
	SPRINTF(mbuffer,msg,i);
	xtextout(y,mbuffer);
}


/* Absolute Position Handler
 * =========================
 */

static void	m_position()
{
	int xpos,ypos;

	clear_panel();
	xpos = atoi(read_text("x-co-ordinate:",18,1));

	V_xmin = (xpos*G_stretch)/G_shrink;
	V_xmax = V_xmin + G_xmax;

	ypos = atoi(read_text("y-co-ordinate:",36,1));

	V_ymin = (ypos*G_stretch)/G_shrink;
	V_ymax = V_ymin + G_ymax + COFFSET;

	position_abs_scrollbars();
	disable_signal(); 
        displayCanvas(); 
        enable_signal();

	clear_panel();
	reset_menues(); 
}


/* Pick Position Handler
 * =====================
 */

static int reg_minx, reg_miny, reg_maxx, reg_maxy;


static void m_pic_position()
{
	XEvent  event;
	int	notready,old_cursor,h;
	double  scaleval1, scaleval2;

	m_fetch_region();

	ask_window_size(frame_window);

	if (reg_minx>reg_maxx) { 
		h = reg_minx;
		reg_minx = reg_maxx;
		reg_maxx = h;
	}
	if (reg_miny>reg_maxy) { 
		h = reg_miny;
		reg_miny = reg_maxy;
		reg_maxy = h;
	}
	
	if (reg_minx!=reg_maxx) 
		scaleval1 = (float)(window_width)/(float)(reg_maxx-reg_minx);
	else 	scaleval1 = 1.0;
	if (reg_miny!=reg_maxy) 
		scaleval2 = (float)(window_height)/(float)(reg_maxy-reg_miny);
	else 	scaleval2 = 1.0;

	if (scaleval2<scaleval1) scaleval1 = scaleval2;

	if (scaleval1<1.0) {
		G_stretch = (int)(1000.0*scaleval1);
		G_shrink  = 1000;
	}
	else {
		G_stretch = 1000;
		G_shrink  = (int)(1000.0/scaleval1);
	}
	if (G_shrink <= 0)  G_shrink = 1;
	if (G_stretch <= 0) G_stretch = 1;
	normalize_scaling();
	V_xmin = reg_minx * G_stretch/G_shrink;
	V_ymin = reg_miny * G_stretch/G_shrink;
	V_xmax = V_xmin + G_xmax;
	V_ymax = V_ymin + G_ymax + COFFSET;

	position_abs_scrollbars();
	disable_signal(); 
       	displayCanvas(); 
      	enable_signal();

	clear_panel(); 
	reset_menues(); 
}



/* Centering of Nodes - Handler
 * ============================
 */

void	m_center_node(v,invis)
GNODE v;
int   invis;
{
	int	x, y, width, height;

	clear_panel();

	if (v) {
		if (NINLIST(v)) {
			x      = (NX(v)*G_stretch)/G_shrink;
			y      = (NY(v)*G_stretch)/G_shrink;
			width  = (NWIDTH(v)*NSTRETCH(v)*G_stretch)/(NSHRINK(v)*G_shrink);
			height = (NHEIGHT(v)*NSTRETCH(v)*G_stretch)/(NSHRINK(v)*G_shrink); 
			ask_window_size(frame_window);

			V_xmin = (x+width/2)  - window_width/2;
			V_xmax = V_xmin + G_xmax;
			V_ymin = (y+height/2) - (window_height-60)/2;
			V_ymax = V_ymin + G_ymax + COFFSET;
			position_abs_scrollbars();
			disable_signal(); 
       	        	displayCanvas(); 
                	enable_signal();
			clear_panel(); 
		}
		else {
			if (invis)
				panel_outp("This title is currently not visible. ",
					   "Press button to continue.",
				   	   ""); 
			else 	panel_outp("This title is currently not visible. ",
					   "",
				   	   ""); 
			act_follow_edge = NULL;
			act_follow_node = NULL;
			if (!colored) 
				XSetForeground(root_display, pix_GC, carray[WHITE]);
			else	XSetForeground(root_display, pix_GC, carray[G_color]);
			XFillRectangle(root_display,
               		 	pix_dw,
              		  	pix_GC,
				0, 
				0, 
				G_xmax, G_ymax);
			V_xmin = 0;
			V_xmax = V_xmin + G_xmax;
			V_ymin = 0;
			V_ymax = V_ymin + G_ymax + COFFSET;
			NX(v) = NY(v) = 0;
			x = G_shrink;
			y = G_stretch;
			G_shrink = G_stretch = 1;
			calc_node_size(v);
			gs_setshrink(NSTRETCH(v),
                             	     NSHRINK(v)  );
                	gs_setto(0,0);

			draw_one_node(v);

			G_shrink  = x;
			G_stretch = y;
			show_buffer();
			if (invis) (void)m_wait_until_button(0);
			return;
		}
	}
	else {
		disable_signal(); buildCanvas(); enable_signal();
		show_buffer();
		panel_outp("Cancelled (may be: title is not known).","",""); 
	}
	reset_menues(); 
}


/* Wait until a button is pressed 
 * ==============================
 * We return the code of the button that was presses.
 */

static int m_wait_until_button(expose_allowed)
int expose_allowed;
{
	XEvent  event;
	int	notready,old_cursor,result;

	old_cursor = act_cursor;
	set_select_cursor();
	notready = 1;

	result = G_MOUSE_LEFT;
	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (act_follow_target)
				NREVERT(act_follow_target) = 0;
			disable_signal(); buildCanvas(); enable_signal();
			show_buffer();
			clear_panel();
			finish_selection();
			notready = 0;
			result = which_button(&event);
	    		break;
	  	case Expose:
			if (!expose_allowed) break;
			/*FALLTHROUGH*/
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
	return(result);
}


/* Follow an Edge - Handler
 * =========================
 * The start/end-node of the edge is selected by mouse clicking. 
 */


static void	m_follow_edge()
{
	GNODE	v;
	XEvent  event;
	int	notready,old_cursor;

	panel_outp("Select a node to follow its edges.","","");

	act_follow_edge = NULL;
	act_follow_node = NULL;
	old_cursor = act_cursor;
	set_select_cursor();
	notready = 1;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				v = search_xy_node(button_x,button_y);
				if (v && (NSUCC(v)||NPRED(v)||NCONNECT(v))) {
					act_follow_node = v;
					follow_state = 0;
					next_follow_edge();
					x11_followedge_arrow(act_follow_edge);
					notready = 0;
					m_follow_p2_edge();
				}
				else TRY_AGAIN_MESSAGE( 
					"This is not a node or ",
					"it has no edges.");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				finish_selection();
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
}



static void	m_follow_p2_edge()
{
	GNODE	v;
	GEDGE   afe;
	XEvent  event;
	int	notready;
	int     x,y,width,height;
	int 	i;

	panel_outp("Select an edge to follow: ",
		   "Left button for next, ",
		   "right button to continue.");

	notready = 1;
	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				next_follow_edge();
				show_buffer();
				x11_followedge_arrow(act_follow_edge);
				panel_outp("Left button for next, ",
					   "right button to continue.","");
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				notready = 0;
				v = search_target_node(act_follow_node,act_follow_edge);
				if (v) {
					act_follow_node = act_follow_target = v;
					NREVERT(v) = 1;
					x      = (NX(v)*G_stretch)/G_shrink;
					y      = (NY(v)*G_stretch)/G_shrink;
					width  = (NWIDTH(v)*NSTRETCH(v)*G_stretch)/(NSHRINK(v)*G_shrink);
					height = (NHEIGHT(v)*NSTRETCH(v)*G_stretch)/(NSHRINK(v)*G_shrink); 
					ask_window_size(frame_window);

					V_xmin = (x+width/2)  - window_width/2;
					V_xmax = V_xmin + G_xmax;
					V_ymin = (y+height/2) - (window_height-60)/2;
					V_ymax = V_ymin + G_ymax + COFFSET;
					position_abs_scrollbars();
					disable_signal(); 
               		 		buildCanvas(); 
             	   			enable_signal();
					show_buffer();
					panel_outp("Press left button to follow some edge,",
						   " right button to stop.","");
					if (m_wait_until_button(0)==G_MOUSE_LEFT) {
						follow_state = 0;
						afe = last_follow_edge;
						act_follow_edge = NULL;
						i = 0;
						while (afe!=act_follow_edge) {
							next_follow_edge();
							i++;
							if (i>100) break;
						}
						show_buffer();
						x11_followedge_arrow(act_follow_edge);
						m_follow_p2_edge();
					}
				}
				else { assert((0)); }
			}
	    		break;
		default:
			default_handler(&event);
	    		break;
		}
    	}
}


/* Get the next follow edge
 * ------------------------
 * This functions sets the global variable act_follow_edge
 * to the next edge of the node act_follow_node.
 * If act_follow_edge was NULL, it becomes the first edge.
 * Depending on the follow_state, we see which edges are
 * currently actual:
 *   follow_state = 0   =>  no edges are actual  
 *   follow_state = 1   =>  successor   edges NSUCC
 *   follow_state = 2   =>  predecessor edges NPRED
 *   follow_state = 3   =>  connections (near edges)
 *
 * Note that on follow_state = 3, we fetch also the edges
 * that are touched by anchors. Here, we must switch the 
 * act_follow_node to the anchordummy and back.
 */ 

static void next_follow_edge()
{
	ADJEDGE a;
	CONNECT c;

	switch (follow_state) {
	case 1: a = NSUCC(act_follow_node);
		while (a) {  /* look for act_follow_edge */
			if (AKANTE(a)==act_follow_edge) break;
			a = ANEXT(a);
		}
		if (a && ANEXT(a)) { 
			act_follow_edge = AKANTE(ANEXT(a));
			return;
		}
		break;
	case 2: a = NPRED(act_follow_node);
		while (a) { /* look for act_follow_edge */
			if (AKANTE(a)==act_follow_edge) break;
			a = ANEXT(a);
		}
		if (a && ANEXT(a)) { 
			act_follow_edge = AKANTE(ANEXT(a));
			return;
		}
		break;
	}

	/* Now, we have not found an act_follow_edge, or the
 	 * next edge in the same act_follow_state does not
	 * exist. Thus we must switch the act_follow_state.
	 */
	act_follow_edge = 0;
	while (!act_follow_edge) {
		if (follow_state==0) {
			a = NSUCC(act_follow_node);
			follow_state = 1;
			if (a) act_follow_edge = AKANTE(a);
		}
		else if (follow_state==1) {
			a = NPRED(act_follow_node);
			follow_state = 2;
			if (a) act_follow_edge = AKANTE(a);
		}
		else if (follow_state==2) {
			c = NCONNECT(act_follow_node);
			if ((c)&&(CEDGE2(c))) act_follow_edge = CEDGE2(c);
			follow_state = 3;
		}
		else if (follow_state==3) {
			c = NCONNECT(act_follow_node);
			if ((c)&&(CEDGE(c))) act_follow_edge = CEDGE(c);
			follow_state = 0;
			if ((c)&&(CEDGE(c))&&(NANCHORNODE(CTARGET(c)))) {
				act_follow_node = CTARGET(c);
				act_follow_edge = 0;
			}
			else if (NANCHORNODE(act_follow_node)) {
				act_follow_node = CTARGET(c);
				act_follow_edge = 0;
			}
		}
	}
}


/* Look for the target of edge e that starts at node v
 * ---------------------------------------------------
 * We get a real node as target, but not a dummy node
 * or a label.
 * Note: v and e must be visible.
 */

static GNODE search_target_node(v,e)
GNODE v;
GEDGE e;
{
	GNODE w,h;
	GEDGE e1;
	CONNECT c;

	assert((e));
	w = ESTART(e);
	if (w==v) w = EEND(e);

	last_follow_edge = e;

	/* check whether w is in the nodelist, i.e. a visible
	 * original node or graph summary node. 
	 */
	h = nodelist;
	while (h) { 
		if (h==w) break;
		h = NNEXT(h);
	}

	if (!h) { /* w is not in the nodelist. It must be a dummy
		   * node or a label.
		   */

		c = NCONNECT(w);
		if (c && (CEDGE(c))) {
			e1 = CEDGE(c);
			if (e1!=e) return(search_target_node(w,e1));
		}
		if (c && (CEDGE2(c))) {
			e1 = CEDGE2(c);
			if (e1!=e) return(search_target_node(w,e1));
		}
		/* dummy nodes and labels have maximal 2 successors */
		if (NSUCC(w)) {
			e1 = AKANTE(NSUCC(w));
			if (e1!=e) return(search_target_node(w,e1));
		}	
		if (NSUCC(w) && (ANEXT(NSUCC(w)))) {
			e1 = AKANTE(ANEXT(NSUCC(w)));
			if (e1!=e) return(search_target_node(w,e1));
		}	
		/* dummy nodes and labels have maximal 2 predecessors */
		if (NPRED(w)) {
			e1 = AKANTE(NPRED(w));
			if (e1!=e) return(search_target_node(w,e1));
		}	
		if (NPRED(w) && (ANEXT(NPRED(w)))) {
			e1 = AKANTE(ANEXT(NPRED(w)));
			if (e1!=e) return(search_target_node(w,e1));
		}	
	}
	return(w);
}


/* To speedup the follow edge operation, we use a special
 * drawing routine in x11_followedge_arrow that does not
 * draws to the buffer but to the window.
 * Thus, the window can be cleaned by simply refreshing it.
 */

void x11_followedge_line(fx,fy,tx,ty,t,c) 
int fx,fy,tx,ty,t,c;
{
	XSetForeground(root_display, pix_GC, carray[c]);
	XSetLineAttributes(root_display, pix_GC, (t>0?t-1:0),
                LineSolid, CapRound, JoinRound);
	XDrawLine(root_display,
                (Drawable)pix_window,
                pix_GC,
                fx-V_xmin-act_x_pos, fy-V_ymin-act_y_pos,
                tx-V_xmin-act_x_pos, ty-V_ymin-act_y_pos
        );
        XSync(root_display, 0);
	XSetLineAttributes(root_display, pix_GC, 0, 
		LineSolid, CapRound, JoinRound);
}



/* Scale Menu Handler
 * ==================
 */

static void 	handle_scale_menu(item)
int item;
{
	int xx,yy; 

	xx = V_xmin * G_shrink/G_stretch;
	yy = V_ymin * G_shrink/G_stretch;
	switch(item) {
	case 1: /* normal */
		G_stretch = 1;
		G_shrink  = 1;
		break;
	case 2: /* "400 %" */
		G_stretch *= 4;
		break;
	case 3: /* "200 %" */
		G_stretch *= 2;
		break;
	case 4: /* "150 %" */
		G_stretch *= 3;
		G_shrink  *= 2;
		break;
	case 5: /* "90 %" */
		G_stretch *= 9;
		G_shrink  *= 10;
		break;
	case 6: /* "80 %" */
		G_stretch *= 8;
		G_shrink  *= 10;
		break;
	case 7: /* "70 %" */
		G_stretch *= 7;
		G_shrink  *= 10;
		break;
	case 8: /* "60 %" */
		G_stretch *= 6;
		G_shrink  *= 10;
		break;
	case 9: /* "50 %" */
		G_shrink  *= 2;
		break;
	case 10: /* "25 %" */
		G_shrink  *= 4;
		break;
	}

	normalize_scaling();
	V_xmin = xx * G_stretch/G_shrink;
	V_ymin = yy * G_stretch/G_shrink;
	V_xmax = V_xmin+G_xmax;
	V_ymax = V_ymin+G_ymax+COFFSET;
	
	position_abs_scrollbars();
	disable_signal(); 
        displayCanvas(); 
        enable_signal();
}


/* Export Menu Handler
 * ===================
 */


static void 	handle_export_menu(item)
int item;
{
	switch(item) {
	case 1: /* "Load" */
		load_save_flag = LS_LOAD;
		clear_panel();
		m_loadsave();
		return;
	case 2: /* "Reload" */
		m_reload();
		return;
	case 3:	/* "Save to file" */
		load_save_flag=LS_SAVEASCII;
		m_loadsave();	
		return;
	case 4:	/* "Export " */
		m_fetch_region();	
		x11_print_dialog(reg_minx, reg_miny, reg_maxx, reg_maxy);
		switch (act_output_type) { 
		case 0:
			panel_outp("Cancelled !\n","","");
			reset_menues();
			return;
		case 1: load_save_flag=LS_SAVEPPM;
			break;
		case 2: load_save_flag=LS_SAVEPPM;
			break;
		case 3: load_save_flag=LS_SAVEPS;
			break;
		}
		m_loadsave();
		return;
	}
	disable_signal(); 
        displayCanvas(); 
        enable_signal();
}


/*  Fetch a region to by a rubber band
 *  ----------------------------------
 *  The result is in region_[min|max][x|y].
 */

static void m_fetch_region()
{
	int notready, old_cursor, rubberthere;
	XEvent  event;
	int sx,sy,tx,ty;

	reg_minx = reg_miny = reg_maxx = reg_maxy = 0;

	panel_outp("Select a region by a rubberband. ",
		   "Right mouse button to cancel.","");

	old_cursor = act_cursor;
	set_fold_cursor();
	notready = 1;
	rubberthere = 0;

	while (notready) {

		XNextEvent (root_display, &event);

		switch (event.type) {
	  	case ButtonPress:
	    		prologue (&event, "ButtonPress");
			if (which_button(&event)==G_MOUSE_LEFT) {
				if (!rubberthere) {
					rubberthere = 1;
					reg_minx = (button_x+V_xmin)
							*G_shrink/G_stretch;
					reg_miny = (button_y+V_ymin)
							*G_shrink/G_stretch;
				        panel_outp(
             				    "Select a region by a rubberband. ",
		   			    "Right mouse button to retry.","");
				}
			}
			else if (which_button(&event)==G_MOUSE_RIGHT) {
				if (!rubberthere) {
					reg_minx = reg_miny = 
					reg_maxx = reg_maxy = 0;
					notready = 0; 
				}
				else {
				       panel_outp(
             				    "Select a region by a rubberband. ",
		   			    "Right mouse button to cancel.","");
					rubberthere = 0;
					reg_minx = reg_miny = 
					reg_maxx = reg_maxy = 0;
				}
			}	
	    		break;
	  	case MotionNotify:
	    		prologue (&event, "MotionNotify");
			if (((XMotionEvent *)(&event))->window==pix_window) {
				sx = reg_minx*G_stretch/G_shrink
					-V_xmin-act_x_pos;
				sy = reg_miny*G_stretch/G_shrink
					-V_ymin-act_y_pos;
				tx = ((XMotionEvent *)(&event))->x;
				ty = ((XMotionEvent *)(&event))->y;
				if (rubberthere) draw_rubberband(sx,sy,tx,ty);
				else draw_rubberband(0,0,0,0);
			}
			break;
	  	case ButtonRelease:
	    		prologue (&event, "ButtonRelease");
			if (which_button(&event)==G_MOUSE_LEFT) {
				if (rubberthere) {
					reg_maxx = (button_x+V_xmin)
							*G_shrink/G_stretch;
					reg_maxy = (button_y+V_ymin)
							*G_shrink/G_stretch;
					sx = reg_minx*G_stretch/G_shrink
						-V_xmin-act_x_pos;
					sy = reg_miny*G_stretch/G_shrink
						-V_ymin-act_y_pos;
					tx = reg_maxx*G_stretch/G_shrink
						-V_xmin-act_x_pos;
					ty = reg_maxy*G_stretch/G_shrink
						-V_ymin-act_y_pos;
					draw_rubberband(sx,sy,tx,ty);
					notready = 0;
				}
			}
			break;
		default:
			default_handler(&event);
	    		break;
		}
    	}

	act_cursor = old_cursor;
 	reset_cursor();
	clear_panel();
	show_buffer();
}



static void draw_rubberband(a,b,c,d)
int a,b,c,d;
{
	show_buffer();
	if ((G_color == BLACK) && (colored))
		XSetForeground(root_display, pix_GC, carray[WHITE]);
	else	XSetForeground(root_display, pix_GC, carray[BLACK]);

	XDrawLine(root_display, (Drawable)pix_window, pix_GC, a,b, c,b);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, c,b, c,d);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, c,d, a,d);
	XDrawLine(root_display, (Drawable)pix_window, pix_GC, a,d, a,b);
}



/* Load/Save a file 
 * ================
 */

static char fbuf[1024];

static void	m_loadsave()
{
	char	*name;
	int old_cursor,success,pos;


	pos = 18;
	success = 0;
	old_cursor = act_cursor;
	while (!success) {
		set_busy_cursor();
		name = x11_print_fisel_dialog();
		if (!name) break;
		*fbuf = 0;
		if (name) strcpy(fbuf, name);
	
		disable_signal(); 

		success = 1;
		if (load_save_flag==LS_LOAD) {
			strcpy(Dataname, fbuf);
	
			success = is_readeable(Dataname);
	
			if (success) {
				clear_hide_class();
				parse_part();
				visualize_part();
				resizeWindow(); 
			}
		}
		else if (load_save_flag==LS_SAVEASCII) {
			success = is_writable(fbuf);
			if (success && (!print_graph(fbuf))) {
				panel_outp("Error on writing file. ",
					   "File may exist or is unwriteable.",""); 
				success = 0;
			}
		}
		else if (load_save_flag==LS_SAVEPPM) {
			success = is_writable(fbuf);
			if (success) 
				(void)print_pbm_or_ppm(fbuf,reg_minx,reg_miny,
						       	    reg_maxx, reg_maxy);
		}
		else if (load_save_flag==LS_SAVEPS) {
			success = is_writable(fbuf);
			if (success) print_all_ps(fbuf, reg_minx, reg_miny, 
							reg_maxx, reg_maxy); 
		}
		pos = 36;
	}
       	if (success) displayCanvas(); 
	act_cursor = old_cursor;
 	reset_cursor();
       	enable_signal();
}


/* Reload the same file
 * ====================
 */

void	m_reload()
{
	int old_cursor,success;

	success = is_readeable(Dataname);
	if (!success) return; 

	old_cursor = act_cursor;
	set_busy_cursor();
	disable_signal(); 
	clear_hide_class();
	parse_part();
	visualize_part();
	resizeWindow(); 
        displayCanvas(); 
	act_cursor = old_cursor;
 	reset_cursor();
        enable_signal();
}


/* Auxiliaries for load and save procedures
 * ----------------------------------------
 */


/* Check whether file is readable.
 * Returns 1 if yes. Opens file stream fp.  
 */

static int is_readeable(fname)
char *fname;
{
	FILE *f;
	char *c;

	f = NULL;
	c = fname;
	while (*c) c++;
	if (c>fname) c--;
	if (*c=='/') {
		panel_outp("Illegal filename.","",""); 
		reset_menues(); 
		return(0);
	}
       	if (( strcmp(fname,"-")==0 ) || (*fname==0)) { 
		panel_outp("Illegal filename.","",""); 
		reset_menues(); 
		return(0);
	}
       	f = fopen(fname,"r");
       	if (f == NULL) { 
		panel_outp("Cannot open file '",fname,"'."); 
		reset_menues(); 
		return(0);
	}
	else fclose(f);
	return(1);
}


/* Check whether file is writable.
 * Returns 1 if yes. Opens file stream fp.  
 */

static int is_writable(fname)
char *fname;
{
	FILE *f;
	char *c;

	f = NULL;
	c = fname;
	while (*c) c++;
	if (c>fname) c--;
	if (*c=='/') {
		panel_outp("Illegal filename.","",""); 
		reset_menues(); 
		return(0);
	}
       	if (( strcmp(fname,"-")==0 ) || (*fname==0)) { 
		panel_outp("Illegal filename.","",""); 
		reset_menues(); 
		return(0);
	}
       	f = fopen(fname,"r");
       	if (f != NULL) { 
		panel_outp("Error on writing file. ",
			   "File may exist or is unwriteable.",""); 
		reset_menues(); 
		fclose(f);
		return(0);
	}
	return(1);
}


/*--------------------------------------------------------------------*/


/* Default Event Handler
 * =====================
 * This handler manages the absolutely basic events like resize of
 * windows, expose, or the minimal keyboard events.
 */

static void default_handler(event)
XEvent *event;
{
	switch (event->type) {
	  case KeyPress:
	  	prologue (event, "KeyPress");
	    	do_minimalKeyPress (event);
	    	break;
	  case Expose:
	  	prologue (event, "Expose");
	    	do_Expose (event);
	    	break;
	  case ConfigureNotify:
	  	prologue (event, "ConfigureNotify");
	    	do_ConfigureNotify (event);
	    	break;
	}
}


/*--------------------------------------------------------------------*/
/*  Node selection handler                                            */
/*--------------------------------------------------------------------*/

/* Handle selection of nodes
 * -------------------------
 * If a node was selected, it is added to the folding keepers.
 * Depending whether the node was a folding keeper before, it is now
 * one ore not. Thus we must redisplay the node and notify the
 * selection.
 */

static void handle_selected_node(v)
GNODE v;
{
        gs_setshrink(G_stretch * NSTRETCH(v),
       		     G_shrink  * NSHRINK(v)  );
       	gs_setto(NX(v) * G_stretch / G_shrink,
       	         NY(v) * G_stretch / G_shrink );
	draw_one_node(v);
	show_buffer();
	selected_flag = 1;
	panel_outp("Next node ... (right mouse button to continue).","","");
}


/* Finish the selection
 * --------------------
 * If something was selected, the selected_flag is true. Then, we must
 * relayout. Otherwise, we only must reinstall the main menu.
 */

static void finish_selection()
{
	clear_panel();
	if (selected_flag==1) complete_relayout();
	else { 	clear_folding_keepers();
		if (selected_flag==-1) buildCanvas();
		reset_menues(); 
	}
	selected_flag = 0;
}


/*  Reinit the main menu of the canvas
 *  ==================================
 *  After building the canvas, we reinitialize the main menu procedure
 *  of the canvas. For security reason, because some event handling
 *  use own canvas selection procedures. 
 */

static void	reset_menues()
{
	if (act_follow_target)
		NREVERT(act_follow_target) = 0;
 	reset_cursor();
}

/* Relayout and display the new graph
 * ----------------------------------
 * If after folding, a complete relayout is necessary, we start here.
 */

static void complete_relayout()
{
	int old_cursor;

	old_cursor = act_cursor;
	set_busy_cursor();
	disable_signal();
	relayout();
	displayCanvas();
	act_cursor = old_cursor;
 	reset_cursor();
	enable_signal();
}


/*--------------------------------------------------------------------*/
/*  Character buffering                                               */
/*--------------------------------------------------------------------*/

/* One large problem with X11 is, that it is ridiculus slow.
 * Especially drawing characters may be improved, if we buffer
 * the character shape and perform bitmap plane copies instead 
 * of drawing characters line by line.
 * 
 * Thus, for small fontsizes, we buffer the fonts, i.e. store 
 * the whole character set in a bitmap and only copy the characters
 * to the pix_window.
 * We use for buffers. The first has the absolute scale factor 1.
 * The second has the relative scale factor 1. 
 * The others have scale factors as determined dynamically during
 * drawing.
 * We use buffering until a scaling factor of 2.
 */

#define MAX_FONTBUFS 4

static Pixmap font_buffer[MAX_FONTBUFS];

static  GC        fbuf_GC;
static  XGCValues fbuf_GCvalues;

static int fbuf_shrink[MAX_FONTBUFS];
static int fbuf_stretch[MAX_FONTBUFS];
static int fbuf_filled[MAX_FONTBUFS];

static int font_buffering = 1;

static int act_font_buffer;
static int act_font_width;
static int act_font_height;

#define FBUF_BLACK 1
#define FBUF_WHITE 0

/* Enable or disable font buffering
 * ================================
 */

void enable_font_buffering()
{
	font_buffering = 1;
}

void disable_font_buffering()
{
	font_buffering = 0;
}


/* Allocate all fontbuffers
 * ========================
 */

static void alloc_all_fontbuffers()
{
	int i;
	for (i=0; i<MAX_FONTBUFS; i++) {
		font_buffer[i] = alloc_fontbuffer();
		fbuf_filled[i] = 0;
	}
        fbuf_GCvalues.graphics_exposures = False;
        fbuf_GCvalues.foreground = FBUF_BLACK;
        fbuf_GCvalues.background = FBUF_WHITE;
	fbuf_GC = XCreateGC(root_display, (Drawable)(font_buffer[0]),
		GCGraphicsExposures | GCForeground | GCBackground, 
		&fbuf_GCvalues);
	normalize_scaling();
}


/* Allocate a fontbuffer and return it
 * -----------------------------------
 */

static Pixmap alloc_fontbuffer()
{
	Pixmap p;

        p = XCreatePixmap(root_display,
                        (Drawable)RootWindow(root_display, root_screen), 
                        (unsigned int)(256*8*2),
                        (unsigned int)(16*2),
                        (unsigned int)1);
	return(p);
}


/* Fill a fontbuffer buf
 * =====================
 * The scaling factors are shrink and stretch.
 */

static unsigned char allcharstring[256] = 
	"/!?\"`'\\:;,.=-+*@|&^%$#~()[]{}<>_0123456789 abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ";

static int bufstretch; /* local updates of scaling factors */
static int bufshrink;

static void fill_fontbuffer(buf,stretch,shrink)
int buf;
int stretch;
int shrink;
{
	unsigned char *c;

	if (buf>=MAX_FONTBUFS) return;
	if (fbuf_filled[buf])  return;
	bufstretch = stretch;
	bufshrink  = shrink;
	XSetForeground(root_display, fbuf_GC, FBUF_WHITE);
	XFillRectangle(root_display,
               	(Drawable)font_buffer[buf],
               	fbuf_GC,
		0, 
		0, 
		256*8*2, 16*2);
	XSetForeground(root_display, fbuf_GC, FBUF_BLACK);
	c = allcharstring;
	act_font_buffer = buf;
	while (*c) {
		charbuffer_draw(*c++);
	}
	fbuf_filled[buf]  = 1;
	fbuf_shrink[buf]  = shrink;
	fbuf_stretch[buf] = stretch;
}

/* Set a new shrink/stretch value
 * ==============================
 */

static void new_scale_fontbuffers(stretch,shrink)
int stretch;
int shrink;
{
	int i;

	for (i=1; i<MAX_FONTBUFS; i++) fbuf_filled[i] = 0;
	fill_fontbuffer(0,1,1);
	if ((stretch!=1)||(shrink!=1)) fill_fontbuffer(1,stretch,shrink);
}


/* Set a new scaling value for font buffering 
 * ==========================================
 * We return 1 on success and 0 on failure.
 * Further, we set act_font_buffer to the number of the buffer, that
 * contains this font.
 */

int set_fontbuffer(stretch,shrink)
int stretch;
int shrink;
{
	int i;

	if (!font_buffering)  return(0);
	if (stretch>2*shrink) return(0);
	act_font_width  = 8*stretch/shrink;
	act_font_height = 16*stretch/shrink;
	for (i=0; i<MAX_FONTBUFS; i++) {
		if (   fbuf_filled[i] 
		    && (fbuf_stretch[i]==stretch) && (fbuf_shrink[i]==shrink)) {
			act_font_buffer = i;
			return(1);
		}
	}
	for (i=0; i<MAX_FONTBUFS; i++) {
		if (!fbuf_filled[i]) { 
			fill_fontbuffer(i,stretch,shrink);
			act_font_buffer = i;
			return(1);
		}
	}
	act_font_buffer = 0;
	return(0);
}


/* Draw a buffered character
 * =========================
 */

void draw_fast_char(color,c,xpos,ypos)
int color;
int c;
int xpos;
int ypos;
{
	XSetForeground(root_display, pix_GC, carray[color]);
	XSetBackground(root_display, pix_GC, carray[gs_actbackground]);
	XCopyPlane(root_display,
               	   (Drawable)font_buffer[act_font_buffer],
		   pix_dw,
               	   pix_GC,
		   (int)c * 16*2, 0,
		   act_font_width,
		   act_font_height,
		   xpos-V_xmin, ypos-V_ymin, 1); 
}


/* After drawing a sequence of chars, we should do this:
 * -----------------------------------------------------
 */

void finish_fast_chars()
{
	XSync(root_display, 0);
}


/*  Turtle graphics cursor positions
 *  --------------------------------
 *  The relative origin of the turtle graphics is (bufxpos,bufypos).  
 *  All co-ordinates of the turtle graphics are scaled offsets to this
 *  origin.
 *  The actual position of the turtle is (bufactxpos, bufactypos). 
 */

static int bufxpos,bufypos;
static int bufactxpos, bufactypos;

/*  Turtle graphics primitiva 
 *  -------------------------
 */

/* 
 *  Set turtle to (x,y) relatively to the origin (bufxpos,bufypos).
 */

#ifndef DRAWLIB_TOO_LARGE
static
#endif
int bufsetto(x,y)
int x,y;
{
	int s=bufstretch;
	int t=bufshrink;
	bufactxpos = bufxpos+(s*x)/t;
	bufactypos = bufypos+(s*y)/t;
}

/* 
 *  Move the turtle from its actual position to (x,y) relatively to 
 *  the origin (bufxpos,bufypos). Draw this movement with color c.
 */

#ifndef DRAWLIB_TOO_LARGE
static
#endif
int bufmoveto(x,y)
int x,y;
{
	int s=bufstretch;
	int t=bufshrink;
	int a = bufxpos+(s*x)/t;
	int b = bufypos+(s*y)/t;
	XDrawLine(root_display,
               	(Drawable)font_buffer[act_font_buffer],
                fbuf_GC,
		bufactxpos,
		bufactypos,
		a,b);
	bufactxpos = a;
	bufactypos = b;
}


/* Draw a character into a buffer
 * ==============================
 * The following is copied and modified from drawlib.c.
 */


static void charbuffer_draw(c)
int c;
{
	bufxpos = bufactxpos = (int)c * 16*2;
	bufypos = bufactypos = 0;

#ifdef DRAWLIB_TOO_LARGE
	x11_draw_char(c);
#else
	switch(c) {
	case '!': 
		bufsetto(3,2); 
		bufmoveto(3,8);
		bufsetto(3,11); 
		bufmoveto(3,11);
		break;
	case '?': 
		bufsetto(1,4); 
		bufmoveto(1,3); 
		bufmoveto(2,2);
		bufmoveto(5,2); 
		bufmoveto(6,3); 
		bufmoveto(6,4);
		bufmoveto(4,7); 
		bufmoveto(4,8); 
		bufsetto(4,11);
		bufmoveto(4,11);
		break;
	case '"': 
		bufsetto(2,2); 
		bufmoveto(2,4);
		bufsetto(5,2); 
		bufmoveto(5,4);
		break;
	case '`': 
		bufsetto(2,2); 
		bufmoveto(2,3); 
		bufmoveto(4,5);
		break;
	case '\'': 
		bufsetto(4,2); 
		bufmoveto(4,3); 
		bufmoveto(2,5);
		break;
	case ':': 
		bufsetto(4,5); 
		bufmoveto(5,5);
		bufmoveto(5,6); 
		bufmoveto(4,6); 
		bufmoveto(4,5);
		bufsetto(4,10); 
		bufmoveto(5,10);
		bufmoveto(5,11); 
		bufmoveto(4,11); 
		bufmoveto(4,10);
		break;
	case ';': 
		bufsetto(4,5); 
		bufmoveto(5,5);
		bufmoveto(5,6); 
		bufmoveto(4,6); 
		bufmoveto(4,5);
		bufsetto(4,10); 
		bufmoveto(5,10);
		bufmoveto(5,11); 
		bufmoveto(4,11); 
		bufmoveto(4,10);
		bufsetto(5,11); 
		bufmoveto(5,12); 
		bufmoveto(3,14);
		break;
	case ',': 
		bufsetto(4,10); 
		bufmoveto(5,10);
		bufmoveto(5,11); 
		bufmoveto(4,11); 
		bufmoveto(4,10);
		bufsetto(5,11); 
		bufmoveto(5,12); 
		bufmoveto(3,14);
		break;
	case '.': 
		bufsetto(4,10); 
		bufmoveto(5,10);
		bufmoveto(5,11); 
		bufmoveto(4,11); 
		bufmoveto(4,10);
		break;
	case '=': 
		bufsetto(1,5); 
		bufmoveto(6,5);
		bufsetto(1,9); 
		bufmoveto(6,9);
		break;
	case '-': 
		bufsetto(1,7); 
		bufmoveto(6,7);
		break;
	case '+': 
		bufsetto(0,7); 
		bufmoveto(6,7);
		bufsetto(3,10); 
		bufmoveto(3,4);
		break;
	case '*': 
		bufsetto(1,5); 
		bufmoveto(2,6);
		bufmoveto(4,6); 
		bufmoveto(5,7);
		bufsetto(3,4); 
		bufmoveto(3,8);
		bufsetto(1,7); 
		bufmoveto(2,6);
		bufmoveto(4,6); 
		bufmoveto(5,5);
		break;
	case '@': 
		bufsetto(6,10); 
		bufmoveto(5,11);
		bufmoveto(3,11); 
		bufmoveto(1,9); 
		bufmoveto(1,4);
		bufmoveto(3,2); 
		bufmoveto(4,2); 
		bufmoveto(6,4);
		bufmoveto(6,7); 
		bufmoveto(5,8); 
		bufmoveto(4,8);
		bufmoveto(3,7); 
		bufmoveto(3,6); 
		bufmoveto(4,5);
		bufmoveto(5,5); 
		bufmoveto(6,6);
		break;
	case '|': 
		bufsetto(3,1); 
		bufmoveto(3,12);
		break;
	case '&': 
		bufsetto(6,7); 
		bufmoveto(3,11);
		bufmoveto(1,11); 
		bufmoveto(0,10);
		bufmoveto(0,7); 
		bufmoveto(4,4);
		bufmoveto(4,3); 
		bufmoveto(3,2);
		bufmoveto(2,2); 
		bufmoveto(1,3);
		bufmoveto(1,4); 
		bufmoveto(2,5);
		bufmoveto(4,9); 
		bufmoveto(4,10);
		bufmoveto(6,11);
		break;
	case '^': 
		bufsetto(1,5); 
		bufmoveto(3,3);
		bufmoveto(4,3); 
		bufmoveto(6,5);
		break;
	case '%': 
		bufsetto(0,3); 
		bufmoveto(1,2); 
		bufmoveto(2,2);
		bufmoveto(3,3); 
		bufmoveto(3,4); 
		bufmoveto(2,5);
		bufmoveto(1,5); 
		bufmoveto(0,4); 
		bufmoveto(0,3);
		bufsetto(3,9); 
		bufmoveto(4,8); 
		bufmoveto(5,8);
		bufmoveto(6,9); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(4,11); 
		bufmoveto(3,10); 
		bufmoveto(3,9);
		bufsetto(6,2); 
		bufmoveto(1,11);
		break;
	case '$': 
		bufsetto(5,4); 
		bufmoveto(5,3);
		bufmoveto(4,2); 
		bufmoveto(2,2); 
		bufmoveto(1,3);
		bufmoveto(1,4); 
		bufmoveto(3,6); 
		bufmoveto(4,6);
		bufmoveto(5,8); 
		bufmoveto(5,10); 
		bufmoveto(4,11);
		bufmoveto(2,11); 
		bufmoveto(1,10); 
		bufmoveto(1,9);
		bufsetto(3,1); 
		bufmoveto(3,12);
		break;
	case '#': 
		bufsetto(1,11); 
		bufmoveto(3,2);
		bufsetto(1,5); 
		bufmoveto(7,5);
		bufsetto(0,9); 
		bufmoveto(6,9);
		bufsetto(4,11); 
		bufmoveto(6,2);
		break;
	case '~': 
		bufsetto(1,4); 
		bufmoveto(2,3); 
		bufmoveto(3,3);
		bufmoveto(4,4); 
		bufmoveto(5,4); 
		bufmoveto(6,3);
		break;
	case '(': 
		bufsetto(5,1); 
		bufmoveto(2,4);
		bufmoveto(2,9); 
		bufmoveto(5,12); 
		break;
	case ')': 
		bufsetto(2,1); 
		bufmoveto(5,4);
		bufmoveto(5,9); 
		bufmoveto(2,12); 
		break;
	case '[': 
		bufsetto(5,1); 
		bufmoveto(2,1);
		bufmoveto(2,13); 
		bufmoveto(5,13);
		break;
	case ']': 
		bufsetto(2,1); 
		bufmoveto(5,1);
		bufmoveto(5,13); 
		bufmoveto(2,13);
		break;
	case '{': 
		bufsetto(6,1); 
		bufmoveto(4,1); 
		bufmoveto(3,2);
		bufmoveto(3,6); 
		bufmoveto(2,7); 
		bufmoveto(1,7);
		bufmoveto(2,7); 
		bufmoveto(3,8); 
		bufmoveto(3,12);
		bufmoveto(4,13); 
		bufmoveto(6,13);
		break;
	case '}': 
		bufsetto(1,1); 
		bufmoveto(3,1); 
		bufmoveto(4,2);
		bufmoveto(4,6); 
		bufmoveto(5,7); 
		bufmoveto(6,7);
		bufmoveto(5,7); 
		bufmoveto(4,8); 
		bufmoveto(4,12);
		bufmoveto(3,13); 
		bufmoveto(1,13);
		break;
	case '<': 
		bufsetto(6,1); 
		bufmoveto(1,6);
		bufmoveto(6,11); 
		break;
	case '>': 
		bufsetto(1,1); 
		bufmoveto(6,6);
		bufmoveto(1,11); 
		break;
	case '/': 
		bufsetto(0,12); 
		bufmoveto(6,1);
		break;
	case '\\': 
		bufsetto(0,1); 
		bufmoveto(6,12);
		break;
	case '_': 
		bufsetto(0,12); 
		bufmoveto(6,12); 
		break;
	case '0': 
		bufsetto(2,10); 
		bufmoveto(2,3);
		bufmoveto(3,2); 
		bufmoveto(5,2);
		bufmoveto(6,3); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(3,11); 
		bufmoveto(2,10);
		break;
	case '1': 
		bufsetto(2,11); 
		bufmoveto(6,11);
		bufsetto(4,11); 
		bufmoveto(4,2); 
		bufmoveto(2,4);
		break;
	case '2': 
		bufsetto(1,4); 
		bufmoveto(1,3);
		bufmoveto(2,2); 
		bufmoveto(5,2);
		bufmoveto(6,3); 
		bufmoveto(6,4); 
		bufmoveto(1,11);
		bufmoveto(6,11);
		break;
	case '3': 
		bufsetto(1,4); 
		bufmoveto(1,3);
		bufmoveto(2,2); 
		bufmoveto(5,2);
		bufmoveto(6,3); 
		bufmoveto(6,5); 
		bufmoveto(5,6);
		bufmoveto(3,6);
		bufsetto(5,6); 
		bufmoveto(6,7); 
		bufmoveto(6,10);
		bufmoveto(5,11); 
		bufmoveto(2,11); 
		bufmoveto(1,10);
		bufmoveto(1,9);
		break;
	case '4': 
		bufsetto(5,11); 
		bufmoveto(5,2);
		bufmoveto(0,8); 
		bufmoveto(6,8);
		break;
	case '5': 
		bufsetto(6,2); 
		bufmoveto(1,2); 
		bufmoveto(1,6);
		bufmoveto(5,6); 
		bufmoveto(6,7); 
		bufmoveto(6,10);
		bufmoveto(5,11); 
		bufmoveto(2,11); 
		bufmoveto(1,10);
		bufmoveto(1,9);
		break;
	case '6': 
		bufsetto(6,3); 
		bufmoveto(5,2); 
		bufmoveto(2,2);
		bufmoveto(1,3); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10); 
		bufmoveto(6,7);
		bufmoveto(5,6); 
		bufmoveto(1,6);
		break;
	case '7': 
		bufsetto(1,3); 
		bufmoveto(1,2); 
		bufmoveto(6,2);
		bufmoveto(4,10); 
		bufmoveto(4,11);
		break;
	case '8': 
		bufsetto(1,5); 
		bufmoveto(1,3);
		bufmoveto(2,2); 
		bufmoveto(5,2);
		bufmoveto(6,3); 
		bufmoveto(6,5); 
		bufmoveto(5,6);
		bufmoveto(2,6);  
		bufmoveto(1,5);
		bufsetto(5,6); 
		bufmoveto(6,7); 
		bufmoveto(6,10);
		bufmoveto(5,11); 
		bufmoveto(2,11); 
		bufmoveto(1,10);
		bufmoveto(1,7); 
		bufmoveto(2,6);
		break;
	case '9': 
		bufsetto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10);
		bufmoveto(6,3); 
		bufmoveto(5,2); 
		bufmoveto(2,2);
		bufmoveto(1,3);  
		bufmoveto(1,6);  
		bufmoveto(2,7);
		bufmoveto(6,7);
		break;
	case 'a': 
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(4,5);
		bufmoveto(5,6); 
		bufmoveto(5,10); 
		bufmoveto(6,11);
		bufsetto(5,10); 
		bufmoveto(4,11); 
		bufmoveto(2,11);
		bufmoveto(1,10); 
		bufmoveto(1,9); 
		bufmoveto(2,8);
		bufmoveto(5,8);
		break;
	case 'b': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10);
		break;
	case 'c': 
		bufsetto(6,6); 
		bufmoveto(5,5); 
		bufmoveto(2,5);
		bufmoveto(1,6); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10);
		break;
	case 'd': 
		bufsetto(6,2); 
		bufmoveto(6,11);
		bufsetto(6,6); 
		bufmoveto(5,5); 
		bufmoveto(2,5);
		bufmoveto(1,6); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10);
		break;
	case 'e': 
		bufsetto(1,8); 
		bufmoveto(6,8); 
		bufmoveto(6,6);
		bufmoveto(5,5); 
		bufmoveto(2,5);
		bufmoveto(1,6); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10);
		break;
	case 'f': 
		bufsetto(1,6); 
		bufmoveto(5,6);
		bufsetto(3,11); 
		bufmoveto(3,3); 
		bufmoveto(4,2);
		bufmoveto(5,2); 
		bufmoveto(6,3);
		break;
	case 'g': 
		bufsetto(6,6); 
		bufmoveto(5,5); 
		bufmoveto(2,5);
		bufmoveto(1,6); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10);
		bufsetto(6,5); 
		bufmoveto(6,13); 
		bufmoveto(5,14);
		bufmoveto(2,14); 
		bufmoveto(1,13);
		break;
	case 'h': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,11);
		break;
	case 'i': 
		bufsetto(4,2); 
		bufmoveto(4,1);
		bufsetto(2,5); 
		bufmoveto(4,5); 
		bufmoveto(4,11);
		break;
	case 'j': 
		bufsetto(5,2); 
		bufmoveto(5,1);
		bufsetto(3,5); 
		bufmoveto(5,5); 
		bufmoveto(5,13);
		bufmoveto(4,14); 
		bufmoveto(2,14);
		bufmoveto(1,13);
		break;
	case 'k': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,9); 
		bufmoveto(2,9); 
		bufmoveto(5,6);
		bufsetto(2,9); 
		bufmoveto(6,11);
		break;
	case 'l': 
		bufsetto(2,2); 
		bufmoveto(4,2); 
		bufmoveto(4,11);
		break;
	case 'm': 
		bufsetto(0,11); 
		bufmoveto(0,5);
		bufmoveto(2,5); 
		bufmoveto(3,6); 
		bufmoveto(3,11);
		bufsetto(3,6); 
		bufmoveto(4,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,11);
		break;
	case 'n': 
		bufsetto(1,11); 
		bufmoveto(1,5);
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,11);
		break;
	case 'o': 
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10); 
		bufmoveto(1,6);
		break;
	case 'p': 
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10); 
		bufmoveto(1,5);
		bufmoveto(1,15);
		break;
	case 'q': 
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10); 
		bufmoveto(1,6);
		bufsetto(6,5); 
		bufmoveto(6,15);
		break;
	case 'r': 
		bufsetto(1,11); 
		bufmoveto(1,5);
		bufsetto(1,6); 
		bufmoveto(2,5); 
		bufmoveto(5,5);
		bufmoveto(6,6);
		break;
	case 's': 
		bufsetto(6,6); 
		bufmoveto(5,5); 
		bufmoveto(2,5);
		bufmoveto(1,6); 
		bufmoveto(1,7); 
		bufmoveto(2,8);
		bufmoveto(5,8); 
		bufmoveto(6,9); 
		bufmoveto(6,10);
		bufmoveto(5,11); 
		bufmoveto(2,11); 
		bufmoveto(1,10);
		break;
	case 't': 
		bufsetto(1,5); 
		bufmoveto(4,5);
		bufsetto(3,3); 
		bufmoveto(3,10); 
		bufmoveto(4,11);
		bufmoveto(5,11); 
		bufmoveto(6,10);
		break;
	case 'u': 
		bufsetto(6,5); 
		bufmoveto(6,11);
		bufsetto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10); 
		bufmoveto(1,5);
		break;
	case 'v': 
		bufsetto(1,5);
		bufmoveto(4,11); 
		bufmoveto(6,5);
		break;
	case 'w': 
		bufsetto(0,5); 
		bufmoveto(0,10); 
		bufmoveto(1,11);
		bufmoveto(2,11); 
		bufmoveto(3,10); 
		bufmoveto(3,7);
		bufsetto(3,10); 
		bufmoveto(4,11); 
		bufmoveto(5,11);
		bufmoveto(6,10); 
		bufmoveto(6,5);
		break;
	case 'x': 
		bufsetto(1,5); 
		bufmoveto(1,6); 
		bufmoveto(6,10);
		bufmoveto(6,11);
		bufsetto(1,11); 
		bufmoveto(1,10); 
		bufmoveto(6,6);
		bufmoveto(6,5);
		break;
	case 'y': 
		bufsetto(1,5); 
		bufmoveto(4,12);
		bufsetto(6,5); 
		bufmoveto(4,12); 
		bufmoveto(2,15);
		bufmoveto(1,14);
		break;
	case 'z': 
		bufsetto(1,5); 
		bufmoveto(6,5); 
		bufmoveto(1,11);
		bufmoveto(6,11);
		break;
	case 'A': 
		bufsetto(1,11); 
		bufmoveto(1,8); 
		bufmoveto(3,2);
		bufmoveto(4,2); 
		bufmoveto(6,8); 
		bufmoveto(6,11);
		bufsetto(1,8); 
		bufmoveto(6,8);
		break;
	case 'B': 
		bufsetto(1,11); 
		bufmoveto(1,2); 
		bufmoveto(4,2);
		bufmoveto(5,3); 
		bufmoveto(5,5); 
		bufmoveto(4,6);
		bufmoveto(1,6);
		bufsetto(4,6); 
		bufmoveto(6,8); 
		bufmoveto(6,10);
		bufmoveto(5,11); 
		bufmoveto(1,11);
		break;
	case 'C': 
		bufsetto(6,4); 
		bufmoveto(6,3); 
		bufmoveto(5,2);
		bufmoveto(2,2);
		bufmoveto(1,3); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10); 
		bufmoveto(6,9);
		break;
	case 'D': 
		bufsetto(1,2); 
		bufmoveto(1,11); 
		bufmoveto(4,11);
		bufmoveto(6,9); 
		bufmoveto(6,4); 
		bufmoveto(4,2);
		bufmoveto(1,2);
		break;
	case 'E': 
		bufsetto(1,2); 
		bufmoveto(1,11); 
		bufmoveto(6,11);
		bufsetto(1,2); 
		bufmoveto(6,2);
		bufsetto(1,6); 
		bufmoveto(5,6);
		break;
	case 'F': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,2); 
		bufmoveto(6,2);
		bufsetto(1,6); 
		bufmoveto(5,6);
		break;
	case 'G': 
		bufsetto(6,4); 
		bufmoveto(6,3); 
		bufmoveto(5,2);
		bufmoveto(2,2);
		bufmoveto(1,3); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(4,11); 
		bufmoveto(6,10);
		bufsetto(6,11); 
		bufmoveto(6,7);
		bufmoveto(4,7);
		break;
	case 'H': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(6,2); 
		bufmoveto(6,11);
		bufsetto(1,6); 
		bufmoveto(6,6);
		break;
	case 'I': 
		bufsetto(1,2); 
		bufmoveto(5,2);
		bufsetto(3,2); 
		bufmoveto(3,11);
		bufsetto(1,11); 
		bufmoveto(5,11);
		break;
	case 'J': 
		bufsetto(3,2); 
		bufmoveto(6,2);
		bufsetto(5,2); 
		bufmoveto(5,10);
		bufmoveto(4,11); 
		bufmoveto(2,11);
		bufmoveto(1,10); 
		bufmoveto(1,9);
		break;
	case 'K': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,7); 
		bufmoveto(6,2);
		bufsetto(1,7); 
		bufmoveto(6,11);
		break;
	case 'L': 
		bufsetto(1,2); 
		bufmoveto(1,11); 
		bufmoveto(6,11);
		break;
	case 'M': 
		bufsetto(0,11); 
		bufmoveto(0,2); 
		bufmoveto(3,9);
		bufmoveto(6,2); 
		bufmoveto(6,11);
		break;
	case 'N': 
		bufsetto(1,11); 
		bufmoveto(1,2); 
		bufmoveto(6,11);
		bufmoveto(6,2);
		break;
	case 'O': 
		bufsetto(1,10); 
		bufmoveto(1,3);
		bufmoveto(2,2); 
		bufmoveto(5,2);
		bufmoveto(6,3); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10);
		break;
	case 'P': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,2); 
		bufmoveto(5,2); 
		bufmoveto(6,3);
		bufmoveto(6,5); 
		bufmoveto(5,6); 
		bufmoveto(1,6);
		break;
	case 'Q': 
		bufsetto(1,10); 
		bufmoveto(1,3);
		bufmoveto(2,2); 
		bufmoveto(5,2);
		bufmoveto(6,3); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10);
		bufsetto(2,11); 
		bufmoveto(5,14); 
		bufmoveto(6,14);
		break;
	case 'R': 
		bufsetto(1,2); 
		bufmoveto(1,11);
		bufsetto(1,2); 
		bufmoveto(5,2); 
		bufmoveto(6,3);
		bufmoveto(6,5); 
		bufmoveto(5,6); 
		bufmoveto(1,6);
		bufsetto(3,6); 
		bufmoveto(6,11);
		break;
	case 'S': 
		bufsetto(6,4); 
		bufmoveto(6,3);
		bufmoveto(5,2); 
		bufmoveto(2,2); 
		bufmoveto(1,3);
		bufmoveto(1,4); 
		bufmoveto(3,6); 
		bufmoveto(4,6);
		bufmoveto(6,8); 
		bufmoveto(6,10); 
		bufmoveto(5,11);
		bufmoveto(2,11); 
		bufmoveto(1,10); 
		bufmoveto(1,9);
		break;
	case 'T': 
		bufsetto(0,2); 
		bufmoveto(6,2);
		bufsetto(3,2); 
		bufmoveto(3,11);
		break;
	case 'U': 
		bufsetto(1,2); 
		bufmoveto(1,10); 
		bufmoveto(2,11);
		bufmoveto(5,11); 
		bufmoveto(6,10); 
		bufmoveto(6,2);
		break;
	case 'V': 
		bufsetto(1,2); 
		bufmoveto(3,11); 
		bufmoveto(4,11);
		bufmoveto(6,2);
		break;
	case 'W': 
		bufsetto(0,2); 
		bufmoveto(2,11);
		bufmoveto(3,5); 
		bufmoveto(4,11); 
		bufmoveto(6,2);
		break;
	case 'X': 
		bufsetto(1,2); 
		bufmoveto(1,3);
		bufmoveto(6,10); 
		bufmoveto(6,11);
		bufsetto(1,11); 
		bufmoveto(1,10);
		bufmoveto(6,3); 
		bufmoveto(6,2);
		break;
	case 'Y': 
		bufsetto(0,2); 
		bufmoveto(3,7); 
		bufmoveto(6,2);
		bufsetto(3,7); 
		bufmoveto(3,11);
		break;
	case 'Z': 
		bufsetto(1,2); 
		bufmoveto(6,2);
		bufmoveto(6,4); 
		bufmoveto(1,9); 
		bufmoveto(1,11);
		bufmoveto(6,11);
		break;
	}
#endif
}


/*--------------------------------------------------------------------*/

#endif /* X11 */

