.Id SCCS-info %W% %E% 
.Id $Id: vcg.man,v 1.12 1994/08/09 11:47:51 sander Exp $
.TH VCG|XVCG 1l local
.SH NAME
VCG tool \- visualization of compiler graphs 
.SH SYNOPSIS
.B vcg
[options] [filename]
.br
.B xvcg
[options] [filename]
.SH DESCRIPTION
The
.I VCG tool 
reads a VCG specification and visualizes the graph.
If not all positions of nodes are fixed, the tool
layouts the graph using several heuristics as
reducing the number of crossings, minimizing the size of 
edges, centering of nodes.
The specification language of the  
.I VCG tool
is nearly compatible to GRL, the language of the 
.I edge tool,
but contains many extensions.
The
.I VCG tool
allows folding of dynamically or statically specified
regions of the graph.
It uses colors and runs on 
.I Sunview 
or 
.I X11. 
.SH OPTIONS 
.TP 15
.B \-
Read the specification from
.I stdin.
.TP
.B \-h | \-H | \-?
Print a help message about the usage of the tool.
.TP
.B \-v | \-V
Print a version and copyright message.
.TP
.B \-a <num> | \-A <num>
Start the tool as animation handler.
This implies that the tool is controlled by signals
.I (USRSIG1, USRSIG2)
from an external program.
The signal
.I USRSIG1
causes the 
.I VCG tool
to open the display window and reload its input file.
The signal
.I USRSIG2
causes the
.I VCG tool
to close the display window.
The tool processes the input and indicates the completion
of the processing to the controlling program.
If 
.I <num>
is greater 0, this indication is done by sleeping
.I <num> 
seconds and touching the input file afterwards such that
its time stamp is refreshed.
If 
.I <num>
is less than 0, this indication is done by sleeping
.I \- <num>
seconds and sending signal
.I USRSIG1
to the caller process afterwards.
.TP
.B \-b <num> | \-B <num>
Set the maximal number of iterations used for bary centering
or median centering layout
to
.I <num>.
Bary centering/median centering reduces the number of crossings 
during the layout phase
of a graph, but may be time consuming on large graphs.
Reducing the number of iterations results in a faster but ugly layout. 
As default, bary centering is iterated as long as improvements are
possible.
.TP
.B \-c <num> | \-C <num>
Set the maximal number of iterations used for center shift layout
to
.I <num>.
Center shifting calculates the x co-ordinates of nodes such that the
nodes are centered relatively to their incoming and outgoing edges.
Reducing the number of iterations results in a faster but ugly layout. 
The default value is 100.
.TP
.B \-d\+ | \-D\+
Maximize the depth of the layout (layout maxdepth).
An alternative layout algorithm is used that partitioned the nodes
into layers.
It should be used if the layout is too wide in x direction.
This algorithm is very fast.
.TP
.B \-d\- | \-D\-
Minimize the depth of the layout (layout mindepth).
An alternative layout algorithm is used that partitioned the nodes
into layers.
It should be used if the layout is too wide in y direction.
This algorithm is very fast.
.TP
.B \-d\+\+ | \-D\+\+
Maximize the depth of the layout (layout maxdepthslow). See above.
This algorithm is very slow, but may give better results.
.TP
.B \-d\-\- | \-D\-\-
Minimize the depth of the layout (layout mindepthslow). See above.
This algorithm is very slow, but may give better results.
.TP
.B \-d0 | \-D0
Minimize the number of backward edges (layout minbackward). 
An alternative layout algorithm is used that partitioned the nodes
into layers.
If the graph is acyclic, no backward edges will occur, i.e. all 
edges point into the same direction.
.TP
.B \-dminindeg | \-Dminindeg
Prepare the nodes by sorting them according increasing indegree
(number of incoming edges = layout minindegree).
The nodes with the minimal indegree come first.
This may have various effects on the layout.
.TP
.B \-dmaxindeg | \-Dmaxindeg
Prepare the nodes by sorting them according decreasing indegree
(number of incoming edges = layout maxindegree).
The nodes with the maximal indegree come first.
This may have various effects on the layout.
.TP
.B \-dminoutdeg | \-Dminoutdeg
Prepare the nodes by sorting them according increasing outdegree
(number of outgoing edges = layout minoutdegree).
The nodes with the minimal outdegree come first.
This may have various effects on the layout.
.TP
.B \-dmaxoutdeg | \-Dmaxoutdeg
Prepare the nodes by sorting them according decreasing outdegree
(number of outgoing edges = layout maxoutdegree).
The nodes with the maximal outdegree come first.
This may have various effects on the layout.
.TP
.B \-dmindeg | \-Dmindeg
Prepare the nodes by sorting them according increasing degree
(number of incoming and outgoing edges = layout mindegree).
The nodes with the minimal degree come first.
This may have various effects on the layout.
.TP
.B \-dmaxdeg | \-Dmaxdeg
Prepare the nodes by sorting them according decreasing degree
(number of incoming and outgoing edges = layout maxdegree).
The nodes with the maximal degree come first.
This may have various effects on the layout.
.TP
.B \-dtree | \-Dtree 
Specialized layout for trees. It does not work with non-trees.
.TP
.B \-e <num> | \-E <num>
Stop after 
.I <num>
errors during parsing of the specification.
.TP
.B \-f | \-F
Switch fast and dirty and ugly mode on.
The layout phase will be very fast, but the layout will be ugly.
This is helpful on very large graphs where aesthetic visibility
is of minor importance.
The option \-f  implies \-b 2 \-c 2 \-m 2 \-n 2.
.TP
.B \-l/\-L
Switch a local crossing optimization off.
This phase additionally examines pairs of edge polygons and tries
to unwind them. 
It slows down if the degree of the nodes is large.
.TP
.B \-m <num> | \-M <num>
Set the maximal number of iterations used for medium shift layout
to
.I <num>.
Medium shifting calculates the x co-ordinates of nodes such that the
layout is medium dense. 
It tries to avoid extreme gradients of edges. 
Reducing the number of iterations results in a faster but ugly layout. 
The default value is 100.
.TP
.B \-n <num> | \-N <num>
Set the maximal number of iterations used for edge bending layout
to
.I <num>.
Edge bendings are used to avoid that edges are drawn across nodes.
This layout phase is iterated to minimize the number of edge bendings.
Reducing the number of iterations results in a faster but ugly layout,
i.e. to much bendings occur. 
The default value is 100.
.TP
.B \-s | \-S
Switch edge summary layout on.
Multiple edges between the same source and target node are summarized.
This reduces the number of visible edges.
.TP
.B \-t | \-T
Switch fine tuning layout off.
Fine tuning is a postprocessing phase after partitioning of nodes
into layers.
It changes the layers of nodes to minimize the length of edges.
.TP 
.B \-spline
Use splines instead of polygons to draw edges. This is mainly useful
if you want to export the graph into a high quality PostScript picture.
WARNING: Drawing splines is very slow.
.TP 
.B \-median
Use median centering instead of bary centering to reduce the
number of crossings.
Median centering is often faster, but bary centering often
eliminates more crossings. 
.TP
.B \-latelabels
Create the labels after the partitioning of edges.
This has only an effect if labels are shown in a nondirty way.
If labels are created after the partitioning of edges, the
layout will be a little bit wider and may have less crossings.
But note that sometimes this layout may also be worser than the
normal layout.
.TP 
.B \-silent
Be silent during layout.  
No messages or warnings are produced.
.TP
.B \-nocolors | \-blackwhite
Do not use colors on a color screen.
On a black&white screen the graph is drawn black&white even if it
is specified with colors.
On a color screen, this mode is simulated, if this option is selected.
The option is useful, if the
.I VCG tool
conflicts with other programs that need colors.
.SH X11 OPTIONS 
.TP 15
.B \-display <host:dpy>
Set the remote X11 server to 
.I host:dpy.
This is analogous to
.I xterm(1l).
.TP 
.B \-geometry <geom>
Specify the hint of size and location of the X11 window.
This is analogous to
.I xterm(1l).
.TP 
.B \-bw <num>
Set the border width of the X11 window to
.I <num>
pixels.
This is analogous to
.I xterm(1l).
.TP
.B \-bs <backing>
Set the mode of backing store for the X11 window.
This option is obsolete now.
.TP
.B \-font <xfont>
Set the font used for messages and menu items in the
X11 window.
This is analogous to
.I xterm(1l).
.TP
.B \-grabinputfocus
Switch setting of InputFocus on or off (depending on the default).
Cause the VCG tool to execute a XSetInputFocus, or to
avoid to execute a XSetInputFocus on initialization.


.SH GRAMMAR 
The grammar of the specification language is the following:
.TP 5
.B graph
::=  "graph:" '{' graph_entry_list '}'		
.br
;
.TP
.B graph_entry_list
::=  graph_entry_list graph_entry			
.br
| graph_entry					
.br
;
.TP
.B graph_entry
::=  graph_attribute
.br
| node_defaults
.br
| edge_defaults
.br
| foldnode_defaults
.br
| foldedge_defaults
.br
| graph
.br
| node
.br
| edge
.br
| nearedge
.br
;
.TP
.B graph_attribute
::=  'x' ':' integer
.br
| 'y' ':' integer
.br
| "loc:" '{' 'x' ':' integer 'y' ':' int_const '}'
.br
| "width" ':' integer 
.br
| "height" ':' integer
.br
| "xmax" ':' integer	
.br
| "ymax" ':' integer	
.br
| "xbase" ':' integer	
.br
| "ybase" ':' integer	
.br
| "xspace" ':' integer
.br
| "xlspace" ':' integer
.br
| "yspace" ':' integer
.br
| "xraster" ':' integer
.br
| "xlraster" ':' integer
.br
| "yraster" ':' integer
.br
| "folding" ':' integer
.br
| "invisible" ':' integer
.br
| "hidden" ':' integer
.br
| "title" ':' string	
.br
| "label" ':' string	
.br
| "classname" integer ':' string	
.br
| "infoname" integer ':' string	
.br
| "info1" ':' string	
.br
| "info2" ':' string	
.br
| "info3" ':' string	
.br
| "textmode" ':' enum_textmode		
.br
| "borderwidth" ':' integer
.br
| "color" ':' enum_color 
.br
| "textcolor" ':'enum_color 
.br
| "bordercolor" ':'enum_color 
.br
| "orientation" ':' enum_orientation		
.br
| "node_alignment" ':' enum_node_align
.br
| "scaling" ':' float	
.br
| "shrink" ':' integer
.br
| "stretch" ':' integer
.br
| "layoutalgorithm" ':' enum_layoutalgorithm	
.br
| "layout_downfactor" ':' integer 
.br
| "layout_upfactor" ':' integer 
.br
| "layout_nearfactor" ':' integer 
.br
| "layout_splinefactor" ':' integer
.br
| "splinefactor" ':' integer
.br
| "status" ':' enum_status			
.br
| "late_edge_labels" ':' enum_yes_no
.br
| "display_edge_labels" ':' enum_yes_no
.br
| "dirty_edge_labels" ':' enum_yes_no
.br
| "finetuning" ':' enum_yes_no 
.br
| "splines" ':'    enum_yes_no 
.br
| "no_nearedges"
.br
| "nearedges" ':' "no" 
.br
| "nearedges" ':' "yes" 
.br
| "shape" ':' enum_shape
.br
| "level" ':' integer 
.br
| "vertical_order" ':' integer 
.br
| "horizontal_order" ':' integer 
.br
| "crossing_optimization" ':' enum_yes_no 
.br
| "crossing_weight" ':' enum_cross_weight 
.br
| "spreadlevel"     ':' integer  
.br
| "treefactor" ':' float  
.br
;
.TP
.B enum_color
::=  "aquamarine"      
.br
| "black"      
.br
| "blue"      
.br
| "cyan"      
.br
| "darkblue"      
.br
| "darkcyan"      
.br
| "darkgreen"      
.br
| "darkgrey"      
.br
| "darkmagenta"    
.br
| "darkred"      
.br
| "darkyellow"      
.br
| "gold"      
.br
| "green"      
.br
| "khaki"      
.br
| "lightblue"      
.br
| "lightcyan"      
.br
| "lightgreen"      
.br
| "lightgrey"      
.br
| "lightmagenta"    
.br
| "lightred"      
.br
| "lightyellow"    
.br
| "lilac"      
.br
| "magenta"      
.br
| "orange"      
.br
| "orchid"      
.br
| "pink"      
.br
| "purple"      
.br
| "red"      
.br
| "turquoise"      
.br
| "white"      
.br
| "yellow"      
.br
| "yellowgreen"   
.br
;
.TP
.B enum_orientation
::=  "top_to_bottom"
.br
| "bottom_to_top"
.br
| "left_to_right"
.br
| "right_to_left"
.br
;
.TP
.B enum_layoutalgorithm
::=  
.br
| "tree"
.br
| "maxdepth"
.br
| "mindepth"
.br
| "maxdepthslow"
.br
| "mindepthslow"
.br
| "maxdegree"
.br
| "mindegree"
.br
| "maxindegree"
.br
| "minindegree"
.br
| "maxoutdegree"
.br
| "minoutdegree"
.br
| "minbackward"
.br
;
.TP
.B enum_status
::=  "black"
.br
| "grey"
.br
| "white"
.br
;
.TP
.B enum_yes_no
::=  "yes"
.br
| "no"
.br
;
.TP
.B enum_cross_weight
::=  "bary" 
.br
| "median"
.br
;
.TP
.B foldnode_defaults
::=  "foldnode." node_attribute 	
.br
;
.TP
.B foldedge_defaults
::=  "foldedge." edge_attribute 	
.br
;
.TP
.B node_defaults
::=  "node." node_attribute 	
.br
;
.TP
.B edge_defaults
::=  "edge." edge_attribute  
.br
;
.TP
.B node
::=  "node:" '{' node_attribute_list '}'	
.br
;
.TP
.B node_attribute_list
::=  node_attribute_list node_attribute		
.br
| node_attribute				
.br
;
.TP
.B edge
::=  "edge:" '{' edge_attribute_list '}'        
.br
; 
.TP
.B nearedge
::=  "nearedge:" '{' edge_attribute_list '}'
.br
; 
.TP
.B edge_attribute_list
::=  edge_attribute_list edge_attribute     
.br
| edge_attribute                             
.br
; 
.TP
.B node_attribute
::=  "title" ':' string	
.br
| "label" ':' string	
.br
| "info1" ':' string	
.br
| "info2" ':' string	
.br
| "info3" ':' string	
.br
| "color" ':' enum_color
.br
| "textcolor" ':'enum_color 
.br
| "bordercolor" ':'enum_color 
.br
| "width" ':' integer	
.br
| "height" ':' integer	
.br
| "borderwidth" ':' integer
.br
| "loc:" '{' 'x' ':' integer 'y' ':' int_const '}'
.br
| "folding" ':' integer
.br
| "scaling" ':' float	
.br
| "shrink" ':' integer	
.br
| "stretch" ':' integer
.br
| "textmode" ':' enum_textmode		
.br
| "shape" ':' enum_shape
.br
| "level" ':' integer 
.br
| "vertical_order" ':' integer 
.br
| "horizontal_order" ':' integer 
.br
;
.TP
.B enum_textmode
::=  "center"
.br
| "left_justify"
.br
| "right_justify"
.br
;
.TP
.B enum_shape
::=  "box"
.br
| "rhomb"
.br
| "ellipse"
.br
| "triangle"
.br
;
.TP
.B enum_node_align
::=  "bottom"
.br
| "top"
.br
| "center"
.br
;
.TP
.B edge_attribute
::=  "sourcename" ':' string
.br
| "targetname" ':' string 
.br
| "label" ':' string	
.br
| "color" ':' enum_color
.br
| "thickness" ':' integer
.br
| "class" ':' integer	
.br
| "priority" ':' integer
.br
| "arrowsize" ':' integer
.br
| "linestyle" ':' enum_linestyle		
.br
| "anchor" ':' integer
.br
| "horizontal_order" ':' integer 
.br
; 
.TP
.B enum_linestyle
::=  "continuous"
.br
| "solid"      
.br
| "dotted"
.br
| "dashed"
.br
| "invisible" 
.br
;
.SH WARNINGS
The
.I VCG tool
needs about 400 bytes per edge and node.
Depending on the layout, it will produce a lot of additional
dummy nodes and dummy edges,
such that it may run out of memory.
The layout algorithm need exponentially time in the worst case.
.SH ACKNOWLEDGEMENTS
The 
.I edge tool
was developed at the University of Karlsruhe.
GRL was described by S. Manke and F.N. Paulisch.
.SH SEE ALSO
Sunview(1) X11(1l) edge(l) 
.br
demomaker(l) pbmshift(l) pbmrot90(l)
.br
.I VCG \- Visualization of Compiler Graphs, 
User Documentation,
Ref. Compare, USAAR-1049-visual, January 1994 
.SH BUGS
The X11 version has the `InputFocus' problem. 
This problem is solved for 99 % of all cases, but
may still occur. 
.br
If a graph is written to a file and reload
from this file, the layout may be different and may be
ugly.
.br
The attribute horizontal_order does only works for connected
graphs, but not for unconnected graphs.
.br
Currently, no further bugs are known.
.SH AUTHORS
Georg Sander, University of Saarland, Germany.
.br
Iris Lemke, University of Saarland, Germany.

